// DO NOT EDIT: This file is autogenerated via the builtin command.

package influxdb

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   77,
				},
				File:   "influxdb.flux",
				Source: "package influxdb\n\nimport \"influxdata/influxdb\"\nimport \"influxdata/influxdb/v1\"\n\n// _mask will hide the given columns from downstream\n// transformations. It will not perform any copies and\n// it will not regroup. This should only be used when\n// the user knows it can't cause a key conflict.\nbuiltin _mask : (<-tables: [A], columns: [string]) => [B] where A: Record, B: Record\n\n// from will retrieve data from a bucket between the start and stop time.\n// This version of from is the equivalent of doing from |> range\n// as a single call.\nfrom = (bucket, start, stop=now(), org=\"\", host=\"\", token=\"\") => {\n    source =\n        if org != \"\" and host != \"\" and token != \"\" then\n            influxdb.from(bucket, org, host, token)\n        else if org != \"\" and token != \"\" then\n            influxdb.from(bucket, org, token)\n        else if org != \"\" and host != \"\" then\n            influxdb.from(bucket, org, host)\n        else if host != \"\" and token != \"\" then\n            influxdb.from(bucket, host, token)\n        else if org != \"\" then\n            influxdb.from(bucket, org)\n        else if host != \"\" then\n            influxdb.from(bucket, host)\n        else if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)\n\n    return source |> range(start, stop)\n}\n\n// _from allows us to reference the from function from\n// within the select call which has a function parameter\n// with the same name.\n_from = from\n\n// select will select data from an influxdb instance within\n// the range between `start` and `stop` from the bucket specified by\n// the `from` parameter. It will select the specific measurement\n// and it will only include fields that are included in the list of\n// `fields`.\n//\n// In order to filter by tags, the `where` function can be used to further\n// limit the amount of data selected.\nselect = (from, start, stop=now(), m, fields=[], org=\"\", host=\"\", token=\"\", where=(r) => true) => {\n    bucket = from\n    tables = _from(bucket, start, stop, org, host, token)\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)\n\n    nfields = length(arr: fields)\n    fn =\n        if nfields == 0 then\n            (r) => true\n        else if nfields == 1 then\n            (r) => r._field == fields[0]\n        else if nfields == 2 then\n            (r) => r._field == fields[0] or r._field == fields[1]\n        else if nfields == 3 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n        else if nfields == 4 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n        else if nfields == 5 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n        else\n            (r) => contains(value: r._field, set: fields)\n\n    return tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])\n}",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// _mask will hide the given columns from downstream\n"}, ast.Comment{Text: "// transformations. It will not perform any copies and\n"}, ast.Comment{Text: "// it will not regroup. This should only be used when\n"}, ast.Comment{Text: "// the user knows it can't cause a key conflict.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   10,
					},
					File:   "influxdb.flux",
					Source: "builtin _mask",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   10,
						},
						File:   "influxdb.flux",
						Source: "_mask",
						Start: ast.Position{
							Column: 9,
							Line:   10,
						},
					},
				},
				Name: "_mask",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   10,
						},
						File:   "influxdb.flux",
						Source: "(<-tables: [A], columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 17,
							Line:   10,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   10,
							},
							File:   "influxdb.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 65,
								Line:   10,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   10,
								},
								File:   "influxdb.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 68,
									Line:   10,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   10,
								},
								File:   "influxdb.flux",
								Source: "A",
								Start: ast.Position{
									Column: 65,
									Line:   10,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   10,
							},
							File:   "influxdb.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 76,
								Line:   10,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   10,
								},
								File:   "influxdb.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 79,
									Line:   10,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   10,
								},
								File:   "influxdb.flux",
								Source: "B",
								Start: ast.Position{
									Column: 76,
									Line:   10,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   10,
							},
							File:   "influxdb.flux",
							Source: "(<-tables: [A], columns: [string]) => [B]",
							Start: ast.Position{
								Column: 17,
								Line:   10,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   10,
								},
								File:   "influxdb.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   10,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   10,
									},
									File:   "influxdb.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   10,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   10,
									},
									File:   "influxdb.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   10,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   10,
										},
										File:   "influxdb.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   10,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   10,
											},
											File:   "influxdb.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   10,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   10,
								},
								File:   "influxdb.flux",
								Source: "columns: [string]",
								Start: ast.Position{
									Column: 33,
									Line:   10,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   10,
									},
									File:   "influxdb.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 33,
										Line:   10,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   10,
									},
									File:   "influxdb.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 42,
										Line:   10,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   10,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   10,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   10,
											},
											File:   "influxdb.flux",
											Source: "string",
											Start: ast.Position{
												Column: 43,
												Line:   10,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   10,
								},
								File:   "influxdb.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 55,
									Line:   10,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   10,
									},
									File:   "influxdb.flux",
									Source: "B",
									Start: ast.Position{
										Column: 56,
										Line:   10,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   10,
										},
										File:   "influxdb.flux",
										Source: "B",
										Start: ast.Position{
											Column: 56,
											Line:   10,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   35,
					},
					File:   "influxdb.flux",
					Source: "from = (bucket, start, stop=now(), org=\"\", host=\"\", token=\"\") => {\n    source =\n        if org != \"\" and host != \"\" and token != \"\" then\n            influxdb.from(bucket, org, host, token)\n        else if org != \"\" and token != \"\" then\n            influxdb.from(bucket, org, token)\n        else if org != \"\" and host != \"\" then\n            influxdb.from(bucket, org, host)\n        else if host != \"\" and token != \"\" then\n            influxdb.from(bucket, host, token)\n        else if org != \"\" then\n            influxdb.from(bucket, org)\n        else if host != \"\" then\n            influxdb.from(bucket, host)\n        else if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)\n\n    return source |> range(start, stop)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// from will retrieve data from a bucket between the start and stop time.\n"}, ast.Comment{Text: "// This version of from is the equivalent of doing from |> range\n"}, ast.Comment{Text: "// as a single call.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   15,
						},
						File:   "influxdb.flux",
						Source: "from",
						Start: ast.Position{
							Column: 1,
							Line:   15,
						},
					},
				},
				Name: "from",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   35,
						},
						File:   "influxdb.flux",
						Source: "(bucket, start, stop=now(), org=\"\", host=\"\", token=\"\") => {\n    source =\n        if org != \"\" and host != \"\" and token != \"\" then\n            influxdb.from(bucket, org, host, token)\n        else if org != \"\" and token != \"\" then\n            influxdb.from(bucket, org, token)\n        else if org != \"\" and host != \"\" then\n            influxdb.from(bucket, org, host)\n        else if host != \"\" and token != \"\" then\n            influxdb.from(bucket, host, token)\n        else if org != \"\" then\n            influxdb.from(bucket, org)\n        else if host != \"\" then\n            influxdb.from(bucket, host)\n        else if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)\n\n    return source |> range(start, stop)\n}",
						Start: ast.Position{
							Column: 8,
							Line:   15,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   35,
							},
							File:   "influxdb.flux",
							Source: "{\n    source =\n        if org != \"\" and host != \"\" and token != \"\" then\n            influxdb.from(bucket, org, host, token)\n        else if org != \"\" and token != \"\" then\n            influxdb.from(bucket, org, token)\n        else if org != \"\" and host != \"\" then\n            influxdb.from(bucket, org, host)\n        else if host != \"\" and token != \"\" then\n            influxdb.from(bucket, host, token)\n        else if org != \"\" then\n            influxdb.from(bucket, org)\n        else if host != \"\" then\n            influxdb.from(bucket, host)\n        else if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)\n\n    return source |> range(start, stop)\n}",
							Start: ast.Position{
								Column: 66,
								Line:   15,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   32,
								},
								File:   "influxdb.flux",
								Source: "source =\n        if org != \"\" and host != \"\" and token != \"\" then\n            influxdb.from(bucket, org, host, token)\n        else if org != \"\" and token != \"\" then\n            influxdb.from(bucket, org, token)\n        else if org != \"\" and host != \"\" then\n            influxdb.from(bucket, org, host)\n        else if host != \"\" and token != \"\" then\n            influxdb.from(bucket, host, token)\n        else if org != \"\" then\n            influxdb.from(bucket, org)\n        else if host != \"\" then\n            influxdb.from(bucket, host)\n        else if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)",
								Start: ast.Position{
									Column: 5,
									Line:   16,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   16,
									},
									File:   "influxdb.flux",
									Source: "source",
									Start: ast.Position{
										Column: 5,
										Line:   16,
									},
								},
							},
							Name: "source",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.ConditionalExpression{
								Alternate: &ast.ConditionalExpression{
									Alternate: &ast.ConditionalExpression{
										Alternate: &ast.ConditionalExpression{
											Alternate: &ast.ConditionalExpression{
												Alternate: &ast.ConditionalExpression{
													Alternate: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   32,
																	},
																	File:   "influxdb.flux",
																	Source: "bucket",
																	Start: ast.Position{
																		Column: 27,
																		Line:   32,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   32,
																		},
																		File:   "influxdb.flux",
																		Source: "bucket",
																		Start: ast.Position{
																			Column: 27,
																			Line:   32,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   32,
																			},
																			File:   "influxdb.flux",
																			Source: "bucket",
																			Start: ast.Position{
																				Column: 27,
																				Line:   32,
																			},
																		},
																	},
																	Name: "bucket",
																},
																Separator: nil,
																Value:     nil,
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   32,
																},
																File:   "influxdb.flux",
																Source: "influxdb.from(bucket)",
																Start: ast.Position{
																	Column: 13,
																	Line:   32,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   32,
																	},
																	File:   "influxdb.flux",
																	Source: "influxdb.from",
																	Start: ast.Position{
																		Column: 13,
																		Line:   32,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   32,
																		},
																		File:   "influxdb.flux",
																		Source: "influxdb",
																		Start: ast.Position{
																			Column: 13,
																			Line:   32,
																		},
																	},
																},
																Name: "influxdb",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   32,
																		},
																		File:   "influxdb.flux",
																		Source: "from",
																		Start: ast.Position{
																			Column: 22,
																			Line:   32,
																		},
																	},
																},
																Name: "from",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   32,
															},
															File:   "influxdb.flux",
															Source: "if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)",
															Start: ast.Position{
																Column: 14,
																Line:   29,
															},
														},
													},
													Consequent: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   30,
																	},
																	File:   "influxdb.flux",
																	Source: "bucket, token",
																	Start: ast.Position{
																		Column: 27,
																		Line:   30,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   30,
																		},
																		File:   "influxdb.flux",
																		Source: "bucket",
																		Start: ast.Position{
																			Column: 27,
																			Line:   30,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   30,
																			},
																			File:   "influxdb.flux",
																			Source: "bucket",
																			Start: ast.Position{
																				Column: 27,
																				Line:   30,
																			},
																		},
																	},
																	Name: "bucket",
																},
																Separator: nil,
																Value:     nil,
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   30,
																		},
																		File:   "influxdb.flux",
																		Source: "token",
																		Start: ast.Position{
																			Column: 35,
																			Line:   30,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   30,
																			},
																			File:   "influxdb.flux",
																			Source: "token",
																			Start: ast.Position{
																				Column: 35,
																				Line:   30,
																			},
																		},
																	},
																	Name: "token",
																},
																Separator: nil,
																Value:     nil,
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   30,
																},
																File:   "influxdb.flux",
																Source: "influxdb.from(bucket, token)",
																Start: ast.Position{
																	Column: 13,
																	Line:   30,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   30,
																	},
																	File:   "influxdb.flux",
																	Source: "influxdb.from",
																	Start: ast.Position{
																		Column: 13,
																		Line:   30,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   30,
																		},
																		File:   "influxdb.flux",
																		Source: "influxdb",
																		Start: ast.Position{
																			Column: 13,
																			Line:   30,
																		},
																	},
																},
																Name: "influxdb",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   30,
																		},
																		File:   "influxdb.flux",
																		Source: "from",
																		Start: ast.Position{
																			Column: 22,
																			Line:   30,
																		},
																	},
																},
																Name: "from",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
													Test: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   29,
																},
																File:   "influxdb.flux",
																Source: "token != \"\"",
																Start: ast.Position{
																	Column: 17,
																	Line:   29,
																},
															},
														},
														Left: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   29,
																	},
																	File:   "influxdb.flux",
																	Source: "token",
																	Start: ast.Position{
																		Column: 17,
																		Line:   29,
																	},
																},
															},
															Name: "token",
														},
														Operator: 18,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   29,
																	},
																	File:   "influxdb.flux",
																	Source: "\"\"",
																	Start: ast.Position{
																		Column: 26,
																		Line:   29,
																	},
																},
															},
															Value: "",
														},
													},
													Tk_else: nil,
													Tk_if:   nil,
													Tk_then: nil,
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   32,
														},
														File:   "influxdb.flux",
														Source: "if host != \"\" then\n            influxdb.from(bucket, host)\n        else if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)",
														Start: ast.Position{
															Column: 14,
															Line:   27,
														},
													},
												},
												Consequent: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   28,
																},
																File:   "influxdb.flux",
																Source: "bucket, host",
																Start: ast.Position{
																	Column: 27,
																	Line:   28,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   28,
																	},
																	File:   "influxdb.flux",
																	Source: "bucket",
																	Start: ast.Position{
																		Column: 27,
																		Line:   28,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   28,
																		},
																		File:   "influxdb.flux",
																		Source: "bucket",
																		Start: ast.Position{
																			Column: 27,
																			Line:   28,
																		},
																	},
																},
																Name: "bucket",
															},
															Separator: nil,
															Value:     nil,
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   28,
																	},
																	File:   "influxdb.flux",
																	Source: "host",
																	Start: ast.Position{
																		Column: 35,
																		Line:   28,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 39,
																			Line:   28,
																		},
																		File:   "influxdb.flux",
																		Source: "host",
																		Start: ast.Position{
																			Column: 35,
																			Line:   28,
																		},
																	},
																},
																Name: "host",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   28,
															},
															File:   "influxdb.flux",
															Source: "influxdb.from(bucket, host)",
															Start: ast.Position{
																Column: 13,
																Line:   28,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   28,
																},
																File:   "influxdb.flux",
																Source: "influxdb.from",
																Start: ast.Position{
																	Column: 13,
																	Line:   28,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   28,
																	},
																	File:   "influxdb.flux",
																	Source: "influxdb",
																	Start: ast.Position{
																		Column: 13,
																		Line:   28,
																	},
																},
															},
															Name: "influxdb",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   28,
																	},
																	File:   "influxdb.flux",
																	Source: "from",
																	Start: ast.Position{
																		Column: 22,
																		Line:   28,
																	},
																},
															},
															Name: "from",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   27,
															},
															File:   "influxdb.flux",
															Source: "host != \"\"",
															Start: ast.Position{
																Column: 17,
																Line:   27,
															},
														},
													},
													Left: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   27,
																},
																File:   "influxdb.flux",
																Source: "host",
																Start: ast.Position{
																	Column: 17,
																	Line:   27,
																},
															},
														},
														Name: "host",
													},
													Operator: 18,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   27,
																},
																File:   "influxdb.flux",
																Source: "\"\"",
																Start: ast.Position{
																	Column: 25,
																	Line:   27,
																},
															},
														},
														Value: "",
													},
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   32,
													},
													File:   "influxdb.flux",
													Source: "if org != \"\" then\n            influxdb.from(bucket, org)\n        else if host != \"\" then\n            influxdb.from(bucket, host)\n        else if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)",
													Start: ast.Position{
														Column: 14,
														Line:   25,
													},
												},
											},
											Consequent: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   26,
															},
															File:   "influxdb.flux",
															Source: "bucket, org",
															Start: ast.Position{
																Column: 27,
																Line:   26,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 33,
																	Line:   26,
																},
																File:   "influxdb.flux",
																Source: "bucket",
																Start: ast.Position{
																	Column: 27,
																	Line:   26,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   26,
																	},
																	File:   "influxdb.flux",
																	Source: "bucket",
																	Start: ast.Position{
																		Column: 27,
																		Line:   26,
																	},
																},
															},
															Name: "bucket",
														},
														Separator: nil,
														Value:     nil,
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   26,
																},
																File:   "influxdb.flux",
																Source: "org",
																Start: ast.Position{
																	Column: 35,
																	Line:   26,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   26,
																	},
																	File:   "influxdb.flux",
																	Source: "org",
																	Start: ast.Position{
																		Column: 35,
																		Line:   26,
																	},
																},
															},
															Name: "org",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   26,
														},
														File:   "influxdb.flux",
														Source: "influxdb.from(bucket, org)",
														Start: ast.Position{
															Column: 13,
															Line:   26,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   26,
															},
															File:   "influxdb.flux",
															Source: "influxdb.from",
															Start: ast.Position{
																Column: 13,
																Line:   26,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   26,
																},
																File:   "influxdb.flux",
																Source: "influxdb",
																Start: ast.Position{
																	Column: 13,
																	Line:   26,
																},
															},
														},
														Name: "influxdb",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   26,
																},
																File:   "influxdb.flux",
																Source: "from",
																Start: ast.Position{
																	Column: 22,
																	Line:   26,
																},
															},
														},
														Name: "from",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
											Test: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   25,
														},
														File:   "influxdb.flux",
														Source: "org != \"\"",
														Start: ast.Position{
															Column: 17,
															Line:   25,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 20,
																Line:   25,
															},
															File:   "influxdb.flux",
															Source: "org",
															Start: ast.Position{
																Column: 17,
																Line:   25,
															},
														},
													},
													Name: "org",
												},
												Operator: 18,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   25,
															},
															File:   "influxdb.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 24,
																Line:   25,
															},
														},
													},
													Value: "",
												},
											},
											Tk_else: nil,
											Tk_if:   nil,
											Tk_then: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   32,
												},
												File:   "influxdb.flux",
												Source: "if host != \"\" and token != \"\" then\n            influxdb.from(bucket, host, token)\n        else if org != \"\" then\n            influxdb.from(bucket, org)\n        else if host != \"\" then\n            influxdb.from(bucket, host)\n        else if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)",
												Start: ast.Position{
													Column: 14,
													Line:   23,
												},
											},
										},
										Consequent: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   24,
														},
														File:   "influxdb.flux",
														Source: "bucket, host, token",
														Start: ast.Position{
															Column: 27,
															Line:   24,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   24,
															},
															File:   "influxdb.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 27,
																Line:   24,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 33,
																	Line:   24,
																},
																File:   "influxdb.flux",
																Source: "bucket",
																Start: ast.Position{
																	Column: 27,
																	Line:   24,
																},
															},
														},
														Name: "bucket",
													},
													Separator: nil,
													Value:     nil,
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   24,
															},
															File:   "influxdb.flux",
															Source: "host",
															Start: ast.Position{
																Column: 35,
																Line:   24,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   24,
																},
																File:   "influxdb.flux",
																Source: "host",
																Start: ast.Position{
																	Column: 35,
																	Line:   24,
																},
															},
														},
														Name: "host",
													},
													Separator: nil,
													Value:     nil,
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   24,
															},
															File:   "influxdb.flux",
															Source: "token",
															Start: ast.Position{
																Column: 41,
																Line:   24,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   24,
																},
																File:   "influxdb.flux",
																Source: "token",
																Start: ast.Position{
																	Column: 41,
																	Line:   24,
																},
															},
														},
														Name: "token",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   24,
													},
													File:   "influxdb.flux",
													Source: "influxdb.from(bucket, host, token)",
													Start: ast.Position{
														Column: 13,
														Line:   24,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   24,
														},
														File:   "influxdb.flux",
														Source: "influxdb.from",
														Start: ast.Position{
															Column: 13,
															Line:   24,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   24,
															},
															File:   "influxdb.flux",
															Source: "influxdb",
															Start: ast.Position{
																Column: 13,
																Line:   24,
															},
														},
													},
													Name: "influxdb",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   24,
															},
															File:   "influxdb.flux",
															Source: "from",
															Start: ast.Position{
																Column: 22,
																Line:   24,
															},
														},
													},
													Name: "from",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
										Test: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   23,
													},
													File:   "influxdb.flux",
													Source: "host != \"\" and token != \"\"",
													Start: ast.Position{
														Column: 17,
														Line:   23,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   23,
														},
														File:   "influxdb.flux",
														Source: "host != \"\"",
														Start: ast.Position{
															Column: 17,
															Line:   23,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   23,
															},
															File:   "influxdb.flux",
															Source: "host",
															Start: ast.Position{
																Column: 17,
																Line:   23,
															},
														},
													},
													Name: "host",
												},
												Operator: 18,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   23,
															},
															File:   "influxdb.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 25,
																Line:   23,
															},
														},
													},
													Value: "",
												},
											},
											Operator: 1,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   23,
														},
														File:   "influxdb.flux",
														Source: "token != \"\"",
														Start: ast.Position{
															Column: 32,
															Line:   23,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   23,
															},
															File:   "influxdb.flux",
															Source: "token",
															Start: ast.Position{
																Column: 32,
																Line:   23,
															},
														},
													},
													Name: "token",
												},
												Operator: 18,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   23,
															},
															File:   "influxdb.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 41,
																Line:   23,
															},
														},
													},
													Value: "",
												},
											},
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   32,
											},
											File:   "influxdb.flux",
											Source: "if org != \"\" and host != \"\" then\n            influxdb.from(bucket, org, host)\n        else if host != \"\" and token != \"\" then\n            influxdb.from(bucket, host, token)\n        else if org != \"\" then\n            influxdb.from(bucket, org)\n        else if host != \"\" then\n            influxdb.from(bucket, host)\n        else if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)",
											Start: ast.Position{
												Column: 14,
												Line:   21,
											},
										},
									},
									Consequent: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   22,
													},
													File:   "influxdb.flux",
													Source: "bucket, org, host",
													Start: ast.Position{
														Column: 27,
														Line:   22,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   22,
														},
														File:   "influxdb.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 27,
															Line:   22,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   22,
															},
															File:   "influxdb.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 27,
																Line:   22,
															},
														},
													},
													Name: "bucket",
												},
												Separator: nil,
												Value:     nil,
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   22,
														},
														File:   "influxdb.flux",
														Source: "org",
														Start: ast.Position{
															Column: 35,
															Line:   22,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   22,
															},
															File:   "influxdb.flux",
															Source: "org",
															Start: ast.Position{
																Column: 35,
																Line:   22,
															},
														},
													},
													Name: "org",
												},
												Separator: nil,
												Value:     nil,
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   22,
														},
														File:   "influxdb.flux",
														Source: "host",
														Start: ast.Position{
															Column: 40,
															Line:   22,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   22,
															},
															File:   "influxdb.flux",
															Source: "host",
															Start: ast.Position{
																Column: 40,
																Line:   22,
															},
														},
													},
													Name: "host",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   22,
												},
												File:   "influxdb.flux",
												Source: "influxdb.from(bucket, org, host)",
												Start: ast.Position{
													Column: 13,
													Line:   22,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   22,
													},
													File:   "influxdb.flux",
													Source: "influxdb.from",
													Start: ast.Position{
														Column: 13,
														Line:   22,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   22,
														},
														File:   "influxdb.flux",
														Source: "influxdb",
														Start: ast.Position{
															Column: 13,
															Line:   22,
														},
													},
												},
												Name: "influxdb",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   22,
														},
														File:   "influxdb.flux",
														Source: "from",
														Start: ast.Position{
															Column: 22,
															Line:   22,
														},
													},
												},
												Name: "from",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
									Test: &ast.LogicalExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   21,
												},
												File:   "influxdb.flux",
												Source: "org != \"\" and host != \"\"",
												Start: ast.Position{
													Column: 17,
													Line:   21,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   21,
													},
													File:   "influxdb.flux",
													Source: "org != \"\"",
													Start: ast.Position{
														Column: 17,
														Line:   21,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   21,
														},
														File:   "influxdb.flux",
														Source: "org",
														Start: ast.Position{
															Column: 17,
															Line:   21,
														},
													},
												},
												Name: "org",
											},
											Operator: 18,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   21,
														},
														File:   "influxdb.flux",
														Source: "\"\"",
														Start: ast.Position{
															Column: 24,
															Line:   21,
														},
													},
												},
												Value: "",
											},
										},
										Operator: 1,
										Right: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   21,
													},
													File:   "influxdb.flux",
													Source: "host != \"\"",
													Start: ast.Position{
														Column: 31,
														Line:   21,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   21,
														},
														File:   "influxdb.flux",
														Source: "host",
														Start: ast.Position{
															Column: 31,
															Line:   21,
														},
													},
												},
												Name: "host",
											},
											Operator: 18,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   21,
														},
														File:   "influxdb.flux",
														Source: "\"\"",
														Start: ast.Position{
															Column: 39,
															Line:   21,
														},
													},
												},
												Value: "",
											},
										},
									},
									Tk_else: nil,
									Tk_if:   nil,
									Tk_then: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   32,
										},
										File:   "influxdb.flux",
										Source: "if org != \"\" and token != \"\" then\n            influxdb.from(bucket, org, token)\n        else if org != \"\" and host != \"\" then\n            influxdb.from(bucket, org, host)\n        else if host != \"\" and token != \"\" then\n            influxdb.from(bucket, host, token)\n        else if org != \"\" then\n            influxdb.from(bucket, org)\n        else if host != \"\" then\n            influxdb.from(bucket, host)\n        else if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)",
										Start: ast.Position{
											Column: 14,
											Line:   19,
										},
									},
								},
								Consequent: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   20,
												},
												File:   "influxdb.flux",
												Source: "bucket, org, token",
												Start: ast.Position{
													Column: 27,
													Line:   20,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   20,
													},
													File:   "influxdb.flux",
													Source: "bucket",
													Start: ast.Position{
														Column: 27,
														Line:   20,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   20,
														},
														File:   "influxdb.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 27,
															Line:   20,
														},
													},
												},
												Name: "bucket",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   20,
													},
													File:   "influxdb.flux",
													Source: "org",
													Start: ast.Position{
														Column: 35,
														Line:   20,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   20,
														},
														File:   "influxdb.flux",
														Source: "org",
														Start: ast.Position{
															Column: 35,
															Line:   20,
														},
													},
												},
												Name: "org",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   20,
													},
													File:   "influxdb.flux",
													Source: "token",
													Start: ast.Position{
														Column: 40,
														Line:   20,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   20,
														},
														File:   "influxdb.flux",
														Source: "token",
														Start: ast.Position{
															Column: 40,
															Line:   20,
														},
													},
												},
												Name: "token",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   20,
											},
											File:   "influxdb.flux",
											Source: "influxdb.from(bucket, org, token)",
											Start: ast.Position{
												Column: 13,
												Line:   20,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   20,
												},
												File:   "influxdb.flux",
												Source: "influxdb.from",
												Start: ast.Position{
													Column: 13,
													Line:   20,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   20,
													},
													File:   "influxdb.flux",
													Source: "influxdb",
													Start: ast.Position{
														Column: 13,
														Line:   20,
													},
												},
											},
											Name: "influxdb",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   20,
													},
													File:   "influxdb.flux",
													Source: "from",
													Start: ast.Position{
														Column: 22,
														Line:   20,
													},
												},
											},
											Name: "from",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
								Test: &ast.LogicalExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   19,
											},
											File:   "influxdb.flux",
											Source: "org != \"\" and token != \"\"",
											Start: ast.Position{
												Column: 17,
												Line:   19,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   19,
												},
												File:   "influxdb.flux",
												Source: "org != \"\"",
												Start: ast.Position{
													Column: 17,
													Line:   19,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   19,
													},
													File:   "influxdb.flux",
													Source: "org",
													Start: ast.Position{
														Column: 17,
														Line:   19,
													},
												},
											},
											Name: "org",
										},
										Operator: 18,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   19,
													},
													File:   "influxdb.flux",
													Source: "\"\"",
													Start: ast.Position{
														Column: 24,
														Line:   19,
													},
												},
											},
											Value: "",
										},
									},
									Operator: 1,
									Right: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   19,
												},
												File:   "influxdb.flux",
												Source: "token != \"\"",
												Start: ast.Position{
													Column: 31,
													Line:   19,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   19,
													},
													File:   "influxdb.flux",
													Source: "token",
													Start: ast.Position{
														Column: 31,
														Line:   19,
													},
												},
											},
											Name: "token",
										},
										Operator: 18,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   19,
													},
													File:   "influxdb.flux",
													Source: "\"\"",
													Start: ast.Position{
														Column: 40,
														Line:   19,
													},
												},
											},
											Value: "",
										},
									},
								},
								Tk_else: nil,
								Tk_if:   nil,
								Tk_then: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   32,
									},
									File:   "influxdb.flux",
									Source: "if org != \"\" and host != \"\" and token != \"\" then\n            influxdb.from(bucket, org, host, token)\n        else if org != \"\" and token != \"\" then\n            influxdb.from(bucket, org, token)\n        else if org != \"\" and host != \"\" then\n            influxdb.from(bucket, org, host)\n        else if host != \"\" and token != \"\" then\n            influxdb.from(bucket, host, token)\n        else if org != \"\" then\n            influxdb.from(bucket, org)\n        else if host != \"\" then\n            influxdb.from(bucket, host)\n        else if token != \"\" then\n            influxdb.from(bucket, token)\n        else\n            influxdb.from(bucket)",
									Start: ast.Position{
										Column: 9,
										Line:   17,
									},
								},
							},
							Consequent: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   18,
											},
											File:   "influxdb.flux",
											Source: "bucket, org, host, token",
											Start: ast.Position{
												Column: 27,
												Line:   18,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   18,
												},
												File:   "influxdb.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 27,
													Line:   18,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   18,
													},
													File:   "influxdb.flux",
													Source: "bucket",
													Start: ast.Position{
														Column: 27,
														Line:   18,
													},
												},
											},
											Name: "bucket",
										},
										Separator: nil,
										Value:     nil,
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   18,
												},
												File:   "influxdb.flux",
												Source: "org",
												Start: ast.Position{
													Column: 35,
													Line:   18,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   18,
													},
													File:   "influxdb.flux",
													Source: "org",
													Start: ast.Position{
														Column: 35,
														Line:   18,
													},
												},
											},
											Name: "org",
										},
										Separator: nil,
										Value:     nil,
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   18,
												},
												File:   "influxdb.flux",
												Source: "host",
												Start: ast.Position{
													Column: 40,
													Line:   18,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   18,
													},
													File:   "influxdb.flux",
													Source: "host",
													Start: ast.Position{
														Column: 40,
														Line:   18,
													},
												},
											},
											Name: "host",
										},
										Separator: nil,
										Value:     nil,
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   18,
												},
												File:   "influxdb.flux",
												Source: "token",
												Start: ast.Position{
													Column: 46,
													Line:   18,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   18,
													},
													File:   "influxdb.flux",
													Source: "token",
													Start: ast.Position{
														Column: 46,
														Line:   18,
													},
												},
											},
											Name: "token",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   18,
										},
										File:   "influxdb.flux",
										Source: "influxdb.from(bucket, org, host, token)",
										Start: ast.Position{
											Column: 13,
											Line:   18,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   18,
											},
											File:   "influxdb.flux",
											Source: "influxdb.from",
											Start: ast.Position{
												Column: 13,
												Line:   18,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   18,
												},
												File:   "influxdb.flux",
												Source: "influxdb",
												Start: ast.Position{
													Column: 13,
													Line:   18,
												},
											},
										},
										Name: "influxdb",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   18,
												},
												File:   "influxdb.flux",
												Source: "from",
												Start: ast.Position{
													Column: 22,
													Line:   18,
												},
											},
										},
										Name: "from",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							Test: &ast.LogicalExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   17,
										},
										File:   "influxdb.flux",
										Source: "org != \"\" and host != \"\" and token != \"\"",
										Start: ast.Position{
											Column: 12,
											Line:   17,
										},
									},
								},
								Left: &ast.LogicalExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   17,
											},
											File:   "influxdb.flux",
											Source: "org != \"\" and host != \"\"",
											Start: ast.Position{
												Column: 12,
												Line:   17,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   17,
												},
												File:   "influxdb.flux",
												Source: "org != \"\"",
												Start: ast.Position{
													Column: 12,
													Line:   17,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   17,
													},
													File:   "influxdb.flux",
													Source: "org",
													Start: ast.Position{
														Column: 12,
														Line:   17,
													},
												},
											},
											Name: "org",
										},
										Operator: 18,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   17,
													},
													File:   "influxdb.flux",
													Source: "\"\"",
													Start: ast.Position{
														Column: 19,
														Line:   17,
													},
												},
											},
											Value: "",
										},
									},
									Operator: 1,
									Right: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   17,
												},
												File:   "influxdb.flux",
												Source: "host != \"\"",
												Start: ast.Position{
													Column: 26,
													Line:   17,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   17,
													},
													File:   "influxdb.flux",
													Source: "host",
													Start: ast.Position{
														Column: 26,
														Line:   17,
													},
												},
											},
											Name: "host",
										},
										Operator: 18,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   17,
													},
													File:   "influxdb.flux",
													Source: "\"\"",
													Start: ast.Position{
														Column: 34,
														Line:   17,
													},
												},
											},
											Value: "",
										},
									},
								},
								Operator: 1,
								Right: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   17,
											},
											File:   "influxdb.flux",
											Source: "token != \"\"",
											Start: ast.Position{
												Column: 41,
												Line:   17,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   17,
												},
												File:   "influxdb.flux",
												Source: "token",
												Start: ast.Position{
													Column: 41,
													Line:   17,
												},
											},
										},
										Name: "token",
									},
									Operator: 18,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   17,
												},
												File:   "influxdb.flux",
												Source: "\"\"",
												Start: ast.Position{
													Column: 50,
													Line:   17,
												},
											},
										},
										Value: "",
									},
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   34,
										},
										File:   "influxdb.flux",
										Source: "source",
										Start: ast.Position{
											Column: 12,
											Line:   34,
										},
									},
								},
								Name: "source",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   34,
									},
									File:   "influxdb.flux",
									Source: "source |> range(start, stop)",
									Start: ast.Position{
										Column: 12,
										Line:   34,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   34,
											},
											File:   "influxdb.flux",
											Source: "start, stop",
											Start: ast.Position{
												Column: 28,
												Line:   34,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   34,
												},
												File:   "influxdb.flux",
												Source: "start",
												Start: ast.Position{
													Column: 28,
													Line:   34,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   34,
													},
													File:   "influxdb.flux",
													Source: "start",
													Start: ast.Position{
														Column: 28,
														Line:   34,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value:     nil,
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   34,
												},
												File:   "influxdb.flux",
												Source: "stop",
												Start: ast.Position{
													Column: 35,
													Line:   34,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   34,
													},
													File:   "influxdb.flux",
													Source: "stop",
													Start: ast.Position{
														Column: 35,
														Line:   34,
													},
												},
											},
											Name: "stop",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   34,
										},
										File:   "influxdb.flux",
										Source: "range(start, stop)",
										Start: ast.Position{
											Column: 22,
											Line:   34,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   34,
											},
											File:   "influxdb.flux",
											Source: "range",
											Start: ast.Position{
												Column: 22,
												Line:   34,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   34,
								},
								File:   "influxdb.flux",
								Source: "return source |> range(start, stop)",
								Start: ast.Position{
									Column: 5,
									Line:   34,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   15,
							},
							File:   "influxdb.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 9,
								Line:   15,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   15,
								},
								File:   "influxdb.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 9,
									Line:   15,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   15,
							},
							File:   "influxdb.flux",
							Source: "start",
							Start: ast.Position{
								Column: 17,
								Line:   15,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   15,
								},
								File:   "influxdb.flux",
								Source: "start",
								Start: ast.Position{
									Column: 17,
									Line:   15,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   15,
							},
							File:   "influxdb.flux",
							Source: "stop=now()",
							Start: ast.Position{
								Column: 24,
								Line:   15,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   15,
								},
								File:   "influxdb.flux",
								Source: "stop",
								Start: ast.Position{
									Column: 24,
									Line:   15,
								},
							},
						},
						Name: "stop",
					},
					Separator: nil,
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   15,
								},
								File:   "influxdb.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 29,
									Line:   15,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   15,
									},
									File:   "influxdb.flux",
									Source: "now",
									Start: ast.Position{
										Column: 29,
										Line:   15,
									},
								},
							},
							Name: "now",
						},
						Lparen: nil,
						Rparen: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   15,
							},
							File:   "influxdb.flux",
							Source: "org=\"\"",
							Start: ast.Position{
								Column: 36,
								Line:   15,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   15,
								},
								File:   "influxdb.flux",
								Source: "org",
								Start: ast.Position{
									Column: 36,
									Line:   15,
								},
							},
						},
						Name: "org",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   15,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 40,
									Line:   15,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   15,
							},
							File:   "influxdb.flux",
							Source: "host=\"\"",
							Start: ast.Position{
								Column: 44,
								Line:   15,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   15,
								},
								File:   "influxdb.flux",
								Source: "host",
								Start: ast.Position{
									Column: 44,
									Line:   15,
								},
							},
						},
						Name: "host",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   15,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 49,
									Line:   15,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   15,
							},
							File:   "influxdb.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 53,
								Line:   15,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   15,
								},
								File:   "influxdb.flux",
								Source: "token",
								Start: ast.Position{
									Column: 53,
									Line:   15,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   15,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 59,
									Line:   15,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   40,
					},
					File:   "influxdb.flux",
					Source: "_from = from",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// _from allows us to reference the from function from\n"}, ast.Comment{Text: "// within the select call which has a function parameter\n"}, ast.Comment{Text: "// with the same name.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   40,
						},
						File:   "influxdb.flux",
						Source: "_from",
						Start: ast.Position{
							Column: 1,
							Line:   40,
						},
					},
				},
				Name: "_from",
			},
			Init: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   40,
						},
						File:   "influxdb.flux",
						Source: "from",
						Start: ast.Position{
							Column: 9,
							Line:   40,
						},
					},
				},
				Name: "from",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   77,
					},
					File:   "influxdb.flux",
					Source: "select = (from, start, stop=now(), m, fields=[], org=\"\", host=\"\", token=\"\", where=(r) => true) => {\n    bucket = from\n    tables = _from(bucket, start, stop, org, host, token)\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)\n\n    nfields = length(arr: fields)\n    fn =\n        if nfields == 0 then\n            (r) => true\n        else if nfields == 1 then\n            (r) => r._field == fields[0]\n        else if nfields == 2 then\n            (r) => r._field == fields[0] or r._field == fields[1]\n        else if nfields == 3 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n        else if nfields == 4 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n        else if nfields == 5 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n        else\n            (r) => contains(value: r._field, set: fields)\n\n    return tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// select will select data from an influxdb instance within\n"}, ast.Comment{Text: "// the range between `start` and `stop` from the bucket specified by\n"}, ast.Comment{Text: "// the `from` parameter. It will select the specific measurement\n"}, ast.Comment{Text: "// and it will only include fields that are included in the list of\n"}, ast.Comment{Text: "// `fields`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// In order to filter by tags, the `where` function can be used to further\n"}, ast.Comment{Text: "// limit the amount of data selected.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   50,
						},
						File:   "influxdb.flux",
						Source: "select",
						Start: ast.Position{
							Column: 1,
							Line:   50,
						},
					},
				},
				Name: "select",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   77,
						},
						File:   "influxdb.flux",
						Source: "(from, start, stop=now(), m, fields=[], org=\"\", host=\"\", token=\"\", where=(r) => true) => {\n    bucket = from\n    tables = _from(bucket, start, stop, org, host, token)\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)\n\n    nfields = length(arr: fields)\n    fn =\n        if nfields == 0 then\n            (r) => true\n        else if nfields == 1 then\n            (r) => r._field == fields[0]\n        else if nfields == 2 then\n            (r) => r._field == fields[0] or r._field == fields[1]\n        else if nfields == 3 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n        else if nfields == 4 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n        else if nfields == 5 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n        else\n            (r) => contains(value: r._field, set: fields)\n\n    return tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])\n}",
						Start: ast.Position{
							Column: 10,
							Line:   50,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   77,
							},
							File:   "influxdb.flux",
							Source: "{\n    bucket = from\n    tables = _from(bucket, start, stop, org, host, token)\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)\n\n    nfields = length(arr: fields)\n    fn =\n        if nfields == 0 then\n            (r) => true\n        else if nfields == 1 then\n            (r) => r._field == fields[0]\n        else if nfields == 2 then\n            (r) => r._field == fields[0] or r._field == fields[1]\n        else if nfields == 3 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n        else if nfields == 4 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n        else if nfields == 5 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n        else\n            (r) => contains(value: r._field, set: fields)\n\n    return tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])\n}",
							Start: ast.Position{
								Column: 99,
								Line:   50,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   51,
								},
								File:   "influxdb.flux",
								Source: "bucket = from",
								Start: ast.Position{
									Column: 5,
									Line:   51,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   51,
									},
									File:   "influxdb.flux",
									Source: "bucket",
									Start: ast.Position{
										Column: 5,
										Line:   51,
									},
								},
							},
							Name: "bucket",
						},
						Init: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   51,
									},
									File:   "influxdb.flux",
									Source: "from",
									Start: ast.Position{
										Column: 14,
										Line:   51,
									},
								},
							},
							Name: "from",
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   54,
								},
								File:   "influxdb.flux",
								Source: "tables = _from(bucket, start, stop, org, host, token)\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)",
								Start: ast.Position{
									Column: 5,
									Line:   52,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   52,
									},
									File:   "influxdb.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 5,
										Line:   52,
									},
								},
							},
							Name: "tables",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   52,
												},
												File:   "influxdb.flux",
												Source: "bucket, start, stop, org, host, token",
												Start: ast.Position{
													Column: 20,
													Line:   52,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   52,
													},
													File:   "influxdb.flux",
													Source: "bucket",
													Start: ast.Position{
														Column: 20,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   52,
														},
														File:   "influxdb.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 20,
															Line:   52,
														},
													},
												},
												Name: "bucket",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   52,
													},
													File:   "influxdb.flux",
													Source: "start",
													Start: ast.Position{
														Column: 28,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   52,
														},
														File:   "influxdb.flux",
														Source: "start",
														Start: ast.Position{
															Column: 28,
															Line:   52,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   52,
													},
													File:   "influxdb.flux",
													Source: "stop",
													Start: ast.Position{
														Column: 35,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   52,
														},
														File:   "influxdb.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 35,
															Line:   52,
														},
													},
												},
												Name: "stop",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   52,
													},
													File:   "influxdb.flux",
													Source: "org",
													Start: ast.Position{
														Column: 41,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   52,
														},
														File:   "influxdb.flux",
														Source: "org",
														Start: ast.Position{
															Column: 41,
															Line:   52,
														},
													},
												},
												Name: "org",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   52,
													},
													File:   "influxdb.flux",
													Source: "host",
													Start: ast.Position{
														Column: 46,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   52,
														},
														File:   "influxdb.flux",
														Source: "host",
														Start: ast.Position{
															Column: 46,
															Line:   52,
														},
													},
												},
												Name: "host",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   52,
													},
													File:   "influxdb.flux",
													Source: "token",
													Start: ast.Position{
														Column: 52,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   52,
														},
														File:   "influxdb.flux",
														Source: "token",
														Start: ast.Position{
															Column: 52,
															Line:   52,
														},
													},
												},
												Name: "token",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   52,
											},
											File:   "influxdb.flux",
											Source: "_from(bucket, start, stop, org, host, token)",
											Start: ast.Position{
												Column: 14,
												Line:   52,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   52,
												},
												File:   "influxdb.flux",
												Source: "_from",
												Start: ast.Position{
													Column: 14,
													Line:   52,
												},
											},
										},
										Name: "_from",
									},
									Lparen: nil,
									Rparen: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   53,
										},
										File:   "influxdb.flux",
										Source: "_from(bucket, start, stop, org, host, token)\n        |> filter(fn: (r) => r._measurement == m)",
										Start: ast.Position{
											Column: 14,
											Line:   52,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   53,
												},
												File:   "influxdb.flux",
												Source: "fn: (r) => r._measurement == m",
												Start: ast.Position{
													Column: 19,
													Line:   53,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   53,
													},
													File:   "influxdb.flux",
													Source: "fn: (r) => r._measurement == m",
													Start: ast.Position{
														Column: 19,
														Line:   53,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   53,
														},
														File:   "influxdb.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 19,
															Line:   53,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   53,
														},
														File:   "influxdb.flux",
														Source: "(r) => r._measurement == m",
														Start: ast.Position{
															Column: 23,
															Line:   53,
														},
													},
												},
												Body: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   53,
															},
															File:   "influxdb.flux",
															Source: "r._measurement == m",
															Start: ast.Position{
																Column: 30,
																Line:   53,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   53,
																},
																File:   "influxdb.flux",
																Source: "r._measurement",
																Start: ast.Position{
																	Column: 30,
																	Line:   53,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   53,
																	},
																	File:   "influxdb.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 30,
																		Line:   53,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   53,
																	},
																	File:   "influxdb.flux",
																	Source: "_measurement",
																	Start: ast.Position{
																		Column: 32,
																		Line:   53,
																	},
																},
															},
															Name: "_measurement",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   53,
																},
																File:   "influxdb.flux",
																Source: "m",
																Start: ast.Position{
																	Column: 48,
																	Line:   53,
																},
															},
														},
														Name: "m",
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   53,
															},
															File:   "influxdb.flux",
															Source: "r",
															Start: ast.Position{
																Column: 24,
																Line:   53,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   53,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   53,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   53,
											},
											File:   "influxdb.flux",
											Source: "filter(fn: (r) => r._measurement == m)",
											Start: ast.Position{
												Column: 12,
												Line:   53,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   53,
												},
												File:   "influxdb.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 12,
													Line:   53,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   54,
									},
									File:   "influxdb.flux",
									Source: "_from(bucket, start, stop, org, host, token)\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)",
									Start: ast.Position{
										Column: 14,
										Line:   52,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   54,
											},
											File:   "influxdb.flux",
											Source: "fn: where",
											Start: ast.Position{
												Column: 19,
												Line:   54,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   54,
												},
												File:   "influxdb.flux",
												Source: "fn: where",
												Start: ast.Position{
													Column: 19,
													Line:   54,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   54,
													},
													File:   "influxdb.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   54,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   54,
													},
													File:   "influxdb.flux",
													Source: "where",
													Start: ast.Position{
														Column: 23,
														Line:   54,
													},
												},
											},
											Name: "where",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   54,
										},
										File:   "influxdb.flux",
										Source: "filter(fn: where)",
										Start: ast.Position{
											Column: 12,
											Line:   54,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   54,
											},
											File:   "influxdb.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 12,
												Line:   54,
											},
										},
									},
									Name: "filter",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   56,
								},
								File:   "influxdb.flux",
								Source: "nfields = length(arr: fields)",
								Start: ast.Position{
									Column: 5,
									Line:   56,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   56,
									},
									File:   "influxdb.flux",
									Source: "nfields",
									Start: ast.Position{
										Column: 5,
										Line:   56,
									},
								},
							},
							Name: "nfields",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   56,
										},
										File:   "influxdb.flux",
										Source: "arr: fields",
										Start: ast.Position{
											Column: 22,
											Line:   56,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   56,
											},
											File:   "influxdb.flux",
											Source: "arr: fields",
											Start: ast.Position{
												Column: 22,
												Line:   56,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   56,
												},
												File:   "influxdb.flux",
												Source: "arr",
												Start: ast.Position{
													Column: 22,
													Line:   56,
												},
											},
										},
										Name: "arr",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   56,
												},
												File:   "influxdb.flux",
												Source: "fields",
												Start: ast.Position{
													Column: 27,
													Line:   56,
												},
											},
										},
										Name: "fields",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   56,
									},
									File:   "influxdb.flux",
									Source: "length(arr: fields)",
									Start: ast.Position{
										Column: 15,
										Line:   56,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   56,
										},
										File:   "influxdb.flux",
										Source: "length",
										Start: ast.Position{
											Column: 15,
											Line:   56,
										},
									},
								},
								Name: "length",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   71,
								},
								File:   "influxdb.flux",
								Source: "fn =\n        if nfields == 0 then\n            (r) => true\n        else if nfields == 1 then\n            (r) => r._field == fields[0]\n        else if nfields == 2 then\n            (r) => r._field == fields[0] or r._field == fields[1]\n        else if nfields == 3 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n        else if nfields == 4 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n        else if nfields == 5 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n        else\n            (r) => contains(value: r._field, set: fields)",
								Start: ast.Position{
									Column: 5,
									Line:   57,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   57,
									},
									File:   "influxdb.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 5,
										Line:   57,
									},
								},
							},
							Name: "fn",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.ConditionalExpression{
								Alternate: &ast.ConditionalExpression{
									Alternate: &ast.ConditionalExpression{
										Alternate: &ast.ConditionalExpression{
											Alternate: &ast.ConditionalExpression{
												Alternate: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   71,
															},
															File:   "influxdb.flux",
															Source: "(r) => contains(value: r._field, set: fields)",
															Start: ast.Position{
																Column: 13,
																Line:   71,
															},
														},
													},
													Body: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 57,
																		Line:   71,
																	},
																	File:   "influxdb.flux",
																	Source: "value: r._field, set: fields",
																	Start: ast.Position{
																		Column: 29,
																		Line:   71,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   71,
																		},
																		File:   "influxdb.flux",
																		Source: "value: r._field",
																		Start: ast.Position{
																			Column: 29,
																			Line:   71,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 34,
																				Line:   71,
																			},
																			File:   "influxdb.flux",
																			Source: "value",
																			Start: ast.Position{
																				Column: 29,
																				Line:   71,
																			},
																		},
																	},
																	Name: "value",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 44,
																				Line:   71,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 36,
																				Line:   71,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 37,
																					Line:   71,
																				},
																				File:   "influxdb.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 36,
																					Line:   71,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 44,
																					Line:   71,
																				},
																				File:   "influxdb.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 38,
																					Line:   71,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   71,
																		},
																		File:   "influxdb.flux",
																		Source: "set: fields",
																		Start: ast.Position{
																			Column: 46,
																			Line:   71,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   71,
																			},
																			File:   "influxdb.flux",
																			Source: "set",
																			Start: ast.Position{
																				Column: 46,
																				Line:   71,
																			},
																		},
																	},
																	Name: "set",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 57,
																				Line:   71,
																			},
																			File:   "influxdb.flux",
																			Source: "fields",
																			Start: ast.Position{
																				Column: 51,
																				Line:   71,
																			},
																		},
																	},
																	Name: "fields",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   71,
																},
																File:   "influxdb.flux",
																Source: "contains(value: r._field, set: fields)",
																Start: ast.Position{
																	Column: 20,
																	Line:   71,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   71,
																	},
																	File:   "influxdb.flux",
																	Source: "contains",
																	Start: ast.Position{
																		Column: 20,
																		Line:   71,
																	},
																},
															},
															Name: "contains",
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 15,
																	Line:   71,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 14,
																	Line:   71,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 15,
																		Line:   71,
																	},
																	File:   "influxdb.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 14,
																		Line:   71,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   71,
														},
														File:   "influxdb.flux",
														Source: "if nfields == 5 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n        else\n            (r) => contains(value: r._field, set: fields)",
														Start: ast.Position{
															Column: 14,
															Line:   68,
														},
													},
												},
												Consequent: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 141,
																Line:   69,
															},
															File:   "influxdb.flux",
															Source: "(r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]",
															Start: ast.Position{
																Column: 13,
																Line:   69,
															},
														},
													},
													Body: &ast.LogicalExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 141,
																	Line:   69,
																},
																File:   "influxdb.flux",
																Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]",
																Start: ast.Position{
																	Column: 20,
																	Line:   69,
																},
															},
														},
														Left: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 116,
																		Line:   69,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]",
																	Start: ast.Position{
																		Column: 20,
																		Line:   69,
																	},
																},
															},
															Left: &ast.LogicalExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 91,
																			Line:   69,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2]",
																		Start: ast.Position{
																			Column: 20,
																			Line:   69,
																		},
																	},
																},
																Left: &ast.LogicalExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   69,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field == fields[0] or r._field == fields[1]",
																			Start: ast.Position{
																				Column: 20,
																				Line:   69,
																			},
																		},
																	},
																	Left: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 41,
																					Line:   69,
																				},
																				File:   "influxdb.flux",
																				Source: "r._field == fields[0]",
																				Start: ast.Position{
																					Column: 20,
																					Line:   69,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   69,
																					},
																					File:   "influxdb.flux",
																					Source: "r._field",
																					Start: ast.Position{
																						Column: 20,
																						Line:   69,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 21,
																							Line:   69,
																						},
																						File:   "influxdb.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 20,
																							Line:   69,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   69,
																						},
																						File:   "influxdb.flux",
																						Source: "_field",
																						Start: ast.Position{
																							Column: 22,
																							Line:   69,
																						},
																					},
																				},
																				Name: "_field",
																			},
																			Rbrack: nil,
																		},
																		Operator: 17,
																		Right: &ast.IndexExpression{
																			Array: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 38,
																							Line:   69,
																						},
																						File:   "influxdb.flux",
																						Source: "fields",
																						Start: ast.Position{
																							Column: 32,
																							Line:   69,
																						},
																					},
																				},
																				Name: "fields",
																			},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 41,
																						Line:   69,
																					},
																					File:   "influxdb.flux",
																					Source: "fields[0]",
																					Start: ast.Position{
																						Column: 32,
																						Line:   69,
																					},
																				},
																			},
																			Index: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 40,
																							Line:   69,
																						},
																						File:   "influxdb.flux",
																						Source: "0",
																						Start: ast.Position{
																							Column: 39,
																							Line:   69,
																						},
																					},
																				},
																				Value: int64(0),
																			},
																			Lbrack: nil,
																			Rbrack: nil,
																		},
																	},
																	Operator: 2,
																	Right: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 66,
																					Line:   69,
																				},
																				File:   "influxdb.flux",
																				Source: "r._field == fields[1]",
																				Start: ast.Position{
																					Column: 45,
																					Line:   69,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 53,
																						Line:   69,
																					},
																					File:   "influxdb.flux",
																					Source: "r._field",
																					Start: ast.Position{
																						Column: 45,
																						Line:   69,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 46,
																							Line:   69,
																						},
																						File:   "influxdb.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 45,
																							Line:   69,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 53,
																							Line:   69,
																						},
																						File:   "influxdb.flux",
																						Source: "_field",
																						Start: ast.Position{
																							Column: 47,
																							Line:   69,
																						},
																					},
																				},
																				Name: "_field",
																			},
																			Rbrack: nil,
																		},
																		Operator: 17,
																		Right: &ast.IndexExpression{
																			Array: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 63,
																							Line:   69,
																						},
																						File:   "influxdb.flux",
																						Source: "fields",
																						Start: ast.Position{
																							Column: 57,
																							Line:   69,
																						},
																					},
																				},
																				Name: "fields",
																			},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 66,
																						Line:   69,
																					},
																					File:   "influxdb.flux",
																					Source: "fields[1]",
																					Start: ast.Position{
																						Column: 57,
																						Line:   69,
																					},
																				},
																			},
																			Index: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 65,
																							Line:   69,
																						},
																						File:   "influxdb.flux",
																						Source: "1",
																						Start: ast.Position{
																							Column: 64,
																							Line:   69,
																						},
																					},
																				},
																				Value: int64(1),
																			},
																			Lbrack: nil,
																			Rbrack: nil,
																		},
																	},
																},
																Operator: 2,
																Right: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 91,
																				Line:   69,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field == fields[2]",
																			Start: ast.Position{
																				Column: 70,
																				Line:   69,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 78,
																					Line:   69,
																				},
																				File:   "influxdb.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 70,
																					Line:   69,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 71,
																						Line:   69,
																					},
																					File:   "influxdb.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 70,
																						Line:   69,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 78,
																						Line:   69,
																					},
																					File:   "influxdb.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 72,
																						Line:   69,
																					},
																				},
																			},
																			Name: "_field",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.IndexExpression{
																		Array: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 88,
																						Line:   69,
																					},
																					File:   "influxdb.flux",
																					Source: "fields",
																					Start: ast.Position{
																						Column: 82,
																						Line:   69,
																					},
																				},
																			},
																			Name: "fields",
																		},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 91,
																					Line:   69,
																				},
																				File:   "influxdb.flux",
																				Source: "fields[2]",
																				Start: ast.Position{
																					Column: 82,
																					Line:   69,
																				},
																			},
																		},
																		Index: &ast.IntegerLiteral{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 90,
																						Line:   69,
																					},
																					File:   "influxdb.flux",
																					Source: "2",
																					Start: ast.Position{
																						Column: 89,
																						Line:   69,
																					},
																				},
																			},
																			Value: int64(2),
																		},
																		Lbrack: nil,
																		Rbrack: nil,
																	},
																},
															},
															Operator: 2,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 116,
																			Line:   69,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field == fields[3]",
																		Start: ast.Position{
																			Column: 95,
																			Line:   69,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 103,
																				Line:   69,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 95,
																				Line:   69,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 96,
																					Line:   69,
																				},
																				File:   "influxdb.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 95,
																					Line:   69,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 103,
																					Line:   69,
																				},
																				File:   "influxdb.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 97,
																					Line:   69,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.IndexExpression{
																	Array: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 113,
																					Line:   69,
																				},
																				File:   "influxdb.flux",
																				Source: "fields",
																				Start: ast.Position{
																					Column: 107,
																					Line:   69,
																				},
																			},
																		},
																		Name: "fields",
																	},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 116,
																				Line:   69,
																			},
																			File:   "influxdb.flux",
																			Source: "fields[3]",
																			Start: ast.Position{
																				Column: 107,
																				Line:   69,
																			},
																		},
																	},
																	Index: &ast.IntegerLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 115,
																					Line:   69,
																				},
																				File:   "influxdb.flux",
																				Source: "3",
																				Start: ast.Position{
																					Column: 114,
																					Line:   69,
																				},
																			},
																		},
																		Value: int64(3),
																	},
																	Lbrack: nil,
																	Rbrack: nil,
																},
															},
														},
														Operator: 2,
														Right: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 141,
																		Line:   69,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field == fields[4]",
																	Start: ast.Position{
																		Column: 120,
																		Line:   69,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 128,
																			Line:   69,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field",
																		Start: ast.Position{
																			Column: 120,
																			Line:   69,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 121,
																				Line:   69,
																			},
																			File:   "influxdb.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 120,
																				Line:   69,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 128,
																				Line:   69,
																			},
																			File:   "influxdb.flux",
																			Source: "_field",
																			Start: ast.Position{
																				Column: 122,
																				Line:   69,
																			},
																		},
																	},
																	Name: "_field",
																},
																Rbrack: nil,
															},
															Operator: 17,
															Right: &ast.IndexExpression{
																Array: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 138,
																				Line:   69,
																			},
																			File:   "influxdb.flux",
																			Source: "fields",
																			Start: ast.Position{
																				Column: 132,
																				Line:   69,
																			},
																		},
																	},
																	Name: "fields",
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 141,
																			Line:   69,
																		},
																		File:   "influxdb.flux",
																		Source: "fields[4]",
																		Start: ast.Position{
																			Column: 132,
																			Line:   69,
																		},
																	},
																},
																Index: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 140,
																				Line:   69,
																			},
																			File:   "influxdb.flux",
																			Source: "4",
																			Start: ast.Position{
																				Column: 139,
																				Line:   69,
																			},
																		},
																	},
																	Value: int64(4),
																},
																Lbrack: nil,
																Rbrack: nil,
															},
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 15,
																	Line:   69,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 14,
																	Line:   69,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 15,
																		Line:   69,
																	},
																	File:   "influxdb.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 14,
																		Line:   69,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   68,
															},
															File:   "influxdb.flux",
															Source: "nfields == 5",
															Start: ast.Position{
																Column: 17,
																Line:   68,
															},
														},
													},
													Left: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   68,
																},
																File:   "influxdb.flux",
																Source: "nfields",
																Start: ast.Position{
																	Column: 17,
																	Line:   68,
																},
															},
														},
														Name: "nfields",
													},
													Operator: 17,
													Right: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   68,
																},
																File:   "influxdb.flux",
																Source: "5",
																Start: ast.Position{
																	Column: 28,
																	Line:   68,
																},
															},
														},
														Value: int64(5),
													},
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   71,
													},
													File:   "influxdb.flux",
													Source: "if nfields == 4 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n        else if nfields == 5 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n        else\n            (r) => contains(value: r._field, set: fields)",
													Start: ast.Position{
														Column: 14,
														Line:   66,
													},
												},
											},
											Consequent: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 116,
															Line:   67,
														},
														File:   "influxdb.flux",
														Source: "(r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]",
														Start: ast.Position{
															Column: 13,
															Line:   67,
														},
													},
												},
												Body: &ast.LogicalExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 116,
																Line:   67,
															},
															File:   "influxdb.flux",
															Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]",
															Start: ast.Position{
																Column: 20,
																Line:   67,
															},
														},
													},
													Left: &ast.LogicalExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 91,
																	Line:   67,
																},
																File:   "influxdb.flux",
																Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2]",
																Start: ast.Position{
																	Column: 20,
																	Line:   67,
																},
															},
														},
														Left: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 66,
																		Line:   67,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field == fields[0] or r._field == fields[1]",
																	Start: ast.Position{
																		Column: 20,
																		Line:   67,
																	},
																},
															},
															Left: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   67,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field == fields[0]",
																		Start: ast.Position{
																			Column: 20,
																			Line:   67,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   67,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 20,
																				Line:   67,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 21,
																					Line:   67,
																				},
																				File:   "influxdb.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 20,
																					Line:   67,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   67,
																				},
																				File:   "influxdb.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 22,
																					Line:   67,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.IndexExpression{
																	Array: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 38,
																					Line:   67,
																				},
																				File:   "influxdb.flux",
																				Source: "fields",
																				Start: ast.Position{
																					Column: 32,
																					Line:   67,
																				},
																			},
																		},
																		Name: "fields",
																	},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 41,
																				Line:   67,
																			},
																			File:   "influxdb.flux",
																			Source: "fields[0]",
																			Start: ast.Position{
																				Column: 32,
																				Line:   67,
																			},
																		},
																	},
																	Index: &ast.IntegerLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 40,
																					Line:   67,
																				},
																				File:   "influxdb.flux",
																				Source: "0",
																				Start: ast.Position{
																					Column: 39,
																					Line:   67,
																				},
																			},
																		},
																		Value: int64(0),
																	},
																	Lbrack: nil,
																	Rbrack: nil,
																},
															},
															Operator: 2,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 66,
																			Line:   67,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field == fields[1]",
																		Start: ast.Position{
																			Column: 45,
																			Line:   67,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 53,
																				Line:   67,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 45,
																				Line:   67,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 46,
																					Line:   67,
																				},
																				File:   "influxdb.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 45,
																					Line:   67,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 53,
																					Line:   67,
																				},
																				File:   "influxdb.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 47,
																					Line:   67,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.IndexExpression{
																	Array: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 63,
																					Line:   67,
																				},
																				File:   "influxdb.flux",
																				Source: "fields",
																				Start: ast.Position{
																					Column: 57,
																					Line:   67,
																				},
																			},
																		},
																		Name: "fields",
																	},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   67,
																			},
																			File:   "influxdb.flux",
																			Source: "fields[1]",
																			Start: ast.Position{
																				Column: 57,
																				Line:   67,
																			},
																		},
																	},
																	Index: &ast.IntegerLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 65,
																					Line:   67,
																				},
																				File:   "influxdb.flux",
																				Source: "1",
																				Start: ast.Position{
																					Column: 64,
																					Line:   67,
																				},
																			},
																		},
																		Value: int64(1),
																	},
																	Lbrack: nil,
																	Rbrack: nil,
																},
															},
														},
														Operator: 2,
														Right: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 91,
																		Line:   67,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field == fields[2]",
																	Start: ast.Position{
																		Column: 70,
																		Line:   67,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 78,
																			Line:   67,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field",
																		Start: ast.Position{
																			Column: 70,
																			Line:   67,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 71,
																				Line:   67,
																			},
																			File:   "influxdb.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 70,
																				Line:   67,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 78,
																				Line:   67,
																			},
																			File:   "influxdb.flux",
																			Source: "_field",
																			Start: ast.Position{
																				Column: 72,
																				Line:   67,
																			},
																		},
																	},
																	Name: "_field",
																},
																Rbrack: nil,
															},
															Operator: 17,
															Right: &ast.IndexExpression{
																Array: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 88,
																				Line:   67,
																			},
																			File:   "influxdb.flux",
																			Source: "fields",
																			Start: ast.Position{
																				Column: 82,
																				Line:   67,
																			},
																		},
																	},
																	Name: "fields",
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 91,
																			Line:   67,
																		},
																		File:   "influxdb.flux",
																		Source: "fields[2]",
																		Start: ast.Position{
																			Column: 82,
																			Line:   67,
																		},
																	},
																},
																Index: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 90,
																				Line:   67,
																			},
																			File:   "influxdb.flux",
																			Source: "2",
																			Start: ast.Position{
																				Column: 89,
																				Line:   67,
																			},
																		},
																	},
																	Value: int64(2),
																},
																Lbrack: nil,
																Rbrack: nil,
															},
														},
													},
													Operator: 2,
													Right: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 116,
																	Line:   67,
																},
																File:   "influxdb.flux",
																Source: "r._field == fields[3]",
																Start: ast.Position{
																	Column: 95,
																	Line:   67,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 103,
																		Line:   67,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 95,
																		Line:   67,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 96,
																			Line:   67,
																		},
																		File:   "influxdb.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 95,
																			Line:   67,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 103,
																			Line:   67,
																		},
																		File:   "influxdb.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 97,
																			Line:   67,
																		},
																	},
																},
																Name: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.IndexExpression{
															Array: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 113,
																			Line:   67,
																		},
																		File:   "influxdb.flux",
																		Source: "fields",
																		Start: ast.Position{
																			Column: 107,
																			Line:   67,
																		},
																	},
																},
																Name: "fields",
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 116,
																		Line:   67,
																	},
																	File:   "influxdb.flux",
																	Source: "fields[3]",
																	Start: ast.Position{
																		Column: 107,
																		Line:   67,
																	},
																},
															},
															Index: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 115,
																			Line:   67,
																		},
																		File:   "influxdb.flux",
																		Source: "3",
																		Start: ast.Position{
																			Column: 114,
																			Line:   67,
																		},
																	},
																},
																Value: int64(3),
															},
															Lbrack: nil,
															Rbrack: nil,
														},
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   67,
															},
															File:   "influxdb.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   67,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 15,
																	Line:   67,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 14,
																	Line:   67,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
											Test: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   66,
														},
														File:   "influxdb.flux",
														Source: "nfields == 4",
														Start: ast.Position{
															Column: 17,
															Line:   66,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   66,
															},
															File:   "influxdb.flux",
															Source: "nfields",
															Start: ast.Position{
																Column: 17,
																Line:   66,
															},
														},
													},
													Name: "nfields",
												},
												Operator: 17,
												Right: &ast.IntegerLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   66,
															},
															File:   "influxdb.flux",
															Source: "4",
															Start: ast.Position{
																Column: 28,
																Line:   66,
															},
														},
													},
													Value: int64(4),
												},
											},
											Tk_else: nil,
											Tk_if:   nil,
											Tk_then: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   71,
												},
												File:   "influxdb.flux",
												Source: "if nfields == 3 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n        else if nfields == 4 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n        else if nfields == 5 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n        else\n            (r) => contains(value: r._field, set: fields)",
												Start: ast.Position{
													Column: 14,
													Line:   64,
												},
											},
										},
										Consequent: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 91,
														Line:   65,
													},
													File:   "influxdb.flux",
													Source: "(r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]",
													Start: ast.Position{
														Column: 13,
														Line:   65,
													},
												},
											},
											Body: &ast.LogicalExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 91,
															Line:   65,
														},
														File:   "influxdb.flux",
														Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2]",
														Start: ast.Position{
															Column: 20,
															Line:   65,
														},
													},
												},
												Left: &ast.LogicalExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   65,
															},
															File:   "influxdb.flux",
															Source: "r._field == fields[0] or r._field == fields[1]",
															Start: ast.Position{
																Column: 20,
																Line:   65,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   65,
																},
																File:   "influxdb.flux",
																Source: "r._field == fields[0]",
																Start: ast.Position{
																	Column: 20,
																	Line:   65,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   65,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 20,
																		Line:   65,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 21,
																			Line:   65,
																		},
																		File:   "influxdb.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 20,
																			Line:   65,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 28,
																			Line:   65,
																		},
																		File:   "influxdb.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 22,
																			Line:   65,
																		},
																	},
																},
																Name: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.IndexExpression{
															Array: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 38,
																			Line:   65,
																		},
																		File:   "influxdb.flux",
																		Source: "fields",
																		Start: ast.Position{
																			Column: 32,
																			Line:   65,
																		},
																	},
																},
																Name: "fields",
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   65,
																	},
																	File:   "influxdb.flux",
																	Source: "fields[0]",
																	Start: ast.Position{
																		Column: 32,
																		Line:   65,
																	},
																},
															},
															Index: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   65,
																		},
																		File:   "influxdb.flux",
																		Source: "0",
																		Start: ast.Position{
																			Column: 39,
																			Line:   65,
																		},
																	},
																},
																Value: int64(0),
															},
															Lbrack: nil,
															Rbrack: nil,
														},
													},
													Operator: 2,
													Right: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 66,
																	Line:   65,
																},
																File:   "influxdb.flux",
																Source: "r._field == fields[1]",
																Start: ast.Position{
																	Column: 45,
																	Line:   65,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   65,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 45,
																		Line:   65,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   65,
																		},
																		File:   "influxdb.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 45,
																			Line:   65,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   65,
																		},
																		File:   "influxdb.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 47,
																			Line:   65,
																		},
																	},
																},
																Name: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.IndexExpression{
															Array: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 63,
																			Line:   65,
																		},
																		File:   "influxdb.flux",
																		Source: "fields",
																		Start: ast.Position{
																			Column: 57,
																			Line:   65,
																		},
																	},
																},
																Name: "fields",
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 66,
																		Line:   65,
																	},
																	File:   "influxdb.flux",
																	Source: "fields[1]",
																	Start: ast.Position{
																		Column: 57,
																		Line:   65,
																	},
																},
															},
															Index: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 65,
																			Line:   65,
																		},
																		File:   "influxdb.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 64,
																			Line:   65,
																		},
																	},
																},
																Value: int64(1),
															},
															Lbrack: nil,
															Rbrack: nil,
														},
													},
												},
												Operator: 2,
												Right: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 91,
																Line:   65,
															},
															File:   "influxdb.flux",
															Source: "r._field == fields[2]",
															Start: ast.Position{
																Column: 70,
																Line:   65,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 78,
																	Line:   65,
																},
																File:   "influxdb.flux",
																Source: "r._field",
																Start: ast.Position{
																	Column: 70,
																	Line:   65,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 71,
																		Line:   65,
																	},
																	File:   "influxdb.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 70,
																		Line:   65,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 78,
																		Line:   65,
																	},
																	File:   "influxdb.flux",
																	Source: "_field",
																	Start: ast.Position{
																		Column: 72,
																		Line:   65,
																	},
																},
															},
															Name: "_field",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.IndexExpression{
														Array: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 88,
																		Line:   65,
																	},
																	File:   "influxdb.flux",
																	Source: "fields",
																	Start: ast.Position{
																		Column: 82,
																		Line:   65,
																	},
																},
															},
															Name: "fields",
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 91,
																	Line:   65,
																},
																File:   "influxdb.flux",
																Source: "fields[2]",
																Start: ast.Position{
																	Column: 82,
																	Line:   65,
																},
															},
														},
														Index: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 90,
																		Line:   65,
																	},
																	File:   "influxdb.flux",
																	Source: "2",
																	Start: ast.Position{
																		Column: 89,
																		Line:   65,
																	},
																},
															},
															Value: int64(2),
														},
														Lbrack: nil,
														Rbrack: nil,
													},
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   65,
														},
														File:   "influxdb.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   65,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   65,
															},
															File:   "influxdb.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   65,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
										Test: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   64,
													},
													File:   "influxdb.flux",
													Source: "nfields == 3",
													Start: ast.Position{
														Column: 17,
														Line:   64,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   64,
														},
														File:   "influxdb.flux",
														Source: "nfields",
														Start: ast.Position{
															Column: 17,
															Line:   64,
														},
													},
												},
												Name: "nfields",
											},
											Operator: 17,
											Right: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   64,
														},
														File:   "influxdb.flux",
														Source: "3",
														Start: ast.Position{
															Column: 28,
															Line:   64,
														},
													},
												},
												Value: int64(3),
											},
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   71,
											},
											File:   "influxdb.flux",
											Source: "if nfields == 2 then\n            (r) => r._field == fields[0] or r._field == fields[1]\n        else if nfields == 3 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n        else if nfields == 4 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n        else if nfields == 5 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n        else\n            (r) => contains(value: r._field, set: fields)",
											Start: ast.Position{
												Column: 14,
												Line:   62,
											},
										},
									},
									Consequent: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   63,
												},
												File:   "influxdb.flux",
												Source: "(r) => r._field == fields[0] or r._field == fields[1]",
												Start: ast.Position{
													Column: 13,
													Line:   63,
												},
											},
										},
										Body: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   63,
													},
													File:   "influxdb.flux",
													Source: "r._field == fields[0] or r._field == fields[1]",
													Start: ast.Position{
														Column: 20,
														Line:   63,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   63,
														},
														File:   "influxdb.flux",
														Source: "r._field == fields[0]",
														Start: ast.Position{
															Column: 20,
															Line:   63,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   63,
															},
															File:   "influxdb.flux",
															Source: "r._field",
															Start: ast.Position{
																Column: 20,
																Line:   63,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   63,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 20,
																	Line:   63,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   63,
																},
																File:   "influxdb.flux",
																Source: "_field",
																Start: ast.Position{
																	Column: 22,
																	Line:   63,
																},
															},
														},
														Name: "_field",
													},
													Rbrack: nil,
												},
												Operator: 17,
												Right: &ast.IndexExpression{
													Array: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   63,
																},
																File:   "influxdb.flux",
																Source: "fields",
																Start: ast.Position{
																	Column: 32,
																	Line:   63,
																},
															},
														},
														Name: "fields",
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   63,
															},
															File:   "influxdb.flux",
															Source: "fields[0]",
															Start: ast.Position{
																Column: 32,
																Line:   63,
															},
														},
													},
													Index: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   63,
																},
																File:   "influxdb.flux",
																Source: "0",
																Start: ast.Position{
																	Column: 39,
																	Line:   63,
																},
															},
														},
														Value: int64(0),
													},
													Lbrack: nil,
													Rbrack: nil,
												},
											},
											Operator: 2,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   63,
														},
														File:   "influxdb.flux",
														Source: "r._field == fields[1]",
														Start: ast.Position{
															Column: 45,
															Line:   63,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   63,
															},
															File:   "influxdb.flux",
															Source: "r._field",
															Start: ast.Position{
																Column: 45,
																Line:   63,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   63,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 45,
																	Line:   63,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 53,
																	Line:   63,
																},
																File:   "influxdb.flux",
																Source: "_field",
																Start: ast.Position{
																	Column: 47,
																	Line:   63,
																},
															},
														},
														Name: "_field",
													},
													Rbrack: nil,
												},
												Operator: 17,
												Right: &ast.IndexExpression{
													Array: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 63,
																	Line:   63,
																},
																File:   "influxdb.flux",
																Source: "fields",
																Start: ast.Position{
																	Column: 57,
																	Line:   63,
																},
															},
														},
														Name: "fields",
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   63,
															},
															File:   "influxdb.flux",
															Source: "fields[1]",
															Start: ast.Position{
																Column: 57,
																Line:   63,
															},
														},
													},
													Index: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   63,
																},
																File:   "influxdb.flux",
																Source: "1",
																Start: ast.Position{
																	Column: 64,
																	Line:   63,
																},
															},
														},
														Value: int64(1),
													},
													Lbrack: nil,
													Rbrack: nil,
												},
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   63,
													},
													File:   "influxdb.flux",
													Source: "r",
													Start: ast.Position{
														Column: 14,
														Line:   63,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   63,
														},
														File:   "influxdb.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   63,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
									Test: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   62,
												},
												File:   "influxdb.flux",
												Source: "nfields == 2",
												Start: ast.Position{
													Column: 17,
													Line:   62,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   62,
													},
													File:   "influxdb.flux",
													Source: "nfields",
													Start: ast.Position{
														Column: 17,
														Line:   62,
													},
												},
											},
											Name: "nfields",
										},
										Operator: 17,
										Right: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   62,
													},
													File:   "influxdb.flux",
													Source: "2",
													Start: ast.Position{
														Column: 28,
														Line:   62,
													},
												},
											},
											Value: int64(2),
										},
									},
									Tk_else: nil,
									Tk_if:   nil,
									Tk_then: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   71,
										},
										File:   "influxdb.flux",
										Source: "if nfields == 1 then\n            (r) => r._field == fields[0]\n        else if nfields == 2 then\n            (r) => r._field == fields[0] or r._field == fields[1]\n        else if nfields == 3 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n        else if nfields == 4 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n        else if nfields == 5 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n        else\n            (r) => contains(value: r._field, set: fields)",
										Start: ast.Position{
											Column: 14,
											Line:   60,
										},
									},
								},
								Consequent: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   61,
											},
											File:   "influxdb.flux",
											Source: "(r) => r._field == fields[0]",
											Start: ast.Position{
												Column: 13,
												Line:   61,
											},
										},
									},
									Body: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   61,
												},
												File:   "influxdb.flux",
												Source: "r._field == fields[0]",
												Start: ast.Position{
													Column: 20,
													Line:   61,
												},
											},
										},
										Left: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   61,
													},
													File:   "influxdb.flux",
													Source: "r._field",
													Start: ast.Position{
														Column: 20,
														Line:   61,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   61,
														},
														File:   "influxdb.flux",
														Source: "r",
														Start: ast.Position{
															Column: 20,
															Line:   61,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   61,
														},
														File:   "influxdb.flux",
														Source: "_field",
														Start: ast.Position{
															Column: 22,
															Line:   61,
														},
													},
												},
												Name: "_field",
											},
											Rbrack: nil,
										},
										Operator: 17,
										Right: &ast.IndexExpression{
											Array: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   61,
														},
														File:   "influxdb.flux",
														Source: "fields",
														Start: ast.Position{
															Column: 32,
															Line:   61,
														},
													},
												},
												Name: "fields",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   61,
													},
													File:   "influxdb.flux",
													Source: "fields[0]",
													Start: ast.Position{
														Column: 32,
														Line:   61,
													},
												},
											},
											Index: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   61,
														},
														File:   "influxdb.flux",
														Source: "0",
														Start: ast.Position{
															Column: 39,
															Line:   61,
														},
													},
												},
												Value: int64(0),
											},
											Lbrack: nil,
											Rbrack: nil,
										},
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   61,
												},
												File:   "influxdb.flux",
												Source: "r",
												Start: ast.Position{
													Column: 14,
													Line:   61,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   61,
													},
													File:   "influxdb.flux",
													Source: "r",
													Start: ast.Position{
														Column: 14,
														Line:   61,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
								Test: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   60,
											},
											File:   "influxdb.flux",
											Source: "nfields == 1",
											Start: ast.Position{
												Column: 17,
												Line:   60,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   60,
												},
												File:   "influxdb.flux",
												Source: "nfields",
												Start: ast.Position{
													Column: 17,
													Line:   60,
												},
											},
										},
										Name: "nfields",
									},
									Operator: 17,
									Right: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   60,
												},
												File:   "influxdb.flux",
												Source: "1",
												Start: ast.Position{
													Column: 28,
													Line:   60,
												},
											},
										},
										Value: int64(1),
									},
								},
								Tk_else: nil,
								Tk_if:   nil,
								Tk_then: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   71,
									},
									File:   "influxdb.flux",
									Source: "if nfields == 0 then\n            (r) => true\n        else if nfields == 1 then\n            (r) => r._field == fields[0]\n        else if nfields == 2 then\n            (r) => r._field == fields[0] or r._field == fields[1]\n        else if nfields == 3 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n        else if nfields == 4 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n        else if nfields == 5 then\n            (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n        else\n            (r) => contains(value: r._field, set: fields)",
									Start: ast.Position{
										Column: 9,
										Line:   58,
									},
								},
							},
							Consequent: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   59,
										},
										File:   "influxdb.flux",
										Source: "(r) => true",
										Start: ast.Position{
											Column: 13,
											Line:   59,
										},
									},
								},
								Body: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   59,
											},
											File:   "influxdb.flux",
											Source: "true",
											Start: ast.Position{
												Column: 20,
												Line:   59,
											},
										},
									},
									Name: "true",
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   59,
											},
											File:   "influxdb.flux",
											Source: "r",
											Start: ast.Position{
												Column: 14,
												Line:   59,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   59,
												},
												File:   "influxdb.flux",
												Source: "r",
												Start: ast.Position{
													Column: 14,
													Line:   59,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   58,
										},
										File:   "influxdb.flux",
										Source: "nfields == 0",
										Start: ast.Position{
											Column: 12,
											Line:   58,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   58,
											},
											File:   "influxdb.flux",
											Source: "nfields",
											Start: ast.Position{
												Column: 12,
												Line:   58,
											},
										},
									},
									Name: "nfields",
								},
								Operator: 17,
								Right: &ast.IntegerLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   58,
											},
											File:   "influxdb.flux",
											Source: "0",
											Start: ast.Position{
												Column: 23,
												Line:   58,
											},
										},
									},
									Value: int64(0),
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   73,
												},
												File:   "influxdb.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 12,
													Line:   73,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   74,
											},
											File:   "influxdb.flux",
											Source: "tables\n        |> filter(fn)",
											Start: ast.Position{
												Column: 12,
												Line:   73,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   74,
													},
													File:   "influxdb.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   74,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   74,
														},
														File:   "influxdb.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 19,
															Line:   74,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   74,
															},
															File:   "influxdb.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   74,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   74,
												},
												File:   "influxdb.flux",
												Source: "filter(fn)",
												Start: ast.Position{
													Column: 12,
													Line:   74,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   74,
													},
													File:   "influxdb.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   74,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   75,
										},
										File:   "influxdb.flux",
										Source: "tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()",
										Start: ast.Position{
											Column: 12,
											Line:   73,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   75,
											},
											File:   "influxdb.flux",
											Source: "v1.fieldsAsCols()",
											Start: ast.Position{
												Column: 12,
												Line:   75,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   75,
												},
												File:   "influxdb.flux",
												Source: "v1.fieldsAsCols",
												Start: ast.Position{
													Column: 12,
													Line:   75,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   75,
													},
													File:   "influxdb.flux",
													Source: "v1",
													Start: ast.Position{
														Column: 12,
														Line:   75,
													},
												},
											},
											Name: "v1",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   75,
													},
													File:   "influxdb.flux",
													Source: "fieldsAsCols",
													Start: ast.Position{
														Column: 15,
														Line:   75,
													},
												},
											},
											Name: "fieldsAsCols",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   76,
									},
									File:   "influxdb.flux",
									Source: "tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 12,
										Line:   73,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 62,
												Line:   76,
											},
											File:   "influxdb.flux",
											Source: "columns: [\"_measurement\", \"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 18,
												Line:   76,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   76,
												},
												File:   "influxdb.flux",
												Source: "columns: [\"_measurement\", \"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 18,
													Line:   76,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   76,
													},
													File:   "influxdb.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 18,
														Line:   76,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   76,
													},
													File:   "influxdb.flux",
													Source: "[\"_measurement\", \"_start\", \"_stop\"]",
													Start: ast.Position{
														Column: 27,
														Line:   76,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   76,
														},
														File:   "influxdb.flux",
														Source: "\"_measurement\"",
														Start: ast.Position{
															Column: 28,
															Line:   76,
														},
													},
												},
												Value: "_measurement",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   76,
														},
														File:   "influxdb.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 44,
															Line:   76,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   76,
														},
														File:   "influxdb.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 54,
															Line:   76,
														},
													},
												},
												Value: "_stop",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   76,
										},
										File:   "influxdb.flux",
										Source: "_mask(columns: [\"_measurement\", \"_start\", \"_stop\"])",
										Start: ast.Position{
											Column: 12,
											Line:   76,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   76,
											},
											File:   "influxdb.flux",
											Source: "_mask",
											Start: ast.Position{
												Column: 12,
												Line:   76,
											},
										},
									},
									Name: "_mask",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   76,
								},
								File:   "influxdb.flux",
								Source: "return tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 5,
									Line:   73,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   50,
							},
							File:   "influxdb.flux",
							Source: "from",
							Start: ast.Position{
								Column: 11,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "from",
								Start: ast.Position{
									Column: 11,
									Line:   50,
								},
							},
						},
						Name: "from",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   50,
							},
							File:   "influxdb.flux",
							Source: "start",
							Start: ast.Position{
								Column: 17,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "start",
								Start: ast.Position{
									Column: 17,
									Line:   50,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   50,
							},
							File:   "influxdb.flux",
							Source: "stop=now()",
							Start: ast.Position{
								Column: 24,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "stop",
								Start: ast.Position{
									Column: 24,
									Line:   50,
								},
							},
						},
						Name: "stop",
					},
					Separator: nil,
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 29,
									Line:   50,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   50,
									},
									File:   "influxdb.flux",
									Source: "now",
									Start: ast.Position{
										Column: 29,
										Line:   50,
									},
								},
							},
							Name: "now",
						},
						Lparen: nil,
						Rparen: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   50,
							},
							File:   "influxdb.flux",
							Source: "m",
							Start: ast.Position{
								Column: 36,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "m",
								Start: ast.Position{
									Column: 36,
									Line:   50,
								},
							},
						},
						Name: "m",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   50,
							},
							File:   "influxdb.flux",
							Source: "fields=[]",
							Start: ast.Position{
								Column: 39,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "fields",
								Start: ast.Position{
									Column: 39,
									Line:   50,
								},
							},
						},
						Name: "fields",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 46,
									Line:   50,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   50,
							},
							File:   "influxdb.flux",
							Source: "org=\"\"",
							Start: ast.Position{
								Column: 50,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "org",
								Start: ast.Position{
									Column: 50,
									Line:   50,
								},
							},
						},
						Name: "org",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 54,
									Line:   50,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   50,
							},
							File:   "influxdb.flux",
							Source: "host=\"\"",
							Start: ast.Position{
								Column: 58,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "host",
								Start: ast.Position{
									Column: 58,
									Line:   50,
								},
							},
						},
						Name: "host",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 63,
									Line:   50,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   50,
							},
							File:   "influxdb.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 67,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "token",
								Start: ast.Position{
									Column: 67,
									Line:   50,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 73,
									Line:   50,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   50,
							},
							File:   "influxdb.flux",
							Source: "where=(r) => true",
							Start: ast.Position{
								Column: 77,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "where",
								Start: ast.Position{
									Column: 77,
									Line:   50,
								},
							},
						},
						Name: "where",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   50,
								},
								File:   "influxdb.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 83,
									Line:   50,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 94,
										Line:   50,
									},
									File:   "influxdb.flux",
									Source: "true",
									Start: ast.Position{
										Column: 90,
										Line:   50,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   50,
									},
									File:   "influxdb.flux",
									Source: "r",
									Start: ast.Position{
										Column: 84,
										Line:   50,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   50,
										},
										File:   "influxdb.flux",
										Source: "r",
										Start: ast.Position{
											Column: 84,
											Line:   50,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   3,
					},
					File:   "influxdb.flux",
					Source: "import \"influxdata/influxdb\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   3,
						},
						File:   "influxdb.flux",
						Source: "\"influxdata/influxdb\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "influxdata/influxdb",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   4,
					},
					File:   "influxdb.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   4,
						},
						File:   "influxdb.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "influxdb.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   1,
					},
					File:   "influxdb.flux",
					Source: "package influxdb",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   1,
						},
						File:   "influxdb.flux",
						Source: "influxdb",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "influxdb",
			},
		},
	}},
	Package: "influxdb",
	Path:    "contrib/jsternberg/influxdb",
}
