'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Provider = undefined;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

exports.default = function (domNode, provider) {
  if (!(provider instanceof Provider)) {
    throw new Error('provider is not extended from the base Provider');
  }

  var defaultState = (0, _extends3.default)({}, _shortcuts2.default.defaultState, _api2.default.defaultState, _ui2.default.defaultState);
  var clientStore = new _podda2.default(defaultState);
  clientStore.registerAPI('toggle', function (store, key) {
    return store.set(key, !store.get(key));
  });

  var context = (0, _context2.default)(clientStore, domNode, provider);
  var app = (0, _mantraCore.createApp)(context);

  app.loadModule(_shortcuts2.default);
  app.loadModule(_api2.default);
  app.loadModule(_ui2.default);

  (0, _compose.setContext)(context);
  (0, _compose.setActions)(app._bindContext(app.actions)); // eslint-disable-line

  app.init();
};

var _mantraCore = require('@storybook/mantra-core');

var _podda = require('@storybook/podda');

var _podda2 = _interopRequireDefault(_podda);

var _context = require('./context');

var _context2 = _interopRequireDefault(_context);

var _shortcuts = require('./modules/shortcuts');

var _shortcuts2 = _interopRequireDefault(_shortcuts);

var _api = require('./modules/api');

var _api2 = _interopRequireDefault(_api);

var _ui = require('./modules/ui');

var _ui2 = _interopRequireDefault(_ui);

var _compose = require('./compose');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Provider = exports.Provider = function () {
  function Provider() {
    (0, _classCallCheck3.default)(this, Provider);
  }

  (0, _createClass3.default)(Provider, [{
    key: 'renderPreview',
    value: function renderPreview() {
      throw new Error('Provider.renderPreview() is not implemented!');
    }
  }, {
    key: 'handleAPI',
    value: function handleAPI() {
      throw new Error('Provider.handleAPI() is not implemented!');
    }
  }]);
  return Provider;
}();