'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react3 = require('@storybook/react');

var _Card = require('../Card');

var _Card2 = _interopRequireDefault(_Card);

var _OverflowMenu = require('../OverflowMenu');

var _OverflowMenu2 = _interopRequireDefault(_OverflowMenu);

var _OverflowMenuItem = require('../OverflowMenuItem');

var _OverflowMenuItem2 = _interopRequireDefault(_OverflowMenuItem);

var _CardFooter = require('../CardFooter');

var _CardFooter2 = _interopRequireDefault(_CardFooter);

var _CardContent = require('../CardContent');

var _CardContent2 = _interopRequireDefault(_CardContent);

var _CardStatus = require('../CardStatus');

var _CardStatus2 = _interopRequireDefault(_CardStatus);

var _CardActions = require('../CardActions');

var _CardActions2 = _interopRequireDefault(_CardActions);

var _CardActionItem = require('../CardActionItem');

var _CardActionItem2 = _interopRequireDefault(_CardActionItem);

var _Button = require('../Button');

var _Button2 = _interopRequireDefault(_Button);

var _Link = require('../Link');

var _Link2 = _interopRequireDefault(_Link);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* eslint-disable no-console */

var cardProps = {
  onClick: function onClick() {
    console.log('click');
  },
  onFocus: function onFocus() {
    console.log('focus');
  },
  className: 'some-class'
};

var overflowMenuProps = {
  onClick: function onClick() {
    console.log('click');
  },
  onFocus: function onFocus() {
    console.log('focus');
  },
  className: 'some-class'
};

var overflowMenuItemProps = {
  onFocus: function onFocus() {
    console.log('focus');
  },
  className: 'some-class'
};

var ControlledCard = function (_Component) {
  _inherits(ControlledCard, _Component);

  function ControlledCard(props) {
    _classCallCheck(this, ControlledCard);

    var _this = _possibleConstructorReturn(this, (ControlledCard.__proto__ || Object.getPrototypeOf(ControlledCard)).call(this, props));

    _this.stopApp = function () {
      _this.setState({
        status: _CardStatus2.default.appStatus.STOPPED
      });
    };

    _this.restartApp = function () {
      _this.setState({
        status: _CardStatus2.default.appStatus.RUNNING
      });
    };

    _this.deleteApp = function () {
      console.log('Example function deleteApp() is triggered');
    };

    _this.renameApp = function () {
      console.log('Example function renameApp() is triggered');
    };

    _this.goToApp = function () {
      console.log('Example function goToApp() is triggered');
    };

    _this.favoriteApp = function () {
      console.log('Example function favoriteApp() is triggered');
    };

    _this.state = {
      status: _this.props.status
    };
    return _this;
  }

  _createClass(ControlledCard, [{
    key: 'render',
    value: function render() {
      var cardLinks = ['http://myapp.mybluemix.net'];

      return this.props.simple ? _react2.default.createElement(
        _Card2.default,
        cardProps,
        _react2.default.createElement(
          _CardContent2.default,
          {
            cardTitle: 'Card Name',
            cardIcon: 'app-services',
            cardInfo: ['Secondary Information'] },
          _react2.default.createElement(
            _OverflowMenu2.default,
            overflowMenuProps,
            _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, { itemText: 'Stop App' })),
            _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, {
              itemText: 'Restart App'
            })),
            _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, {
              itemText: 'Rename App'
            })),
            _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, {
              itemText: 'Delete App',
              hasDivider: true
            }))
          )
        ),
        _react2.default.createElement(
          _CardFooter2.default,
          null,
          _react2.default.createElement(
            _Button2.default,
            { small: true, kind: 'primary' },
            'View credentials'
          ),
          _react2.default.createElement(
            _Link2.default,
            { href: '#', className: 'bx--card-footer__link' },
            'Link'
          )
        )
      ) : _react2.default.createElement(
        _Card2.default,
        cardProps,
        _react2.default.createElement(
          _CardContent2.default,
          { cardTitle: 'App Title 1', cardLink: cardLinks },
          _react2.default.createElement(
            _OverflowMenu2.default,
            overflowMenuProps,
            _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, {
              itemText: 'Stop App',
              onClick: this.stopApp
            })),
            _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, {
              itemText: 'Restart App',
              onClick: this.restartApp
            })),
            _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, {
              itemText: 'Rename App',
              onClick: this.renameApp
            })),
            _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, {
              itemText: 'Delete App',
              hasDivider: true,
              onClick: this.deleteApp
            }))
          )
        ),
        _react2.default.createElement(
          _CardFooter2.default,
          null,
          _react2.default.createElement(_CardStatus2.default, { status: this.state.status }),
          _react2.default.createElement(
            _CardActions2.default,
            null,
            _react2.default.createElement(_CardActionItem2.default, {
              iconName: 'restart--glyph',
              onClick: this.restartApp,
              description: 'Restart App'
            }),
            _react2.default.createElement(_CardActionItem2.default, {
              iconName: 'launch--glyph',
              onClick: this.goToApp,
              description: 'Go To App'
            }),
            _react2.default.createElement(_CardActionItem2.default, {
              iconName: 'favorite',
              onClick: this.favoriteApp,
              description: 'Favorite App'
            })
          )
        )
      );
    }
  }]);

  return ControlledCard;
}(_react.Component);

ControlledCard.propTypes = {
  status: _propTypes2.default.number,
  simple: _propTypes2.default.bool
};
ControlledCard.defaultProps = {
  status: _CardStatus2.default.appStatus.RUNNING,
  simple: false
};


(0, _react3.storiesOf)('Card', module).addWithInfo('card', '\n      Cards provide an at-a glance preview of the content they link to and frequently contain\n      easily-consumable content. The example below shows an empty card. Create Card Content, Card Footer,\n      Card Status and Card Actions components to add content to your card.\n    ', function () {
  return _react2.default.createElement(ControlledCard, { simple: true });
}).addWithInfo('card with example functions', '\n      Cards provide an at-a glance preview of the content they link to and frequently contain\n      easily-consumable content. The Card component can be divided into seperate parts.\n      Use the Card Footer component to add a section to the bottom of your Card. The Card Content component\n      contains the main content of the card (cardIcon, cardTitle, cardLink, cardInfo). Card Status displays the\n      current status of the application (RUNNING, NOT_RUNNING, STOPPED). Finally, create Card Actions\n      to add functional buttons with icons. The example below shows a Card component with info and an Overflow Menu in the\n      Card Content, plus Restart/Go To/Favorite actions in the Card Footer.\n    ', function () {
  return _react2.default.createElement(ControlledCard, { status: _CardStatus2.default.appStatus.RUNNING });
}).addWithInfo('basic card', '\n      Cards provide an at-a glance preview of the content they link to and frequently contain\n      easily-consumable content. The example below shows an empty card. Create Card Content, Card Footer,\n      Card Status and Card Actions components to add content to your card.\n    ', function () {
  return _react2.default.createElement(_Card2.default, null);
});