'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _DangerButton = require('../DangerButton');

var _DangerButton2 = _interopRequireDefault(_DangerButton);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('DangerButton', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _DangerButton2.default,
      { small: true, className: 'extra-class' },
      _react2.default.createElement(
        'div',
        { className: 'child' },
        'Test'
      ),
      _react2.default.createElement(
        'div',
        { className: 'child' },
        'Test'
      )
    ));

    it('Renders children as expected', function () {
      expect(wrapper.find('.child').length).toBe(2);
      expect(wrapper.find('svg').length).toBe(0);
    });
    it('Renders wrapper as expected', function () {
      expect(wrapper.length).toBe(1);
    });
    it('Has kind="danger"', function () {
      expect(wrapper.props().kind).toEqual('danger');
    });
    it('Has small property', function () {
      expect(wrapper.props().small).toEqual(true);
    });
    it('Should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });

    describe('Renders icon buttons', function () {
      var iconButton = (0, _enzyme.mount)(_react2.default.createElement(
        _DangerButton2.default,
        { icon: 'search', iconDescription: 'Search' },
        'Search'
      ));
      var icon = iconButton.find('svg');
      it('should have the appropriate icon', function () {
        expect(icon.hasClass('bx--btn__icon')).toBe(true);
      });
    });
  });
});