'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _Breadcrumb = require('../Breadcrumb');

var _Breadcrumb2 = _interopRequireDefault(_Breadcrumb);

var _BreadcrumbItem = require('../BreadcrumbItem');

var _BreadcrumbItem2 = _interopRequireDefault(_BreadcrumbItem);

var _OverflowMenu = require('../OverflowMenu');

var _OverflowMenu2 = _interopRequireDefault(_OverflowMenu);

var _OverflowMenuItem = require('../OverflowMenuItem');

var _OverflowMenuItem2 = _interopRequireDefault(_OverflowMenuItem);

var _DetailPageHeader = require('../DetailPageHeader');

var _DetailPageHeader2 = _interopRequireDefault(_DetailPageHeader);

var _Tabs = require('../Tabs');

var _Tabs2 = _interopRequireDefault(_Tabs);

var _Tab = require('../Tab');

var _Tab2 = _interopRequireDefault(_Tab);

var _Icon = require('../Icon');

var _Icon2 = _interopRequireDefault(_Icon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var detailPageHeaderProps = {
  title: 'Detail Page Header',
  statusText: 'Running'
};

var overflowMenuProps = {
  onClick: (0, _addonActions.action)('onClick'),
  className: 'some-class',
  flipped: true
};

var overflowMenuItemProps = {
  onClick: (0, _addonActions.action)('onClick'),
  className: 'some-class'
};

(0, _react3.storiesOf)('DetailPageHeader', module).addDecorator(function (story) {
  return _react2.default.createElement(
    'div',
    { style: { minWidth: '60em' } },
    story()
  );
}).addWithInfo('without tabs', function () {
  return _react2.default.createElement(
    _DetailPageHeader2.default,
    detailPageHeaderProps,
    _react2.default.createElement(_Icon2.default, { name: 'watson' }),
    _react2.default.createElement(
      _Breadcrumb2.default,
      null,
      _react2.default.createElement(
        _BreadcrumbItem2.default,
        { href: 'www.google.com' },
        'Breadcrumb 1'
      ),
      _react2.default.createElement(
        _BreadcrumbItem2.default,
        { href: 'www.google.com' },
        'Breadcrumb 2'
      ),
      _react2.default.createElement(
        _BreadcrumbItem2.default,
        { href: 'www.google.com' },
        'Breadcrumb 3'
      )
    ),
    _react2.default.createElement(
      _OverflowMenu2.default,
      overflowMenuProps,
      _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, { itemText: 'Stop App' })),
      _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, { itemText: 'Restart App' })),
      _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, { itemText: 'Rename App' })),
      _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, {
        itemText: 'Edit Routes and Access'
      })),
      _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, {
        itemText: 'Delete App',
        isDelete: true,
        isLastItem: true
      }))
    )
  );
}).addWithInfo('with tabs', function () {
  return _react2.default.createElement(
    _DetailPageHeader2.default,
    _extends({}, detailPageHeaderProps, { hasTabs: true }),
    _react2.default.createElement(_Icon2.default, { name: 'watson' }),
    _react2.default.createElement(
      _Breadcrumb2.default,
      null,
      _react2.default.createElement(
        _BreadcrumbItem2.default,
        { href: 'www.google.com' },
        'Breadcrumb 1'
      ),
      _react2.default.createElement(
        _BreadcrumbItem2.default,
        { href: 'www.google.com' },
        'Breadcrumb 2'
      ),
      _react2.default.createElement(
        _BreadcrumbItem2.default,
        { href: 'www.google.com' },
        'Breadcrumb 3'
      )
    ),
    _react2.default.createElement(
      _OverflowMenu2.default,
      overflowMenuProps,
      _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, { itemText: 'Stop App' })),
      _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, { itemText: 'Restart App' })),
      _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, { itemText: 'Rename App' })),
      _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, {
        itemText: 'Edit Routes and Access'
      })),
      _react2.default.createElement(_OverflowMenuItem2.default, _extends({}, overflowMenuItemProps, {
        itemText: 'Delete App',
        isDelete: true,
        isLastItem: true
      }))
    ),
    _react2.default.createElement(
      _Tabs2.default,
      null,
      _react2.default.createElement(_Tab2.default, { label: 'Overview' }),
      _react2.default.createElement(_Tab2.default, { label: 'Apple' }),
      _react2.default.createElement(_Tab2.default, { label: 'Banana' }),
      _react2.default.createElement(_Tab2.default, { label: 'Orange' })
    )
  );
});