'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Link = require('../Link');

var _Link2 = _interopRequireDefault(_Link);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Link', function () {
  describe('Renders as expected', function () {
    var link = (0, _enzyme.shallow)(_react2.default.createElement(
      _Link2.default,
      { href: 'www.google.com', className: 'some-class' },
      'A simple link'
    ));
    it('should use the appropriate link class', function () {
      expect(link.hasClass('bx--link')).toEqual(true);
    });
    it('should inherit the href property', function () {
      expect(link.props().href).toEqual('www.google.com');
    });
    it('should include child content', function () {
      expect(link.text()).toEqual('A simple link');
    });
    it('should all for custom classes to be applied', function () {
      expect(link.hasClass('some-class')).toEqual(true);
    });
  });
});