"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

var Selection =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Selection, _React$Component);

  function Selection(props) {
    var _this;

    _classCallCheck(this, Selection);

    _this = _possibleConstructorReturn(this, (Selection.__proto__ || Object.getPrototypeOf(Selection)).call(this, props));
    Object.defineProperty(_assertThisInitialized(_this), "internalSetState", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(stateToSet, callback) {
        return _this.setState(stateToSet, function () {
          if (callback) {
            callback();
          }

          if (_this.props.onChange) {
            _this.props.onChange(_this.state);
          }
        });
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleClearSelection", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        _this.internalSetState({
          selectedItems: []
        });
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleSelectItem", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(item) {
        _this.internalSetState(function (state) {
          return {
            selectedItems: state.selectedItems.concat(item)
          };
        });
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleRemoveItem", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(index) {
        _this.internalSetState(function (state) {
          return {
            selectedItems: removeAtIndex(state.selectedItems, index)
          };
        });
      }
    });
    Object.defineProperty(_assertThisInitialized(_this), "handleOnItemChange", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(item) {
        var selectedItems = _this.state.selectedItems;
        var selectedIndex = selectedItems.indexOf(item);

        if (selectedIndex === -1) {
          _this.handleSelectItem(item);

          return;
        }

        _this.handleRemoveItem(selectedIndex);
      }
    });
    _this.state = {
      selectedItems: props.initialSelectedItems
    };
    return _this;
  }

  _createClass(Selection, [{
    key: "render",
    value: function render() {
      var _props = this.props,
          children = _props.children,
          render = _props.render;
      var selectedItems = this.state.selectedItems;
      var renderProps = {
        selectedItems: selectedItems,
        onItemChange: this.handleOnItemChange,
        clearSelection: this.handleClearSelection
      };

      if (render !== undefined) {
        return render(renderProps);
      }

      if (children !== undefined) {
        return children(renderProps);
      }

      return null;
    }
  }]);

  return Selection;
}(_react.default.Component); // Generic utility for safely removing an element at a given index from an
// array.


exports.default = Selection;
Object.defineProperty(Selection, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    initialSelectedItems: _propTypes.default.array.isRequired
  }
});
Object.defineProperty(Selection, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    initialSelectedItems: []
  }
});

var removeAtIndex = function removeAtIndex(array, index) {
  var result = array.slice();
  result.splice(index, 1);
  return result;
};