var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import warning from 'warning';
import settings from '../../globals/js/settings';
import mixin from '../../globals/js/misc/mixin';
import createComponent from '../../globals/js/mixins/create-component';
import initComponentBySearch from '../../globals/js/mixins/init-component-by-search';
import handles from '../../globals/js/mixins/handles';
import eventMatches from '../../globals/js/misc/event-matches';
import on from '../../globals/js/misc/on';

var didWarnAboutDeprecation = false;

var Card = function (_mixin) {
  _inherits(Card, _mixin);

  /**
   * The container for cards.
   * @extends CreateComponent
   * @extends InitComponentBySearch
   * @extends Handles
   * @param {HTMLElement} element The element working as a container.
   * @param {Object} [options] The component options.
   * @param {string} [options.selectorCard] The CSS selector to find cards.
   */
  function Card(element, options) {
    _classCallCheck(this, Card);

    var _this = _possibleConstructorReturn(this, (Card.__proto__ || Object.getPrototypeOf(Card)).call(this, element, options));

    _this.manage(on(_this.element, 'keydown', function (event) {
      _this._cardKeyPress(event);
    }));
    if (process.env.NODE_ENV !== 'production') {
      process.env.NODE_ENV !== 'production' ? warning(didWarnAboutDeprecation, 'Accessing the `card` component from the `carbon-components` package ' + 'is deprecated. Use the `carbon-addons-cloud` package instead.') : void 0;
      didWarnAboutDeprecation = true;
    }
    return _this;
  }

  /**
   * Goes back/forward among cards,
   * right arrow key for going forward, left arrow key for going backward.
   * @param {Event} event The event triggering this method.
   */


  _createClass(Card, [{
    key: '_cardKeyPress',
    value: function _cardKeyPress(event) {
      var direction = {
        37: this.constructor.NAVIGATE.BACKWARD,
        39: this.constructor.NAVIGATE.FORWARD
      }[event.which];
      var card = eventMatches(event, this.options.selectorCard);

      if (direction && card && card === document.activeElement) {
        var cards = [].concat(_toConsumableArray(this.element.querySelectorAll(this.options.selectorCard)));
        var nextIndex = Math.max(cards.indexOf(card) + direction, -1 /* For `card` not found in `cards` */);
        var nextIndexLooped = nextIndex >= 0 && nextIndex < cards.length ? nextIndex : nextIndex - Math.sign(nextIndex) * cards.length;
        cards[nextIndexLooped].focus();
      }
    }

    /**
     * The map associating DOM element and card list instance.
     * @member Card.components
     * @type {WeakMap}
     */

  }], [{
    key: 'options',


    /**
     * The component options.
     * If `options` is specified in the constructor, {@linkcode Card.create .create()}, or {@linkcode Card.init .init()},
     * properties in this object are overriden for the instance being create and how {@linkcode Card.init .init()} works.
     * @member Card.options
     * @type {Object}
     * @property {string} selectorInit The CSS selector to find card containers.
     * @property {string} [selectorCard] The CSS selector to find cards.
     */
    get: function get() {
      var prefix = settings.prefix;

      return {
        selectorInit: '[data-card-list]',
        selectorCard: '.' + prefix + '--card'
      };
    }

    /**
     * Enum for navigating backward/forward.
     * @readonly
     * @member Card.NAVIGATE
     * @type {Object}
     * @property {number} BACKWARD Navigating backward.
     * @property {number} FORWARD Navigating forward.
     */

  }]);

  return Card;
}(mixin(createComponent, initComponentBySearch, handles));

Card.components = new WeakMap();
Card.NAVIGATE = {
  BACKWARD: -1,
  FORWARD: 1
};


export default Card;