'use strict';

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var iconHelpers = require('@carbon/icon-helpers');
var PropTypes = _interopDefault(require('prop-types'));
var React = _interopDefault(require('react'));

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var defaultStyle = {
  "willChange": "transform"
};
var LogoSnapchat20 = React.forwardRef(function (_ref, ref) {
  var className = _ref.className,
      children = _ref.children,
      style = _ref.style,
      tabIndex = _ref.tabIndex,
      rest = _objectWithoutProperties(_ref, ["className", "children", "style", "tabIndex"]);

  var _getAttributes = iconHelpers.getAttributes(_objectSpread({}, rest, {
    tabindex: tabIndex
  })),
      tabindex = _getAttributes.tabindex,
      props = _objectWithoutProperties(_getAttributes, ["tabindex"]);

  if (className) {
    props.className = className;
  }

  if (tabindex !== undefined && tabindex !== null) {
    props.tabIndex = tabindex;
  }

  if (_typeof(style) === 'object') {
    props.style = _objectSpread({}, defaultStyle, style);
  } else {
    props.style = defaultStyle;
  }

  if (ref) {
    props.ref = ref;
  }

  return React.createElement('svg', props, children, React.createElement('path', {
    d: 'M30 8.56a8.44 8.44 0 0 0-.13-1.5 6.13 6.13 0 0 0-.57-1.74 6.13 6.13 0 0 0-1.2-1.56 5.88 5.88 0 0 0-2.54-1.45A10.66 10.66 0 0 0 22.87 2H9.13c-.51 0-1 0-1.54.07a7.73 7.73 0 0 0-1.65.37A5.89 5.89 0 0 0 3.76 3.9 5.78 5.78 0 0 0 2.3 6.45 10 10 0 0 0 2 9.12v13.77a16.2 16.2 0 0 0 .13 1.86 6.46 6.46 0 0 0 .57 1.89 6 6 0 0 0 1.68 2 5.45 5.45 0 0 0 1.69.92 9 9 0 0 0 2.77.4h14.57a9.59 9.59 0 0 0 1.68-.18 5.74 5.74 0 0 0 2.81-1.36 5.85 5.85 0 0 0 1.86-3.1 11.25 11.25 0 0 0 .24-2.43V8.56zm-3.75 13c-.18.42-1.08.77-2.61 1-.15 0-.21.26-.29.64a4.05 4.05 0 0 1-.12.47.28.28 0 0 1-.3.23 2.15 2.15 0 0 1-.44-.06 5.3 5.3 0 0 0-2-.05 3.94 3.94 0 0 0-1.57.81 4.56 4.56 0 0 1-2.76 1.08h-.26a4.56 4.56 0 0 1-2.76-1.08 4 4 0 0 0-1.58-.81 5.92 5.92 0 0 0-.82-.07 6 6 0 0 0-1.15.13 2.07 2.07 0 0 1-.44.06.3.3 0 0 1-.33-.23 4.15 4.15 0 0 1-.11-.48c-.09-.38-.15-.61-.29-.63-1.53-.24-2.44-.59-2.62-1a.31.31 0 0 1 0-.13.24.24 0 0 1 .2-.26 5.35 5.35 0 0 0 3.22-1.91 7.37 7.37 0 0 0 1.1-1.71 1.08 1.08 0 0 0 .11-.92c-.2-.47-.85-.67-1.29-.81l-.29-.1c-.38-.15-1-.47-.93-.91a.85.85 0 0 1 .84-.55.66.66 0 0 1 .25 0 2.58 2.58 0 0 0 1 .28.89.89 0 0 0 .6-.19v-.61a10.24 10.24 0 0 1 .19-4.15 5.38 5.38 0 0 1 5-3.22h.41a5.38 5.38 0 0 1 5 3.22 10.61 10.61 0 0 1 .25 4.14v.61a.82.82 0 0 0 .54.18 2.55 2.55 0 0 0 1-.27.84.84 0 0 1 .32-.06.9.9 0 0 1 .37.07.68.68 0 0 1 .51.56c0 .21-.16.53-.94.84l-.29.1c-.43.14-1.09.34-1.28.81a1.11 1.11 0 0 0 .1.92c.05.13 1.37 3.13 4.31 3.62a.26.26 0 0 1 .21.26.65.65 0 0 1-.09.14z'
  }));
});
LogoSnapchat20.displayName = 'LogoSnapchat20';
LogoSnapchat20.propTypes = {
  'aria-hidden': PropTypes.bool,
  'aria-label': PropTypes.string,
  'aria-labelledby': PropTypes.string,
  className: PropTypes.string,
  children: PropTypes.node,
  height: PropTypes.number,
  preserveAspectRatio: PropTypes.string,
  tabIndex: PropTypes.string,
  viewBox: PropTypes.string,
  width: PropTypes.number,
  xmlns: PropTypes.string
};
LogoSnapchat20.defaultProps = {
  width: 20,
  height: 20,
  viewBox: '0 0 32 32',
  xmlns: 'http://www.w3.org/2000/svg',
  preserveAspectRatio: 'xMidYMid meet'
};

module.exports = LogoSnapchat20;
