'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _ListItem = require('../ListItem');

var _ListItem2 = _interopRequireDefault(_ListItem);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('ListItem', function () {
  describe('Renders as expected', function () {
    var item = (0, _enzyme.shallow)(_react2.default.createElement(
      _ListItem2.default,
      { className: 'some-class' },
      'An Item'
    ));

    it('should render as an li element', function () {
      expect(item.find('li').length).toEqual(1);
    });

    it('should render with the appropriate classes', function () {
      expect(item.hasClass('bx--list__item')).toEqual(true);
      expect(item.hasClass('some-class')).toEqual(true);
    });

    it('should include child content', function () {
      expect(item.text()).toEqual('An Item');
    });
  });
});