"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

var ContentSwitcher =
/*#__PURE__*/
function (_React$Component) {
  _inherits(ContentSwitcher, _React$Component);

  function ContentSwitcher() {
    var _ref;

    var _temp, _this;

    _classCallCheck(this, ContentSwitcher);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _possibleConstructorReturn(_this, (_temp = _this = _possibleConstructorReturn(this, (_ref = ContentSwitcher.__proto__ || Object.getPrototypeOf(ContentSwitcher)).call.apply(_ref, [this].concat(args))), Object.defineProperty(_assertThisInitialized(_this), "state", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: {
        selectedIndex: _this.props.selectedIndex
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "handleChildChange", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(data) {
        var selectedIndex = _this.state.selectedIndex;
        var index = data.index;

        if (selectedIndex !== index) {
          _this.setState({
            selectedIndex: index
          });

          _this.props.onChange(data);
        }
      }
    }), _temp));
  }

  _createClass(ContentSwitcher, [{
    key: "getChildren",
    value: function getChildren(children) {
      var _this2 = this;

      return _react.default.Children.map(children, function (child, index) {
        return _react.default.cloneElement(child, {
          index: index,
          onClick: _this2.handleChildChange,
          onKeyDown: _this2.handleChildChange,
          selected: index === _this2.state.selectedIndex
        });
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _props = this.props,
          children = _props.children,
          className = _props.className,
          selectedIndex = _props.selectedIndex,
          other = _objectWithoutProperties(_props, ["children", "className", "selectedIndex"]);

      var classes = (0, _classnames.default)('bx--content-switcher', className);
      return _react.default.createElement("div", _extends({}, other, {
        className: classes
      }), this.getChildren(children));
    }
  }]);

  return ContentSwitcher;
}(_react.default.Component);

exports.default = ContentSwitcher;
Object.defineProperty(ContentSwitcher, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    children: _propTypes.default.node,
    className: _propTypes.default.string,
    onChange: _propTypes.default.func.isRequired,
    selectedIndex: _propTypes.default.number
  }
});
Object.defineProperty(ContentSwitcher, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    selectedIndex: 0
  }
});