var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import warning from 'warning';
import settings from '../../globals/js/settings';
import mixin from '../../globals/js/misc/mixin';
import createComponent from '../../globals/js/mixins/create-component';
import initComponentBySearch from '../../globals/js/mixins/init-component-by-search';
import handles from '../../globals/js/mixins/handles';
import eventMatches from '../../globals/js/misc/event-matches';
import on from '../../globals/js/misc/on';
import toggleClass from '../../globals/js/misc/svg-toggle-class';

var didWarnAboutDeprecation = false;

var InteriorLeftNav = function (_mixin) {
  _inherits(InteriorLeftNav, _mixin);

  /**
   * Interior left nav.
   * @extends CreateComponent
   * @extends InitComponentBySearch
   * @extends Handles
   * @param {HTMLElement} element The element working as an interior left nav.
   * @param {Object} options The component options.
   */
  function InteriorLeftNav(element, options) {
    _classCallCheck(this, InteriorLeftNav);

    var _this = _possibleConstructorReturn(this, (InteriorLeftNav.__proto__ || Object.getPrototypeOf(InteriorLeftNav)).call(this, element, options));

    _this.hookListItemsEvents = function () {
      _this.manage(on(_this.element, 'click', function (evt) {
        var leftNavItem = eventMatches(evt, _this.options.selectorLeftNavListItem);
        var collapseEl = eventMatches(evt, _this.options.selectorLeftNavCollapse);
        var collapsedBar = eventMatches(evt, '.' + _this.options.classLeftNavCollapsed);

        if (leftNavItem) {
          var childItem = eventMatches(evt, _this.options.selectorLeftNavNestedListItem);
          var hasChildren = leftNavItem.classList.contains('left-nav-list__item--has-children');
          if (childItem) {
            _this.addActiveListItem(childItem);
          } else if (hasChildren) {
            _this.handleNestedListClick(leftNavItem, evt);
          } else {
            _this.addActiveListItem(leftNavItem);
          }
        }

        if (collapseEl || collapsedBar) {
          evt.preventDefault();
          _this.toggleLeftNav();
        }
      }));

      _this.manage(on(_this.element, 'keydown', function (evt) {
        var leftNavItemWithChildren = eventMatches(evt, _this.options.selectorLeftNavListItemHasChildren);
        var leftNavItem = eventMatches(evt, _this.options.selectorLeftNavListItem);

        if (leftNavItemWithChildren && evt.which === 13) {
          _this.handleNestedListClick(leftNavItemWithChildren, evt);
        } else if (leftNavItem && evt.which === 13) {
          _this.addActiveListItem(leftNavItem);
        }
      }));
    };

    _this.toggleLeftNav = function () {
      var collapsed = _this.element.dataset.collapsed === 'true';
      var eventStart = new CustomEvent(_this.options.eventBeforeLeftNavToggled, {
        bubbles: true,
        cancelable: true,
        detail: { collapsed: !collapsed } // shows where the toggle is going, not where it is
      });

      if (_this.element.dispatchEvent(eventStart)) {
        var svgTitle = _this.element.querySelector(_this.options.selectorLeftNavArrowTitle);
        if (!collapsed) {
          _this.element.dataset.collapsed = true;
          _this.element.classList.add(_this.options.classLeftNavCollapsing);
          if (svgTitle) {
            svgTitle.textContent = _this.options.expandTitle;
          }
          window.setTimeout(function () {
            _this.element.classList.remove(_this.options.classLeftNavCollapsing);
            _this.element.classList.add(_this.options.classLeftNavCollapsed);
            _this.element.dispatchEvent(new CustomEvent(_this.options.eventAfterLeftNavToggled, {
              bubbles: true,
              cancelable: true,
              detail: { collapsed: true }
            }));
          }, 250);
        } else {
          _this.element.dataset.collapsed = false;
          _this.element.classList.remove(_this.options.classLeftNavCollapsed);
          _this.element.classList.add(_this.options.classLeftNavExpanding);
          if (svgTitle) {
            svgTitle.textContent = _this.options.collapsePane;
          }
          window.setTimeout(function () {
            _this.element.classList.remove(_this.options.classLeftNavExpanding);
            _this.element.dispatchEvent(new CustomEvent(_this.options.eventAfterLeftNavToggled, {
              bubbles: true,
              cancelable: true,
              detail: { collapsed: false }
            }));
          }, 250);
        }
      }
    };

    _this.constructor.components.set(_this.element, _this);

    _this.keepOpen = _this.element.dataset.keepOpen === undefined ? _this.options.keepOpen : Boolean(_this.element.dataset.keepOpen);

    _this.hookListItemsEvents();
    if (process.env.NODE_ENV !== 'production') {
      process.env.NODE_ENV !== 'production' ? warning(didWarnAboutDeprecation, 'Accessing the `interior-left-nav` component from the' + '`carbon-components` package is deprecated. Use the' + '`carbon-addons-cloud` package instead.') : void 0;
      didWarnAboutDeprecation = true;
    }
    return _this;
  }

  _createClass(InteriorLeftNav, [{
    key: 'addActiveListItem',
    value: function addActiveListItem(item) {
      var _this2 = this;

      [].concat(_toConsumableArray(this.element.querySelectorAll(this.options.selectorLeftNavListItem))).forEach(function (currentItem) {
        if (!(item === currentItem)) {
          currentItem.classList.remove(_this2.options.classActiveLeftNavListItem);
        }
      });
      [].concat(_toConsumableArray(this.element.querySelectorAll(this.options.selectorLeftNavNestedListItem))).forEach(function (currentItem) {
        if (!(item === currentItem)) {
          currentItem.classList.remove(_this2.options.classActiveLeftNavListItem);
        }
      });
      item.classList.add(this.options.classActiveLeftNavListItem);
    }

    /**
     * Handles click on a list item that contains a nested list in the left navigation.
     * The nested list is expanded and the icon is rotated.
     * @param {HTMLElement} listItem The list item that was clicked.
     * @param {Event} evt The evt triggering this method.
     */

  }, {
    key: 'handleNestedListClick',
    value: function handleNestedListClick(listItem, evt) {
      var _this3 = this;

      var allNestedItems = [].concat(_toConsumableArray(this.element.querySelectorAll(this.options.selectorLeftNavListItemHasChildren)));
      var isOpen = listItem.classList.contains(this.options.classExpandedLeftNavListItem);
      var list = listItem.querySelector(this.options.selectorLeftNavNestedList);
      var listItems = [].concat(_toConsumableArray(list.querySelectorAll(this.options.selectorLeftNavNestedListItem)));

      if (!this.keepOpen) {
        allNestedItems.forEach(function (currentItem) {
          if (currentItem !== listItem) {
            toggleClass(currentItem, _this3.options.classExpandedLeftNavListItem, false);
          }
        });
      }

      if (!('InteriorLeftNavItemLink' in evt.target.dataset)) {
        toggleClass(listItem, this.options.classExpandedLeftNavListItem, !isOpen);
      }

      // a11y
      listItems.forEach(function (item) {
        if (isOpen) {
          // eslint-disable-next-line no-param-reassign
          item.querySelector(_this3.options.selectorLeftNavListItemLink).tabIndex = -1;
        } else {
          // eslint-disable-next-line no-param-reassign
          item.querySelector(_this3.options.selectorLeftNavListItemLink).tabIndex = 0;
        }
      });
    }

    /**
     * The map associating DOM element and spinner instance.
     * @member InteriorLeftNav.components
     * @type {WeakMap}
     */

  }], [{
    key: 'options',


    /**
     * The component options.
     * If `options` is specified in the constructor,
     * {@linkcode InteriorLeftNav.create .create()}, or {@linkcode InteriorLeftNav.init .init()},
     * properties in this object are overriden for the instance being create and how {@linkcode InteriorLeftNav.init .init()} works.
     * @member InteriorLeftNav.options
     * @type {Object}
     * @property {string} selectorInit The CSS selector to find interior left navs.
     */
    get: function get() {
      var prefix = settings.prefix;

      return {
        selectorInit: '[data-interior-left-nav]',
        // Data Attribute selectors
        selectorLeftNavList: '[data-interior-left-nav-list]',
        selectorLeftNavNestedList: '[data-interior-left-nav-nested-list]',
        selectorLeftNavListItem: '[data-interior-left-nav-item]',
        selectorLeftNavListItemLink: '[data-interior-left-nav-item-link]',
        selectorLeftNavNestedListItem: '[data-interior-left-nav-nested-item]',
        selectorLeftNavListItemHasChildren: '[data-interior-left-nav-with-children]',
        selectorLeftNavCollapse: '[data-interior-left-nav-collapse]',
        selectorLeftNavArrowTitle: '[data-interior-left-nav-arrow] title',
        // CSS Class Selectors
        classActiveLeftNavListItem: 'left-nav-list__item--active',
        classExpandedLeftNavListItem: 'left-nav-list__item--expanded',
        classLeftNavCollapsing: prefix + '--interior-left-nav--collapsing',
        classLeftNavCollapsed: prefix + '--interior-left-nav--collapsed',
        classLeftNavExpanding: prefix + '--interior-left-nav--expanding',
        // Event
        eventBeforeLeftNavToggled: 'left-nav-beingtoggled',
        eventAfterLeftNavToggled: 'left-nav-toggled',
        // Option
        expandTitle: 'Expand nav pane',
        collapseTitle: 'Collapse nav pane',
        keepOpen: false
      };
    }
  }]);

  return InteriorLeftNav;
}(mixin(createComponent, initComponentBySearch, handles));

InteriorLeftNav.components = new WeakMap();


export default InteriorLeftNav;