"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const TreeViewList_1 = require("./TreeViewList");
const TreeViewListItem_1 = require("./TreeViewListItem");
exports.TreeView = (_a) => {
    var { data, isNested = false, hasChecks = false, hasBadges = false, defaultAllExpanded = false, icon, expandedIcon, parentItem, onSelect, onCheck, onSearch, searchProps, activeItems, compareItems = (item, itemToCheck) => item.id === itemToCheck.id } = _a, props = tslib_1.__rest(_a, ["data", "isNested", "hasChecks", "hasBadges", "defaultAllExpanded", "icon", "expandedIcon", "parentItem", "onSelect", "onCheck", "onSearch", "searchProps", "activeItems", "compareItems"]);
    return (react_1.default.createElement(TreeViewList_1.TreeViewList, Object.assign({ isNested: isNested, onSearch: onSearch, searchProps: searchProps }, props), data.map(item => (react_1.default.createElement(TreeViewListItem_1.TreeViewListItem, Object.assign({ key: item.name.toString(), name: item.name, id: item.id, defaultExpanded: item.defaultExpanded !== undefined ? item.defaultExpanded : defaultAllExpanded, onSelect: onSelect, onCheck: onCheck, hasCheck: item.hasCheck !== undefined ? item.hasCheck : hasChecks, checkProps: item.checkProps, hasBadge: item.hasBadge !== undefined ? item.hasBadge : hasBadges, badgeProps: item.checkProps, activeItems: activeItems, parentItem: parentItem, itemData: item, icon: item.icon !== undefined ? item.icon : icon, expandedIcon: item.expandedIcon !== undefined ? item.expandedIcon : expandedIcon, action: item.action, actionProps: item.actionProps, compareItems: compareItems }, (item.children && {
        children: (react_1.default.createElement(exports.TreeView, { data: item.children, isNested: true, parentItem: item, hasChecks: hasChecks, hasBadges: hasBadges, defaultAllExpanded: defaultAllExpanded, onSelect: onSelect, onCheck: onCheck, activeItems: activeItems, icon: icon, expandedIcon: expandedIcon }))
    })))))));
};
exports.TreeView.displayName = 'TreeView';
//# sourceMappingURL=TreeView.js.map