"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const search_input_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/SearchInput/search-input"));
const react_styles_1 = require("@patternfly/react-styles");
const Button_1 = require("../Button");
const Badge_1 = require("../Badge");
const angle_down_icon_1 = tslib_1.__importDefault(require("@patternfly/react-icons/dist/js/icons/angle-down-icon"));
const angle_up_icon_1 = tslib_1.__importDefault(require("@patternfly/react-icons/dist/js/icons/angle-up-icon"));
const times_icon_1 = tslib_1.__importDefault(require("@patternfly/react-icons/dist/js/icons/times-icon"));
const search_icon_1 = tslib_1.__importDefault(require("@patternfly/react-icons/dist/js/icons/search-icon"));
exports.SearchInput = (_a) => {
    var { className, value = '', placeholder, onChange, onClear, resultsCount, onNextClick, onPreviousClick, 'aria-label': ariaLabel = 'Search input' } = _a, props = tslib_1.__rest(_a, ["className", "value", "placeholder", "onChange", "onClear", "resultsCount", "onNextClick", "onPreviousClick", 'aria-label']);
    const onChangeHandler = (event) => {
        if (onChange) {
            onChange(event.currentTarget.value, event);
        }
    };
    return (React.createElement("div", Object.assign({ className: react_styles_1.css(className, search_input_1.default.searchInput) }, props),
        React.createElement("span", { className: react_styles_1.css(search_input_1.default.searchInputText) },
            React.createElement("span", { className: react_styles_1.css(search_input_1.default.searchInputIcon) },
                React.createElement(search_icon_1.default, null)),
            React.createElement("input", { className: react_styles_1.css(search_input_1.default.searchInputTextInput), value: value, placeholder: placeholder, "aria-label": ariaLabel, onChange: onChangeHandler })),
        value && (React.createElement("span", { className: react_styles_1.css(search_input_1.default.searchInputUtilities) },
            resultsCount && (React.createElement("span", { className: react_styles_1.css(search_input_1.default.searchInputCount) },
                React.createElement(Badge_1.Badge, { isRead: true }, resultsCount))),
            !!onNextClick && !!onPreviousClick && (React.createElement("span", { className: react_styles_1.css(search_input_1.default.searchInputNav) },
                React.createElement(Button_1.Button, { variant: Button_1.ButtonVariant.plain, "aria-label": "Previous", onClick: onPreviousClick },
                    React.createElement(angle_up_icon_1.default, null)),
                React.createElement(Button_1.Button, { variant: Button_1.ButtonVariant.plain, "aria-label": "Next", onClick: onNextClick },
                    React.createElement(angle_down_icon_1.default, null)))),
            React.createElement("span", { className: "pf-c-search-input__clear" },
                React.createElement(Button_1.Button, { variant: Button_1.ButtonVariant.plain, "aria-label": "Clear", onClick: onClear },
                    React.createElement(times_icon_1.default, null)))))));
};
exports.SearchInput.displayName = 'SearchInput';
//# sourceMappingURL=SearchInput.js.map