import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Splitter/splitter';
import { css } from '@patternfly/react-styles';
export var SplitterOrientation;
(function (SplitterOrientation) {
    SplitterOrientation["horizontal"] = "horizontal";
    SplitterOrientation["vertical"] = "vertical";
})(SplitterOrientation || (SplitterOrientation = {}));
const SplitterBase = (_a) => {
    var { className = '', orientation = 'horizontal', innerRef = React.createRef() } = _a, props = __rest(_a, ["className", "orientation", "innerRef"]);
    return (React.createElement("div", Object.assign({ className: css(styles.splitter, orientation === 'vertical' && styles.modifiers.vertical, className), role: "separator", tabIndex: 0 }, { 'aria-orientation': orientation }, { ref: innerRef }, props),
        React.createElement("div", { className: css(styles.splitterHandle) })));
};
export const Splitter = React.forwardRef((props, ref) => (React.createElement(SplitterBase, Object.assign({}, props, { innerRef: ref }))));
Splitter.displayName = 'Splitter';
//# sourceMappingURL=Splitter.js.map