"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmAlertGroup = exports.AcmAlert = exports.AcmAlertProvider = exports.AcmAlertContext = void 0;
var Collapse_1 = __importDefault(require("@material-ui/core/Collapse"));
var react_core_1 = require("@patternfly/react-core");
var react_1 = __importStar(require("react"));
/* istanbul ignore next */
var noop = function () { return null; };
exports.AcmAlertContext = react_1.createContext({
    alertInfos: [],
    addAlert: noop,
    removeAlert: noop,
    clearAlerts: noop,
    clear: 0,
});
function AcmAlertProvider(props) {
    var _a = react_1.useState([]), alertInfos = _a[0], setAlertInfos = _a[1];
    var _b = react_1.useState(0), clear = _b[0], setClear = _b[1];
    var addAlert = react_1.useCallback(function (alertInfo) {
        alertInfo.id = Math.random().toString(36).substring(7);
        setAlertInfos(function (alertInfos) { return __spreadArrays(alertInfos, [alertInfo]); });
    }, []);
    var removeAlert = react_1.useCallback(function (alertInfo) {
        setAlertInfos(function (alertInfos) {
            var index = alertInfos.findIndex(function (ai) { return ai.id === alertInfo.id; });
            var newAlertInfos = __spreadArrays(alertInfos);
            /* istanbul ignore else */
            if (index !== -1)
                newAlertInfos.splice(index, 1);
            return newAlertInfos;
        });
    }, []);
    var clearAlerts = react_1.useCallback(function () { return setClear(function (clear) { return clear + 1; }); }, []);
    return (react_1.default.createElement(exports.AcmAlertContext.Provider, { value: { alertInfos: alertInfos, addAlert: addAlert, removeAlert: removeAlert, clearAlerts: clearAlerts, clear: clear } }, props.children));
}
exports.AcmAlertProvider = AcmAlertProvider;
function AcmAlert(props) {
    var alertContext = react_1.useContext(exports.AcmAlertContext);
    var alertInfo = props.alertInfo;
    var _a = react_1.useState(false), open = _a[0], setOpen = _a[1];
    var clear = react_1.useState(alertContext.clear)[0];
    react_1.useEffect(function () { return setOpen(true); }, []);
    react_1.useEffect(function () {
        if (clear !== alertContext.clear)
            setOpen(false);
    }, [alertContext]);
    return (react_1.default.createElement(Collapse_1.default, { style: props.style, in: open, onExit: function () {
            /* istanbul ignore else */
            if (alertInfo) {
                setTimeout(function () { return alertContext.removeAlert(alertInfo); }, 200);
            }
        }, timeout: 200 },
        react_1.default.createElement("div", { style: { paddingBottom: '8px' } },
            react_1.default.createElement(react_core_1.Alert, { isInline: props.isInline, title: (alertInfo === null || alertInfo === void 0 ? void 0 : alertInfo.title) || props.title, actionClose: !props.noClose && react_1.default.createElement(react_core_1.AlertActionCloseButton, { onClose: function () { return setOpen(false); } }), variant: (alertInfo === null || alertInfo === void 0 ? void 0 : alertInfo.type) || props.variant }, (alertInfo === null || alertInfo === void 0 ? void 0 : alertInfo.message) || props.message || props.subtitle))));
}
exports.AcmAlert = AcmAlert;
function AcmAlertGroup(props) {
    var alertContext = react_1.useContext(exports.AcmAlertContext);
    return alertContext.alertInfos.length > 0 ? (react_1.default.createElement("div", { style: { paddingBottom: '16px' } }, alertContext.alertInfos.map(function (alertInfo) { return (react_1.default.createElement(AcmAlert, { key: alertInfo.id, alertInfo: alertInfo, isInline: props.isInline, noClose: !props.canClose })); }))) : (react_1.default.createElement(react_1.default.Fragment, null));
}
exports.AcmAlertGroup = AcmAlertGroup;
//# sourceMappingURL=AcmAlert.js.map