"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var invariant = require('invariant');
var isCallingCanDrag = false;
var isCallingIsDragging = false;
var DragSourceMonitorImpl = /** @class */ (function () {
    function DragSourceMonitorImpl(manager) {
        this.sourceId = null;
        this.internalMonitor = manager.getMonitor();
    }
    DragSourceMonitorImpl.prototype.receiveHandlerId = function (sourceId) {
        this.sourceId = sourceId;
    };
    DragSourceMonitorImpl.prototype.getHandlerId = function () {
        return this.sourceId;
    };
    DragSourceMonitorImpl.prototype.canDrag = function () {
        invariant(!isCallingCanDrag, 'You may not call monitor.canDrag() inside your canDrag() implementation. ' +
            'Read more: http://react-dnd.github.io/react-dnd/docs/api/drag-source-monitor');
        try {
            isCallingCanDrag = true;
            return this.internalMonitor.canDragSource(this.sourceId);
        }
        finally {
            isCallingCanDrag = false;
        }
    };
    DragSourceMonitorImpl.prototype.isDragging = function () {
        if (!this.sourceId) {
            return false;
        }
        invariant(!isCallingIsDragging, 'You may not call monitor.isDragging() inside your isDragging() implementation. ' +
            'Read more: http://react-dnd.github.io/react-dnd/docs/api/drag-source-monitor');
        try {
            isCallingIsDragging = true;
            return this.internalMonitor.isDraggingSource(this.sourceId);
        }
        finally {
            isCallingIsDragging = false;
        }
    };
    DragSourceMonitorImpl.prototype.subscribeToStateChange = function (listener, options) {
        return this.internalMonitor.subscribeToStateChange(listener, options);
    };
    DragSourceMonitorImpl.prototype.isDraggingSource = function (sourceId) {
        return this.internalMonitor.isDraggingSource(sourceId);
    };
    DragSourceMonitorImpl.prototype.isOverTarget = function (targetId, options) {
        return this.internalMonitor.isOverTarget(targetId, options);
    };
    DragSourceMonitorImpl.prototype.getTargetIds = function () {
        return this.internalMonitor.getTargetIds();
    };
    DragSourceMonitorImpl.prototype.isSourcePublic = function () {
        return this.internalMonitor.isSourcePublic();
    };
    DragSourceMonitorImpl.prototype.getSourceId = function () {
        return this.internalMonitor.getSourceId();
    };
    DragSourceMonitorImpl.prototype.subscribeToOffsetChange = function (listener) {
        return this.internalMonitor.subscribeToOffsetChange(listener);
    };
    DragSourceMonitorImpl.prototype.canDragSource = function (sourceId) {
        return this.internalMonitor.canDragSource(sourceId);
    };
    DragSourceMonitorImpl.prototype.canDropOnTarget = function (targetId) {
        return this.internalMonitor.canDropOnTarget(targetId);
    };
    DragSourceMonitorImpl.prototype.getItemType = function () {
        return this.internalMonitor.getItemType();
    };
    DragSourceMonitorImpl.prototype.getItem = function () {
        return this.internalMonitor.getItem();
    };
    DragSourceMonitorImpl.prototype.getDropResult = function () {
        return this.internalMonitor.getDropResult();
    };
    DragSourceMonitorImpl.prototype.didDrop = function () {
        return this.internalMonitor.didDrop();
    };
    DragSourceMonitorImpl.prototype.getInitialClientOffset = function () {
        return this.internalMonitor.getInitialClientOffset();
    };
    DragSourceMonitorImpl.prototype.getInitialSourceClientOffset = function () {
        return this.internalMonitor.getInitialSourceClientOffset();
    };
    DragSourceMonitorImpl.prototype.getSourceClientOffset = function () {
        return this.internalMonitor.getSourceClientOffset();
    };
    DragSourceMonitorImpl.prototype.getClientOffset = function () {
        return this.internalMonitor.getClientOffset();
    };
    DragSourceMonitorImpl.prototype.getDifferenceFromInitialOffset = function () {
        return this.internalMonitor.getDifferenceFromInitialOffset();
    };
    return DragSourceMonitorImpl;
}());
exports.default = DragSourceMonitorImpl;
