"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmCodeSnippet = void 0;
require("@patternfly/react-styles/css/components/CodeEditor/code-editor.css");
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var ClipboardCopyButton_1 = require("@patternfly/react-core/dist/js/components/ClipboardCopy/ClipboardCopyButton");
var utils_1 = require("../utils");
function AcmCodeSnippet(props) {
    var _a;
    var _b = react_1.useState(false), copied = _b[0], setCopied = _b[1];
    react_1.useEffect(function () {
        if (copied) {
            setTimeout(function () { return setCopied(false); }, 2000);
        }
    }, [copied]);
    return (react_1.default.createElement("div", { className: "pf-c-code-editor pf-m-read-only", style: { display: 'flex' }, id: props.id },
        react_1.default.createElement("div", { className: "pf-c-code-editor__main", style: { width: '100%' } },
            react_1.default.createElement("div", { className: "pf-c-code-editor__code" },
                react_1.default.createElement("pre", { className: "pf-c-code-editor__code-pre" }, (_a = props.fakeCommand) !== null && _a !== void 0 ? _a : props.command))),
        react_1.default.createElement(ClipboardCopyButton_1.ClipboardCopyButton, { exitDelay: 500, entryDelay: 100, maxWidth: '150px', position: react_core_1.TooltipPosition.auto, id: "copy-button-" + props.id, textId: "text-input-" + props.id, "aria-label": 'Copy buton', 
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            onClick: function (event) {
                setCopied(true);
                utils_1.onCopy(event, props.command);
            } }, copied ? props.copySuccessText : props.copyTooltipText)));
}
exports.AcmCodeSnippet = AcmCodeSnippet;
//# sourceMappingURL=AcmCodeSnippet.js.map