"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmTextArea = void 0;
var react_core_1 = require("@patternfly/react-core");
var help_icon_1 = __importDefault(require("@patternfly/react-icons/dist/js/icons/help-icon"));
var react_1 = __importStar(require("react"));
var AcmForm_1 = require("../AcmForm/AcmForm");
function AcmTextArea(props) {
    var ValidationContext = AcmForm_1.useValidationContext();
    var _a = react_1.useState('default'), validated = _a[0], setValidated = _a[1];
    var _b = react_1.useState(''), error = _b[0], setError = _b[1];
    var validation = props.validation, labelHelp = props.labelHelp, labelHelpTitle = props.labelHelpTitle, helperText = props.helperText, textAreaProps = __rest(props, ["validation", "labelHelp", "labelHelpTitle", "helperText"]);
    react_1.useLayoutEffect(function () {
        var error = undefined;
        /* istanbul ignore else */
        if (props.hidden !== true) {
            if (props.isRequired) {
                if (!props.value || (typeof props.value === 'string' && props.value.trim() === '')) {
                    error = 'Required';
                }
            }
            if (!error && validation) {
                error = validation(props.value);
            }
        }
        setError(error !== null && error !== void 0 ? error : '');
        if (ValidationContext.validate) {
            setValidated(error ? 'error' : 'default');
        }
        ValidationContext.setError(props.id, error);
    }, [props.value, props.hidden]);
    react_1.useLayoutEffect(function () {
        setValidated(error ? 'error' : 'default');
    }, [ValidationContext.validate]);
    return (react_1.default.createElement(react_core_1.FormGroup, { id: props.id + "-label", label: props.label, isRequired: props.isRequired, fieldId: props.id, hidden: props.hidden, helperTextInvalid: error, validated: validated, helperText: helperText, labelIcon: 
        /* istanbul ignore next */
        props.labelHelp ? (react_1.default.createElement(react_core_1.Popover, { headerContent: labelHelpTitle, bodyContent: labelHelp },
            react_1.default.createElement(react_core_1.Button, { variant: "plain", "aria-label": "More info", onClick: function (e) { return e.preventDefault(); }, 
                // aria-describedby="simple-form-name"
                className: "pf-c-form__group-label-help" },
                react_1.default.createElement(help_icon_1.default, { noVerticalAlign: true })))) : (react_1.default.createElement(react_1.Fragment, null)) },
        react_1.default.createElement(react_core_1.TextArea, __assign({}, textAreaProps, { validated: validated, resizeOrientation: 
            /* istanbul ignore next */ props.resizeOrientation ? props.resizeOrientation : 'vertical', disabled: ValidationContext.isReadOnly, autoResize: true }))));
}
exports.AcmTextArea = AcmTextArea;
//# sourceMappingURL=AcmTextArea.js.map