"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartContainer = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_core_1 = require("victory-core");
const ChartUtils_1 = require("../ChartUtils");
exports.ChartContainer = (_a) => {
    var { className, themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant) } = _a, rest = tslib_1.__rest(_a, ["className", "themeColor", "themeVariant", "theme"]);
    const chartClassName = ChartUtils_1.getClassName({ className });
    // Note: className is valid, but Victory is missing a type
    return React.createElement(victory_core_1.VictoryContainer, Object.assign({ className: chartClassName, theme: theme }, rest));
};
exports.ChartContainer.displayName = 'ChartContainer';
// Note: VictoryContainer.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartContainer, victory_core_1.VictoryContainer);
//# sourceMappingURL=ChartContainer.js.map