"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var getDecoratedComponent_1 = require("./utils/getDecoratedComponent");
var discount_lodash_1 = require("./utils/discount_lodash");
var invariant = require('invariant');
var ALLOWED_SPEC_METHODS = ['canDrag', 'beginDrag', 'isDragging', 'endDrag'];
var REQUIRED_SPEC_METHODS = ['beginDrag'];
var SourceImpl = /** @class */ (function () {
    function SourceImpl(spec, monitor, ref) {
        var _this = this;
        this.spec = spec;
        this.monitor = monitor;
        this.ref = ref;
        this.props = null;
        this.beginDrag = function () {
            if (!_this.props) {
                return;
            }
            var item = _this.spec.beginDrag(_this.props, _this.monitor, _this.ref.current);
            if (process.env.NODE_ENV !== 'production') {
                invariant(discount_lodash_1.isPlainObject(item), 'beginDrag() must return a plain object that represents the dragged item. ' +
                    'Instead received %s. ' +
                    'Read more: http://react-dnd.github.io/react-dnd/docs/api/drag-source', item);
            }
            return item;
        };
    }
    SourceImpl.prototype.receiveProps = function (props) {
        this.props = props;
    };
    SourceImpl.prototype.canDrag = function () {
        if (!this.props) {
            return false;
        }
        if (!this.spec.canDrag) {
            return true;
        }
        return this.spec.canDrag(this.props, this.monitor);
    };
    SourceImpl.prototype.isDragging = function (globalMonitor, sourceId) {
        if (!this.props) {
            return false;
        }
        if (!this.spec.isDragging) {
            return sourceId === globalMonitor.getSourceId();
        }
        return this.spec.isDragging(this.props, this.monitor);
    };
    SourceImpl.prototype.endDrag = function () {
        if (!this.props) {
            return;
        }
        if (!this.spec.endDrag) {
            return;
        }
        this.spec.endDrag(this.props, this.monitor, getDecoratedComponent_1.getDecoratedComponent(this.ref));
    };
    return SourceImpl;
}());
function createSourceFactory(spec) {
    Object.keys(spec).forEach(function (key) {
        invariant(ALLOWED_SPEC_METHODS.indexOf(key) > -1, 'Expected the drag source specification to only have ' +
            'some of the following keys: %s. ' +
            'Instead received a specification with an unexpected "%s" key. ' +
            'Read more: http://react-dnd.github.io/react-dnd/docs/api/drag-source', ALLOWED_SPEC_METHODS.join(', '), key);
        invariant(typeof spec[key] === 'function', 'Expected %s in the drag source specification to be a function. ' +
            'Instead received a specification with %s: %s. ' +
            'Read more: http://react-dnd.github.io/react-dnd/docs/api/drag-source', key, key, spec[key]);
    });
    REQUIRED_SPEC_METHODS.forEach(function (key) {
        invariant(typeof spec[key] === 'function', 'Expected %s in the drag source specification to be a function. ' +
            'Instead received a specification with %s: %s. ' +
            'Read more: http://react-dnd.github.io/react-dnd/docs/api/drag-source', key, key, spec[key]);
    });
    return function createSource(monitor, ref) {
        return new SourceImpl(spec, monitor, ref);
    };
}
exports.default = createSourceFactory;
