"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = createMountWrapper;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _airbnbPropTypes = require("airbnb-prop-types");

var _RootFinder = _interopRequireDefault(require("./RootFinder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/* eslint react/forbid-prop-types: 0 */
var stringOrFunction = _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].string]);

var makeValidElementType = function makeValidElementType(adapter) {
  if (!adapter) {
    return stringOrFunction;
  }

  function validElementTypeRequired(props, propName) {
    if (!adapter.isValidElementType) {
      for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
        args[_key - 2] = arguments[_key];
      }

      return stringOrFunction.isRequired.apply(stringOrFunction, [props, propName].concat(args));
    }

    var propValue = props[propName]; // eslint-disable-line react/destructuring-assignment

    if (adapter.isValidElementType(propValue)) {
      return null;
    }

    return new TypeError("".concat(propName, " must be a valid element type!"));
  }

  function validElementType(props, propName) {
    var propValue = props[propName];

    if (propValue == null) {
      return null;
    }

    for (var _len2 = arguments.length, args = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
      args[_key2 - 2] = arguments[_key2];
    }

    return validElementTypeRequired.apply(void 0, [props, propName].concat(args));
  }

  validElementType.isRequired = validElementTypeRequired;
  return validElementType;
};
/**
 * This is a utility component to wrap around the nodes we are
 * passing in to `mount()`. Theoretically, you could do everything
 * we are doing without this, but this makes it easier since
 * `renderIntoDocument()` doesn't really pass back a reference to
 * the DOM node it rendered to, so we can't really "re-render" to
 * pass new props in.
 */


function createMountWrapper(node) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var adapter = options.adapter,
      WrappingComponent = options.wrappingComponent;

  var WrapperComponent = /*#__PURE__*/function (_React$Component) {
    _inherits(WrapperComponent, _React$Component);

    var _super = _createSuper(WrapperComponent);

    function WrapperComponent() {
      var _this;

      _classCallCheck(this, WrapperComponent);

      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      _this = _super.call.apply(_super, [this].concat(args));
      var _this$props = _this.props,
          props = _this$props.props,
          wrappingComponentProps = _this$props.wrappingComponentProps,
          context = _this$props.context;
      _this.state = {
        mount: true,
        props: props,
        wrappingComponentProps: wrappingComponentProps,
        context: context
      };
      return _this;
    }

    _createClass(WrapperComponent, [{
      key: "setChildProps",
      value: function setChildProps(newProps, newContext) {
        var callback = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : undefined;
        var _this$state = this.state,
            oldProps = _this$state.props,
            oldContext = _this$state.context;

        var props = _objectSpread(_objectSpread({}, oldProps), newProps);

        var context = _objectSpread(_objectSpread({}, oldContext), newContext);

        this.setState({
          props: props,
          context: context
        }, callback);
      }
    }, {
      key: "setWrappingComponentProps",
      value: function setWrappingComponentProps(props) {
        var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;
        this.setState({
          wrappingComponentProps: props
        }, callback);
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props2 = this.props,
            Component = _this$props2.Component,
            refProp = _this$props2.refProp;
        var _this$state2 = this.state,
            mount = _this$state2.mount,
            props = _this$state2.props,
            wrappingComponentProps = _this$state2.wrappingComponentProps;
        if (!mount) return null; // eslint-disable-next-line react/jsx-props-no-spreading

        var component = /*#__PURE__*/_react["default"].createElement(Component, _extends({
          ref: refProp
        }, props));

        if (WrappingComponent) {
          return (
            /*#__PURE__*/
            // eslint-disable-next-line react/jsx-props-no-spreading
            _react["default"].createElement(WrappingComponent, wrappingComponentProps, /*#__PURE__*/_react["default"].createElement(_RootFinder["default"], null, component))
          );
        }

        return component;
      }
    }]);

    return WrapperComponent;
  }(_react["default"].Component);

  WrapperComponent.propTypes = {
    Component: makeValidElementType(adapter).isRequired,
    refProp: _propTypes["default"].oneOfType([_propTypes["default"].string, (0, _airbnbPropTypes.ref)()]),
    props: _propTypes["default"].object.isRequired,
    wrappingComponentProps: _propTypes["default"].object,
    context: _propTypes["default"].object
  };
  WrapperComponent.defaultProps = {
    refProp: null,
    context: null,
    wrappingComponentProps: null
  };

  if (options.context && (node.type.contextTypes || options.childContextTypes)) {
    // For full rendering, we are using this wrapper component to provide context if it is
    // specified in both the options AND the child component defines `contextTypes` statically
    // OR the merged context types for all children (the node component or deeper children) are
    // specified in options parameter under childContextTypes.
    // In that case, we define both a `getChildContext()` function and a `childContextTypes` prop.
    var childContextTypes = _objectSpread(_objectSpread({}, node.type.contextTypes), options.childContextTypes);

    WrapperComponent.prototype.getChildContext = function getChildContext() {
      return this.state.context;
    };

    WrapperComponent.childContextTypes = childContextTypes;
  }

  return WrapperComponent;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=createMountWrapper.js.map