"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmDropdown = void 0;
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var styles_1 = require("@material-ui/styles");
var utils_1 = require("../utils");
var useStyles = styles_1.makeStyles({
    button: {
        '& button': {
            backgroundColor: function (props) {
                if (!props.isKebab) {
                    if (props.isDisabled) {
                        return 'var(--pf-global--disabled-color--200)';
                    }
                    else if (!props.isDisabled && props.isPrimary) {
                        return 'var(--pf-c-dropdown__toggle--BackgroundColor)';
                    }
                    else {
                        return 'transparent';
                    }
                }
                return undefined;
            },
            '& span': {
                color: function (props) {
                    if (props.isDisabled) {
                        return 'var(--pf-global--Color--100)';
                    }
                    else if (props.isPrimary) {
                        return 'var(--pf-global--Color--light-100)';
                    }
                    else if (props.isKebab) {
                        return undefined;
                    }
                    return 'var(--pf-global--primary-color--100)';
                },
            },
            '&:hover, &:focus': {
                '& span': {
                    color: function (props) {
                        return props.isKebab ? undefined : 'var(--pf-global--primary-color--100)';
                    },
                },
                '& span.pf-c-dropdown__toggle-text': {
                    color: function (props) { return props.isPrimary && 'var(--pf-global--Color--light-100)'; },
                },
                '& span.pf-c-dropdown__toggle-icon': {
                    color: function (props) { return props.isPrimary && 'var(--pf-global--Color--light-100)'; },
                },
            },
            '& span.pf-c-dropdown__toggle-text': {
                // centers dropdown text in plain dropdown button
                paddingLeft: function (props) {
                    if (props.isPlain) {
                        return '8px';
                    }
                    return undefined;
                },
            },
        },
    },
    label: {
        marginLeft: '8px',
    },
});
function AcmDropdown(props) {
    var _a = react_1.useState(false), isOpen = _a[0], setOpen = _a[1];
    var classes = useStyles(props);
    var onSelect = function (id) {
        props.onSelect(id);
        setOpen(false);
        var element = document.getElementById(props.id);
        /* istanbul ignore else */
        if (element)
            element.focus();
    };
    return (react_1.default.createElement(utils_1.TooltipWrapper, { showTooltip: props.isDisabled && !!props.tooltip, tooltip: props.tooltip, tooltipPosition: props.tooltipPosition },
        react_1.default.createElement(react_core_1.Dropdown, { className: classes.button, onMouseOver: props.onHover, position: props.dropdownPosition || react_core_1.DropdownPosition.right, dropdownItems: props.dropdownItems.map(function (item) { return (react_1.default.createElement(utils_1.TooltipWrapper, { showTooltip: item.isDisabled && !!item.tooltip, tooltip: item.tooltip, key: item.id, tooltipPosition: item.tooltipPosition },
                react_1.default.createElement(react_core_1.DropdownItem, __assign({}, item, { onClick: function () { return onSelect(item.id); } }),
                    item.text,
                    item.label && item.labelColor && (react_1.default.createElement(react_core_1.Label, { className: classes.label, color: item.labelColor }, item.label))))); }), toggle: props.isKebab ? (react_1.default.createElement(react_core_1.KebabToggle, { id: props.id, isDisabled: props.isDisabled, onToggle: function () {
                    /* istanbul ignore next */
                    if (props.onToggle) {
                        props.onToggle(!isOpen);
                    }
                    setOpen(!isOpen);
                } })) : (react_1.default.createElement(react_core_1.DropdownToggle, { isPrimary: props.isPrimary, id: props.id, isDisabled: props.isDisabled, onToggle: function () {
                    if (props.onToggle) {
                        props.onToggle(!isOpen);
                    }
                    setOpen(!isOpen);
                } }, props.text)), isOpen: isOpen, isPlain: props.isPlain })));
}
exports.AcmDropdown = AcmDropdown;
//# sourceMappingURL=AcmDropdown.js.map