"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartLabel = exports.ChartLabelPlacement = exports.ChartLabelDirection = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const defaults_1 = tslib_1.__importDefault(require("lodash/defaults"));
const victory_core_1 = require("victory-core");
const ChartTheme_1 = require("../ChartTheme");
var ChartLabelDirection;
(function (ChartLabelDirection) {
    ChartLabelDirection["rtl"] = "rtl";
    ChartLabelDirection["ltr"] = "ltr";
    ChartLabelDirection["inherit"] = "inherit";
})(ChartLabelDirection = exports.ChartLabelDirection || (exports.ChartLabelDirection = {}));
var ChartLabelPlacement;
(function (ChartLabelPlacement) {
    ChartLabelPlacement["parallel"] = "parallel";
    ChartLabelPlacement["perpendicular"] = "perpendicular";
    ChartLabelPlacement["vertical"] = "vertical";
})(ChartLabelPlacement = exports.ChartLabelPlacement || (exports.ChartLabelPlacement = {}));
const ChartLabel = (_a) => {
    var { style, textAnchor } = _a, rest = tslib_1.__rest(_a, ["style", "textAnchor"]);
    const applyDefaultStyle = (customStyle) => defaults_1.default(Object.assign(Object.assign({}, customStyle), { textAnchor // textAnchor prop must override given theme styles
     }), {
        fontFamily: ChartTheme_1.ChartCommonStyles.label.fontFamily,
        fontSize: ChartTheme_1.ChartCommonStyles.label.fontSize,
        letterSpacing: ChartTheme_1.ChartCommonStyles.label.letterSpacing
    });
    const newStyle = Array.isArray(style) ? style.map(applyDefaultStyle) : applyDefaultStyle(style);
    return React.createElement(victory_core_1.VictoryLabel, Object.assign({ style: newStyle, textAnchor: textAnchor }, rest));
};
exports.ChartLabel = ChartLabel;
exports.ChartLabel.displayName = 'ChartLabel';
// Note: VictoryLabel.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartLabel, victory_core_1.VictoryLabel);
//# sourceMappingURL=ChartLabel.js.map