// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/scheduler/v1beta1/target.proto

package scheduler // import "google.golang.org/genproto/googleapis/cloud/scheduler/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/any"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The HTTP method used to execute the job.
type HttpMethod int32

const (
	// HTTP method unspecified. Defaults to POST.
	HttpMethod_HTTP_METHOD_UNSPECIFIED HttpMethod = 0
	// HTTP POST
	HttpMethod_POST HttpMethod = 1
	// HTTP GET
	HttpMethod_GET HttpMethod = 2
	// HTTP HEAD
	HttpMethod_HEAD HttpMethod = 3
	// HTTP PUT
	HttpMethod_PUT HttpMethod = 4
	// HTTP DELETE
	HttpMethod_DELETE HttpMethod = 5
	// HTTP PATCH
	HttpMethod_PATCH HttpMethod = 6
	// HTTP OPTIONS
	HttpMethod_OPTIONS HttpMethod = 7
)

var HttpMethod_name = map[int32]string{
	0: "HTTP_METHOD_UNSPECIFIED",
	1: "POST",
	2: "GET",
	3: "HEAD",
	4: "PUT",
	5: "DELETE",
	6: "PATCH",
	7: "OPTIONS",
}
var HttpMethod_value = map[string]int32{
	"HTTP_METHOD_UNSPECIFIED": 0,
	"POST":                    1,
	"GET":                     2,
	"HEAD":                    3,
	"PUT":                     4,
	"DELETE":                  5,
	"PATCH":                   6,
	"OPTIONS":                 7,
}

func (x HttpMethod) String() string {
	return proto.EnumName(HttpMethod_name, int32(x))
}
func (HttpMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_target_d943b6e907724d6e, []int{0}
}

// Http target. The job will be pushed to the job handler by means of
// an HTTP request via an [http_method][google.cloud.scheduler.v1beta1.HttpTarget.http_method] such as HTTP
// POST, HTTP GET, etc. The job is acknowledged by means of an HTTP
// response code in the range [200 - 299]. A failure to receive a response
// constitutes a failed execution. For a redirected request, the response
// returned by the redirected request is considered.
type HttpTarget struct {
	// Required.
	//
	// The full URI path that the request will be sent to. This string
	// must begin with either "http://" or "https://". Some examples of
	// valid values for [uri][google.cloud.scheduler.v1beta1.HttpTarget.uri] are:
	// `http://acme.com` and `https://acme.com/sales:8080`. Cloud Scheduler will
	// encode some characters for safety and compatibility. The maximum allowed
	// URL length is 2083 characters after encoding.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Which HTTP method to use for the request.
	HttpMethod HttpMethod `protobuf:"varint,2,opt,name=http_method,json=httpMethod,proto3,enum=google.cloud.scheduler.v1beta1.HttpMethod" json:"http_method,omitempty"`
	// The user can specify HTTP request headers to send with the job's
	// HTTP request. This map contains the header field names and
	// values. Repeated headers are not supported, but a header value can
	// contain commas. These headers represent a subset of the headers
	// that will accompany the job's HTTP request. Some HTTP request
	// headers will be ignored or replaced. A partial list of headers that
	// will be ignored or replaced is below:
	// - Host: This will be computed by Cloud Scheduler and derived from
	// [uri][google.cloud.scheduler.v1beta1.HttpTarget.uri].
	// * `Content-Length`: This will be computed by Cloud Scheduler.
	// * `User-Agent`: This will be set to `"Google-Cloud-Scheduler"`.
	// * `X-Google-*`: Google internal use only.
	// * `X-AppEngine-*`: Google internal use only.
	//
	// The total size of headers must be less than 80KB.
	Headers map[string]string `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// HTTP request body. A request body is allowed only if the HTTP
	// method is POST, PUT, or PATCH. It is an error to set body on a job with an
	// incompatible [HttpMethod][google.cloud.scheduler.v1beta1.HttpMethod].
	Body []byte `protobuf:"bytes,4,opt,name=body,proto3" json:"body,omitempty"`
	// The mode for generating an `Authorization` header for HTTP requests.
	//
	// If specified, all `Authorization` headers in the [HttpTarget.headers][google.cloud.scheduler.v1beta1.HttpTarget.headers]
	// field will be overridden.
	//
	// Types that are valid to be assigned to AuthorizationHeader:
	//	*HttpTarget_OauthToken
	//	*HttpTarget_OidcToken
	AuthorizationHeader  isHttpTarget_AuthorizationHeader `protobuf_oneof:"authorization_header"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *HttpTarget) Reset()         { *m = HttpTarget{} }
func (m *HttpTarget) String() string { return proto.CompactTextString(m) }
func (*HttpTarget) ProtoMessage()    {}
func (*HttpTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_d943b6e907724d6e, []int{0}
}
func (m *HttpTarget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HttpTarget.Unmarshal(m, b)
}
func (m *HttpTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HttpTarget.Marshal(b, m, deterministic)
}
func (dst *HttpTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpTarget.Merge(dst, src)
}
func (m *HttpTarget) XXX_Size() int {
	return xxx_messageInfo_HttpTarget.Size(m)
}
func (m *HttpTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpTarget.DiscardUnknown(m)
}

var xxx_messageInfo_HttpTarget proto.InternalMessageInfo

func (m *HttpTarget) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *HttpTarget) GetHttpMethod() HttpMethod {
	if m != nil {
		return m.HttpMethod
	}
	return HttpMethod_HTTP_METHOD_UNSPECIFIED
}

func (m *HttpTarget) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *HttpTarget) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

type isHttpTarget_AuthorizationHeader interface {
	isHttpTarget_AuthorizationHeader()
}

type HttpTarget_OauthToken struct {
	OauthToken *OAuthToken `protobuf:"bytes,5,opt,name=oauth_token,json=oauthToken,proto3,oneof"`
}

type HttpTarget_OidcToken struct {
	OidcToken *OidcToken `protobuf:"bytes,6,opt,name=oidc_token,json=oidcToken,proto3,oneof"`
}

func (*HttpTarget_OauthToken) isHttpTarget_AuthorizationHeader() {}

func (*HttpTarget_OidcToken) isHttpTarget_AuthorizationHeader() {}

func (m *HttpTarget) GetAuthorizationHeader() isHttpTarget_AuthorizationHeader {
	if m != nil {
		return m.AuthorizationHeader
	}
	return nil
}

func (m *HttpTarget) GetOauthToken() *OAuthToken {
	if x, ok := m.GetAuthorizationHeader().(*HttpTarget_OauthToken); ok {
		return x.OauthToken
	}
	return nil
}

func (m *HttpTarget) GetOidcToken() *OidcToken {
	if x, ok := m.GetAuthorizationHeader().(*HttpTarget_OidcToken); ok {
		return x.OidcToken
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HttpTarget) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HttpTarget_OneofMarshaler, _HttpTarget_OneofUnmarshaler, _HttpTarget_OneofSizer, []interface{}{
		(*HttpTarget_OauthToken)(nil),
		(*HttpTarget_OidcToken)(nil),
	}
}

func _HttpTarget_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HttpTarget)
	// authorization_header
	switch x := m.AuthorizationHeader.(type) {
	case *HttpTarget_OauthToken:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OauthToken); err != nil {
			return err
		}
	case *HttpTarget_OidcToken:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OidcToken); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HttpTarget.AuthorizationHeader has unexpected type %T", x)
	}
	return nil
}

func _HttpTarget_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HttpTarget)
	switch tag {
	case 5: // authorization_header.oauth_token
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(OAuthToken)
		err := b.DecodeMessage(msg)
		m.AuthorizationHeader = &HttpTarget_OauthToken{msg}
		return true, err
	case 6: // authorization_header.oidc_token
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(OidcToken)
		err := b.DecodeMessage(msg)
		m.AuthorizationHeader = &HttpTarget_OidcToken{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HttpTarget_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HttpTarget)
	// authorization_header
	switch x := m.AuthorizationHeader.(type) {
	case *HttpTarget_OauthToken:
		s := proto.Size(x.OauthToken)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HttpTarget_OidcToken:
		s := proto.Size(x.OidcToken)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// App Engine target. The job will be pushed to a job handler by means
// of an HTTP request via an [http_method][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.http_method] such
// as HTTP POST, HTTP GET, etc. The job is acknowledged by means of an
// HTTP response code in the range [200 - 299]. Error 503 is
// considered an App Engine system error instead of an application
// error. Requests returning error 503 will be retried regardless of
// retry configuration and not counted against retry counts. Any other
// response code, or a failure to receive a response before the
// deadline, constitutes a failed attempt.
type AppEngineHttpTarget struct {
	// The HTTP method to use for the request. PATCH and OPTIONS are not
	// permitted.
	HttpMethod HttpMethod `protobuf:"varint,1,opt,name=http_method,json=httpMethod,proto3,enum=google.cloud.scheduler.v1beta1.HttpMethod" json:"http_method,omitempty"`
	// App Engine Routing setting for the job.
	AppEngineRouting *AppEngineRouting `protobuf:"bytes,2,opt,name=app_engine_routing,json=appEngineRouting,proto3" json:"app_engine_routing,omitempty"`
	// The relative URI.
	//
	// The relative URL must begin with "/" and must be a valid HTTP relative URL.
	// It can contain a path, query string arguments, and `#` fragments.
	// If the relative URL is empty, then the root path "/" will be used.
	// No spaces are allowed, and the maximum length allowed is 2083 characters.
	RelativeUri string `protobuf:"bytes,3,opt,name=relative_uri,json=relativeUri,proto3" json:"relative_uri,omitempty"`
	// HTTP request headers.
	//
	// This map contains the header field names and values. Headers can be set
	// when the job is created.
	//
	// Cloud Scheduler sets some headers to default values:
	//
	// * `User-Agent`: By default, this header is
	//   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
	//   This header can be modified, but Cloud Scheduler will append
	//   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
	//   modified `User-Agent`.
	// * `X-CloudScheduler`: This header will be set to true.
	//
	// If the job has an [body][google.cloud.scheduler.v1beta1.AppEngineHttpTarget.body], Cloud Scheduler sets
	// the following headers:
	//
	// * `Content-Type`: By default, the `Content-Type` header is set to
	//   `"application/octet-stream"`. The default can be overridden by explictly
	//   setting `Content-Type` to a particular media type when the job is
	//   created.
	//   For example, `Content-Type` can be set to `"application/json"`.
	// * `Content-Length`: This is computed by Cloud Scheduler. This value is
	//   output only. It cannot be changed.
	//
	// The headers below are output only. They cannot be set or overridden:
	//
	// * `X-Google-*`: For Google internal use only.
	// * `X-AppEngine-*`: For Google internal use only.
	//
	// In addition, some App Engine headers, which contain
	// job-specific information, are also be sent to the job handler.
	Headers map[string]string `protobuf:"bytes,4,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Body.
	//
	// HTTP request body. A request body is allowed only if the HTTP method is
	// POST or PUT. It will result in invalid argument error to set a body on a
	// job with an incompatible [HttpMethod][google.cloud.scheduler.v1beta1.HttpMethod].
	Body                 []byte   `protobuf:"bytes,5,opt,name=body,proto3" json:"body,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppEngineHttpTarget) Reset()         { *m = AppEngineHttpTarget{} }
func (m *AppEngineHttpTarget) String() string { return proto.CompactTextString(m) }
func (*AppEngineHttpTarget) ProtoMessage()    {}
func (*AppEngineHttpTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_d943b6e907724d6e, []int{1}
}
func (m *AppEngineHttpTarget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppEngineHttpTarget.Unmarshal(m, b)
}
func (m *AppEngineHttpTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppEngineHttpTarget.Marshal(b, m, deterministic)
}
func (dst *AppEngineHttpTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppEngineHttpTarget.Merge(dst, src)
}
func (m *AppEngineHttpTarget) XXX_Size() int {
	return xxx_messageInfo_AppEngineHttpTarget.Size(m)
}
func (m *AppEngineHttpTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_AppEngineHttpTarget.DiscardUnknown(m)
}

var xxx_messageInfo_AppEngineHttpTarget proto.InternalMessageInfo

func (m *AppEngineHttpTarget) GetHttpMethod() HttpMethod {
	if m != nil {
		return m.HttpMethod
	}
	return HttpMethod_HTTP_METHOD_UNSPECIFIED
}

func (m *AppEngineHttpTarget) GetAppEngineRouting() *AppEngineRouting {
	if m != nil {
		return m.AppEngineRouting
	}
	return nil
}

func (m *AppEngineHttpTarget) GetRelativeUri() string {
	if m != nil {
		return m.RelativeUri
	}
	return ""
}

func (m *AppEngineHttpTarget) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *AppEngineHttpTarget) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

// Pub/Sub target. The job will be delivered by publishing a message to
// the given Pub/Sub topic.
type PubsubTarget struct {
	// Required.
	//
	// The name of the Cloud Pub/Sub topic to which messages will
	// be published when a job is delivered. The topic name must be in the
	// same format as required by PubSub's
	// [PublishRequest.name](https://cloud.google.com/pubsub/docs/reference/rpc/google.pubsub.v1#publishrequest),
	// for example `projects/PROJECT_ID/topics/TOPIC_ID`.
	//
	// The topic must be in the same project as the Cloud Scheduler job.
	TopicName string `protobuf:"bytes,1,opt,name=topic_name,json=topicName,proto3" json:"topic_name,omitempty"`
	// The message payload for PubsubMessage.
	//
	// Pubsub message must contain either non-empty data, or at least one
	// attribute.
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// Attributes for PubsubMessage.
	//
	// Pubsub message must contain either non-empty data, or at least one
	// attribute.
	Attributes           map[string]string `protobuf:"bytes,4,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PubsubTarget) Reset()         { *m = PubsubTarget{} }
func (m *PubsubTarget) String() string { return proto.CompactTextString(m) }
func (*PubsubTarget) ProtoMessage()    {}
func (*PubsubTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_d943b6e907724d6e, []int{2}
}
func (m *PubsubTarget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PubsubTarget.Unmarshal(m, b)
}
func (m *PubsubTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PubsubTarget.Marshal(b, m, deterministic)
}
func (dst *PubsubTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PubsubTarget.Merge(dst, src)
}
func (m *PubsubTarget) XXX_Size() int {
	return xxx_messageInfo_PubsubTarget.Size(m)
}
func (m *PubsubTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_PubsubTarget.DiscardUnknown(m)
}

var xxx_messageInfo_PubsubTarget proto.InternalMessageInfo

func (m *PubsubTarget) GetTopicName() string {
	if m != nil {
		return m.TopicName
	}
	return ""
}

func (m *PubsubTarget) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *PubsubTarget) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// App Engine Routing.
//
// For more information about services, versions, and instances see
// [An Overview of App
// Engine](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine),
// [Microservices Architecture on Google App
// Engine](https://cloud.google.com/appengine/docs/python/microservices-on-app-engine),
// [App Engine Standard request
// routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed),
// and [App Engine Flex request
// routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
type AppEngineRouting struct {
	// App service.
	//
	// By default, the job is sent to the service which is the default
	// service when the job is attempted.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// App version.
	//
	// By default, the job is sent to the version which is the default
	// version when the job is attempted.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// App instance.
	//
	// By default, the job is sent to an instance which is available when
	// the job is attempted.
	//
	// Requests can only be sent to a specific instance if
	// [manual scaling is used in App Engine
	// Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
	// App Engine Flex does not support instances. For more information, see
	// [App Engine Standard request
	// routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
	// and [App Engine Flex request
	// routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
	Instance string `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	// Output only. The host that the job is sent to.
	//
	// For more information about how App Engine requests are routed, see
	// [here](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
	//
	// The host is constructed as:
	//
	//
	// * `host = [application_domain_name]`</br>
	//   `| [service] + '.' + [application_domain_name]`</br>
	//   `| [version] + '.' + [application_domain_name]`</br>
	//   `| [version_dot_service]+ '.' + [application_domain_name]`</br>
	//   `| [instance] + '.' + [application_domain_name]`</br>
	//   `| [instance_dot_service] + '.' + [application_domain_name]`</br>
	//   `| [instance_dot_version] + '.' + [application_domain_name]`</br>
	//   `| [instance_dot_version_dot_service] + '.' + [application_domain_name]`
	//
	// * `application_domain_name` = The domain name of the app, for
	//   example <app-id>.appspot.com, which is associated with the
	//   job's project ID.
	//
	// * `service =` [service][google.cloud.scheduler.v1beta1.AppEngineRouting.service]
	//
	// * `version =` [version][google.cloud.scheduler.v1beta1.AppEngineRouting.version]
	//
	// * `version_dot_service =`
	//   [version][google.cloud.scheduler.v1beta1.AppEngineRouting.version] `+ '.' +`
	//   [service][google.cloud.scheduler.v1beta1.AppEngineRouting.service]
	//
	// * `instance =` [instance][google.cloud.scheduler.v1beta1.AppEngineRouting.instance]
	//
	// * `instance_dot_service =`
	//   [instance][google.cloud.scheduler.v1beta1.AppEngineRouting.instance] `+ '.' +`
	//   [service][google.cloud.scheduler.v1beta1.AppEngineRouting.service]
	//
	// * `instance_dot_version =`
	//   [instance][google.cloud.scheduler.v1beta1.AppEngineRouting.instance] `+ '.' +`
	//   [version][google.cloud.scheduler.v1beta1.AppEngineRouting.version]
	//
	// * `instance_dot_version_dot_service =`
	//   [instance][google.cloud.scheduler.v1beta1.AppEngineRouting.instance] `+ '.' +`
	//   [version][google.cloud.scheduler.v1beta1.AppEngineRouting.version] `+ '.' +`
	//   [service][google.cloud.scheduler.v1beta1.AppEngineRouting.service]
	//
	//
	// If [service][google.cloud.scheduler.v1beta1.AppEngineRouting.service] is empty, then the job will be sent
	// to the service which is the default service when the job is attempted.
	//
	// If [version][google.cloud.scheduler.v1beta1.AppEngineRouting.version] is empty, then the job will be sent
	// to the version which is the default version when the job is attempted.
	//
	// If [instance][google.cloud.scheduler.v1beta1.AppEngineRouting.instance] is empty, then the job will be
	// sent to an instance which is available when the job is attempted.
	//
	// If [service][google.cloud.scheduler.v1beta1.AppEngineRouting.service],
	// [version][google.cloud.scheduler.v1beta1.AppEngineRouting.version], or
	// [instance][google.cloud.scheduler.v1beta1.AppEngineRouting.instance] is invalid, then the job will be sent
	// to the default version of the default service when the job is attempted.
	Host                 string   `protobuf:"bytes,4,opt,name=host,proto3" json:"host,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppEngineRouting) Reset()         { *m = AppEngineRouting{} }
func (m *AppEngineRouting) String() string { return proto.CompactTextString(m) }
func (*AppEngineRouting) ProtoMessage()    {}
func (*AppEngineRouting) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_d943b6e907724d6e, []int{3}
}
func (m *AppEngineRouting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppEngineRouting.Unmarshal(m, b)
}
func (m *AppEngineRouting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppEngineRouting.Marshal(b, m, deterministic)
}
func (dst *AppEngineRouting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppEngineRouting.Merge(dst, src)
}
func (m *AppEngineRouting) XXX_Size() int {
	return xxx_messageInfo_AppEngineRouting.Size(m)
}
func (m *AppEngineRouting) XXX_DiscardUnknown() {
	xxx_messageInfo_AppEngineRouting.DiscardUnknown(m)
}

var xxx_messageInfo_AppEngineRouting proto.InternalMessageInfo

func (m *AppEngineRouting) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *AppEngineRouting) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *AppEngineRouting) GetInstance() string {
	if m != nil {
		return m.Instance
	}
	return ""
}

func (m *AppEngineRouting) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

// Contains information needed for generating an
// [OAuth token](https://developers.google.com/identity/protocols/OAuth2).
// This type of authorization should be used when sending requests to a GCP
// endpoint.
type OAuthToken struct {
	// [Service account email](https://cloud.google.com/iam/docs/service-accounts)
	// to be used for generating OAuth token.
	// The service account must be within the same project as the job. The caller
	// must have iam.serviceAccounts.actAs permission for the service account.
	ServiceAccountEmail string `protobuf:"bytes,1,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// OAuth scope to be used for generating OAuth access token.
	// If not specified, "https://www.googleapis.com/auth/cloud-platform"
	// will be used.
	Scope                string   `protobuf:"bytes,2,opt,name=scope,proto3" json:"scope,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OAuthToken) Reset()         { *m = OAuthToken{} }
func (m *OAuthToken) String() string { return proto.CompactTextString(m) }
func (*OAuthToken) ProtoMessage()    {}
func (*OAuthToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_d943b6e907724d6e, []int{4}
}
func (m *OAuthToken) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OAuthToken.Unmarshal(m, b)
}
func (m *OAuthToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OAuthToken.Marshal(b, m, deterministic)
}
func (dst *OAuthToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OAuthToken.Merge(dst, src)
}
func (m *OAuthToken) XXX_Size() int {
	return xxx_messageInfo_OAuthToken.Size(m)
}
func (m *OAuthToken) XXX_DiscardUnknown() {
	xxx_messageInfo_OAuthToken.DiscardUnknown(m)
}

var xxx_messageInfo_OAuthToken proto.InternalMessageInfo

func (m *OAuthToken) GetServiceAccountEmail() string {
	if m != nil {
		return m.ServiceAccountEmail
	}
	return ""
}

func (m *OAuthToken) GetScope() string {
	if m != nil {
		return m.Scope
	}
	return ""
}

// Contains information needed for generating an
// [OpenID Connect
// token](https://developers.google.com/identity/protocols/OpenIDConnect). This
// type of authorization should be used when sending requests to third party
// endpoints.
type OidcToken struct {
	// [Service account email](https://cloud.google.com/iam/docs/service-accounts)
	// to be used for generating OIDC token.
	// The service account must be within the same project as the job. The caller
	// must have iam.serviceAccounts.actAs permission for the service account.
	ServiceAccountEmail string `protobuf:"bytes,1,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Audience to be used when generating OIDC token. If not specified, the URI
	// specified in target will be used.
	Audience             string   `protobuf:"bytes,2,opt,name=audience,proto3" json:"audience,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OidcToken) Reset()         { *m = OidcToken{} }
func (m *OidcToken) String() string { return proto.CompactTextString(m) }
func (*OidcToken) ProtoMessage()    {}
func (*OidcToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_target_d943b6e907724d6e, []int{5}
}
func (m *OidcToken) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OidcToken.Unmarshal(m, b)
}
func (m *OidcToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OidcToken.Marshal(b, m, deterministic)
}
func (dst *OidcToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OidcToken.Merge(dst, src)
}
func (m *OidcToken) XXX_Size() int {
	return xxx_messageInfo_OidcToken.Size(m)
}
func (m *OidcToken) XXX_DiscardUnknown() {
	xxx_messageInfo_OidcToken.DiscardUnknown(m)
}

var xxx_messageInfo_OidcToken proto.InternalMessageInfo

func (m *OidcToken) GetServiceAccountEmail() string {
	if m != nil {
		return m.ServiceAccountEmail
	}
	return ""
}

func (m *OidcToken) GetAudience() string {
	if m != nil {
		return m.Audience
	}
	return ""
}

func init() {
	proto.RegisterType((*HttpTarget)(nil), "google.cloud.scheduler.v1beta1.HttpTarget")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.scheduler.v1beta1.HttpTarget.HeadersEntry")
	proto.RegisterType((*AppEngineHttpTarget)(nil), "google.cloud.scheduler.v1beta1.AppEngineHttpTarget")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.scheduler.v1beta1.AppEngineHttpTarget.HeadersEntry")
	proto.RegisterType((*PubsubTarget)(nil), "google.cloud.scheduler.v1beta1.PubsubTarget")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.scheduler.v1beta1.PubsubTarget.AttributesEntry")
	proto.RegisterType((*AppEngineRouting)(nil), "google.cloud.scheduler.v1beta1.AppEngineRouting")
	proto.RegisterType((*OAuthToken)(nil), "google.cloud.scheduler.v1beta1.OAuthToken")
	proto.RegisterType((*OidcToken)(nil), "google.cloud.scheduler.v1beta1.OidcToken")
	proto.RegisterEnum("google.cloud.scheduler.v1beta1.HttpMethod", HttpMethod_name, HttpMethod_value)
}

func init() {
	proto.RegisterFile("google/cloud/scheduler/v1beta1/target.proto", fileDescriptor_target_d943b6e907724d6e)
}

var fileDescriptor_target_d943b6e907724d6e = []byte{
	// 754 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0xdb, 0x6e, 0xf3, 0x44,
	0x10, 0xae, 0xeb, 0x1c, 0x9a, 0x71, 0x04, 0xd6, 0xb6, 0x40, 0x08, 0x07, 0x85, 0x5c, 0x85, 0x22,
	0xd9, 0x34, 0x5c, 0x80, 0x0a, 0x48, 0xa4, 0x8d, 0x69, 0x0a, 0xb4, 0x31, 0xae, 0xcb, 0x45, 0x41,
	0x58, 0x1b, 0x7b, 0xb1, 0x57, 0x4d, 0x76, 0x2d, 0x7b, 0x1d, 0x29, 0x88, 0x97, 0xe0, 0x91, 0x78,
	0x11, 0x9e, 0x05, 0x79, 0x7d, 0x68, 0x14, 0x89, 0x3f, 0xfd, 0xff, 0xde, 0xcd, 0xf1, 0x9b, 0xf9,
	0x66, 0x66, 0x6d, 0xf8, 0x2c, 0xe4, 0x3c, 0x5c, 0x12, 0xd3, 0x5f, 0xf2, 0x2c, 0x30, 0x53, 0x3f,
	0x22, 0x41, 0xb6, 0x24, 0x89, 0xb9, 0x3e, 0x5b, 0x10, 0x81, 0xcf, 0x4c, 0x81, 0x93, 0x90, 0x08,
	0x23, 0x4e, 0xb8, 0xe0, 0xe8, 0xe3, 0x22, 0xd8, 0x90, 0xc1, 0x46, 0x1d, 0x6c, 0x94, 0xc1, 0xfd,
	0x0f, 0x4b, 0x30, 0x1c, 0x53, 0x13, 0x33, 0xc6, 0x05, 0x16, 0x94, 0xb3, 0xb4, 0xc8, 0xee, 0xbf,
	0x5f, 0x7a, 0xa5, 0xb6, 0xc8, 0xfe, 0x30, 0x31, 0xdb, 0x14, 0xae, 0xe1, 0x3f, 0x2a, 0xc0, 0x4c,
	0x88, 0xd8, 0x95, 0xd5, 0x90, 0x0e, 0x6a, 0x96, 0xd0, 0x9e, 0x32, 0x50, 0x46, 0x1d, 0x27, 0x17,
	0xd1, 0x8f, 0xa0, 0x45, 0x42, 0xc4, 0xde, 0x8a, 0x88, 0x88, 0x07, 0xbd, 0xc3, 0x81, 0x32, 0x7a,
	0x6b, 0x7c, 0x6a, 0xbc, 0xba, 0x1f, 0x23, 0x87, 0xbc, 0x91, 0x19, 0x0e, 0x44, 0xb5, 0x8c, 0x7e,
	0x86, 0x76, 0x44, 0x70, 0x40, 0x92, 0xb4, 0xa7, 0x0e, 0xd4, 0x91, 0x36, 0xfe, 0xf2, 0x39, 0x40,
	0x45, 0x6f, 0xc6, 0xac, 0xc8, 0xb4, 0x98, 0x48, 0x36, 0x4e, 0x85, 0x83, 0x10, 0x34, 0x16, 0x3c,
	0xd8, 0xf4, 0x1a, 0x03, 0x65, 0xd4, 0x75, 0xa4, 0x8c, 0x6e, 0x40, 0xe3, 0x38, 0x13, 0x91, 0x27,
	0xf8, 0x23, 0x61, 0xbd, 0xe6, 0x40, 0x19, 0x69, 0xfb, 0x7b, 0x9e, 0x4f, 0x32, 0x11, 0xb9, 0x79,
	0xc6, 0xec, 0xc0, 0x01, 0x09, 0x20, 0x35, 0xf4, 0x03, 0x00, 0xa7, 0x81, 0x5f, 0xa2, 0xb5, 0x24,
	0xda, 0xa7, 0x7b, 0xd1, 0x68, 0xe0, 0x57, 0x60, 0x1d, 0x5e, 0x29, 0xfd, 0x73, 0xe8, 0x6e, 0xf3,
	0xc8, 0x07, 0xfe, 0x48, 0x36, 0xd5, 0xc0, 0x1f, 0xc9, 0x06, 0x9d, 0x40, 0x73, 0x8d, 0x97, 0x19,
	0x91, 0xa3, 0xee, 0x38, 0x85, 0x72, 0x7e, 0xf8, 0x95, 0x72, 0xf1, 0x2e, 0x9c, 0xe4, 0x4d, 0xf1,
	0x84, 0xfe, 0x29, 0xd7, 0xeb, 0x15, 0x33, 0x18, 0xfe, 0xad, 0xc2, 0xf1, 0x24, 0x8e, 0x2d, 0x16,
	0x52, 0x46, 0xb6, 0x96, 0xb9, 0xb3, 0x3a, 0xe5, 0x45, 0xab, 0xfb, 0x1d, 0x10, 0x8e, 0x63, 0x8f,
	0xc8, 0x22, 0x5e, 0xc2, 0x33, 0x41, 0x59, 0x28, 0x7b, 0xd4, 0xc6, 0x9f, 0xef, 0xc3, 0xac, 0xbb,
	0x73, 0x8a, 0x3c, 0x47, 0xc7, 0x3b, 0x16, 0xf4, 0x09, 0x74, 0x13, 0xb2, 0xc4, 0x82, 0xae, 0x89,
	0x97, 0x9f, 0xa0, 0x2a, 0xd9, 0x6b, 0x95, 0xed, 0x3e, 0xa1, 0xe8, 0xe1, 0xe9, 0x7a, 0x1a, 0xf2,
	0x7a, 0xbe, 0x7b, 0x76, 0xdd, 0x67, 0x9f, 0x51, 0xf3, 0xe9, 0x8c, 0x5e, 0xb2, 0xab, 0xe1, 0xbf,
	0x0a, 0x74, 0xed, 0x6c, 0x91, 0x66, 0x8b, 0x72, 0x19, 0x1f, 0x01, 0x08, 0x1e, 0x53, 0xdf, 0x63,
	0x78, 0x45, 0x4a, 0x8c, 0x8e, 0xb4, 0xdc, 0xe2, 0x15, 0xc9, 0xeb, 0x07, 0x58, 0x60, 0x49, 0xbb,
	0xeb, 0x48, 0x19, 0xfd, 0x06, 0x80, 0x85, 0x48, 0xe8, 0x22, 0x13, 0xa4, 0xa2, 0xfc, 0xcd, 0x3e,
	0xca, 0xdb, 0x45, 0x8d, 0x49, 0x9d, 0x5e, 0xd0, 0xdd, 0xc2, 0xeb, 0x7f, 0x0b, 0x6f, 0xef, 0xb8,
	0x5f, 0x8b, 0xe0, 0x1a, 0xf4, 0xdd, 0xad, 0xa2, 0x1e, 0xb4, 0x53, 0x92, 0xac, 0xa9, 0x5f, 0x11,
	0xac, 0xd4, 0xdc, 0xb3, 0x26, 0x49, 0x4a, 0x39, 0x2b, 0x91, 0x2a, 0x15, 0xf5, 0xe1, 0x88, 0xb2,
	0x54, 0x60, 0xe6, 0x93, 0x72, 0xe7, 0xb5, 0x9e, 0x0f, 0x25, 0xe2, 0xa9, 0x90, 0x6f, 0xbb, 0xe3,
	0x48, 0x79, 0xf8, 0x0b, 0xc0, 0xd3, 0x43, 0x45, 0x63, 0x78, 0xa7, 0x2c, 0xe1, 0x61, 0xdf, 0xe7,
	0x19, 0x13, 0x1e, 0x59, 0x61, 0xba, 0x2c, 0xeb, 0x1f, 0x97, 0xce, 0x49, 0xe1, 0xb3, 0x72, 0x57,
	0xce, 0x29, 0xf5, 0x79, 0x5c, 0x73, 0x92, 0xca, 0xf0, 0x57, 0xe8, 0xd4, 0x4f, 0xf6, 0x8d, 0x60,
	0xfb, 0x70, 0x84, 0xb3, 0x80, 0x92, 0x9c, 0x48, 0x81, 0x5c, 0xeb, 0xa7, 0x69, 0xf1, 0x91, 0x2d,
	0x9f, 0xd2, 0x07, 0xf0, 0xde, 0xcc, 0x75, 0x6d, 0xef, 0xc6, 0x72, 0x67, 0xf3, 0xa9, 0x77, 0x7f,
	0x7b, 0x67, 0x5b, 0x97, 0xd7, 0xdf, 0x5f, 0x5b, 0x53, 0xfd, 0x00, 0x1d, 0x41, 0xc3, 0x9e, 0xdf,
	0xb9, 0xba, 0x82, 0xda, 0xa0, 0x5e, 0x59, 0xae, 0x7e, 0x98, 0x9b, 0x66, 0xd6, 0x64, 0xaa, 0xab,
	0xb9, 0xc9, 0xbe, 0x77, 0xf5, 0x06, 0x02, 0x68, 0x4d, 0xad, 0x9f, 0x2c, 0xd7, 0xd2, 0x9b, 0xa8,
	0x03, 0x4d, 0x7b, 0xe2, 0x5e, 0xce, 0xf4, 0x16, 0xd2, 0xa0, 0x3d, 0xb7, 0xdd, 0xeb, 0xf9, 0xed,
	0x9d, 0xde, 0xbe, 0xf8, 0x0b, 0x86, 0x3e, 0x5f, 0xed, 0xb9, 0x97, 0x0b, 0xad, 0x38, 0x15, 0x3b,
	0xff, 0x1b, 0xd8, 0xca, 0xc3, 0x55, 0x19, 0x1e, 0xf2, 0x25, 0x66, 0xa1, 0xc1, 0x93, 0xd0, 0x0c,
	0x09, 0x93, 0xff, 0x0a, 0xb3, 0x70, 0xe1, 0x98, 0xa6, 0xff, 0xf7, 0xd3, 0xfa, 0xba, 0xb6, 0x2c,
	0x5a, 0x32, 0xe7, 0x8b, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x69, 0x77, 0x8b, 0x53, 0xe7, 0x06,
	0x00, 0x00,
}
