// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/mutate_job_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v1/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import status "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [MutateJobService.CreateMutateJobRequest][]
type CreateMutateJobRequest struct {
	// The ID of the customer for which to create a mutate job.
	CustomerId           string   `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateMutateJobRequest) Reset()         { *m = CreateMutateJobRequest{} }
func (m *CreateMutateJobRequest) String() string { return proto.CompactTextString(m) }
func (*CreateMutateJobRequest) ProtoMessage()    {}
func (*CreateMutateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_mutate_job_service_ffc52ee77e0c9b27, []int{0}
}
func (m *CreateMutateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateMutateJobRequest.Unmarshal(m, b)
}
func (m *CreateMutateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateMutateJobRequest.Marshal(b, m, deterministic)
}
func (dst *CreateMutateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateMutateJobRequest.Merge(dst, src)
}
func (m *CreateMutateJobRequest) XXX_Size() int {
	return xxx_messageInfo_CreateMutateJobRequest.Size(m)
}
func (m *CreateMutateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateMutateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateMutateJobRequest proto.InternalMessageInfo

func (m *CreateMutateJobRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

// Response message for [MutateJobService.CreateMutateJobResponse][]
type CreateMutateJobResponse struct {
	// The resource name of the MutateJob.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateMutateJobResponse) Reset()         { *m = CreateMutateJobResponse{} }
func (m *CreateMutateJobResponse) String() string { return proto.CompactTextString(m) }
func (*CreateMutateJobResponse) ProtoMessage()    {}
func (*CreateMutateJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_mutate_job_service_ffc52ee77e0c9b27, []int{1}
}
func (m *CreateMutateJobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateMutateJobResponse.Unmarshal(m, b)
}
func (m *CreateMutateJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateMutateJobResponse.Marshal(b, m, deterministic)
}
func (dst *CreateMutateJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateMutateJobResponse.Merge(dst, src)
}
func (m *CreateMutateJobResponse) XXX_Size() int {
	return xxx_messageInfo_CreateMutateJobResponse.Size(m)
}
func (m *CreateMutateJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateMutateJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateMutateJobResponse proto.InternalMessageInfo

func (m *CreateMutateJobResponse) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [MutateJobService.GetMutateJob][google.ads.googleads.v1.services.MutateJobService.GetMutateJob]
type GetMutateJobRequest struct {
	// The resource name of the MutateJob to get.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMutateJobRequest) Reset()         { *m = GetMutateJobRequest{} }
func (m *GetMutateJobRequest) String() string { return proto.CompactTextString(m) }
func (*GetMutateJobRequest) ProtoMessage()    {}
func (*GetMutateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_mutate_job_service_ffc52ee77e0c9b27, []int{2}
}
func (m *GetMutateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMutateJobRequest.Unmarshal(m, b)
}
func (m *GetMutateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMutateJobRequest.Marshal(b, m, deterministic)
}
func (dst *GetMutateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMutateJobRequest.Merge(dst, src)
}
func (m *GetMutateJobRequest) XXX_Size() int {
	return xxx_messageInfo_GetMutateJobRequest.Size(m)
}
func (m *GetMutateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMutateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMutateJobRequest proto.InternalMessageInfo

func (m *GetMutateJobRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [MutateJobService.RunMutateJob][google.ads.googleads.v1.services.MutateJobService.RunMutateJob]
type RunMutateJobRequest struct {
	// The resource name of the MutateJob to run.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunMutateJobRequest) Reset()         { *m = RunMutateJobRequest{} }
func (m *RunMutateJobRequest) String() string { return proto.CompactTextString(m) }
func (*RunMutateJobRequest) ProtoMessage()    {}
func (*RunMutateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_mutate_job_service_ffc52ee77e0c9b27, []int{3}
}
func (m *RunMutateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunMutateJobRequest.Unmarshal(m, b)
}
func (m *RunMutateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunMutateJobRequest.Marshal(b, m, deterministic)
}
func (dst *RunMutateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunMutateJobRequest.Merge(dst, src)
}
func (m *RunMutateJobRequest) XXX_Size() int {
	return xxx_messageInfo_RunMutateJobRequest.Size(m)
}
func (m *RunMutateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunMutateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunMutateJobRequest proto.InternalMessageInfo

func (m *RunMutateJobRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [MutateJobService.AddMutateJobOperations][google.ads.googleads.v1.services.MutateJobService.AddMutateJobOperations]
type AddMutateJobOperationsRequest struct {
	// The resource name of the MutateJob.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// A token used to enforce sequencing.
	//
	// The first AddMutateJobOperations request for a MutateJob should not set
	// sequence_token. Subsequent requests must set sequence_token to the value of
	// next_sequence_token received in the previous AddMutateJobOperations
	// response.
	SequenceToken string `protobuf:"bytes,2,opt,name=sequence_token,json=sequenceToken,proto3" json:"sequence_token,omitempty"`
	// The list of mutates being added.
	//
	// Operations can use negative integers as temp ids to signify dependencies
	// between entities created in this MutateJob. For example, a customer with
	// id = 1234 can create a campaign and an ad group in that same campaign by
	// creating a campaign in the first operation with the resource name
	// explicitly set to "customers/1234/campaigns/-1", and creating an ad group
	// in the second operation with the campaign field also set to
	// "customers/1234/campaigns/-1".
	MutateOperations     []*MutateOperation `protobuf:"bytes,3,rep,name=mutate_operations,json=mutateOperations,proto3" json:"mutate_operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *AddMutateJobOperationsRequest) Reset()         { *m = AddMutateJobOperationsRequest{} }
func (m *AddMutateJobOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*AddMutateJobOperationsRequest) ProtoMessage()    {}
func (*AddMutateJobOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_mutate_job_service_ffc52ee77e0c9b27, []int{4}
}
func (m *AddMutateJobOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddMutateJobOperationsRequest.Unmarshal(m, b)
}
func (m *AddMutateJobOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddMutateJobOperationsRequest.Marshal(b, m, deterministic)
}
func (dst *AddMutateJobOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddMutateJobOperationsRequest.Merge(dst, src)
}
func (m *AddMutateJobOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_AddMutateJobOperationsRequest.Size(m)
}
func (m *AddMutateJobOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddMutateJobOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddMutateJobOperationsRequest proto.InternalMessageInfo

func (m *AddMutateJobOperationsRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AddMutateJobOperationsRequest) GetSequenceToken() string {
	if m != nil {
		return m.SequenceToken
	}
	return ""
}

func (m *AddMutateJobOperationsRequest) GetMutateOperations() []*MutateOperation {
	if m != nil {
		return m.MutateOperations
	}
	return nil
}

// Response message for [MutateJobService.AddMutateJobOperations][google.ads.googleads.v1.services.MutateJobService.AddMutateJobOperations]
type AddMutateJobOperationsResponse struct {
	// The total number of operations added so far for this job.
	TotalOperations int64 `protobuf:"varint,1,opt,name=total_operations,json=totalOperations,proto3" json:"total_operations,omitempty"`
	// The sequence token to be used when calling AddMutateJobOperations again if
	// more operations need to be added. The next AddMutateJobOperations request
	// must set the sequence_token field to the value of this field.
	NextSequenceToken    string   `protobuf:"bytes,2,opt,name=next_sequence_token,json=nextSequenceToken,proto3" json:"next_sequence_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddMutateJobOperationsResponse) Reset()         { *m = AddMutateJobOperationsResponse{} }
func (m *AddMutateJobOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*AddMutateJobOperationsResponse) ProtoMessage()    {}
func (*AddMutateJobOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_mutate_job_service_ffc52ee77e0c9b27, []int{5}
}
func (m *AddMutateJobOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddMutateJobOperationsResponse.Unmarshal(m, b)
}
func (m *AddMutateJobOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddMutateJobOperationsResponse.Marshal(b, m, deterministic)
}
func (dst *AddMutateJobOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddMutateJobOperationsResponse.Merge(dst, src)
}
func (m *AddMutateJobOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_AddMutateJobOperationsResponse.Size(m)
}
func (m *AddMutateJobOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddMutateJobOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddMutateJobOperationsResponse proto.InternalMessageInfo

func (m *AddMutateJobOperationsResponse) GetTotalOperations() int64 {
	if m != nil {
		return m.TotalOperations
	}
	return 0
}

func (m *AddMutateJobOperationsResponse) GetNextSequenceToken() string {
	if m != nil {
		return m.NextSequenceToken
	}
	return ""
}

// Request message for [MutateJobService.ListMutateJobResults][google.ads.googleads.v1.services.MutateJobService.ListMutateJobResults].
type ListMutateJobResultsRequest struct {
	// The resource name of the MutateJob whose results are being listed.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Token of the page to retrieve. If not specified, the first
	// page of results will be returned. Use the value obtained from
	// `next_page_token` in the previous response in order to request
	// the next page of results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Number of elements to retrieve in a single page.
	// When a page request is too large, the server may decide to
	// further limit the number of returned resources.
	PageSize             int32    `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMutateJobResultsRequest) Reset()         { *m = ListMutateJobResultsRequest{} }
func (m *ListMutateJobResultsRequest) String() string { return proto.CompactTextString(m) }
func (*ListMutateJobResultsRequest) ProtoMessage()    {}
func (*ListMutateJobResultsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_mutate_job_service_ffc52ee77e0c9b27, []int{6}
}
func (m *ListMutateJobResultsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMutateJobResultsRequest.Unmarshal(m, b)
}
func (m *ListMutateJobResultsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMutateJobResultsRequest.Marshal(b, m, deterministic)
}
func (dst *ListMutateJobResultsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMutateJobResultsRequest.Merge(dst, src)
}
func (m *ListMutateJobResultsRequest) XXX_Size() int {
	return xxx_messageInfo_ListMutateJobResultsRequest.Size(m)
}
func (m *ListMutateJobResultsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMutateJobResultsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListMutateJobResultsRequest proto.InternalMessageInfo

func (m *ListMutateJobResultsRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *ListMutateJobResultsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListMutateJobResultsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for [MutateJobService.ListMutateJobResults][google.ads.googleads.v1.services.MutateJobService.ListMutateJobResults].
type ListMutateJobResultsResponse struct {
	// The list of rows that matched the query.
	Results []*MutateJobResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Pagination token used to retrieve the next page of results.
	// Pass the content of this string as the `page_token` attribute of
	// the next request. `next_page_token` is not returned for the last
	// page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMutateJobResultsResponse) Reset()         { *m = ListMutateJobResultsResponse{} }
func (m *ListMutateJobResultsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMutateJobResultsResponse) ProtoMessage()    {}
func (*ListMutateJobResultsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_mutate_job_service_ffc52ee77e0c9b27, []int{7}
}
func (m *ListMutateJobResultsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMutateJobResultsResponse.Unmarshal(m, b)
}
func (m *ListMutateJobResultsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMutateJobResultsResponse.Marshal(b, m, deterministic)
}
func (dst *ListMutateJobResultsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMutateJobResultsResponse.Merge(dst, src)
}
func (m *ListMutateJobResultsResponse) XXX_Size() int {
	return xxx_messageInfo_ListMutateJobResultsResponse.Size(m)
}
func (m *ListMutateJobResultsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMutateJobResultsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMutateJobResultsResponse proto.InternalMessageInfo

func (m *ListMutateJobResultsResponse) GetResults() []*MutateJobResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *ListMutateJobResultsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// MutateJob result.
type MutateJobResult struct {
	// Index of the mutate operation.
	OperationIndex int64 `protobuf:"varint,1,opt,name=operation_index,json=operationIndex,proto3" json:"operation_index,omitempty"`
	// Response for the mutate.
	// May be empty if errors occurred.
	MutateOperationResponse *MutateOperationResponse `protobuf:"bytes,2,opt,name=mutate_operation_response,json=mutateOperationResponse,proto3" json:"mutate_operation_response,omitempty"`
	// Details of the errors when processing the operation.
	Status               *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *MutateJobResult) Reset()         { *m = MutateJobResult{} }
func (m *MutateJobResult) String() string { return proto.CompactTextString(m) }
func (*MutateJobResult) ProtoMessage()    {}
func (*MutateJobResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_mutate_job_service_ffc52ee77e0c9b27, []int{8}
}
func (m *MutateJobResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateJobResult.Unmarshal(m, b)
}
func (m *MutateJobResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateJobResult.Marshal(b, m, deterministic)
}
func (dst *MutateJobResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateJobResult.Merge(dst, src)
}
func (m *MutateJobResult) XXX_Size() int {
	return xxx_messageInfo_MutateJobResult.Size(m)
}
func (m *MutateJobResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateJobResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateJobResult proto.InternalMessageInfo

func (m *MutateJobResult) GetOperationIndex() int64 {
	if m != nil {
		return m.OperationIndex
	}
	return 0
}

func (m *MutateJobResult) GetMutateOperationResponse() *MutateOperationResponse {
	if m != nil {
		return m.MutateOperationResponse
	}
	return nil
}

func (m *MutateJobResult) GetStatus() *status.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateMutateJobRequest)(nil), "google.ads.googleads.v1.services.CreateMutateJobRequest")
	proto.RegisterType((*CreateMutateJobResponse)(nil), "google.ads.googleads.v1.services.CreateMutateJobResponse")
	proto.RegisterType((*GetMutateJobRequest)(nil), "google.ads.googleads.v1.services.GetMutateJobRequest")
	proto.RegisterType((*RunMutateJobRequest)(nil), "google.ads.googleads.v1.services.RunMutateJobRequest")
	proto.RegisterType((*AddMutateJobOperationsRequest)(nil), "google.ads.googleads.v1.services.AddMutateJobOperationsRequest")
	proto.RegisterType((*AddMutateJobOperationsResponse)(nil), "google.ads.googleads.v1.services.AddMutateJobOperationsResponse")
	proto.RegisterType((*ListMutateJobResultsRequest)(nil), "google.ads.googleads.v1.services.ListMutateJobResultsRequest")
	proto.RegisterType((*ListMutateJobResultsResponse)(nil), "google.ads.googleads.v1.services.ListMutateJobResultsResponse")
	proto.RegisterType((*MutateJobResult)(nil), "google.ads.googleads.v1.services.MutateJobResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// MutateJobServiceClient is the client API for MutateJobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MutateJobServiceClient interface {
	// Creates a mutate job.
	CreateMutateJob(ctx context.Context, in *CreateMutateJobRequest, opts ...grpc.CallOption) (*CreateMutateJobResponse, error)
	// Returns the mutate job.
	GetMutateJob(ctx context.Context, in *GetMutateJobRequest, opts ...grpc.CallOption) (*resources.MutateJob, error)
	// Returns the results of the mutate job. The job must be done.
	// Supports standard list paging.
	ListMutateJobResults(ctx context.Context, in *ListMutateJobResultsRequest, opts ...grpc.CallOption) (*ListMutateJobResultsResponse, error)
	// Runs the mutate job.
	//
	// The Operation.metadata field type is MutateJobMetadata. When finished, the
	// long running operation will not contain errors or a response. Instead, use
	// ListMutateJobResults to get the results of the job.
	RunMutateJob(ctx context.Context, in *RunMutateJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Add operations to the mutate job.
	AddMutateJobOperations(ctx context.Context, in *AddMutateJobOperationsRequest, opts ...grpc.CallOption) (*AddMutateJobOperationsResponse, error)
}

type mutateJobServiceClient struct {
	cc *grpc.ClientConn
}

func NewMutateJobServiceClient(cc *grpc.ClientConn) MutateJobServiceClient {
	return &mutateJobServiceClient{cc}
}

func (c *mutateJobServiceClient) CreateMutateJob(ctx context.Context, in *CreateMutateJobRequest, opts ...grpc.CallOption) (*CreateMutateJobResponse, error) {
	out := new(CreateMutateJobResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.MutateJobService/CreateMutateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) GetMutateJob(ctx context.Context, in *GetMutateJobRequest, opts ...grpc.CallOption) (*resources.MutateJob, error) {
	out := new(resources.MutateJob)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.MutateJobService/GetMutateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) ListMutateJobResults(ctx context.Context, in *ListMutateJobResultsRequest, opts ...grpc.CallOption) (*ListMutateJobResultsResponse, error) {
	out := new(ListMutateJobResultsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.MutateJobService/ListMutateJobResults", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) RunMutateJob(ctx context.Context, in *RunMutateJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.MutateJobService/RunMutateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mutateJobServiceClient) AddMutateJobOperations(ctx context.Context, in *AddMutateJobOperationsRequest, opts ...grpc.CallOption) (*AddMutateJobOperationsResponse, error) {
	out := new(AddMutateJobOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.MutateJobService/AddMutateJobOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MutateJobServiceServer is the server API for MutateJobService service.
type MutateJobServiceServer interface {
	// Creates a mutate job.
	CreateMutateJob(context.Context, *CreateMutateJobRequest) (*CreateMutateJobResponse, error)
	// Returns the mutate job.
	GetMutateJob(context.Context, *GetMutateJobRequest) (*resources.MutateJob, error)
	// Returns the results of the mutate job. The job must be done.
	// Supports standard list paging.
	ListMutateJobResults(context.Context, *ListMutateJobResultsRequest) (*ListMutateJobResultsResponse, error)
	// Runs the mutate job.
	//
	// The Operation.metadata field type is MutateJobMetadata. When finished, the
	// long running operation will not contain errors or a response. Instead, use
	// ListMutateJobResults to get the results of the job.
	RunMutateJob(context.Context, *RunMutateJobRequest) (*longrunning.Operation, error)
	// Add operations to the mutate job.
	AddMutateJobOperations(context.Context, *AddMutateJobOperationsRequest) (*AddMutateJobOperationsResponse, error)
}

func RegisterMutateJobServiceServer(s *grpc.Server, srv MutateJobServiceServer) {
	s.RegisterService(&_MutateJobService_serviceDesc, srv)
}

func _MutateJobService_CreateMutateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMutateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).CreateMutateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.MutateJobService/CreateMutateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).CreateMutateJob(ctx, req.(*CreateMutateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_GetMutateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMutateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).GetMutateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.MutateJobService/GetMutateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).GetMutateJob(ctx, req.(*GetMutateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_ListMutateJobResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMutateJobResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).ListMutateJobResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.MutateJobService/ListMutateJobResults",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).ListMutateJobResults(ctx, req.(*ListMutateJobResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_RunMutateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunMutateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).RunMutateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.MutateJobService/RunMutateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).RunMutateJob(ctx, req.(*RunMutateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MutateJobService_AddMutateJobOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddMutateJobOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MutateJobServiceServer).AddMutateJobOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.MutateJobService/AddMutateJobOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MutateJobServiceServer).AddMutateJobOperations(ctx, req.(*AddMutateJobOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MutateJobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.MutateJobService",
	HandlerType: (*MutateJobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMutateJob",
			Handler:    _MutateJobService_CreateMutateJob_Handler,
		},
		{
			MethodName: "GetMutateJob",
			Handler:    _MutateJobService_GetMutateJob_Handler,
		},
		{
			MethodName: "ListMutateJobResults",
			Handler:    _MutateJobService_ListMutateJobResults_Handler,
		},
		{
			MethodName: "RunMutateJob",
			Handler:    _MutateJobService_RunMutateJob_Handler,
		},
		{
			MethodName: "AddMutateJobOperations",
			Handler:    _MutateJobService_AddMutateJobOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/mutate_job_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/mutate_job_service.proto", fileDescriptor_mutate_job_service_ffc52ee77e0c9b27)
}

var fileDescriptor_mutate_job_service_ffc52ee77e0c9b27 = []byte{
	// 867 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0x4f, 0x6f, 0xe3, 0x44,
	0x14, 0xd7, 0x24, 0x62, 0x97, 0x9d, 0xb4, 0x9b, 0xee, 0x2c, 0x6c, 0x83, 0x77, 0x0b, 0x91, 0x77,
	0x81, 0x12, 0xad, 0x6c, 0x12, 0x76, 0xa5, 0xcd, 0xac, 0xba, 0x6d, 0x8a, 0x50, 0x69, 0xf9, 0x57,
	0x39, 0xa8, 0x07, 0x14, 0x61, 0x39, 0xf1, 0xc8, 0x32, 0x24, 0x33, 0xc6, 0x33, 0xae, 0xaa, 0x56,
	0xe5, 0xc0, 0x57, 0xe8, 0x27, 0x80, 0x1b, 0x7c, 0x0c, 0x8e, 0x70, 0xe4, 0xc0, 0x89, 0x0b, 0x42,
	0x1c, 0xf8, 0x0c, 0x1c, 0x56, 0xb6, 0x67, 0x1c, 0x27, 0x75, 0x9a, 0x26, 0xb7, 0xc9, 0x6f, 0xde,
	0xef, 0xcd, 0xef, 0xf7, 0xe6, 0xe5, 0x79, 0x60, 0xdb, 0x63, 0xcc, 0x1b, 0x12, 0xd3, 0x71, 0xb9,
	0x99, 0x2e, 0xe3, 0xd5, 0x71, 0xd3, 0xe4, 0x24, 0x3c, 0xf6, 0x07, 0x84, 0x9b, 0xa3, 0x48, 0x38,
	0x82, 0xd8, 0xdf, 0xb0, 0xbe, 0x2d, 0x31, 0x23, 0x08, 0x99, 0x60, 0xa8, 0x9e, 0xc6, 0x1b, 0x8e,
	0xcb, 0x8d, 0x8c, 0x6a, 0x1c, 0x37, 0x0d, 0x45, 0xd5, 0x5a, 0xb3, 0x92, 0x87, 0x84, 0xb3, 0x28,
	0x9c, 0xcc, 0x9e, 0x66, 0xd5, 0xe6, 0x0b, 0x4a, 0x51, 0xdb, 0x71, 0xf9, 0xa4, 0x20, 0xed, 0x81,
	0xa2, 0x06, 0xbe, 0xe9, 0x50, 0xca, 0x84, 0x23, 0x7c, 0x46, 0xb9, 0xdc, 0x7d, 0x28, 0x77, 0x87,
	0x8c, 0x7a, 0x61, 0x44, 0xa9, 0x4f, 0x3d, 0x93, 0x05, 0x24, 0x9c, 0x08, 0x5a, 0x97, 0x41, 0x61,
	0x30, 0x30, 0xb9, 0x70, 0x44, 0x24, 0x37, 0xf4, 0x36, 0xbc, 0xf7, 0x61, 0x48, 0x1c, 0x41, 0x3e,
	0x4b, 0x04, 0x1f, 0xb0, 0xbe, 0x45, 0xbe, 0x8b, 0x08, 0x17, 0xe8, 0x2d, 0x58, 0x19, 0x44, 0x5c,
	0xb0, 0x11, 0x09, 0x6d, 0xdf, 0xad, 0x81, 0x3a, 0xd8, 0xbc, 0x65, 0x41, 0x05, 0xed, 0xbb, 0xfa,
	0x0b, 0xb8, 0x7e, 0x89, 0xca, 0x03, 0x46, 0x39, 0x41, 0x0f, 0xe1, 0xaa, 0x2a, 0x85, 0x4d, 0x9d,
	0x11, 0x91, 0xec, 0x15, 0x05, 0x7e, 0xee, 0x8c, 0x88, 0x8e, 0xe1, 0xdd, 0x3d, 0x22, 0x2e, 0x9d,
	0x7b, 0x5d, 0xae, 0x15, 0xd1, 0xe5, 0xb8, 0xbf, 0x03, 0xb8, 0xd1, 0x71, 0xdd, 0x8c, 0xfc, 0x45,
	0x56, 0xac, 0x45, 0xd2, 0xa0, 0xb7, 0xe1, 0x6d, 0x1e, 0xc7, 0xd3, 0x01, 0xb1, 0x05, 0xfb, 0x96,
	0xd0, 0x5a, 0x29, 0x89, 0x5a, 0x55, 0xe8, 0x97, 0x31, 0x88, 0xbe, 0x86, 0x77, 0x64, 0x2f, 0x8c,
	0x2f, 0xa5, 0x56, 0xae, 0x97, 0x37, 0x2b, 0xad, 0xa6, 0x31, 0xaf, 0xd3, 0x8c, 0x54, 0x64, 0xa6,
	0xd0, 0x5a, 0x1b, 0x4d, 0x02, 0x5c, 0x3f, 0x83, 0x6f, 0xce, 0x32, 0x23, 0x2f, 0xe3, 0x3d, 0xb8,
	0x26, 0x98, 0x70, 0x86, 0x79, 0x01, 0xb1, 0xa1, 0xb2, 0x55, 0x4d, 0xf0, 0x31, 0x05, 0x19, 0xf0,
	0x2e, 0x25, 0x27, 0xc2, 0x2e, 0x34, 0x76, 0x27, 0xde, 0xea, 0xe6, 0xcd, 0xe9, 0xdf, 0xc3, 0xfb,
	0x9f, 0xfa, 0x3c, 0x7f, 0x87, 0x3c, 0x1a, 0x8a, 0xc5, 0xea, 0xb8, 0x01, 0x61, 0xe0, 0x78, 0x93,
	0x47, 0xdd, 0x8a, 0x91, 0xb4, 0x7e, 0xf7, 0x61, 0xf2, 0xc3, 0xe6, 0xfe, 0x29, 0xa9, 0x95, 0xeb,
	0x60, 0xf3, 0x15, 0xeb, 0xd5, 0x18, 0xe8, 0xfa, 0xa7, 0x44, 0xbf, 0x00, 0xf0, 0x41, 0xb1, 0x00,
	0xe9, 0xfd, 0x13, 0x78, 0x33, 0x4c, 0xa1, 0x1a, 0x58, 0xac, 0xe6, 0x59, 0x32, 0x4b, 0x65, 0x40,
	0xef, 0xc0, 0x6a, 0x52, 0x9d, 0x4b, 0x72, 0x57, 0x63, 0xf8, 0x50, 0x49, 0xd6, 0xff, 0x02, 0xb0,
	0x3a, 0x95, 0x04, 0xbd, 0x0b, 0xab, 0x59, 0xf9, 0x6d, 0x9f, 0xba, 0xe4, 0x44, 0xde, 0xc1, 0xed,
	0x0c, 0xde, 0x8f, 0x51, 0x14, 0xc1, 0x37, 0xa6, 0xfb, 0xc5, 0x0e, 0xa5, 0x9d, 0xe4, 0xb8, 0x4a,
	0xab, 0xbd, 0x78, 0xdf, 0xc8, 0x04, 0xd6, 0xfa, 0xa8, 0x78, 0x03, 0x35, 0xe0, 0x8d, 0x74, 0x2e,
	0x24, 0x35, 0xae, 0xb4, 0x90, 0x3a, 0x23, 0x0c, 0x06, 0x46, 0x37, 0xd9, 0xb1, 0x64, 0x44, 0xeb,
	0xdf, 0x9b, 0x70, 0x2d, 0xf3, 0xd7, 0x4d, 0x8f, 0x44, 0xbf, 0x02, 0x58, 0x9d, 0x1a, 0x07, 0xe8,
	0xd9, 0x7c, 0xa1, 0xc5, 0xc3, 0x47, 0x6b, 0x2f, 0xc1, 0x4c, 0x9d, 0xe8, 0xf8, 0x87, 0x3f, 0xfe,
	0xb9, 0x28, 0x3d, 0xd1, 0xcd, 0x78, 0xb8, 0xaa, 0x71, 0xc5, 0xcd, 0xb3, 0xdc, 0x30, 0xdb, 0x6a,
	0x9c, 0xcb, 0x01, 0x7d, 0xc0, 0xfa, 0x1c, 0x0f, 0x92, 0x4c, 0x18, 0x34, 0xd0, 0xcf, 0x00, 0xae,
	0xe4, 0x67, 0x12, 0x7a, 0x3a, 0x5f, 0x47, 0xc1, 0x0c, 0xd3, 0x1e, 0xcf, 0xa4, 0x65, 0x5f, 0x88,
	0x71, 0x9b, 0xe9, 0x4f, 0x12, 0xc5, 0x06, 0x7a, 0x1c, 0x2b, 0x3e, 0x9b, 0xf8, 0xc7, 0x6c, 0x8d,
	0x0d, 0x34, 0x72, 0x92, 0xcd, 0xc6, 0x39, 0xfa, 0x13, 0xc0, 0xd7, 0x8a, 0x7a, 0x1f, 0x6d, 0xcd,
	0xd7, 0x7c, 0xc5, 0x9f, 0x56, 0x7b, 0xb1, 0x2c, 0x5d, 0xd6, 0x7f, 0x27, 0x71, 0x83, 0xd1, 0xb3,
	0x45, 0xdc, 0xe0, 0xa1, 0xcf, 0x85, 0x32, 0xf0, 0x23, 0x80, 0x2b, 0xf9, 0xe9, 0x7e, 0x9d, 0x5b,
	0x28, 0xf8, 0x1a, 0x68, 0x1b, 0x8a, 0x96, 0xfb, 0x34, 0x1a, 0x59, 0xeb, 0xeb, 0xcf, 0x13, 0xa1,
	0x4f, 0xf5, 0xf7, 0x17, 0x12, 0x1a, 0x46, 0x34, 0xee, 0x94, 0xbf, 0x01, 0xbc, 0x57, 0x3c, 0x77,
	0xd1, 0xf6, 0x7c, 0xb5, 0x57, 0x7e, 0x7e, 0xb4, 0x9d, 0xe5, 0x13, 0xc8, 0x3b, 0xf8, 0x28, 0xb1,
	0xb6, 0xad, 0xe3, 0x85, 0xac, 0x39, 0xae, 0x3b, 0xce, 0x85, 0x41, 0x63, 0xf7, 0x7f, 0x00, 0x1f,
	0x0d, 0xd8, 0x68, 0xae, 0x9c, 0xdd, 0xd7, 0xa7, 0xc7, 0xc1, 0x61, 0xfc, 0xb8, 0x38, 0x04, 0x5f,
	0x7d, 0x2c, 0xa9, 0x1e, 0x1b, 0x3a, 0xd4, 0x33, 0x58, 0xe8, 0x99, 0x1e, 0xa1, 0xc9, 0xd3, 0x43,
	0xbd, 0x82, 0x02, 0x9f, 0xcf, 0x7e, 0x14, 0x3d, 0x57, 0x8b, 0x9f, 0x4a, 0xe5, 0xbd, 0x4e, 0xe7,
	0x97, 0x52, 0x7d, 0x2f, 0x4d, 0xd8, 0x71, 0xb9, 0x91, 0x2e, 0xe3, 0xd5, 0x51, 0xd3, 0x90, 0x07,
	0xf3, 0xdf, 0x54, 0x48, 0xaf, 0xe3, 0xf2, 0x5e, 0x16, 0xd2, 0x3b, 0x6a, 0xf6, 0x54, 0xc8, 0x7f,
	0xa5, 0x47, 0x29, 0x8e, 0x71, 0xc7, 0xe5, 0x18, 0x67, 0x41, 0x18, 0x1f, 0x35, 0x31, 0x56, 0x61,
	0xfd, 0x1b, 0x89, 0xce, 0x0f, 0x5e, 0x06, 0x00, 0x00, 0xff, 0xff, 0xa4, 0x3d, 0xcf, 0xf4, 0x4c,
	0x0a, 0x00, 0x00,
}
