// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/autoscaling"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To attach an instance to an Auto Scaling group
//
// This example attaches the specified instance to the specified Auto Scaling group.
func ExampleAutoScaling_AttachInstances_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.AttachInstancesInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []*string{
			aws.String("i-93633f9b"),
		},
	}

	result, err := svc.AttachInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a target group to an Auto Scaling group
//
// This example attaches the specified target group to the specified Auto Scaling group.
func ExampleAutoScaling_AttachLoadBalancerTargetGroups_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.AttachLoadBalancerTargetGroupsInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		TargetGroupARNs: []*string{
			aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
		},
	}

	result, err := svc.AttachLoadBalancerTargetGroups(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a load balancer to an Auto Scaling group
//
// This example attaches the specified load balancer to the specified Auto Scaling group.
func ExampleAutoScaling_AttachLoadBalancers_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.AttachLoadBalancersInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		LoadBalancerNames: []*string{
			aws.String("my-load-balancer"),
		},
	}

	result, err := svc.AttachLoadBalancers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To complete the lifecycle action
//
// This example notifies Auto Scaling that the specified lifecycle action is complete
// so that it can finish launching or terminating the instance.
func ExampleAutoScaling_CompleteLifecycleAction_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.CompleteLifecycleActionInput{
		AutoScalingGroupName:  aws.String("my-auto-scaling-group"),
		LifecycleActionResult: aws.String("CONTINUE"),
		LifecycleActionToken:  aws.String("bcd2f1b8-9a78-44d3-8a7a-4dd07d7cf635"),
		LifecycleHookName:     aws.String("my-lifecycle-hook"),
	}

	result, err := svc.CompleteLifecycleAction(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an Auto Scaling group
//
// This example creates an Auto Scaling group.
func ExampleAutoScaling_CreateAutoScalingGroup_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.CreateAutoScalingGroupInput{
		AutoScalingGroupName:    aws.String("my-auto-scaling-group"),
		LaunchConfigurationName: aws.String("my-launch-config"),
		MaxSize:                 aws.Int64(3),
		MinSize:                 aws.Int64(1),
		VPCZoneIdentifier:       aws.String("subnet-4176792c"),
	}

	result, err := svc.CreateAutoScalingGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an Auto Scaling group with an attached load balancer
//
// This example creates an Auto Scaling group and attaches the specified Classic Load
// Balancer.
func ExampleAutoScaling_CreateAutoScalingGroup_shared01() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.CreateAutoScalingGroupInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		AvailabilityZones: []*string{
			aws.String("us-west-2c"),
		},
		HealthCheckGracePeriod:  aws.Int64(120),
		HealthCheckType:         aws.String("ELB"),
		LaunchConfigurationName: aws.String("my-launch-config"),
		LoadBalancerNames: []*string{
			aws.String("my-load-balancer"),
		},
		MaxSize: aws.Int64(3),
		MinSize: aws.Int64(1),
	}

	result, err := svc.CreateAutoScalingGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an Auto Scaling group with an attached target group
//
// This example creates an Auto Scaling group and attaches the specified target group.
func ExampleAutoScaling_CreateAutoScalingGroup_shared02() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.CreateAutoScalingGroupInput{
		AutoScalingGroupName:    aws.String("my-auto-scaling-group"),
		HealthCheckGracePeriod:  aws.Int64(120),
		HealthCheckType:         aws.String("ELB"),
		LaunchConfigurationName: aws.String("my-launch-config"),
		MaxSize:                 aws.Int64(3),
		MinSize:                 aws.Int64(1),
		TargetGroupARNs: []*string{
			aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
		},
		VPCZoneIdentifier: aws.String("subnet-4176792c, subnet-65ea5f08"),
	}

	result, err := svc.CreateAutoScalingGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a launch configuration
//
// This example creates a launch configuration.
func ExampleAutoScaling_CreateLaunchConfiguration_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.CreateLaunchConfigurationInput{
		IamInstanceProfile:      aws.String("my-iam-role"),
		ImageId:                 aws.String("ami-12345678"),
		InstanceType:            aws.String("m3.medium"),
		LaunchConfigurationName: aws.String("my-launch-config"),
		SecurityGroups: []*string{
			aws.String("sg-eb2af88e"),
		},
	}

	result, err := svc.CreateLaunchConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create or update tags for an Auto Scaling group
//
// This example adds two tags to the specified Auto Scaling group.
func ExampleAutoScaling_CreateOrUpdateTags_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.CreateOrUpdateTagsInput{
		Tags: []*autoscaling.Tag{
			{
				Key:               aws.String("Role"),
				PropagateAtLaunch: aws.Bool(true),
				ResourceId:        aws.String("my-auto-scaling-group"),
				ResourceType:      aws.String("auto-scaling-group"),
				Value:             aws.String("WebServer"),
			},
			{
				Key:               aws.String("Dept"),
				PropagateAtLaunch: aws.Bool(true),
				ResourceId:        aws.String("my-auto-scaling-group"),
				ResourceType:      aws.String("auto-scaling-group"),
				Value:             aws.String("Research"),
			},
		},
	}

	result, err := svc.CreateOrUpdateTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an Auto Scaling group
//
// This example deletes the specified Auto Scaling group.
func ExampleAutoScaling_DeleteAutoScalingGroup_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DeleteAutoScalingGroupInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	result, err := svc.DeleteAutoScalingGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an Auto Scaling group and all its instances
//
// This example deletes the specified Auto Scaling group and all its instances.
func ExampleAutoScaling_DeleteAutoScalingGroup_shared01() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DeleteAutoScalingGroupInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		ForceDelete:          aws.Bool(true),
	}

	result, err := svc.DeleteAutoScalingGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a launch configuration
//
// This example deletes the specified launch configuration.
func ExampleAutoScaling_DeleteLaunchConfiguration_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DeleteLaunchConfigurationInput{
		LaunchConfigurationName: aws.String("my-launch-config"),
	}

	result, err := svc.DeleteLaunchConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a lifecycle hook
//
// This example deletes the specified lifecycle hook.
func ExampleAutoScaling_DeleteLifecycleHook_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DeleteLifecycleHookInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		LifecycleHookName:    aws.String("my-lifecycle-hook"),
	}

	result, err := svc.DeleteLifecycleHook(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an Auto Scaling notification
//
// This example deletes the specified notification from the specified Auto Scaling group.
func ExampleAutoScaling_DeleteNotificationConfiguration_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DeleteNotificationConfigurationInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		TopicARN:             aws.String("arn:aws:sns:us-west-2:123456789012:my-sns-topic"),
	}

	result, err := svc.DeleteNotificationConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an Auto Scaling policy
//
// This example deletes the specified Auto Scaling policy.
func ExampleAutoScaling_DeletePolicy_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DeletePolicyInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		PolicyName:           aws.String("ScaleIn"),
	}

	result, err := svc.DeletePolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a scheduled action from an Auto Scaling group
//
// This example deletes the specified scheduled action from the specified Auto Scaling
// group.
func ExampleAutoScaling_DeleteScheduledAction_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DeleteScheduledActionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		ScheduledActionName:  aws.String("my-scheduled-action"),
	}

	result, err := svc.DeleteScheduledAction(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a tag from an Auto Scaling group
//
// This example deletes the specified tag from the specified Auto Scaling group.
func ExampleAutoScaling_DeleteTags_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DeleteTagsInput{
		Tags: []*autoscaling.Tag{
			{
				Key:          aws.String("Dept"),
				ResourceId:   aws.String("my-auto-scaling-group"),
				ResourceType: aws.String("auto-scaling-group"),
				Value:        aws.String("Research"),
			},
		},
	}

	result, err := svc.DeleteTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Auto Scaling account limits
//
// This example describes the Auto Scaling limits for your AWS account.
func ExampleAutoScaling_DescribeAccountLimits_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeAccountLimitsInput{}

	result, err := svc.DescribeAccountLimits(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Auto Scaling adjustment types
//
// This example describes the available adjustment types.
func ExampleAutoScaling_DescribeAdjustmentTypes_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeAdjustmentTypesInput{}

	result, err := svc.DescribeAdjustmentTypes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an Auto Scaling group
//
// This example describes the specified Auto Scaling group.
func ExampleAutoScaling_DescribeAutoScalingGroups_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeAutoScalingGroupsInput{
		AutoScalingGroupNames: []*string{
			aws.String("my-auto-scaling-group"),
		},
	}

	result, err := svc.DescribeAutoScalingGroups(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe one or more Auto Scaling instances
//
// This example describes the specified Auto Scaling instance.
func ExampleAutoScaling_DescribeAutoScalingInstances_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeAutoScalingInstancesInput{
		InstanceIds: []*string{
			aws.String("i-4ba0837f"),
		},
	}

	result, err := svc.DescribeAutoScalingInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Auto Scaling notification types
//
// This example describes the available notification types.
func ExampleAutoScaling_DescribeAutoScalingNotificationTypes_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeAutoScalingNotificationTypesInput{}

	result, err := svc.DescribeAutoScalingNotificationTypes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Auto Scaling launch configurations
//
// This example describes the specified launch configuration.
func ExampleAutoScaling_DescribeLaunchConfigurations_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeLaunchConfigurationsInput{
		LaunchConfigurationNames: []*string{
			aws.String("my-launch-config"),
		},
	}

	result, err := svc.DescribeLaunchConfigurations(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the available types of lifecycle hooks
//
// This example describes the available lifecycle hook types.
func ExampleAutoScaling_DescribeLifecycleHookTypes_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeLifecycleHookTypesInput{}

	result, err := svc.DescribeLifecycleHookTypes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your lifecycle hooks
//
// This example describes the lifecycle hooks for the specified Auto Scaling group.
func ExampleAutoScaling_DescribeLifecycleHooks_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeLifecycleHooksInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	result, err := svc.DescribeLifecycleHooks(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the target groups for an Auto Scaling group
//
// This example describes the target groups attached to the specified Auto Scaling group.
func ExampleAutoScaling_DescribeLoadBalancerTargetGroups_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeLoadBalancerTargetGroupsInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	result, err := svc.DescribeLoadBalancerTargetGroups(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the load balancers for an Auto Scaling group
//
// This example describes the load balancers attached to the specified Auto Scaling
// group.
func ExampleAutoScaling_DescribeLoadBalancers_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeLoadBalancersInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	result, err := svc.DescribeLoadBalancers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Auto Scaling metric collection types
//
// This example describes the available metric collection types.
func ExampleAutoScaling_DescribeMetricCollectionTypes_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeMetricCollectionTypesInput{}

	result, err := svc.DescribeMetricCollectionTypes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Auto Scaling notification configurations
//
// This example describes the notification configurations for the specified Auto Scaling
// group.
func ExampleAutoScaling_DescribeNotificationConfigurations_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeNotificationConfigurationsInput{
		AutoScalingGroupNames: []*string{
			aws.String("my-auto-scaling-group"),
		},
	}

	result, err := svc.DescribeNotificationConfigurations(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Auto Scaling policies
//
// This example describes the policies for the specified Auto Scaling group.
func ExampleAutoScaling_DescribePolicies_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribePoliciesInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	result, err := svc.DescribePolicies(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the scaling activities for an Auto Scaling group
//
// This example describes the scaling activities for the specified Auto Scaling group.
func ExampleAutoScaling_DescribeScalingActivities_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeScalingActivitiesInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	result, err := svc.DescribeScalingActivities(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Auto Scaling process types
//
// This example describes the Auto Scaling process types.
func ExampleAutoScaling_DescribeScalingProcessTypes_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeScalingProcessTypesInput{}

	result, err := svc.DescribeScalingProcessTypes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe scheduled actions
//
// This example describes the scheduled actions for the specified Auto Scaling group.
func ExampleAutoScaling_DescribeScheduledActions_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeScheduledActionsInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
	}

	result, err := svc.DescribeScheduledActions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe tags
//
// This example describes the tags for the specified Auto Scaling group.
func ExampleAutoScaling_DescribeTags_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeTagsInput{
		Filters: []*autoscaling.Filter{
			{
				Name: aws.String("auto-scaling-group"),
				Values: []*string{
					aws.String("my-auto-scaling-group"),
				},
			},
		},
	}

	result, err := svc.DescribeTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeInvalidNextToken:
				fmt.Println(autoscaling.ErrCodeInvalidNextToken, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe termination policy types
//
// This example describes the available termination policy types.
func ExampleAutoScaling_DescribeTerminationPolicyTypes_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DescribeTerminationPolicyTypesInput{}

	result, err := svc.DescribeTerminationPolicyTypes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach an instance from an Auto Scaling group
//
// This example detaches the specified instance from the specified Auto Scaling group.
func ExampleAutoScaling_DetachInstances_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DetachInstancesInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []*string{
			aws.String("i-93633f9b"),
		},
		ShouldDecrementDesiredCapacity: aws.Bool(true),
	}

	result, err := svc.DetachInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a target group from an Auto Scaling group
//
// This example detaches the specified target group from the specified Auto Scaling
// group
func ExampleAutoScaling_DetachLoadBalancerTargetGroups_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DetachLoadBalancerTargetGroupsInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		TargetGroupARNs: []*string{
			aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
		},
	}

	result, err := svc.DetachLoadBalancerTargetGroups(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a load balancer from an Auto Scaling group
//
// This example detaches the specified load balancer from the specified Auto Scaling
// group.
func ExampleAutoScaling_DetachLoadBalancers_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DetachLoadBalancersInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		LoadBalancerNames: []*string{
			aws.String("my-load-balancer"),
		},
	}

	result, err := svc.DetachLoadBalancers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable metrics collection for an Auto Scaling group
//
// This example disables collecting data for the GroupDesiredCapacity metric for the
// specified Auto Scaling group.
func ExampleAutoScaling_DisableMetricsCollection_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.DisableMetricsCollectionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		Metrics: []*string{
			aws.String("GroupDesiredCapacity"),
		},
	}

	result, err := svc.DisableMetricsCollection(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable metrics collection for an Auto Scaling group
//
// This example enables data collection for the specified Auto Scaling group.
func ExampleAutoScaling_EnableMetricsCollection_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.EnableMetricsCollectionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		Granularity:          aws.String("1Minute"),
	}

	result, err := svc.EnableMetricsCollection(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To move instances into standby mode
//
// This example puts the specified instance into standby mode.
func ExampleAutoScaling_EnterStandby_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.EnterStandbyInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []*string{
			aws.String("i-93633f9b"),
		},
		ShouldDecrementDesiredCapacity: aws.Bool(true),
	}

	result, err := svc.EnterStandby(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To execute an Auto Scaling policy
//
// This example executes the specified Auto Scaling policy for the specified Auto Scaling
// group.
func ExampleAutoScaling_ExecutePolicy_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.ExecutePolicyInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		HonorCooldown:        aws.Bool(true),
		PolicyName:           aws.String("ScaleIn"),
	}

	result, err := svc.ExecutePolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To move instances out of standby mode
//
// This example moves the specified instance out of standby mode.
func ExampleAutoScaling_ExitStandby_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.ExitStandbyInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []*string{
			aws.String("i-93633f9b"),
		},
	}

	result, err := svc.ExitStandby(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a lifecycle hook
//
// This example creates a lifecycle hook.
func ExampleAutoScaling_PutLifecycleHook_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.PutLifecycleHookInput{
		AutoScalingGroupName:  aws.String("my-auto-scaling-group"),
		LifecycleHookName:     aws.String("my-lifecycle-hook"),
		LifecycleTransition:   aws.String("autoscaling:EC2_INSTANCE_LAUNCHING"),
		NotificationTargetARN: aws.String("arn:aws:sns:us-west-2:123456789012:my-sns-topic --role-arn"),
		RoleARN:               aws.String("arn:aws:iam::123456789012:role/my-auto-scaling-role"),
	}

	result, err := svc.PutLifecycleHook(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add an Auto Scaling notification
//
// This example adds the specified notification to the specified Auto Scaling group.
func ExampleAutoScaling_PutNotificationConfiguration_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.PutNotificationConfigurationInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		NotificationTypes: []*string{
			aws.String("autoscaling:TEST_NOTIFICATION"),
		},
		TopicARN: aws.String("arn:aws:sns:us-west-2:123456789012:my-sns-topic"),
	}

	result, err := svc.PutNotificationConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a scaling policy to an Auto Scaling group
//
// This example adds the specified policy to the specified Auto Scaling group.
func ExampleAutoScaling_PutScalingPolicy_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.PutScalingPolicyInput{
		AdjustmentType:       aws.String("ChangeInCapacity"),
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		PolicyName:           aws.String("ScaleIn"),
		ScalingAdjustment:    aws.Int64(-1),
	}

	result, err := svc.PutScalingPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a scheduled action to an Auto Scaling group
//
// This example adds the specified scheduled action to the specified Auto Scaling group.
func ExampleAutoScaling_PutScheduledUpdateGroupAction_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.PutScheduledUpdateGroupActionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		DesiredCapacity:      aws.Int64(4),
		EndTime:              parseTime("2006-01-02T15:04:05Z", "2014-05-12T08:00:00Z"),
		MaxSize:              aws.Int64(6),
		MinSize:              aws.Int64(2),
		ScheduledActionName:  aws.String("my-scheduled-action"),
		StartTime:            parseTime("2006-01-02T15:04:05Z", "2014-05-12T08:00:00Z"),
	}

	result, err := svc.PutScheduledUpdateGroupAction(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeAlreadyExistsFault:
				fmt.Println(autoscaling.ErrCodeAlreadyExistsFault, aerr.Error())
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To record a lifecycle action heartbeat
//
// This example records a lifecycle action heartbeat to keep the instance in a pending
// state.
func ExampleAutoScaling_RecordLifecycleActionHeartbeat_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.RecordLifecycleActionHeartbeatInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		LifecycleActionToken: aws.String("bcd2f1b8-9a78-44d3-8a7a-4dd07d7cf635"),
		LifecycleHookName:    aws.String("my-lifecycle-hook"),
	}

	result, err := svc.RecordLifecycleActionHeartbeat(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To resume Auto Scaling processes
//
// This example resumes the specified suspended scaling process for the specified Auto
// Scaling group.
func ExampleAutoScaling_ResumeProcesses_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.ScalingProcessQuery{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		ScalingProcesses: []*string{
			aws.String("AlarmNotification"),
		},
	}

	result, err := svc.ResumeProcesses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To set the desired capacity for an Auto Scaling group
//
// This example sets the desired capacity for the specified Auto Scaling group.
func ExampleAutoScaling_SetDesiredCapacity_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.SetDesiredCapacityInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		DesiredCapacity:      aws.Int64(2),
		HonorCooldown:        aws.Bool(true),
	}

	result, err := svc.SetDesiredCapacity(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To set the health status of an instance
//
// This example sets the health status of the specified instance to Unhealthy.
func ExampleAutoScaling_SetInstanceHealth_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.SetInstanceHealthInput{
		HealthStatus: aws.String("Unhealthy"),
		InstanceId:   aws.String("i-93633f9b"),
	}

	result, err := svc.SetInstanceHealth(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable instance protection for an instance
//
// This example enables instance protection for the specified instance.
func ExampleAutoScaling_SetInstanceProtection_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.SetInstanceProtectionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []*string{
			aws.String("i-93633f9b"),
		},
		ProtectedFromScaleIn: aws.Bool(true),
	}

	result, err := svc.SetInstanceProtection(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable instance protection for an instance
//
// This example disables instance protection for the specified instance.
func ExampleAutoScaling_SetInstanceProtection_shared01() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.SetInstanceProtectionInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		InstanceIds: []*string{
			aws.String("i-93633f9b"),
		},
		ProtectedFromScaleIn: aws.Bool(false),
	}

	result, err := svc.SetInstanceProtection(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeLimitExceededFault:
				fmt.Println(autoscaling.ErrCodeLimitExceededFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To suspend Auto Scaling processes
//
// This example suspends the specified scaling process for the specified Auto Scaling
// group.
func ExampleAutoScaling_SuspendProcesses_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.ScalingProcessQuery{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		ScalingProcesses: []*string{
			aws.String("AlarmNotification"),
		},
	}

	result, err := svc.SuspendProcesses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeResourceInUseFault:
				fmt.Println(autoscaling.ErrCodeResourceInUseFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To terminate an instance in an Auto Scaling group
//
// This example terminates the specified instance from the specified Auto Scaling group
// without updating the size of the group. Auto Scaling launches a replacement instance
// after the specified instance terminates.
func ExampleAutoScaling_TerminateInstanceInAutoScalingGroup_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.TerminateInstanceInAutoScalingGroupInput{
		InstanceId:                     aws.String("i-93633f9b"),
		ShouldDecrementDesiredCapacity: aws.Bool(false),
	}

	result, err := svc.TerminateInstanceInAutoScalingGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the launch configuration
//
// This example updates the launch configuration of the specified Auto Scaling group.
func ExampleAutoScaling_UpdateAutoScalingGroup_shared00() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.UpdateAutoScalingGroupInput{
		AutoScalingGroupName:    aws.String("my-auto-scaling-group"),
		LaunchConfigurationName: aws.String("new-launch-config"),
	}

	result, err := svc.UpdateAutoScalingGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the minimum and maximum size
//
// This example updates the minimum size and maximum size of the specified Auto Scaling
// group.
func ExampleAutoScaling_UpdateAutoScalingGroup_shared01() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.UpdateAutoScalingGroupInput{
		AutoScalingGroupName: aws.String("my-auto-scaling-group"),
		MaxSize:              aws.Int64(3),
		MinSize:              aws.Int64(1),
	}

	result, err := svc.UpdateAutoScalingGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable instance protection
//
// This example enables instance protection for the specified Auto Scaling group.
func ExampleAutoScaling_UpdateAutoScalingGroup_shared02() {
	svc := autoscaling.New(session.New())
	input := &autoscaling.UpdateAutoScalingGroupInput{
		AutoScalingGroupName:             aws.String("my-auto-scaling-group"),
		NewInstancesProtectedFromScaleIn: aws.Bool(true),
	}

	result, err := svc.UpdateAutoScalingGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case autoscaling.ErrCodeScalingActivityInProgressFault:
				fmt.Println(autoscaling.ErrCodeScalingActivityInProgressFault, aerr.Error())
			case autoscaling.ErrCodeResourceContentionFault:
				fmt.Println(autoscaling.ErrCodeResourceContentionFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
