// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlias for more information on using the CreateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAliasRequest method.
//    req, resp := client.CreateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAlias
func (c *GameLift) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output = &CreateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlias API operation for Amazon GameLift.
//
// Creates an alias for a fleet. In most situations, you can use an alias ID
// in place of a fleet ID. By using a fleet alias instead of a specific fleet
// ID, you can switch gameplay and players to a new fleet without changing your
// game client or other game components. For example, for games in production,
// using an alias allows you to seamlessly redirect your player base to a new
// game server update.
//
// Amazon GameLift supports two types of routing strategies for aliases: simple
// and terminal. A simple alias points to an active fleet. A terminal alias
// is used to display messaging or link to a URL instead of routing players
// to an active fleet. For example, you might use a terminal alias when a game
// version is no longer supported and you want to direct players to an upgrade
// site.
//
// To create a fleet alias, specify an alias name, routing strategy, and optional
// description. Each simple alias can point to only one fleet, but a fleet can
// have multiple aliases. If successful, a new alias record is returned, including
// an alias ID, which you can reference when creating a game session. You can
// reassign an alias to another fleet by calling UpdateAlias.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAlias
func (c *GameLift) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	return out, req.Send()
}

// CreateAliasWithContext is the same as CreateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateAliasWithContext(ctx aws.Context, input *CreateAliasInput, opts ...request.Option) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBuild = "CreateBuild"

// CreateBuildRequest generates a "aws/request.Request" representing the
// client's request for the CreateBuild operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBuild for more information on using the CreateBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBuildRequest method.
//    req, resp := client.CreateBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild
func (c *GameLift) CreateBuildRequest(input *CreateBuildInput) (req *request.Request, output *CreateBuildOutput) {
	op := &request.Operation{
		Name:       opCreateBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBuildInput{}
	}

	output = &CreateBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBuild API operation for Amazon GameLift.
//
// Creates a new Amazon GameLift build from a set of game server binary files
// stored in an Amazon Simple Storage Service (Amazon S3) location. To use this
// API call, create a .zip file containing all of the files for the build and
// store it in an Amazon S3 bucket under your AWS account. For help on packaging
// your build files and creating a build, see Uploading Your Game to Amazon
// GameLift (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html).
//
// Use this API action ONLY if you are storing your game build files in an Amazon
// S3 bucket. To create a build using files stored locally, use the CLI command
// upload-build (http://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html),
// which uploads the build files from a file location you specify.
//
// To create a new build using CreateBuild, identify the storage location and
// operating system of your game build. You also have the option of specifying
// a build name and version. If successful, this action creates a new build
// record with an unique build ID and in INITIALIZED status. Use the API call
// DescribeBuild to check the status of your build. A build must be in READY
// status before it can be used to create fleets to host your game.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild
func (c *GameLift) CreateBuild(input *CreateBuildInput) (*CreateBuildOutput, error) {
	req, out := c.CreateBuildRequest(input)
	return out, req.Send()
}

// CreateBuildWithContext is the same as CreateBuild with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateBuildWithContext(ctx aws.Context, input *CreateBuildInput, opts ...request.Option) (*CreateBuildOutput, error) {
	req, out := c.CreateBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleet for more information on using the CreateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFleetRequest method.
//    req, resp := client.CreateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet
func (c *GameLift) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleet API operation for Amazon GameLift.
//
// Creates a new fleet to run your game servers. A fleet is a set of Amazon
// Elastic Compute Cloud (Amazon EC2) instances, each of which can run multiple
// server processes to host game sessions. You configure a fleet to create instances
// with certain hardware specifications (see Amazon EC2 Instance Types (http://aws.amazon.com/ec2/instance-types/)
// for more information), and deploy a specified game build to each instance.
// A newly created fleet passes through several statuses; once it reaches the
// ACTIVE status, it can begin hosting game sessions.
//
// To create a new fleet, you must specify the following: (1) fleet name, (2)
// build ID of an uploaded game build, (3) an EC2 instance type, and (4) a run-time
// configuration that describes which server processes to run on each instance
// in the fleet. (Although the run-time configuration is not a required parameter,
// the fleet cannot be successfully activated without it.)
//
// You can also configure the new fleet with the following settings:
//
//    * Fleet description
//
//    * Access permissions for inbound traffic
//
//    * Fleetwide game session protection
//
//    * Resource creation limit
//
// If you use Amazon CloudWatch for metrics, you can add the new fleet to a
// metric group. This allows you to view aggregated metrics for a set of fleets.
// Once you specify a metric group, the new fleet's metrics are included in
// the metric group's data.
//
// If the CreateFleet call is successful, Amazon GameLift performs the following
// tasks:
//
//    * Creates a fleet record and sets the status to NEW (followed by other
//    statuses as the fleet is activated).
//
//    * Sets the fleet's target capacity to 1 (desired instances), which causes
//    Amazon GameLift to start one new EC2 instance.
//
//    * Starts launching server processes on the instance. If the fleet is configured
//    to run multiple server processes per instance, Amazon GameLift staggers
//    each launch by a few seconds.
//
//    * Begins writing events to the fleet event log, which can be accessed
//    in the Amazon GameLift console.
//
//    * Sets the fleet's status to ACTIVE as soon as one server process in the
//    fleet is ready to host a game session.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateFleet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet
func (c *GameLift) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	return out, req.Send()
}

// CreateFleetWithContext is the same as CreateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateFleetWithContext(ctx aws.Context, input *CreateFleetInput, opts ...request.Option) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGameSession = "CreateGameSession"

// CreateGameSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateGameSession operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGameSession for more information on using the CreateGameSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGameSessionRequest method.
//    req, resp := client.CreateGameSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSession
func (c *GameLift) CreateGameSessionRequest(input *CreateGameSessionInput) (req *request.Request, output *CreateGameSessionOutput) {
	op := &request.Operation{
		Name:       opCreateGameSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGameSessionInput{}
	}

	output = &CreateGameSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGameSession API operation for Amazon GameLift.
//
// Creates a multiplayer game session for players. This action creates a game
// session record and assigns an available server process in the specified fleet
// to host the game session. A fleet must have an ACTIVE status before a game
// session can be created in it.
//
// To create a game session, specify either fleet ID or alias ID and indicate
// a maximum number of players to allow in the game session. You can also provide
// a name and game-specific properties for this game session. If successful,
// a GameSession object is returned containing game session properties, including
// a game session ID with the custom string you provided.
//
// Idempotency tokens. You can add a token that uniquely identifies game session
// requests. This is useful for ensuring that game session requests are idempotent.
// Multiple requests with the same idempotency token are processed only once;
// subsequent requests return the original result. All response values are the
// same with the exception of game session status, which may change.
//
// Resource creation limits. If you are creating a game session on a fleet with
// a resource creation limit policy in force, then you must specify a creator
// ID. Without this ID, Amazon GameLift has no way to evaluate the policy for
// this new game session request.
//
// By default, newly created game sessions allow new players to join. Use UpdateGameSession
// to change the game session's player session creation policy.
//
// Available in Amazon GameLift Local.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateGameSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeFleetCapacityExceededException "FleetCapacityExceededException"
//   The specified fleet has no available instances to fulfill a CreateGameSession
//   request. Clients can retry such requests immediately or after a waiting period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   A game session with this custom ID string already exists in this fleet. Resolve
//   this conflict before retrying this request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSession
func (c *GameLift) CreateGameSession(input *CreateGameSessionInput) (*CreateGameSessionOutput, error) {
	req, out := c.CreateGameSessionRequest(input)
	return out, req.Send()
}

// CreateGameSessionWithContext is the same as CreateGameSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGameSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateGameSessionWithContext(ctx aws.Context, input *CreateGameSessionInput, opts ...request.Option) (*CreateGameSessionOutput, error) {
	req, out := c.CreateGameSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGameSessionQueue = "CreateGameSessionQueue"

// CreateGameSessionQueueRequest generates a "aws/request.Request" representing the
// client's request for the CreateGameSessionQueue operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGameSessionQueue for more information on using the CreateGameSessionQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGameSessionQueueRequest method.
//    req, resp := client.CreateGameSessionQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue
func (c *GameLift) CreateGameSessionQueueRequest(input *CreateGameSessionQueueInput) (req *request.Request, output *CreateGameSessionQueueOutput) {
	op := &request.Operation{
		Name:       opCreateGameSessionQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGameSessionQueueInput{}
	}

	output = &CreateGameSessionQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGameSessionQueue API operation for Amazon GameLift.
//
// Establishes a new queue for processing requests to place new game sessions.
// A queue identifies where new game sessions can be hosted -- by specifying
// a list of destinations (fleets or aliases) -- and how long requests can wait
// in the queue before timing out. You can set up a queue to try to place game
// sessions on fleets in multiple regions. To add placement requests to a queue,
// call StartGameSessionPlacement and reference the queue name.
//
// Destination order. When processing a request for a game session, Amazon GameLift
// tries each destination in order until it finds one with available resources
// to host the new game session. A queue's default order is determined by how
// destinations are listed. The default order is overridden when a game session
// placement request provides player latency information. Player latency information
// enables Amazon GameLift to prioritize destinations where players report the
// lowest average latency, as a result placing the new game session where the
// majority of players will have the best possible gameplay experience.
//
// Player latency policies. For placement requests containing player latency
// information, use player latency policies to protect individual players from
// very high latencies. With a latency cap, even when a destination can deliver
// a low latency for most players, the game is not placed where any individual
// player is reporting latency higher than a policy's maximum. A queue can have
// multiple latency policies, which are enforced consecutively starting with
// the policy with the lowest latency cap. Use multiple policies to gradually
// relax latency controls; for example, you might set a policy with a low latency
// cap for the first 60 seconds, a second policy with a higher cap for the next
// 60 seconds, etc.
//
// To create a new queue, provide a name, timeout value, a list of destinations
// and, if desired, a set of latency policies. If successful, a new queue object
// is returned.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateGameSessionQueue for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue
func (c *GameLift) CreateGameSessionQueue(input *CreateGameSessionQueueInput) (*CreateGameSessionQueueOutput, error) {
	req, out := c.CreateGameSessionQueueRequest(input)
	return out, req.Send()
}

// CreateGameSessionQueueWithContext is the same as CreateGameSessionQueue with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGameSessionQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateGameSessionQueueWithContext(ctx aws.Context, input *CreateGameSessionQueueInput, opts ...request.Option) (*CreateGameSessionQueueOutput, error) {
	req, out := c.CreateGameSessionQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlayerSession = "CreatePlayerSession"

// CreatePlayerSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlayerSession operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlayerSession for more information on using the CreatePlayerSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePlayerSessionRequest method.
//    req, resp := client.CreatePlayerSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession
func (c *GameLift) CreatePlayerSessionRequest(input *CreatePlayerSessionInput) (req *request.Request, output *CreatePlayerSessionOutput) {
	op := &request.Operation{
		Name:       opCreatePlayerSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlayerSessionInput{}
	}

	output = &CreatePlayerSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlayerSession API operation for Amazon GameLift.
//
// Adds a player to a game session and creates a player session record. Before
// a player can be added, a game session must have an ACTIVE status, have a
// creation policy of ALLOW_ALL, and have an open player slot. To add a group
// of players to a game session, use CreatePlayerSessions.
//
// To create a player session, specify a game session ID, player ID, and optionally
// a string of player data. If successful, the player is added to the game session
// and a new PlayerSession object is returned. Player sessions cannot be updated.
//
// Available in Amazon GameLift Local.
//
// Player-session-related operations include:
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreatePlayerSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidGameSessionStatusException "InvalidGameSessionStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the game instance. Resolve
//   the conflict before retrying.
//
//   * ErrCodeGameSessionFullException "GameSessionFullException"
//   The game instance is currently full and cannot allow the requested player(s)
//   to join. Clients can retry such requests immediately or after a waiting period.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession
func (c *GameLift) CreatePlayerSession(input *CreatePlayerSessionInput) (*CreatePlayerSessionOutput, error) {
	req, out := c.CreatePlayerSessionRequest(input)
	return out, req.Send()
}

// CreatePlayerSessionWithContext is the same as CreatePlayerSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlayerSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreatePlayerSessionWithContext(ctx aws.Context, input *CreatePlayerSessionInput, opts ...request.Option) (*CreatePlayerSessionOutput, error) {
	req, out := c.CreatePlayerSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlayerSessions = "CreatePlayerSessions"

// CreatePlayerSessionsRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlayerSessions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlayerSessions for more information on using the CreatePlayerSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePlayerSessionsRequest method.
//    req, resp := client.CreatePlayerSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessions
func (c *GameLift) CreatePlayerSessionsRequest(input *CreatePlayerSessionsInput) (req *request.Request, output *CreatePlayerSessionsOutput) {
	op := &request.Operation{
		Name:       opCreatePlayerSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlayerSessionsInput{}
	}

	output = &CreatePlayerSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlayerSessions API operation for Amazon GameLift.
//
// Adds a group of players to a game session. This action is useful with a team
// matching feature. Before players can be added, a game session must have an
// ACTIVE status, have a creation policy of ALLOW_ALL, and have an open player
// slot. To add a single player to a game session, use CreatePlayerSession.
//
// To create player sessions, specify a game session ID, a list of player IDs,
// and optionally a set of player data strings. If successful, the players are
// added to the game session and a set of new PlayerSession objects is returned.
// Player sessions cannot be updated.
//
// Available in Amazon GameLift Local.
//
// Player-session-related operations include:
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreatePlayerSessions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidGameSessionStatusException "InvalidGameSessionStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the game instance. Resolve
//   the conflict before retrying.
//
//   * ErrCodeGameSessionFullException "GameSessionFullException"
//   The game instance is currently full and cannot allow the requested player(s)
//   to join. Clients can retry such requests immediately or after a waiting period.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessions
func (c *GameLift) CreatePlayerSessions(input *CreatePlayerSessionsInput) (*CreatePlayerSessionsOutput, error) {
	req, out := c.CreatePlayerSessionsRequest(input)
	return out, req.Send()
}

// CreatePlayerSessionsWithContext is the same as CreatePlayerSessions with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlayerSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreatePlayerSessionsWithContext(ctx aws.Context, input *CreatePlayerSessionsInput, opts ...request.Option) (*CreatePlayerSessionsOutput, error) {
	req, out := c.CreatePlayerSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlias operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlias for more information on using the DeleteAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAliasRequest method.
//    req, resp := client.DeleteAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAlias
func (c *GameLift) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	output = &DeleteAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlias API operation for Amazon GameLift.
//
// Deletes an alias. This action removes all record of the alias. Game clients
// attempting to access a server process using the deleted alias receive an
// error. To delete an alias, specify the alias ID to be deleted.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAlias
func (c *GameLift) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	return out, req.Send()
}

// DeleteAliasWithContext is the same as DeleteAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteAliasWithContext(ctx aws.Context, input *DeleteAliasInput, opts ...request.Option) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBuild = "DeleteBuild"

// DeleteBuildRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBuild operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBuild for more information on using the DeleteBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBuildRequest method.
//    req, resp := client.DeleteBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild
func (c *GameLift) DeleteBuildRequest(input *DeleteBuildInput) (req *request.Request, output *DeleteBuildOutput) {
	op := &request.Operation{
		Name:       opDeleteBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBuildInput{}
	}

	output = &DeleteBuildOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBuild API operation for Amazon GameLift.
//
// Deletes a build. This action permanently deletes the build record and any
// uploaded build files.
//
// To delete a build, specify its ID. Deleting a build does not affect the status
// of any active fleets using the build, but you can no longer create new fleets
// with the deleted build.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild
func (c *GameLift) DeleteBuild(input *DeleteBuildInput) (*DeleteBuildOutput, error) {
	req, out := c.DeleteBuildRequest(input)
	return out, req.Send()
}

// DeleteBuildWithContext is the same as DeleteBuild with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteBuildWithContext(ctx aws.Context, input *DeleteBuildInput, opts ...request.Option) (*DeleteBuildOutput, error) {
	req, out := c.DeleteBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleet for more information on using the DeleteFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFleetRequest method.
//    req, resp := client.DeleteFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleet
func (c *GameLift) DeleteFleetRequest(input *DeleteFleetInput) (req *request.Request, output *DeleteFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	output = &DeleteFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFleet API operation for Amazon GameLift.
//
// Deletes everything related to a fleet. Before deleting a fleet, you must
// set the fleet's desired capacity to zero. See UpdateFleetCapacity.
//
// This action removes the fleet's resources and the fleet record. Once a fleet
// is deleted, you can no longer use that fleet.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteFleet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleet
func (c *GameLift) DeleteFleet(input *DeleteFleetInput) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	return out, req.Send()
}

// DeleteFleetWithContext is the same as DeleteFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteFleetWithContext(ctx aws.Context, input *DeleteFleetInput, opts ...request.Option) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGameSessionQueue = "DeleteGameSessionQueue"

// DeleteGameSessionQueueRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGameSessionQueue operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGameSessionQueue for more information on using the DeleteGameSessionQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGameSessionQueueRequest method.
//    req, resp := client.DeleteGameSessionQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue
func (c *GameLift) DeleteGameSessionQueueRequest(input *DeleteGameSessionQueueInput) (req *request.Request, output *DeleteGameSessionQueueOutput) {
	op := &request.Operation{
		Name:       opDeleteGameSessionQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGameSessionQueueInput{}
	}

	output = &DeleteGameSessionQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGameSessionQueue API operation for Amazon GameLift.
//
// Deletes a game session queue. This action means that any StartGameSessionPlacement
// requests that reference this queue will fail. To delete a queue, specify
// the queue name.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteGameSessionQueue for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue
func (c *GameLift) DeleteGameSessionQueue(input *DeleteGameSessionQueueInput) (*DeleteGameSessionQueueOutput, error) {
	req, out := c.DeleteGameSessionQueueRequest(input)
	return out, req.Send()
}

// DeleteGameSessionQueueWithContext is the same as DeleteGameSessionQueue with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGameSessionQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteGameSessionQueueWithContext(ctx aws.Context, input *DeleteGameSessionQueueInput, opts ...request.Option) (*DeleteGameSessionQueueOutput, error) {
	req, out := c.DeleteGameSessionQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScalingPolicy = "DeleteScalingPolicy"

// DeleteScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScalingPolicy for more information on using the DeleteScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScalingPolicyRequest method.
//    req, resp := client.DeleteScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicy
func (c *GameLift) DeleteScalingPolicyRequest(input *DeleteScalingPolicyInput) (req *request.Request, output *DeleteScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScalingPolicyInput{}
	}

	output = &DeleteScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScalingPolicy API operation for Amazon GameLift.
//
// Deletes a fleet scaling policy. This action means that the policy is no longer
// in force and removes all record of it. To delete a scaling policy, specify
// both the scaling policy name and the fleet ID it is associated with.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteScalingPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicy
func (c *GameLift) DeleteScalingPolicy(input *DeleteScalingPolicyInput) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	return out, req.Send()
}

// DeleteScalingPolicyWithContext is the same as DeleteScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteScalingPolicyWithContext(ctx aws.Context, input *DeleteScalingPolicyInput, opts ...request.Option) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlias = "DescribeAlias"

// DescribeAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlias operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlias for more information on using the DescribeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAliasRequest method.
//    req, resp := client.DescribeAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAlias
func (c *GameLift) DescribeAliasRequest(input *DescribeAliasInput) (req *request.Request, output *DescribeAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAliasInput{}
	}

	output = &DescribeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlias API operation for Amazon GameLift.
//
// Retrieves properties for an alias. This operation returns all alias metadata
// and settings. To get an alias's target fleet ID only, use ResolveAlias.
//
// To get alias properties, specify the alias ID. If successful, the requested
// alias record is returned.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAlias
func (c *GameLift) DescribeAlias(input *DescribeAliasInput) (*DescribeAliasOutput, error) {
	req, out := c.DescribeAliasRequest(input)
	return out, req.Send()
}

// DescribeAliasWithContext is the same as DescribeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeAliasWithContext(ctx aws.Context, input *DescribeAliasInput, opts ...request.Option) (*DescribeAliasOutput, error) {
	req, out := c.DescribeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBuild = "DescribeBuild"

// DescribeBuildRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBuild operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBuild for more information on using the DescribeBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBuildRequest method.
//    req, resp := client.DescribeBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild
func (c *GameLift) DescribeBuildRequest(input *DescribeBuildInput) (req *request.Request, output *DescribeBuildOutput) {
	op := &request.Operation{
		Name:       opDescribeBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBuildInput{}
	}

	output = &DescribeBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBuild API operation for Amazon GameLift.
//
// Retrieves properties for a build. To get a build record, specify a build
// ID. If successful, an object containing the build properties is returned.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild
func (c *GameLift) DescribeBuild(input *DescribeBuildInput) (*DescribeBuildOutput, error) {
	req, out := c.DescribeBuildRequest(input)
	return out, req.Send()
}

// DescribeBuildWithContext is the same as DescribeBuild with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeBuildWithContext(ctx aws.Context, input *DescribeBuildInput, opts ...request.Option) (*DescribeBuildOutput, error) {
	req, out := c.DescribeBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEC2InstanceLimits = "DescribeEC2InstanceLimits"

// DescribeEC2InstanceLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEC2InstanceLimits operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEC2InstanceLimits for more information on using the DescribeEC2InstanceLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEC2InstanceLimitsRequest method.
//    req, resp := client.DescribeEC2InstanceLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits
func (c *GameLift) DescribeEC2InstanceLimitsRequest(input *DescribeEC2InstanceLimitsInput) (req *request.Request, output *DescribeEC2InstanceLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeEC2InstanceLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEC2InstanceLimitsInput{}
	}

	output = &DescribeEC2InstanceLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEC2InstanceLimits API operation for Amazon GameLift.
//
// Retrieves the following information for the specified EC2 instance type:
//
//    * maximum number of instances allowed per AWS account (service limit)
//
//    * current usage level for the AWS account
//
// Service limits vary depending on region. Available regions for Amazon GameLift
// can be found in the AWS Management Console for Amazon GameLift (see the drop-down
// list in the upper right corner).
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeEC2InstanceLimits for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits
func (c *GameLift) DescribeEC2InstanceLimits(input *DescribeEC2InstanceLimitsInput) (*DescribeEC2InstanceLimitsOutput, error) {
	req, out := c.DescribeEC2InstanceLimitsRequest(input)
	return out, req.Send()
}

// DescribeEC2InstanceLimitsWithContext is the same as DescribeEC2InstanceLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEC2InstanceLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeEC2InstanceLimitsWithContext(ctx aws.Context, input *DescribeEC2InstanceLimitsInput, opts ...request.Option) (*DescribeEC2InstanceLimitsOutput, error) {
	req, out := c.DescribeEC2InstanceLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetAttributes = "DescribeFleetAttributes"

// DescribeFleetAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetAttributes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetAttributes for more information on using the DescribeFleetAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetAttributesRequest method.
//    req, resp := client.DescribeFleetAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes
func (c *GameLift) DescribeFleetAttributesRequest(input *DescribeFleetAttributesInput) (req *request.Request, output *DescribeFleetAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetAttributesInput{}
	}

	output = &DescribeFleetAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetAttributes API operation for Amazon GameLift.
//
// Retrieves fleet properties, including metadata, status, and configuration,
// for one or more fleets. You can request attributes for all fleets, or specify
// a list of one or more fleet IDs. When requesting multiple fleets, use the
// pagination parameters to retrieve results as a set of sequential pages. If
// successful, a FleetAttributes object is returned for each requested fleet
// ID. When specifying a list of fleet IDs, attribute objects are returned only
// for fleets that currently exist.
//
// Some API actions may limit the number of fleet IDs allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// includes the maximum allowed.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes
func (c *GameLift) DescribeFleetAttributes(input *DescribeFleetAttributesInput) (*DescribeFleetAttributesOutput, error) {
	req, out := c.DescribeFleetAttributesRequest(input)
	return out, req.Send()
}

// DescribeFleetAttributesWithContext is the same as DescribeFleetAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetAttributesWithContext(ctx aws.Context, input *DescribeFleetAttributesInput, opts ...request.Option) (*DescribeFleetAttributesOutput, error) {
	req, out := c.DescribeFleetAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetCapacity = "DescribeFleetCapacity"

// DescribeFleetCapacityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetCapacity operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetCapacity for more information on using the DescribeFleetCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetCapacityRequest method.
//    req, resp := client.DescribeFleetCapacityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity
func (c *GameLift) DescribeFleetCapacityRequest(input *DescribeFleetCapacityInput) (req *request.Request, output *DescribeFleetCapacityOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetCapacityInput{}
	}

	output = &DescribeFleetCapacityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetCapacity API operation for Amazon GameLift.
//
// Retrieves the current status of fleet capacity for one or more fleets. This
// information includes the number of instances that have been requested for
// the fleet and the number currently active. You can request capacity for all
// fleets, or specify a list of one or more fleet IDs. When requesting multiple
// fleets, use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, a FleetCapacity object is returned for each requested
// fleet ID. When specifying a list of fleet IDs, attribute objects are returned
// only for fleets that currently exist.
//
// Some API actions may limit the number of fleet IDs allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// includes the maximum allowed.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetCapacity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity
func (c *GameLift) DescribeFleetCapacity(input *DescribeFleetCapacityInput) (*DescribeFleetCapacityOutput, error) {
	req, out := c.DescribeFleetCapacityRequest(input)
	return out, req.Send()
}

// DescribeFleetCapacityWithContext is the same as DescribeFleetCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetCapacityWithContext(ctx aws.Context, input *DescribeFleetCapacityInput, opts ...request.Option) (*DescribeFleetCapacityOutput, error) {
	req, out := c.DescribeFleetCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetEvents = "DescribeFleetEvents"

// DescribeFleetEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetEvents operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetEvents for more information on using the DescribeFleetEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetEventsRequest method.
//    req, resp := client.DescribeFleetEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents
func (c *GameLift) DescribeFleetEventsRequest(input *DescribeFleetEventsInput) (req *request.Request, output *DescribeFleetEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetEventsInput{}
	}

	output = &DescribeFleetEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetEvents API operation for Amazon GameLift.
//
// Retrieves entries from the specified fleet's event log. You can specify a
// time range to limit the result set. Use the pagination parameters to retrieve
// results as a set of sequential pages. If successful, a collection of event
// log entries matching the request are returned.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents
func (c *GameLift) DescribeFleetEvents(input *DescribeFleetEventsInput) (*DescribeFleetEventsOutput, error) {
	req, out := c.DescribeFleetEventsRequest(input)
	return out, req.Send()
}

// DescribeFleetEventsWithContext is the same as DescribeFleetEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetEventsWithContext(ctx aws.Context, input *DescribeFleetEventsInput, opts ...request.Option) (*DescribeFleetEventsOutput, error) {
	req, out := c.DescribeFleetEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetPortSettings = "DescribeFleetPortSettings"

// DescribeFleetPortSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetPortSettings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetPortSettings for more information on using the DescribeFleetPortSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetPortSettingsRequest method.
//    req, resp := client.DescribeFleetPortSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettings
func (c *GameLift) DescribeFleetPortSettingsRequest(input *DescribeFleetPortSettingsInput) (req *request.Request, output *DescribeFleetPortSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetPortSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetPortSettingsInput{}
	}

	output = &DescribeFleetPortSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetPortSettings API operation for Amazon GameLift.
//
// Retrieves the inbound connection permissions for a fleet. Connection permissions
// include a range of IP addresses and port settings that incoming traffic can
// use to access server processes in the fleet. To get a fleet's inbound connection
// permissions, specify a fleet ID. If successful, a collection of IpPermission
// objects is returned for the requested fleet ID. If the requested fleet has
// been deleted, the result set is empty.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetPortSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettings
func (c *GameLift) DescribeFleetPortSettings(input *DescribeFleetPortSettingsInput) (*DescribeFleetPortSettingsOutput, error) {
	req, out := c.DescribeFleetPortSettingsRequest(input)
	return out, req.Send()
}

// DescribeFleetPortSettingsWithContext is the same as DescribeFleetPortSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetPortSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetPortSettingsWithContext(ctx aws.Context, input *DescribeFleetPortSettingsInput, opts ...request.Option) (*DescribeFleetPortSettingsOutput, error) {
	req, out := c.DescribeFleetPortSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetUtilization = "DescribeFleetUtilization"

// DescribeFleetUtilizationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetUtilization operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetUtilization for more information on using the DescribeFleetUtilization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetUtilizationRequest method.
//    req, resp := client.DescribeFleetUtilizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization
func (c *GameLift) DescribeFleetUtilizationRequest(input *DescribeFleetUtilizationInput) (req *request.Request, output *DescribeFleetUtilizationOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetUtilization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetUtilizationInput{}
	}

	output = &DescribeFleetUtilizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetUtilization API operation for Amazon GameLift.
//
// Retrieves utilization statistics for one or more fleets. You can request
// utilization data for all fleets, or specify a list of one or more fleet IDs.
// When requesting multiple fleets, use the pagination parameters to retrieve
// results as a set of sequential pages. If successful, a FleetUtilization object
// is returned for each requested fleet ID. When specifying a list of fleet
// IDs, utilization objects are returned only for fleets that currently exist.
//
// Some API actions may limit the number of fleet IDs allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// includes the maximum allowed.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetUtilization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization
func (c *GameLift) DescribeFleetUtilization(input *DescribeFleetUtilizationInput) (*DescribeFleetUtilizationOutput, error) {
	req, out := c.DescribeFleetUtilizationRequest(input)
	return out, req.Send()
}

// DescribeFleetUtilizationWithContext is the same as DescribeFleetUtilization with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetUtilization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetUtilizationWithContext(ctx aws.Context, input *DescribeFleetUtilizationInput, opts ...request.Option) (*DescribeFleetUtilizationOutput, error) {
	req, out := c.DescribeFleetUtilizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGameSessionDetails = "DescribeGameSessionDetails"

// DescribeGameSessionDetailsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessionDetails operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessionDetails for more information on using the DescribeGameSessionDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGameSessionDetailsRequest method.
//    req, resp := client.DescribeGameSessionDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails
func (c *GameLift) DescribeGameSessionDetailsRequest(input *DescribeGameSessionDetailsInput) (req *request.Request, output *DescribeGameSessionDetailsOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessionDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionDetailsInput{}
	}

	output = &DescribeGameSessionDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessionDetails API operation for Amazon GameLift.
//
// Retrieves properties, including the protection policy in force, for one or
// more game sessions. This action can be used in several ways: (1) provide
// a GameSessionId or GameSessionArn to request details for a specific game
// session; (2) provide either a FleetId or an AliasId to request properties
// for all game sessions running on a fleet.
//
// To get game session record(s), specify just one of the following: game session
// ID, fleet ID, or alias ID. You can filter this request by game session status.
// Use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, a GameSessionDetail object is returned for each session
// matching the request.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessionDetails for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails
func (c *GameLift) DescribeGameSessionDetails(input *DescribeGameSessionDetailsInput) (*DescribeGameSessionDetailsOutput, error) {
	req, out := c.DescribeGameSessionDetailsRequest(input)
	return out, req.Send()
}

// DescribeGameSessionDetailsWithContext is the same as DescribeGameSessionDetails with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessionDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionDetailsWithContext(ctx aws.Context, input *DescribeGameSessionDetailsInput, opts ...request.Option) (*DescribeGameSessionDetailsOutput, error) {
	req, out := c.DescribeGameSessionDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGameSessionPlacement = "DescribeGameSessionPlacement"

// DescribeGameSessionPlacementRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessionPlacement operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessionPlacement for more information on using the DescribeGameSessionPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGameSessionPlacementRequest method.
//    req, resp := client.DescribeGameSessionPlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement
func (c *GameLift) DescribeGameSessionPlacementRequest(input *DescribeGameSessionPlacementInput) (req *request.Request, output *DescribeGameSessionPlacementOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessionPlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionPlacementInput{}
	}

	output = &DescribeGameSessionPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessionPlacement API operation for Amazon GameLift.
//
// Retrieves properties and current status of a game session placement request.
// To get game session placement details, specify the placement ID. If successful,
// a GameSessionPlacement object is returned.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessionPlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement
func (c *GameLift) DescribeGameSessionPlacement(input *DescribeGameSessionPlacementInput) (*DescribeGameSessionPlacementOutput, error) {
	req, out := c.DescribeGameSessionPlacementRequest(input)
	return out, req.Send()
}

// DescribeGameSessionPlacementWithContext is the same as DescribeGameSessionPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessionPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionPlacementWithContext(ctx aws.Context, input *DescribeGameSessionPlacementInput, opts ...request.Option) (*DescribeGameSessionPlacementOutput, error) {
	req, out := c.DescribeGameSessionPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGameSessionQueues = "DescribeGameSessionQueues"

// DescribeGameSessionQueuesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessionQueues operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessionQueues for more information on using the DescribeGameSessionQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGameSessionQueuesRequest method.
//    req, resp := client.DescribeGameSessionQueuesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues
func (c *GameLift) DescribeGameSessionQueuesRequest(input *DescribeGameSessionQueuesInput) (req *request.Request, output *DescribeGameSessionQueuesOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessionQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionQueuesInput{}
	}

	output = &DescribeGameSessionQueuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessionQueues API operation for Amazon GameLift.
//
// Retrieves the properties for one or more game session queues. When requesting
// multiple queues, use the pagination parameters to retrieve results as a set
// of sequential pages. If successful, a GameSessionQueue object is returned
// for each requested queue. When specifying a list of queues, objects are returned
// only for queues that currently exist in the region.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessionQueues for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues
func (c *GameLift) DescribeGameSessionQueues(input *DescribeGameSessionQueuesInput) (*DescribeGameSessionQueuesOutput, error) {
	req, out := c.DescribeGameSessionQueuesRequest(input)
	return out, req.Send()
}

// DescribeGameSessionQueuesWithContext is the same as DescribeGameSessionQueues with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessionQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionQueuesWithContext(ctx aws.Context, input *DescribeGameSessionQueuesInput, opts ...request.Option) (*DescribeGameSessionQueuesOutput, error) {
	req, out := c.DescribeGameSessionQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGameSessions = "DescribeGameSessions"

// DescribeGameSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessions for more information on using the DescribeGameSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGameSessionsRequest method.
//    req, resp := client.DescribeGameSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions
func (c *GameLift) DescribeGameSessionsRequest(input *DescribeGameSessionsInput) (req *request.Request, output *DescribeGameSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionsInput{}
	}

	output = &DescribeGameSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessions API operation for Amazon GameLift.
//
// Retrieves a set of one or more game sessions. Request a specific game session
// or request all game sessions on a fleet. Alternatively, use SearchGameSessions
// to request a set of active game sessions that are filtered by certain criteria.
// To retrieve protection policy settings for game sessions, use DescribeGameSessionDetails.
//
// To get game sessions, specify one of the following: game session ID, fleet
// ID, or alias ID. You can filter this request by game session status. Use
// the pagination parameters to retrieve results as a set of sequential pages.
// If successful, a GameSession object is returned for each game session matching
// the request.
//
// Available in Amazon GameLift Local.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions
func (c *GameLift) DescribeGameSessions(input *DescribeGameSessionsInput) (*DescribeGameSessionsOutput, error) {
	req, out := c.DescribeGameSessionsRequest(input)
	return out, req.Send()
}

// DescribeGameSessionsWithContext is the same as DescribeGameSessions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionsWithContext(ctx aws.Context, input *DescribeGameSessionsInput, opts ...request.Option) (*DescribeGameSessionsOutput, error) {
	req, out := c.DescribeGameSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstances = "DescribeInstances"

// DescribeInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstances operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstances for more information on using the DescribeInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstancesRequest method.
//    req, resp := client.DescribeInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances
func (c *GameLift) DescribeInstancesRequest(input *DescribeInstancesInput) (req *request.Request, output *DescribeInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstancesInput{}
	}

	output = &DescribeInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstances API operation for Amazon GameLift.
//
// Retrieves information about a fleet's instances, including instance IDs.
// Use this action to get details on all instances in the fleet or get details
// on one specific instance.
//
// To get a specific instance, specify fleet ID and instance ID. To get all
// instances in a fleet, specify a fleet ID only. Use the pagination parameters
// to retrieve results as a set of sequential pages. If successful, an Instance
// object is returned for each result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances
func (c *GameLift) DescribeInstances(input *DescribeInstancesInput) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	return out, req.Send()
}

// DescribeInstancesWithContext is the same as DescribeInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeInstancesWithContext(ctx aws.Context, input *DescribeInstancesInput, opts ...request.Option) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePlayerSessions = "DescribePlayerSessions"

// DescribePlayerSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePlayerSessions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePlayerSessions for more information on using the DescribePlayerSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePlayerSessionsRequest method.
//    req, resp := client.DescribePlayerSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions
func (c *GameLift) DescribePlayerSessionsRequest(input *DescribePlayerSessionsInput) (req *request.Request, output *DescribePlayerSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribePlayerSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePlayerSessionsInput{}
	}

	output = &DescribePlayerSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePlayerSessions API operation for Amazon GameLift.
//
// Retrieves properties for one or more player sessions. This action can be
// used in several ways: (1) provide a PlayerSessionId to request properties
// for a specific player session; (2) provide a GameSessionId to request properties
// for all player sessions in the specified game session; (3) provide a PlayerId
// to request properties for all player sessions of a specified player.
//
// To get game session record(s), specify only one of the following: a player
// session ID, a game session ID, or a player ID. You can filter this request
// by player session status. Use the pagination parameters to retrieve results
// as a set of sequential pages. If successful, a PlayerSession object is returned
// for each session matching the request.
//
// Available in Amazon GameLift Local.
//
// Player-session-related operations include:
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribePlayerSessions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions
func (c *GameLift) DescribePlayerSessions(input *DescribePlayerSessionsInput) (*DescribePlayerSessionsOutput, error) {
	req, out := c.DescribePlayerSessionsRequest(input)
	return out, req.Send()
}

// DescribePlayerSessionsWithContext is the same as DescribePlayerSessions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePlayerSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribePlayerSessionsWithContext(ctx aws.Context, input *DescribePlayerSessionsInput, opts ...request.Option) (*DescribePlayerSessionsOutput, error) {
	req, out := c.DescribePlayerSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRuntimeConfiguration = "DescribeRuntimeConfiguration"

// DescribeRuntimeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRuntimeConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRuntimeConfiguration for more information on using the DescribeRuntimeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRuntimeConfigurationRequest method.
//    req, resp := client.DescribeRuntimeConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfiguration
func (c *GameLift) DescribeRuntimeConfigurationRequest(input *DescribeRuntimeConfigurationInput) (req *request.Request, output *DescribeRuntimeConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeRuntimeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRuntimeConfigurationInput{}
	}

	output = &DescribeRuntimeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRuntimeConfiguration API operation for Amazon GameLift.
//
// Retrieves the current run-time configuration for the specified fleet. The
// run-time configuration tells Amazon GameLift how to launch server processes
// on instances in the fleet.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeRuntimeConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfiguration
func (c *GameLift) DescribeRuntimeConfiguration(input *DescribeRuntimeConfigurationInput) (*DescribeRuntimeConfigurationOutput, error) {
	req, out := c.DescribeRuntimeConfigurationRequest(input)
	return out, req.Send()
}

// DescribeRuntimeConfigurationWithContext is the same as DescribeRuntimeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRuntimeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeRuntimeConfigurationWithContext(ctx aws.Context, input *DescribeRuntimeConfigurationInput, opts ...request.Option) (*DescribeRuntimeConfigurationOutput, error) {
	req, out := c.DescribeRuntimeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScalingPolicies = "DescribeScalingPolicies"

// DescribeScalingPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingPolicies operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingPolicies for more information on using the DescribeScalingPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScalingPoliciesRequest method.
//    req, resp := client.DescribeScalingPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies
func (c *GameLift) DescribeScalingPoliciesRequest(input *DescribeScalingPoliciesInput) (req *request.Request, output *DescribeScalingPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingPoliciesInput{}
	}

	output = &DescribeScalingPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingPolicies API operation for Amazon GameLift.
//
// Retrieves all scaling policies applied to a fleet.
//
// To get a fleet's scaling policies, specify the fleet ID. You can filter this
// request by policy status, such as to retrieve only active scaling policies.
// Use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, set of ScalingPolicy objects is returned for the fleet.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeScalingPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies
func (c *GameLift) DescribeScalingPolicies(input *DescribeScalingPoliciesInput) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	return out, req.Send()
}

// DescribeScalingPoliciesWithContext is the same as DescribeScalingPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeScalingPoliciesWithContext(ctx aws.Context, input *DescribeScalingPoliciesInput, opts ...request.Option) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGameSessionLogUrl = "GetGameSessionLogUrl"

// GetGameSessionLogUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetGameSessionLogUrl operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGameSessionLogUrl for more information on using the GetGameSessionLogUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGameSessionLogUrlRequest method.
//    req, resp := client.GetGameSessionLogUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrl
func (c *GameLift) GetGameSessionLogUrlRequest(input *GetGameSessionLogUrlInput) (req *request.Request, output *GetGameSessionLogUrlOutput) {
	op := &request.Operation{
		Name:       opGetGameSessionLogUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGameSessionLogUrlInput{}
	}

	output = &GetGameSessionLogUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGameSessionLogUrl API operation for Amazon GameLift.
//
// Retrieves the location of stored game session logs for a specified game session.
// When a game session is terminated, Amazon GameLift automatically stores the
// logs in Amazon S3. Use this URL to download the logs.
//
// See the AWS Service Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift)
// page for maximum log file sizes. Log files that exceed this limit are not
// saved.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation GetGameSessionLogUrl for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrl
func (c *GameLift) GetGameSessionLogUrl(input *GetGameSessionLogUrlInput) (*GetGameSessionLogUrlOutput, error) {
	req, out := c.GetGameSessionLogUrlRequest(input)
	return out, req.Send()
}

// GetGameSessionLogUrlWithContext is the same as GetGameSessionLogUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetGameSessionLogUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) GetGameSessionLogUrlWithContext(ctx aws.Context, input *GetGameSessionLogUrlInput, opts ...request.Option) (*GetGameSessionLogUrlOutput, error) {
	req, out := c.GetGameSessionLogUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceAccess = "GetInstanceAccess"

// GetInstanceAccessRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceAccess operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceAccess for more information on using the GetInstanceAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceAccessRequest method.
//    req, resp := client.GetInstanceAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccess
func (c *GameLift) GetInstanceAccessRequest(input *GetInstanceAccessInput) (req *request.Request, output *GetInstanceAccessOutput) {
	op := &request.Operation{
		Name:       opGetInstanceAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceAccessInput{}
	}

	output = &GetInstanceAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceAccess API operation for Amazon GameLift.
//
// Requests remote access to a fleet instance. Remote access is useful for debugging,
// gathering benchmarking data, or watching activity in real time.
//
// Access requires credentials that match the operating system of the instance.
// For a Windows instance, Amazon GameLift returns a user name and password
// as strings for use with a Windows Remote Desktop client. For a Linux instance,
// Amazon GameLift returns a user name and RSA private key, also as strings,
// for use with an SSH client. The private key must be saved in the proper format
// to a .pem file before using. If you're making this request using the AWS
// CLI, saving the secret can be handled as part of the GetInstanceAccess request.
// (See the example later in this topic). For more information on remote access,
// see Remotely Accessing an Instance (http://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html).
//
// To request access to a specific instance, specify the IDs of the instance
// and the fleet it belongs to. If successful, an InstanceAccess object is returned
// containing the instance's IP address and a set of credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation GetInstanceAccess for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccess
func (c *GameLift) GetInstanceAccess(input *GetInstanceAccessInput) (*GetInstanceAccessOutput, error) {
	req, out := c.GetInstanceAccessRequest(input)
	return out, req.Send()
}

// GetInstanceAccessWithContext is the same as GetInstanceAccess with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) GetInstanceAccessWithContext(ctx aws.Context, input *GetInstanceAccessInput, opts ...request.Option) (*GetInstanceAccessOutput, error) {
	req, out := c.GetInstanceAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAliases operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAliases for more information on using the ListAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAliasesRequest method.
//    req, resp := client.ListAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases
func (c *GameLift) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	output = &ListAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAliases API operation for Amazon GameLift.
//
// Retrieves all aliases for this AWS account. You can filter the result set
// by alias name and/or routing strategy type. Use the pagination parameters
// to retrieve results in sequential pages.
//
// Returned aliases are not listed in any particular order.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListAliases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases
func (c *GameLift) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	return out, req.Send()
}

// ListAliasesWithContext is the same as ListAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListAliasesWithContext(ctx aws.Context, input *ListAliasesInput, opts ...request.Option) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBuilds = "ListBuilds"

// ListBuildsRequest generates a "aws/request.Request" representing the
// client's request for the ListBuilds operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuilds for more information on using the ListBuilds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBuildsRequest method.
//    req, resp := client.ListBuildsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds
func (c *GameLift) ListBuildsRequest(input *ListBuildsInput) (req *request.Request, output *ListBuildsOutput) {
	op := &request.Operation{
		Name:       opListBuilds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBuildsInput{}
	}

	output = &ListBuildsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuilds API operation for Amazon GameLift.
//
// Retrieves build records for all builds associated with the AWS account in
// use. You can limit results to builds that are in a specific status by using
// the Status parameter. Use the pagination parameters to retrieve results in
// a set of sequential pages.
//
// Build records are not listed in any particular order.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListBuilds for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds
func (c *GameLift) ListBuilds(input *ListBuildsInput) (*ListBuildsOutput, error) {
	req, out := c.ListBuildsRequest(input)
	return out, req.Send()
}

// ListBuildsWithContext is the same as ListBuilds with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuilds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListBuildsWithContext(ctx aws.Context, input *ListBuildsInput, opts ...request.Option) (*ListBuildsOutput, error) {
	req, out := c.ListBuildsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFleets = "ListFleets"

// ListFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListFleets operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFleets for more information on using the ListFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFleetsRequest method.
//    req, resp := client.ListFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets
func (c *GameLift) ListFleetsRequest(input *ListFleetsInput) (req *request.Request, output *ListFleetsOutput) {
	op := &request.Operation{
		Name:       opListFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListFleetsInput{}
	}

	output = &ListFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFleets API operation for Amazon GameLift.
//
// Retrieves a collection of fleet records for this AWS account. You can filter
// the result set by build ID. Use the pagination parameters to retrieve results
// in sequential pages.
//
// Fleet records are not listed in any particular order.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListFleets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets
func (c *GameLift) ListFleets(input *ListFleetsInput) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	return out, req.Send()
}

// ListFleetsWithContext is the same as ListFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListFleetsWithContext(ctx aws.Context, input *ListFleetsInput, opts ...request.Option) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutScalingPolicy for more information on using the PutScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutScalingPolicyRequest method.
//    req, resp := client.PutScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicy
func (c *GameLift) PutScalingPolicyRequest(input *PutScalingPolicyInput) (req *request.Request, output *PutScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	output = &PutScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutScalingPolicy API operation for Amazon GameLift.
//
// Creates or updates a scaling policy for a fleet. An active scaling policy
// prompts Amazon GameLift to track a certain metric for a fleet and automatically
// change the fleet's capacity in specific circumstances. Each scaling policy
// contains one rule statement. Fleets can have multiple scaling policies in
// force simultaneously.
//
// A scaling policy rule statement has the following structure:
//
// If [MetricName] is [ComparisonOperator][Threshold] for [EvaluationPeriods]
// minutes, then [ScalingAdjustmentType] to/by [ScalingAdjustment].
//
// For example, this policy: "If the number of idle instances exceeds 20 for
// more than 15 minutes, then reduce the fleet capacity by 10 instances" could
// be implemented as the following rule statement:
//
// If [IdleInstances] is [GreaterThanOrEqualToThreshold] [20] for [15] minutes,
// then [ChangeInCapacity] by [-10].
//
// To create or update a scaling policy, specify a unique combination of name
// and fleet ID, and set the rule values. All parameters for this action are
// required. If successful, the policy name is returned. Scaling policies cannot
// be suspended or made inactive. To stop enforcing a scaling policy, call DeleteScalingPolicy.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation PutScalingPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicy
func (c *GameLift) PutScalingPolicy(input *PutScalingPolicyInput) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	return out, req.Send()
}

// PutScalingPolicyWithContext is the same as PutScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) PutScalingPolicyWithContext(ctx aws.Context, input *PutScalingPolicyInput, opts ...request.Option) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRequestUploadCredentials = "RequestUploadCredentials"

// RequestUploadCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the RequestUploadCredentials operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RequestUploadCredentials for more information on using the RequestUploadCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RequestUploadCredentialsRequest method.
//    req, resp := client.RequestUploadCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentials
func (c *GameLift) RequestUploadCredentialsRequest(input *RequestUploadCredentialsInput) (req *request.Request, output *RequestUploadCredentialsOutput) {
	op := &request.Operation{
		Name:       opRequestUploadCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestUploadCredentialsInput{}
	}

	output = &RequestUploadCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RequestUploadCredentials API operation for Amazon GameLift.
//
// This API call is not currently in use.  Retrieves a fresh set of upload credentials
// and the assigned Amazon S3 storage location for a specific build. Valid credentials
// are required to upload your game build files to Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation RequestUploadCredentials for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentials
func (c *GameLift) RequestUploadCredentials(input *RequestUploadCredentialsInput) (*RequestUploadCredentialsOutput, error) {
	req, out := c.RequestUploadCredentialsRequest(input)
	return out, req.Send()
}

// RequestUploadCredentialsWithContext is the same as RequestUploadCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See RequestUploadCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) RequestUploadCredentialsWithContext(ctx aws.Context, input *RequestUploadCredentialsInput, opts ...request.Option) (*RequestUploadCredentialsOutput, error) {
	req, out := c.RequestUploadCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResolveAlias = "ResolveAlias"

// ResolveAliasRequest generates a "aws/request.Request" representing the
// client's request for the ResolveAlias operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResolveAlias for more information on using the ResolveAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResolveAliasRequest method.
//    req, resp := client.ResolveAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAlias
func (c *GameLift) ResolveAliasRequest(input *ResolveAliasInput) (req *request.Request, output *ResolveAliasOutput) {
	op := &request.Operation{
		Name:       opResolveAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveAliasInput{}
	}

	output = &ResolveAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResolveAlias API operation for Amazon GameLift.
//
// Retrieves the fleet ID that a specified alias is currently pointing to.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ResolveAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAlias
func (c *GameLift) ResolveAlias(input *ResolveAliasInput) (*ResolveAliasOutput, error) {
	req, out := c.ResolveAliasRequest(input)
	return out, req.Send()
}

// ResolveAliasWithContext is the same as ResolveAlias with the addition of
// the ability to pass a context and additional request options.
//
// See ResolveAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ResolveAliasWithContext(ctx aws.Context, input *ResolveAliasInput, opts ...request.Option) (*ResolveAliasOutput, error) {
	req, out := c.ResolveAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchGameSessions = "SearchGameSessions"

// SearchGameSessionsRequest generates a "aws/request.Request" representing the
// client's request for the SearchGameSessions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchGameSessions for more information on using the SearchGameSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchGameSessionsRequest method.
//    req, resp := client.SearchGameSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessions
func (c *GameLift) SearchGameSessionsRequest(input *SearchGameSessionsInput) (req *request.Request, output *SearchGameSessionsOutput) {
	op := &request.Operation{
		Name:       opSearchGameSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SearchGameSessionsInput{}
	}

	output = &SearchGameSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchGameSessions API operation for Amazon GameLift.
//
// Retrieves a set of game sessions that match a set of search criteria and
// sorts them in a specified order. A game session search is limited to a single
// fleet. Search results include only game sessions that are in ACTIVE status.
// If you need to retrieve game sessions with a status other than active, use
// DescribeGameSessions. If you need to retrieve the protection policy for each
// game session, use DescribeGameSessionDetails.
//
// You can search or sort by the following game session attributes:
//
//    * gameSessionId -- Unique identifier for the game session. You can use
//    either a GameSessionId or GameSessionArn value.
//
//    * gameSessionName -- Name assigned to a game session. This value is set
//    when requesting a new game session with CreateGameSession or updating
//    with UpdateGameSession. Game session names do not need to be unique to
//    a game session.
//
//    * creationTimeMillis -- Value indicating when a game session was created.
//    It is expressed in Unix time as milliseconds.
//
//    * playerSessionCount -- Number of players currently connected to a game
//    session. This value changes rapidly as players join the session or drop
//    out.
//
//    * maximumSessions -- Maximum number of player sessions allowed for a game
//    session. This value is set when requesting a new game session with CreateGameSession
//    or updating with UpdateGameSession.
//
//    * hasAvailablePlayerSessions -- Boolean value indicating whether a game
//    session has reached its maximum number of players. When searching with
//    this attribute, the search value must be true or false. It is highly recommended
//    that all search requests include this filter attribute to optimize search
//    performance and return only sessions that players can join.
//
// To search or sort, specify either a fleet ID or an alias ID, and provide
// a search filter expression, a sort expression, or both. Use the pagination
// parameters to retrieve results as a set of sequential pages. If successful,
// a collection of GameSession objects matching the request is returned.
//
// Returned values for playerSessionCount and hasAvailablePlayerSessions change
// quickly as players join sessions and others drop out. Results should be considered
// a snapshot in time. Be sure to refresh search results often, and handle sessions
// that fill up before a player can join.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation SearchGameSessions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeTerminalRoutingStrategyException "TerminalRoutingStrategyException"
//   The service is unable to resolve the routing for a particular alias because
//   it has a terminal RoutingStrategy associated with it. The message returned
//   in this exception is the message defined in the routing strategy itself.
//   Such requests should only be retried if the routing strategy for the specified
//   alias is modified.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessions
func (c *GameLift) SearchGameSessions(input *SearchGameSessionsInput) (*SearchGameSessionsOutput, error) {
	req, out := c.SearchGameSessionsRequest(input)
	return out, req.Send()
}

// SearchGameSessionsWithContext is the same as SearchGameSessions with the addition of
// the ability to pass a context and additional request options.
//
// See SearchGameSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) SearchGameSessionsWithContext(ctx aws.Context, input *SearchGameSessionsInput, opts ...request.Option) (*SearchGameSessionsOutput, error) {
	req, out := c.SearchGameSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartGameSessionPlacement = "StartGameSessionPlacement"

// StartGameSessionPlacementRequest generates a "aws/request.Request" representing the
// client's request for the StartGameSessionPlacement operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartGameSessionPlacement for more information on using the StartGameSessionPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartGameSessionPlacementRequest method.
//    req, resp := client.StartGameSessionPlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartGameSessionPlacement
func (c *GameLift) StartGameSessionPlacementRequest(input *StartGameSessionPlacementInput) (req *request.Request, output *StartGameSessionPlacementOutput) {
	op := &request.Operation{
		Name:       opStartGameSessionPlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartGameSessionPlacementInput{}
	}

	output = &StartGameSessionPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartGameSessionPlacement API operation for Amazon GameLift.
//
// Places a request for a new game session in a queue (see CreateGameSessionQueue).
// When processing a placement request, Amazon GameLift searches for available
// resources on the queue's destinations, scanning each until it finds resources
// or the placement request times out.
//
// A game session placement request can also request player sessions. When a
// new game session is successfully created, Amazon GameLift creates a player
// session for each player included in the request.
//
// When placing a game session, by default Amazon GameLift tries each fleet
// in the order they are listed in the queue configuration. Ideally, a queue's
// destinations are listed in preference order.
//
// Alternatively, when requesting a game session with players, you can also
// provide latency data for each player in relevant regions. Latency data indicates
// the performance lag a player experiences when connected to a fleet in the
// region. Amazon GameLift uses latency data to reorder the list of destinations
// to place the game session in a region with minimal lag. If latency data is
// provided for multiple players, Amazon GameLift calculates each region's average
// lag for all players and reorders to get the best game play across all players.
//
// To place a new game session request, specify the following:
//
//    * The queue name and a set of game session properties and settings
//
//    * A unique ID (such as a UUID) for the placement. You use this ID to track
//    the status of the placement request
//
//    * (Optional) A set of IDs and player data for each player you want to
//    join to the new game session
//
//    * Latency data for all players (if you want to optimize game play for
//    the players)
//
// If successful, a new game session placement is created.
//
// To track the status of a placement request, call DescribeGameSessionPlacement
// and check the request's status. If the status is Fulfilled, a new game session
// has been created and a game session ARN and region are referenced. If the
// placement request times out, you can resubmit the request or retry it with
// a different queue.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StartGameSessionPlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartGameSessionPlacement
func (c *GameLift) StartGameSessionPlacement(input *StartGameSessionPlacementInput) (*StartGameSessionPlacementOutput, error) {
	req, out := c.StartGameSessionPlacementRequest(input)
	return out, req.Send()
}

// StartGameSessionPlacementWithContext is the same as StartGameSessionPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See StartGameSessionPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StartGameSessionPlacementWithContext(ctx aws.Context, input *StartGameSessionPlacementInput, opts ...request.Option) (*StartGameSessionPlacementOutput, error) {
	req, out := c.StartGameSessionPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopGameSessionPlacement = "StopGameSessionPlacement"

// StopGameSessionPlacementRequest generates a "aws/request.Request" representing the
// client's request for the StopGameSessionPlacement operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopGameSessionPlacement for more information on using the StopGameSessionPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopGameSessionPlacementRequest method.
//    req, resp := client.StopGameSessionPlacementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopGameSessionPlacement
func (c *GameLift) StopGameSessionPlacementRequest(input *StopGameSessionPlacementInput) (req *request.Request, output *StopGameSessionPlacementOutput) {
	op := &request.Operation{
		Name:       opStopGameSessionPlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopGameSessionPlacementInput{}
	}

	output = &StopGameSessionPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopGameSessionPlacement API operation for Amazon GameLift.
//
// Cancels a game session placement that is in Pending status. To stop a placement,
// provide the placement ID values. If successful, the placement is moved to
// Cancelled status.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StopGameSessionPlacement for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopGameSessionPlacement
func (c *GameLift) StopGameSessionPlacement(input *StopGameSessionPlacementInput) (*StopGameSessionPlacementOutput, error) {
	req, out := c.StopGameSessionPlacementRequest(input)
	return out, req.Send()
}

// StopGameSessionPlacementWithContext is the same as StopGameSessionPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See StopGameSessionPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StopGameSessionPlacementWithContext(ctx aws.Context, input *StopGameSessionPlacementInput, opts ...request.Option) (*StopGameSessionPlacementOutput, error) {
	req, out := c.StopGameSessionPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAlias operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAlias for more information on using the UpdateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAliasRequest method.
//    req, resp := client.UpdateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateAlias
func (c *GameLift) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *UpdateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	output = &UpdateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAlias API operation for Amazon GameLift.
//
// Updates properties for an alias. To update properties, specify the alias
// ID to be updated and provide the information to be changed. To reassign an
// alias to another fleet, provide an updated routing strategy. If successful,
// the updated alias record is returned.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateAlias
func (c *GameLift) UpdateAlias(input *UpdateAliasInput) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	return out, req.Send()
}

// UpdateAliasWithContext is the same as UpdateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateAliasWithContext(ctx aws.Context, input *UpdateAliasInput, opts ...request.Option) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBuild = "UpdateBuild"

// UpdateBuildRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBuild operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBuild for more information on using the UpdateBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBuildRequest method.
//    req, resp := client.UpdateBuildRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateBuild
func (c *GameLift) UpdateBuildRequest(input *UpdateBuildInput) (req *request.Request, output *UpdateBuildOutput) {
	op := &request.Operation{
		Name:       opUpdateBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBuildInput{}
	}

	output = &UpdateBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBuild API operation for Amazon GameLift.
//
// Updates metadata in a build record, including the build name and version.
// To update the metadata, specify the build ID to update and provide the new
// values. If successful, a build object containing the updated metadata is
// returned.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateBuild for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateBuild
func (c *GameLift) UpdateBuild(input *UpdateBuildInput) (*UpdateBuildOutput, error) {
	req, out := c.UpdateBuildRequest(input)
	return out, req.Send()
}

// UpdateBuildWithContext is the same as UpdateBuild with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateBuildWithContext(ctx aws.Context, input *UpdateBuildInput, opts ...request.Option) (*UpdateBuildOutput, error) {
	req, out := c.UpdateBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleetAttributes = "UpdateFleetAttributes"

// UpdateFleetAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleetAttributes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleetAttributes for more information on using the UpdateFleetAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFleetAttributesRequest method.
//    req, resp := client.UpdateFleetAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetAttributes
func (c *GameLift) UpdateFleetAttributesRequest(input *UpdateFleetAttributesInput) (req *request.Request, output *UpdateFleetAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetAttributesInput{}
	}

	output = &UpdateFleetAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleetAttributes API operation for Amazon GameLift.
//
// Updates fleet properties, including name and description, for a fleet. To
// update metadata, specify the fleet ID and the property values that you want
// to change. If successful, the fleet ID for the updated fleet is returned.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateFleetAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetAttributes
func (c *GameLift) UpdateFleetAttributes(input *UpdateFleetAttributesInput) (*UpdateFleetAttributesOutput, error) {
	req, out := c.UpdateFleetAttributesRequest(input)
	return out, req.Send()
}

// UpdateFleetAttributesWithContext is the same as UpdateFleetAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleetAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateFleetAttributesWithContext(ctx aws.Context, input *UpdateFleetAttributesInput, opts ...request.Option) (*UpdateFleetAttributesOutput, error) {
	req, out := c.UpdateFleetAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleetCapacity = "UpdateFleetCapacity"

// UpdateFleetCapacityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleetCapacity operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleetCapacity for more information on using the UpdateFleetCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFleetCapacityRequest method.
//    req, resp := client.UpdateFleetCapacityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetCapacity
func (c *GameLift) UpdateFleetCapacityRequest(input *UpdateFleetCapacityInput) (req *request.Request, output *UpdateFleetCapacityOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetCapacityInput{}
	}

	output = &UpdateFleetCapacityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleetCapacity API operation for Amazon GameLift.
//
// Updates capacity settings for a fleet. Use this action to specify the number
// of EC2 instances (hosts) that you want this fleet to contain. Before calling
// this action, you may want to call DescribeEC2InstanceLimits to get the maximum
// capacity based on the fleet's EC2 instance type.
//
// If you're using autoscaling (see PutScalingPolicy), you may want to specify
// a minimum and/or maximum capacity. If you don't provide these, autoscaling
// can set capacity anywhere between zero and the service limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift).
//
// To update fleet capacity, specify the fleet ID and the number of instances
// you want the fleet to host. If successful, Amazon GameLift starts or terminates
// instances so that the fleet's active instance count matches the desired instance
// count. You can view a fleet's current capacity information by calling DescribeFleetCapacity.
// If the desired instance count is higher than the instance type's limit, the
// "Limit Exceeded" exception occurs.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateFleetCapacity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetCapacity
func (c *GameLift) UpdateFleetCapacity(input *UpdateFleetCapacityInput) (*UpdateFleetCapacityOutput, error) {
	req, out := c.UpdateFleetCapacityRequest(input)
	return out, req.Send()
}

// UpdateFleetCapacityWithContext is the same as UpdateFleetCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleetCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateFleetCapacityWithContext(ctx aws.Context, input *UpdateFleetCapacityInput, opts ...request.Option) (*UpdateFleetCapacityOutput, error) {
	req, out := c.UpdateFleetCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleetPortSettings = "UpdateFleetPortSettings"

// UpdateFleetPortSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleetPortSettings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleetPortSettings for more information on using the UpdateFleetPortSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFleetPortSettingsRequest method.
//    req, resp := client.UpdateFleetPortSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetPortSettings
func (c *GameLift) UpdateFleetPortSettingsRequest(input *UpdateFleetPortSettingsInput) (req *request.Request, output *UpdateFleetPortSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetPortSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetPortSettingsInput{}
	}

	output = &UpdateFleetPortSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleetPortSettings API operation for Amazon GameLift.
//
// Updates port settings for a fleet. To update settings, specify the fleet
// ID to be updated and list the permissions you want to update. List the permissions
// you want to add in InboundPermissionAuthorizations, and permissions you want
// to remove in InboundPermissionRevocations. Permissions to be removed must
// match existing fleet permissions. If successful, the fleet ID for the updated
// fleet is returned.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateFleetPortSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested operation would cause the resource to exceed the allowed service
//   limit. Resolve the issue before retrying.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetPortSettings
func (c *GameLift) UpdateFleetPortSettings(input *UpdateFleetPortSettingsInput) (*UpdateFleetPortSettingsOutput, error) {
	req, out := c.UpdateFleetPortSettingsRequest(input)
	return out, req.Send()
}

// UpdateFleetPortSettingsWithContext is the same as UpdateFleetPortSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleetPortSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateFleetPortSettingsWithContext(ctx aws.Context, input *UpdateFleetPortSettingsInput, opts ...request.Option) (*UpdateFleetPortSettingsOutput, error) {
	req, out := c.UpdateFleetPortSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGameSession = "UpdateGameSession"

// UpdateGameSessionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGameSession operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGameSession for more information on using the UpdateGameSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGameSessionRequest method.
//    req, resp := client.UpdateGameSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSession
func (c *GameLift) UpdateGameSessionRequest(input *UpdateGameSessionInput) (req *request.Request, output *UpdateGameSessionOutput) {
	op := &request.Operation{
		Name:       opUpdateGameSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameSessionInput{}
	}

	output = &UpdateGameSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGameSession API operation for Amazon GameLift.
//
// Updates game session properties. This includes the session name, maximum
// player count, protection policy, which controls whether or not an active
// game session can be terminated during a scale-down event, and the player
// session creation policy, which controls whether or not new players can join
// the session. To update a game session, specify the game session ID and the
// values you want to change. If successful, an updated GameSession object is
// returned.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateGameSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeConflictException "ConflictException"
//   The requested operation would cause a conflict with the current state of
//   a service resource associated with the request. Resolve the conflict before
//   retrying this request.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeInvalidGameSessionStatusException "InvalidGameSessionStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the game instance. Resolve
//   the conflict before retrying.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSession
func (c *GameLift) UpdateGameSession(input *UpdateGameSessionInput) (*UpdateGameSessionOutput, error) {
	req, out := c.UpdateGameSessionRequest(input)
	return out, req.Send()
}

// UpdateGameSessionWithContext is the same as UpdateGameSession with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGameSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateGameSessionWithContext(ctx aws.Context, input *UpdateGameSessionInput, opts ...request.Option) (*UpdateGameSessionOutput, error) {
	req, out := c.UpdateGameSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGameSessionQueue = "UpdateGameSessionQueue"

// UpdateGameSessionQueueRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGameSessionQueue operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGameSessionQueue for more information on using the UpdateGameSessionQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGameSessionQueueRequest method.
//    req, resp := client.UpdateGameSessionQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionQueue
func (c *GameLift) UpdateGameSessionQueueRequest(input *UpdateGameSessionQueueInput) (req *request.Request, output *UpdateGameSessionQueueOutput) {
	op := &request.Operation{
		Name:       opUpdateGameSessionQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameSessionQueueInput{}
	}

	output = &UpdateGameSessionQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGameSessionQueue API operation for Amazon GameLift.
//
// Updates settings for a game session queue, which determines how new game
// session requests in the queue are processed. To update settings, specify
// the queue name to be updated and provide the new settings. When updating
// destinations, provide a complete list of destinations.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateGameSessionQueue for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionQueue
func (c *GameLift) UpdateGameSessionQueue(input *UpdateGameSessionQueueInput) (*UpdateGameSessionQueueOutput, error) {
	req, out := c.UpdateGameSessionQueueRequest(input)
	return out, req.Send()
}

// UpdateGameSessionQueueWithContext is the same as UpdateGameSessionQueue with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGameSessionQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateGameSessionQueueWithContext(ctx aws.Context, input *UpdateGameSessionQueueInput, opts ...request.Option) (*UpdateGameSessionQueueOutput, error) {
	req, out := c.UpdateGameSessionQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuntimeConfiguration = "UpdateRuntimeConfiguration"

// UpdateRuntimeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuntimeConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuntimeConfiguration for more information on using the UpdateRuntimeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuntimeConfigurationRequest method.
//    req, resp := client.UpdateRuntimeConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateRuntimeConfiguration
func (c *GameLift) UpdateRuntimeConfigurationRequest(input *UpdateRuntimeConfigurationInput) (req *request.Request, output *UpdateRuntimeConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateRuntimeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuntimeConfigurationInput{}
	}

	output = &UpdateRuntimeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRuntimeConfiguration API operation for Amazon GameLift.
//
// Updates the current run-time configuration for the specified fleet, which
// tells Amazon GameLift how to launch server processes on instances in the
// fleet. You can update a fleet's run-time configuration at any time after
// the fleet is created; it does not need to be in an ACTIVE status.
//
// To update run-time configuration, specify the fleet ID and provide a RuntimeConfiguration
// object with the updated collection of server process configurations.
//
// Each instance in a Amazon GameLift fleet checks regularly for an updated
// run-time configuration and changes how it launches server processes to comply
// with the latest version. Existing server processes are not affected by the
// update; they continue to run until they end, while Amazon GameLift simply
// adds new server processes to fit the current run-time configuration. As a
// result, the run-time configuration changes are applied gradually as existing
// processes shut down and new processes are launched in Amazon GameLift's normal
// process recycling activity.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateRuntimeConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The client failed authentication. Clients should not retry such requests.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an unrecoverable internal failure while processing
//   the request. Clients can retry such requests immediately or after a waiting
//   period.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   One or more parameter values in the request are invalid. Correct the invalid
//   parameter values before retrying.
//
//   * ErrCodeInvalidFleetStatusException "InvalidFleetStatusException"
//   The requested operation would cause a conflict with the current state of
//   a resource associated with the request and/or the fleet. Resolve the conflict
//   before retrying.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateRuntimeConfiguration
func (c *GameLift) UpdateRuntimeConfiguration(input *UpdateRuntimeConfigurationInput) (*UpdateRuntimeConfigurationOutput, error) {
	req, out := c.UpdateRuntimeConfigurationRequest(input)
	return out, req.Send()
}

// UpdateRuntimeConfigurationWithContext is the same as UpdateRuntimeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuntimeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateRuntimeConfigurationWithContext(ctx aws.Context, input *UpdateRuntimeConfigurationInput, opts ...request.Option) (*UpdateRuntimeConfigurationOutput, error) {
	req, out := c.UpdateRuntimeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Properties describing a fleet alias.
//
// Alias-related operations include:
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/Alias
type Alias struct {
	_ struct{} `type:"structure"`

	// Unique identifier for an alias; alias ARNs are unique across all regions.
	AliasArn *string `min:"1" type:"string"`

	// Unique identifier for an alias; alias IDs are unique within a region.
	AliasId *string `type:"string"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Human-readable description of an alias.
	Description *string `type:"string"`

	// Time stamp indicating when this data object was last modified. Format is
	// a number expressed in Unix time as milliseconds (for example "1469498468.057").
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Descriptive label that is associated with an alias. Alias names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Alias configuration for the alias, including routing type and settings.
	RoutingStrategy *RoutingStrategy `type:"structure"`
}

// String returns the string representation
func (s Alias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alias) GoString() string {
	return s.String()
}

// SetAliasArn sets the AliasArn field's value.
func (s *Alias) SetAliasArn(v string) *Alias {
	s.AliasArn = &v
	return s
}

// SetAliasId sets the AliasId field's value.
func (s *Alias) SetAliasId(v string) *Alias {
	s.AliasId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Alias) SetCreationTime(v time.Time) *Alias {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Alias) SetDescription(v string) *Alias {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Alias) SetLastUpdatedTime(v time.Time) *Alias {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Alias) SetName(v string) *Alias {
	s.Name = &v
	return s
}

// SetRoutingStrategy sets the RoutingStrategy field's value.
func (s *Alias) SetRoutingStrategy(v *RoutingStrategy) *Alias {
	s.RoutingStrategy = v
	return s
}

// AWS access credentials sometimes used for uploading game build files to Amazon
// GameLift. They are valid for a limited time. If they expire before you upload
// your game build, get a new set by calling RequestUploadCredentials.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AwsCredentials
type AwsCredentials struct {
	_ struct{} `type:"structure"`

	// Access key for an AWS account.
	AccessKeyId *string `min:"1" type:"string"`

	// Secret key for an AWS account.
	SecretAccessKey *string `min:"1" type:"string"`

	// Token specific to a build ID.
	SessionToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AwsCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCredentials) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AwsCredentials) SetAccessKeyId(v string) *AwsCredentials {
	s.AccessKeyId = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *AwsCredentials) SetSecretAccessKey(v string) *AwsCredentials {
	s.SecretAccessKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *AwsCredentials) SetSessionToken(v string) *AwsCredentials {
	s.SessionToken = &v
	return s
}

// Properties describing a game build.
//
// Build-related operations include:
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/Build
type Build struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build.
	BuildId *string `type:"string"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Descriptive label that is associated with a build. Build names do not need
	// to be unique. It can be set using CreateBuild or UpdateBuild.
	Name *string `type:"string"`

	// Operating system that the game server binaries are built to run on. This
	// value determines the type of fleet resources that you can use for this build.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// File size of the uploaded game build, expressed in bytes. When the build
	// status is INITIALIZED, this value is 0.
	SizeOnDisk *int64 `min:"1" type:"long"`

	// Current status of the build.
	//
	// Possible build statuses include the following:
	//
	//    * INITIALIZED – A new build has been defined, but no files have been uploaded.
	//    You cannot create fleets for builds that are in this status. When a build
	//    is successfully created, the build status is set to this value.
	//
	//    * READY – The game build has been successfully uploaded. You can now create
	//    new fleets for this build.
	//
	//    * FAILED – The game build upload failed. You cannot create new fleets
	//    for this build.
	Status *string `type:"string" enum:"BuildStatus"`

	// Version that is associated with this build. Version strings do not need to
	// be unique. This value can be set using CreateBuild or UpdateBuild.
	Version *string `type:"string"`
}

// String returns the string representation
func (s Build) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Build) GoString() string {
	return s.String()
}

// SetBuildId sets the BuildId field's value.
func (s *Build) SetBuildId(v string) *Build {
	s.BuildId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Build) SetCreationTime(v time.Time) *Build {
	s.CreationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Build) SetName(v string) *Build {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *Build) SetOperatingSystem(v string) *Build {
	s.OperatingSystem = &v
	return s
}

// SetSizeOnDisk sets the SizeOnDisk field's value.
func (s *Build) SetSizeOnDisk(v int64) *Build {
	s.SizeOnDisk = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Build) SetStatus(v string) *Build {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Build) SetVersion(v string) *Build {
	s.Version = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAliasInput
type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// Human-readable description of an alias.
	Description *string `min:"1" type:"string"`

	// Descriptive label that is associated with an alias. Alias names do not need
	// to be unique.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Object that specifies the fleet and routing type to use for the alias.
	//
	// RoutingStrategy is a required field
	RoutingStrategy *RoutingStrategy `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoutingStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingStrategy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateAliasInput) SetDescription(v string) *CreateAliasInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAliasInput) SetName(v string) *CreateAliasInput {
	s.Name = &v
	return s
}

// SetRoutingStrategy sets the RoutingStrategy field's value.
func (s *CreateAliasInput) SetRoutingStrategy(v *RoutingStrategy) *CreateAliasInput {
	s.RoutingStrategy = v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAliasOutput
type CreateAliasOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created alias record.
	Alias *Alias `type:"structure"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *CreateAliasOutput) SetAlias(v *Alias) *CreateAliasOutput {
	s.Alias = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuildInput
type CreateBuildInput struct {
	_ struct{} `type:"structure"`

	// Descriptive label that is associated with a build. Build names do not need
	// to be unique. You can use UpdateBuild to change this value later.
	Name *string `min:"1" type:"string"`

	// Operating system that the game server binaries are built to run on. This
	// value determines the type of fleet resources that you can use for this build.
	// If your game build contains multiple executables, they all must run on the
	// same operating system.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// Amazon S3 location of the game build files to be uploaded. The S3 bucket
	// must be owned by the same AWS account that you're using to manage Amazon
	// GameLift. It also must in the same region that you want to create a new build
	// in. Before calling CreateBuild with this location, you must allow Amazon
	// GameLift to access your Amazon S3 bucket (see Create a Build with Files in
	// Amazon S3 (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build)).
	StorageLocation *S3Location `type:"structure"`

	// Version that is associated with this build. Version strings do not need to
	// be unique. You can use UpdateBuild to change this value later.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBuildInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}
	if s.StorageLocation != nil {
		if err := s.StorageLocation.Validate(); err != nil {
			invalidParams.AddNested("StorageLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateBuildInput) SetName(v string) *CreateBuildInput {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *CreateBuildInput) SetOperatingSystem(v string) *CreateBuildInput {
	s.OperatingSystem = &v
	return s
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *CreateBuildInput) SetStorageLocation(v *S3Location) *CreateBuildInput {
	s.StorageLocation = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateBuildInput) SetVersion(v string) *CreateBuildInput {
	s.Version = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuildOutput
type CreateBuildOutput struct {
	_ struct{} `type:"structure"`

	// The newly created build record, including a unique build ID and status.
	Build *Build `type:"structure"`

	// Amazon S3 location specified in the request.
	StorageLocation *S3Location `type:"structure"`

	// This element is not currently in use.
	UploadCredentials *AwsCredentials `type:"structure"`
}

// String returns the string representation
func (s CreateBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *CreateBuildOutput) SetBuild(v *Build) *CreateBuildOutput {
	s.Build = v
	return s
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *CreateBuildOutput) SetStorageLocation(v *S3Location) *CreateBuildOutput {
	s.StorageLocation = v
	return s
}

// SetUploadCredentials sets the UploadCredentials field's value.
func (s *CreateBuildOutput) SetUploadCredentials(v *AwsCredentials) *CreateBuildOutput {
	s.UploadCredentials = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleetInput
type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to be deployed on the new fleet. The build
	// must have been successfully uploaded to Amazon GameLift and be in a READY
	// status. This fleet setting cannot be changed once the fleet is created.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`

	// Human-readable description of a fleet.
	Description *string `min:"1" type:"string"`

	// Range of IP addresses and port settings that permit inbound traffic to access
	// server processes running on the fleet. If no inbound permissions are set,
	// including both IP address range and port range, the server processes in the
	// fleet cannot accept connections. You can specify one or more sets of permissions
	// for a fleet.
	EC2InboundPermissions []*IpPermission `type:"list"`

	// Name of an EC2 instance type that is supported in Amazon GameLift. A fleet
	// instance type determines the computing resources of each instance in the
	// fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
	// supports the following EC2 instance types. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	//
	// EC2InstanceType is a required field
	EC2InstanceType *string `type:"string" required:"true" enum:"EC2InstanceType"`

	// This parameter is no longer used. Instead, to specify where Amazon GameLift
	// should store log files once a server process shuts down, use the Amazon GameLift
	// server API ProcessReady() and specify one or more directory paths in logParameters.
	// See more information in the Server API Reference (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process).
	LogPaths []*string `type:"list"`

	// Names of metric groups to add this fleet to. Use an existing metric group
	// name to add this fleet to the group. Or use a new name to create a new metric
	// group. A fleet can only be included in one metric group at a time.
	MetricGroups []*string `type:"list"`

	// Descriptive label that is associated with a fleet. Fleet names do not need
	// to be unique.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Game session protection policy to apply to all instances in this fleet. If
	// this parameter is not set, instances in this fleet default to no protection.
	// You can change a fleet's protection policy using UpdateFleetAttributes, but
	// this change will only affect sessions created after the policy change. You
	// can also set protection for individual instances using UpdateGameSession.
	//
	//    * NoProtection – The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection – If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	NewGameSessionProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`

	// Policy that limits the number of game sessions an individual player can create
	// over a span of time for this fleet.
	ResourceCreationLimitPolicy *ResourceCreationLimitPolicy `type:"structure"`

	// Instructions for launching server processes on each instance in the fleet.
	// The run-time configuration for a fleet has a collection of server process
	// configurations, one for each type of server process to run on an instance.
	// A server process configuration specifies the location of the server executable,
	// launch parameters, and the number of concurrent processes with that configuration
	// to maintain on each instance. A CreateFleet request must include a run-time
	// configuration with at least one server process configuration; otherwise the
	// request fails with an invalid request exception. (This parameter replaces
	// the parameters ServerLaunchPath and ServerLaunchParameters; requests that
	// contain values for these parameters instead of a run-time configuration will
	// continue to work.)
	RuntimeConfiguration *RuntimeConfiguration `type:"structure"`

	// This parameter is no longer used. Instead, specify server launch parameters
	// in the RuntimeConfiguration parameter. (Requests that specify a server launch
	// path and launch parameters instead of a run-time configuration will continue
	// to work.)
	ServerLaunchParameters *string `min:"1" type:"string"`

	// This parameter is no longer used. Instead, specify a server launch path using
	// the RuntimeConfiguration parameter. (Requests that specify a server launch
	// path and launch parameters instead of a run-time configuration will continue
	// to work.)
	ServerLaunchPath *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EC2InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("EC2InstanceType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ServerLaunchParameters != nil && len(*s.ServerLaunchParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerLaunchParameters", 1))
	}
	if s.ServerLaunchPath != nil && len(*s.ServerLaunchPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerLaunchPath", 1))
	}
	if s.EC2InboundPermissions != nil {
		for i, v := range s.EC2InboundPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EC2InboundPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RuntimeConfiguration != nil {
		if err := s.RuntimeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RuntimeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *CreateFleetInput) SetBuildId(v string) *CreateFleetInput {
	s.BuildId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFleetInput) SetDescription(v string) *CreateFleetInput {
	s.Description = &v
	return s
}

// SetEC2InboundPermissions sets the EC2InboundPermissions field's value.
func (s *CreateFleetInput) SetEC2InboundPermissions(v []*IpPermission) *CreateFleetInput {
	s.EC2InboundPermissions = v
	return s
}

// SetEC2InstanceType sets the EC2InstanceType field's value.
func (s *CreateFleetInput) SetEC2InstanceType(v string) *CreateFleetInput {
	s.EC2InstanceType = &v
	return s
}

// SetLogPaths sets the LogPaths field's value.
func (s *CreateFleetInput) SetLogPaths(v []*string) *CreateFleetInput {
	s.LogPaths = v
	return s
}

// SetMetricGroups sets the MetricGroups field's value.
func (s *CreateFleetInput) SetMetricGroups(v []*string) *CreateFleetInput {
	s.MetricGroups = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFleetInput) SetName(v string) *CreateFleetInput {
	s.Name = &v
	return s
}

// SetNewGameSessionProtectionPolicy sets the NewGameSessionProtectionPolicy field's value.
func (s *CreateFleetInput) SetNewGameSessionProtectionPolicy(v string) *CreateFleetInput {
	s.NewGameSessionProtectionPolicy = &v
	return s
}

// SetResourceCreationLimitPolicy sets the ResourceCreationLimitPolicy field's value.
func (s *CreateFleetInput) SetResourceCreationLimitPolicy(v *ResourceCreationLimitPolicy) *CreateFleetInput {
	s.ResourceCreationLimitPolicy = v
	return s
}

// SetRuntimeConfiguration sets the RuntimeConfiguration field's value.
func (s *CreateFleetInput) SetRuntimeConfiguration(v *RuntimeConfiguration) *CreateFleetInput {
	s.RuntimeConfiguration = v
	return s
}

// SetServerLaunchParameters sets the ServerLaunchParameters field's value.
func (s *CreateFleetInput) SetServerLaunchParameters(v string) *CreateFleetInput {
	s.ServerLaunchParameters = &v
	return s
}

// SetServerLaunchPath sets the ServerLaunchPath field's value.
func (s *CreateFleetInput) SetServerLaunchPath(v string) *CreateFleetInput {
	s.ServerLaunchPath = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleetOutput
type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// Properties for the newly created fleet.
	FleetAttributes *FleetAttributes `type:"structure"`
}

// String returns the string representation
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetOutput) GoString() string {
	return s.String()
}

// SetFleetAttributes sets the FleetAttributes field's value.
func (s *CreateFleetOutput) SetFleetAttributes(v *FleetAttributes) *CreateFleetOutput {
	s.FleetAttributes = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionInput
type CreateGameSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for an alias associated with the fleet to create a game
	// session in. Each request must reference either a fleet ID or alias ID, but
	// not both.
	AliasId *string `type:"string"`

	// Unique identifier for a player or entity creating the game session. This
	// ID is used to enforce a resource protection policy (if one exists) that limits
	// the number of concurrent active game sessions one player can have.
	CreatorId *string `min:"1" type:"string"`

	// Unique identifier for a fleet to create a game session in. Each request must
	// reference either a fleet ID or alias ID, but not both.
	FleetId *string `type:"string"`

	// Set of developer-defined properties for a game session. These properties
	// are passed to the server process hosting the game session.
	GameProperties []*GameProperty `type:"list"`

	// This parameter is no longer preferred. Please use IdempotencyToken instead.
	// Custom string that uniquely identifies a request for a new game session.
	// Maximum token length is 48 characters. If provided, this string is included
	// in the new game session's ID. (A game session ID has the following format:
	// arn:aws:gamelift:<region>::gamesession/<fleet ID>/<custom ID string or idempotency
	// token>.)
	GameSessionId *string `min:"1" type:"string"`

	// Custom string that uniquely identifies a request for a new game session.
	// Maximum token length is 48 characters. If provided, this string is included
	// in the new game session's ID. (A game session ID has the following format:
	// arn:aws:gamelift:<region>::gamesession/<fleet ID>/<custom ID string or idempotency
	// token>.)
	IdempotencyToken *string `min:"1" type:"string"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	//
	// MaximumPlayerSessionCount is a required field
	MaximumPlayerSessionCount *int64 `type:"integer" required:"true"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateGameSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGameSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGameSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGameSessionInput"}
	if s.CreatorId != nil && len(*s.CreatorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorId", 1))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.MaximumPlayerSessionCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumPlayerSessionCount"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.GameProperties != nil {
		for i, v := range s.GameProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GameProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *CreateGameSessionInput) SetAliasId(v string) *CreateGameSessionInput {
	s.AliasId = &v
	return s
}

// SetCreatorId sets the CreatorId field's value.
func (s *CreateGameSessionInput) SetCreatorId(v string) *CreateGameSessionInput {
	s.CreatorId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *CreateGameSessionInput) SetFleetId(v string) *CreateGameSessionInput {
	s.FleetId = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *CreateGameSessionInput) SetGameProperties(v []*GameProperty) *CreateGameSessionInput {
	s.GameProperties = v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *CreateGameSessionInput) SetGameSessionId(v string) *CreateGameSessionInput {
	s.GameSessionId = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateGameSessionInput) SetIdempotencyToken(v string) *CreateGameSessionInput {
	s.IdempotencyToken = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *CreateGameSessionInput) SetMaximumPlayerSessionCount(v int64) *CreateGameSessionInput {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGameSessionInput) SetName(v string) *CreateGameSessionInput {
	s.Name = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionOutput
type CreateGameSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created game session record.
	GameSession *GameSession `type:"structure"`
}

// String returns the string representation
func (s CreateGameSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGameSessionOutput) GoString() string {
	return s.String()
}

// SetGameSession sets the GameSession field's value.
func (s *CreateGameSessionOutput) SetGameSession(v *GameSession) *CreateGameSessionOutput {
	s.GameSession = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueueInput
type CreateGameSessionQueueInput struct {
	_ struct{} `type:"structure"`

	// List of fleets that can be used to fulfill game session placement requests
	// in the queue. Fleets are identified by either a fleet ARN or a fleet alias
	// ARN. Destinations are listed in default preference order.
	Destinations []*GameSessionQueueDestination `type:"list"`

	// Descriptive label that is associated with queue. Queue names must be unique
	// within each region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Collection of latency policies to apply when processing game sessions placement
	// requests with player latency information. Multiple policies are evaluated
	// in order of the maximum latency value, starting with the lowest latency values.
	// With just one policy, it is enforced at the start of the game session placement
	// for the duration period. With multiple policies, each policy is enforced
	// consecutively for its duration period. For example, a queue might enforce
	// a 60-second policy followed by a 120-second policy, and then no policy for
	// the remainder of the placement. A player latency policy must set a value
	// for MaximumIndividualPlayerLatencyMilliseconds; if none is set, this API
	// requests will fail.
	PlayerLatencyPolicies []*PlayerLatencyPolicy `type:"list"`

	// Maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status.
	TimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s CreateGameSessionQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGameSessionQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGameSessionQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGameSessionQueueInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinations sets the Destinations field's value.
func (s *CreateGameSessionQueueInput) SetDestinations(v []*GameSessionQueueDestination) *CreateGameSessionQueueInput {
	s.Destinations = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGameSessionQueueInput) SetName(v string) *CreateGameSessionQueueInput {
	s.Name = &v
	return s
}

// SetPlayerLatencyPolicies sets the PlayerLatencyPolicies field's value.
func (s *CreateGameSessionQueueInput) SetPlayerLatencyPolicies(v []*PlayerLatencyPolicy) *CreateGameSessionQueueInput {
	s.PlayerLatencyPolicies = v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *CreateGameSessionQueueInput) SetTimeoutInSeconds(v int64) *CreateGameSessionQueueInput {
	s.TimeoutInSeconds = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueueOutput
type CreateGameSessionQueueOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created game session queue.
	GameSessionQueue *GameSessionQueue `type:"structure"`
}

// String returns the string representation
func (s CreateGameSessionQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGameSessionQueueOutput) GoString() string {
	return s.String()
}

// SetGameSessionQueue sets the GameSessionQueue field's value.
func (s *CreateGameSessionQueueOutput) SetGameSessionQueue(v *GameSessionQueue) *CreateGameSessionQueueOutput {
	s.GameSessionQueue = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessionInput
type CreatePlayerSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to add a player to.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`

	// Developer-defined information related to a player. Amazon GameLift does not
	// use this data, so it can be formatted as needed for use in the game.
	PlayerData *string `min:"1" type:"string"`

	// Unique identifier for a player. Player IDs are developer-defined.
	//
	// PlayerId is a required field
	PlayerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePlayerSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlayerSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlayerSessionInput"}
	if s.GameSessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.PlayerData != nil && len(*s.PlayerData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerData", 1))
	}
	if s.PlayerId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlayerId"))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *CreatePlayerSessionInput) SetGameSessionId(v string) *CreatePlayerSessionInput {
	s.GameSessionId = &v
	return s
}

// SetPlayerData sets the PlayerData field's value.
func (s *CreatePlayerSessionInput) SetPlayerData(v string) *CreatePlayerSessionInput {
	s.PlayerData = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *CreatePlayerSessionInput) SetPlayerId(v string) *CreatePlayerSessionInput {
	s.PlayerId = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessionOutput
type CreatePlayerSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created player session record.
	PlayerSession *PlayerSession `type:"structure"`
}

// String returns the string representation
func (s CreatePlayerSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionOutput) GoString() string {
	return s.String()
}

// SetPlayerSession sets the PlayerSession field's value.
func (s *CreatePlayerSessionOutput) SetPlayerSession(v *PlayerSession) *CreatePlayerSessionOutput {
	s.PlayerSession = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessionsInput
type CreatePlayerSessionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to add players to.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`

	// Map of string pairs, each specifying a player ID and a set of developer-defined
	// information related to the player. Amazon GameLift does not use this data,
	// so it can be formatted as needed for use in the game. Player data strings
	// for player IDs not included in the PlayerIds parameter are ignored.
	PlayerDataMap map[string]*string `type:"map"`

	// List of unique identifiers for the players to be added.
	//
	// PlayerIds is a required field
	PlayerIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreatePlayerSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlayerSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlayerSessionsInput"}
	if s.GameSessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.PlayerIds == nil {
		invalidParams.Add(request.NewErrParamRequired("PlayerIds"))
	}
	if s.PlayerIds != nil && len(s.PlayerIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *CreatePlayerSessionsInput) SetGameSessionId(v string) *CreatePlayerSessionsInput {
	s.GameSessionId = &v
	return s
}

// SetPlayerDataMap sets the PlayerDataMap field's value.
func (s *CreatePlayerSessionsInput) SetPlayerDataMap(v map[string]*string) *CreatePlayerSessionsInput {
	s.PlayerDataMap = v
	return s
}

// SetPlayerIds sets the PlayerIds field's value.
func (s *CreatePlayerSessionsInput) SetPlayerIds(v []*string) *CreatePlayerSessionsInput {
	s.PlayerIds = v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessionsOutput
type CreatePlayerSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of player session objects created for the added players.
	PlayerSessions []*PlayerSession `type:"list"`
}

// String returns the string representation
func (s CreatePlayerSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionsOutput) GoString() string {
	return s.String()
}

// SetPlayerSessions sets the PlayerSessions field's value.
func (s *CreatePlayerSessionsOutput) SetPlayerSessions(v []*PlayerSession) *CreatePlayerSessionsOutput {
	s.PlayerSessions = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAliasInput
type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Specify the alias you want to delete.
	//
	// AliasId is a required field
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DeleteAliasInput) SetAliasId(v string) *DeleteAliasInput {
	s.AliasId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAliasOutput
type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuildInput
type DeleteBuildInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to delete.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBuildInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *DeleteBuildInput) SetBuildId(v string) *DeleteBuildInput {
	s.BuildId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuildOutput
type DeleteBuildOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBuildOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleetInput
type DeleteFleetInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to be deleted.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteFleetInput) SetFleetId(v string) *DeleteFleetInput {
	s.FleetId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleetOutput
type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueueInput
type DeleteGameSessionQueueInput struct {
	_ struct{} `type:"structure"`

	// Descriptive label that is associated with queue. Queue names must be unique
	// within each region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGameSessionQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGameSessionQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGameSessionQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGameSessionQueueInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteGameSessionQueueInput) SetName(v string) *DeleteGameSessionQueueInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueueOutput
type DeleteGameSessionQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGameSessionQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGameSessionQueueOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicyInput
type DeleteScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to be deleted.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Descriptive label that is associated with a scaling policy. Policy names
	// do not need to be unique.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScalingPolicyInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteScalingPolicyInput) SetFleetId(v string) *DeleteScalingPolicyInput {
	s.FleetId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteScalingPolicyInput) SetName(v string) *DeleteScalingPolicyInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicyOutput
type DeleteScalingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPolicyOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAliasInput
type DescribeAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Specify the alias you want to retrieve.
	//
	// AliasId is a required field
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeAliasInput) SetAliasId(v string) *DescribeAliasInput {
	s.AliasId = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAliasOutput
type DescribeAliasOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains the requested alias.
	Alias *Alias `type:"structure"`
}

// String returns the string representation
func (s DescribeAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *DescribeAliasOutput) SetAlias(v *Alias) *DescribeAliasOutput {
	s.Alias = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuildInput
type DescribeBuildInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to retrieve properties for.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBuildInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *DescribeBuildInput) SetBuildId(v string) *DescribeBuildInput {
	s.BuildId = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuildOutput
type DescribeBuildOutput struct {
	_ struct{} `type:"structure"`

	// Set of properties describing the requested build.
	Build *Build `type:"structure"`
}

// String returns the string representation
func (s DescribeBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *DescribeBuildOutput) SetBuild(v *Build) *DescribeBuildOutput {
	s.Build = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimitsInput
type DescribeEC2InstanceLimitsInput struct {
	_ struct{} `type:"structure"`

	// Name of an EC2 instance type that is supported in Amazon GameLift. A fleet
	// instance type determines the computing resources of each instance in the
	// fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
	// supports the following EC2 instance types. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions. Leave
	// this parameter blank to retrieve limits for all types.
	EC2InstanceType *string `type:"string" enum:"EC2InstanceType"`
}

// String returns the string representation
func (s DescribeEC2InstanceLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEC2InstanceLimitsInput) GoString() string {
	return s.String()
}

// SetEC2InstanceType sets the EC2InstanceType field's value.
func (s *DescribeEC2InstanceLimitsInput) SetEC2InstanceType(v string) *DescribeEC2InstanceLimitsInput {
	s.EC2InstanceType = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimitsOutput
type DescribeEC2InstanceLimitsOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains the maximum number of instances for the specified instance
	// type.
	EC2InstanceLimits []*EC2InstanceLimit `type:"list"`
}

// String returns the string representation
func (s DescribeEC2InstanceLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEC2InstanceLimitsOutput) GoString() string {
	return s.String()
}

// SetEC2InstanceLimits sets the EC2InstanceLimits field's value.
func (s *DescribeEC2InstanceLimitsOutput) SetEC2InstanceLimits(v []*EC2InstanceLimit) *DescribeEC2InstanceLimitsOutput {
	s.EC2InstanceLimits = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributesInput
type DescribeFleetAttributesInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet(s) to retrieve attributes for. To request attributes
	// for all fleets, leave this parameter empty.
	FleetIds []*string `min:"1" type:"list"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value. This parameter is ignored
	// when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetAttributesInput"}
	if s.FleetIds != nil && len(s.FleetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetIds sets the FleetIds field's value.
func (s *DescribeFleetAttributesInput) SetFleetIds(v []*string) *DescribeFleetAttributesInput {
	s.FleetIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetAttributesInput) SetLimit(v int64) *DescribeFleetAttributesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAttributesInput) SetNextToken(v string) *DescribeFleetAttributesInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributesOutput
type DescribeFleetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing attribute metadata for each requested fleet
	// ID.
	FleetAttributes []*FleetAttributes `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetAttributesOutput) GoString() string {
	return s.String()
}

// SetFleetAttributes sets the FleetAttributes field's value.
func (s *DescribeFleetAttributesOutput) SetFleetAttributes(v []*FleetAttributes) *DescribeFleetAttributesOutput {
	s.FleetAttributes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAttributesOutput) SetNextToken(v string) *DescribeFleetAttributesOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacityInput
type DescribeFleetCapacityInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet(s) to retrieve capacity information for. To
	// request capacity information for all fleets, leave this parameter empty.
	FleetIds []*string `min:"1" type:"list"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value. This parameter is ignored
	// when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetCapacityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetCapacityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetCapacityInput"}
	if s.FleetIds != nil && len(s.FleetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetIds sets the FleetIds field's value.
func (s *DescribeFleetCapacityInput) SetFleetIds(v []*string) *DescribeFleetCapacityInput {
	s.FleetIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetCapacityInput) SetLimit(v int64) *DescribeFleetCapacityInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetCapacityInput) SetNextToken(v string) *DescribeFleetCapacityInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacityOutput
type DescribeFleetCapacityOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing capacity information for each requested
	// fleet ID. Leave this parameter empty to retrieve capacity information for
	// all fleets.
	FleetCapacity []*FleetCapacity `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetCapacityOutput) GoString() string {
	return s.String()
}

// SetFleetCapacity sets the FleetCapacity field's value.
func (s *DescribeFleetCapacityOutput) SetFleetCapacity(v []*FleetCapacity) *DescribeFleetCapacityOutput {
	s.FleetCapacity = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetCapacityOutput) SetNextToken(v string) *DescribeFleetCapacityOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEventsInput
type DescribeFleetEventsInput struct {
	_ struct{} `type:"structure"`

	// Most recent date to retrieve event logs for. If no end time is specified,
	// this call returns entries from the specified start time up to the present.
	// Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for a fleet to get event logs for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Earliest date to retrieve event logs for. If no start time is specified,
	// this call returns entries starting from when the fleet was created to the
	// specified end time. Format is a number expressed in Unix time as milliseconds
	// (ex: "1469498468.057").
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s DescribeFleetEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetEventsInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeFleetEventsInput) SetEndTime(v time.Time) *DescribeFleetEventsInput {
	s.EndTime = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeFleetEventsInput) SetFleetId(v string) *DescribeFleetEventsInput {
	s.FleetId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetEventsInput) SetLimit(v int64) *DescribeFleetEventsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetEventsInput) SetNextToken(v string) *DescribeFleetEventsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeFleetEventsInput) SetStartTime(v time.Time) *DescribeFleetEventsInput {
	s.StartTime = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEventsOutput
type DescribeFleetEventsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing event log entries for the specified fleet.
	Events []*Event `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeFleetEventsOutput) SetEvents(v []*Event) *DescribeFleetEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetEventsOutput) SetNextToken(v string) *DescribeFleetEventsOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettingsInput
type DescribeFleetPortSettingsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to retrieve port settings for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFleetPortSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetPortSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetPortSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetPortSettingsInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeFleetPortSettingsInput) SetFleetId(v string) *DescribeFleetPortSettingsInput {
	s.FleetId = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettingsOutput
type DescribeFleetPortSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains port settings for the requested fleet ID.
	InboundPermissions []*IpPermission `type:"list"`
}

// String returns the string representation
func (s DescribeFleetPortSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetPortSettingsOutput) GoString() string {
	return s.String()
}

// SetInboundPermissions sets the InboundPermissions field's value.
func (s *DescribeFleetPortSettingsOutput) SetInboundPermissions(v []*IpPermission) *DescribeFleetPortSettingsOutput {
	s.InboundPermissions = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilizationInput
type DescribeFleetUtilizationInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet(s) to retrieve utilization data for. To request
	// utilization data for all fleets, leave this parameter empty.
	FleetIds []*string `min:"1" type:"list"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value. This parameter is ignored
	// when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetUtilizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetUtilizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetUtilizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetUtilizationInput"}
	if s.FleetIds != nil && len(s.FleetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetIds sets the FleetIds field's value.
func (s *DescribeFleetUtilizationInput) SetFleetIds(v []*string) *DescribeFleetUtilizationInput {
	s.FleetIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetUtilizationInput) SetLimit(v int64) *DescribeFleetUtilizationInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetUtilizationInput) SetNextToken(v string) *DescribeFleetUtilizationInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilizationOutput
type DescribeFleetUtilizationOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing utilization information for each requested
	// fleet ID.
	FleetUtilization []*FleetUtilization `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetUtilizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetUtilizationOutput) GoString() string {
	return s.String()
}

// SetFleetUtilization sets the FleetUtilization field's value.
func (s *DescribeFleetUtilizationOutput) SetFleetUtilization(v []*FleetUtilization) *DescribeFleetUtilizationOutput {
	s.FleetUtilization = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetUtilizationOutput) SetNextToken(v string) *DescribeFleetUtilizationOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetailsInput
type DescribeGameSessionDetailsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for an alias associated with the fleet to retrieve all
	// game sessions for.
	AliasId *string `type:"string"`

	// Unique identifier for a fleet to retrieve all game sessions active on the
	// fleet.
	FleetId *string `type:"string"`

	// Unique identifier for the game session to retrieve.
	GameSessionId *string `min:"1" type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Game session status to filter results on. Possible game session statuses
	// include ACTIVE, TERMINATED, ACTIVATING and TERMINATING (the last two are
	// transitory).
	StatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionDetailsInput"}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StatusFilter != nil && len(*s.StatusFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeGameSessionDetailsInput) SetAliasId(v string) *DescribeGameSessionDetailsInput {
	s.AliasId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeGameSessionDetailsInput) SetFleetId(v string) *DescribeGameSessionDetailsInput {
	s.FleetId = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *DescribeGameSessionDetailsInput) SetGameSessionId(v string) *DescribeGameSessionDetailsInput {
	s.GameSessionId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeGameSessionDetailsInput) SetLimit(v int64) *DescribeGameSessionDetailsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionDetailsInput) SetNextToken(v string) *DescribeGameSessionDetailsInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *DescribeGameSessionDetailsInput) SetStatusFilter(v string) *DescribeGameSessionDetailsInput {
	s.StatusFilter = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetailsOutput
type DescribeGameSessionDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing game session properties and the protection
	// policy currently in force for each session matching the request.
	GameSessionDetails []*GameSessionDetail `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionDetailsOutput) GoString() string {
	return s.String()
}

// SetGameSessionDetails sets the GameSessionDetails field's value.
func (s *DescribeGameSessionDetailsOutput) SetGameSessionDetails(v []*GameSessionDetail) *DescribeGameSessionDetailsOutput {
	s.GameSessionDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionDetailsOutput) SetNextToken(v string) *DescribeGameSessionDetailsOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacementInput
type DescribeGameSessionPlacementInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a game session placement to retrieve.
	//
	// PlacementId is a required field
	PlacementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGameSessionPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionPlacementInput"}
	if s.PlacementId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementId"))
	}
	if s.PlacementId != nil && len(*s.PlacementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlacementId sets the PlacementId field's value.
func (s *DescribeGameSessionPlacementInput) SetPlacementId(v string) *DescribeGameSessionPlacementInput {
	s.PlacementId = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacementOutput
type DescribeGameSessionPlacementOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the requested game session placement.
	GameSessionPlacement *GameSessionPlacement `type:"structure"`
}

// String returns the string representation
func (s DescribeGameSessionPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionPlacementOutput) GoString() string {
	return s.String()
}

// SetGameSessionPlacement sets the GameSessionPlacement field's value.
func (s *DescribeGameSessionPlacementOutput) SetGameSessionPlacement(v *GameSessionPlacement) *DescribeGameSessionPlacementOutput {
	s.GameSessionPlacement = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueuesInput
type DescribeGameSessionQueuesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// List of queue names to retrieve information for. To request settings for
	// all queues, leave this parameter empty.
	Names []*string `type:"list"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionQueuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionQueuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionQueuesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeGameSessionQueuesInput) SetLimit(v int64) *DescribeGameSessionQueuesInput {
	s.Limit = &v
	return s
}

// SetNames sets the Names field's value.
func (s *DescribeGameSessionQueuesInput) SetNames(v []*string) *DescribeGameSessionQueuesInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionQueuesInput) SetNextToken(v string) *DescribeGameSessionQueuesInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueuesOutput
type DescribeGameSessionQueuesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects that describes the requested game session queues.
	GameSessionQueues []*GameSessionQueue `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionQueuesOutput) GoString() string {
	return s.String()
}

// SetGameSessionQueues sets the GameSessionQueues field's value.
func (s *DescribeGameSessionQueuesOutput) SetGameSessionQueues(v []*GameSessionQueue) *DescribeGameSessionQueuesOutput {
	s.GameSessionQueues = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionQueuesOutput) SetNextToken(v string) *DescribeGameSessionQueuesOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionsInput
type DescribeGameSessionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for an alias associated with the fleet to retrieve all
	// game sessions for.
	AliasId *string `type:"string"`

	// Unique identifier for a fleet to retrieve all game sessions for.
	FleetId *string `type:"string"`

	// Unique identifier for the game session to retrieve. You can use either a
	// GameSessionId or GameSessionArn value.
	GameSessionId *string `min:"1" type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Game session status to filter results on. Possible game session statuses
	// include ACTIVE, TERMINATED, ACTIVATING, and TERMINATING (the last two are
	// transitory).
	StatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionsInput"}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StatusFilter != nil && len(*s.StatusFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeGameSessionsInput) SetAliasId(v string) *DescribeGameSessionsInput {
	s.AliasId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeGameSessionsInput) SetFleetId(v string) *DescribeGameSessionsInput {
	s.FleetId = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *DescribeGameSessionsInput) SetGameSessionId(v string) *DescribeGameSessionsInput {
	s.GameSessionId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeGameSessionsInput) SetLimit(v int64) *DescribeGameSessionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionsInput) SetNextToken(v string) *DescribeGameSessionsInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *DescribeGameSessionsInput) SetStatusFilter(v string) *DescribeGameSessionsInput {
	s.StatusFilter = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionsOutput
type DescribeGameSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing game session properties for each session
	// matching the request.
	GameSessions []*GameSession `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionsOutput) GoString() string {
	return s.String()
}

// SetGameSessions sets the GameSessions field's value.
func (s *DescribeGameSessionsOutput) SetGameSessions(v []*GameSession) *DescribeGameSessionsOutput {
	s.GameSessions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionsOutput) SetNextToken(v string) *DescribeGameSessionsOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstancesInput
type DescribeInstancesInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to retrieve instance information for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Unique identifier for an instance to retrieve. Specify an instance ID or
	// leave blank to retrieve all instances in the fleet.
	InstanceId *string `type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstancesInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeInstancesInput) SetFleetId(v string) *DescribeInstancesInput {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeInstancesInput) SetInstanceId(v string) *DescribeInstancesInput {
	s.InstanceId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeInstancesInput) SetLimit(v int64) *DescribeInstancesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancesInput) SetNextToken(v string) *DescribeInstancesInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstancesOutput
type DescribeInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing properties for each instance returned.
	Instances []*Instance `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *DescribeInstancesOutput) SetInstances(v []*Instance) *DescribeInstancesOutput {
	s.Instances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancesOutput) SetNextToken(v string) *DescribeInstancesOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessionsInput
type DescribePlayerSessionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to retrieve player sessions for.
	GameSessionId *string `min:"1" type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. If a player session ID is specified,
	// this parameter is ignored.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value. If a player session
	// ID is specified, this parameter is ignored.
	NextToken *string `min:"1" type:"string"`

	// Unique identifier for a player to retrieve player sessions for.
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session to retrieve.
	PlayerSessionId *string `type:"string"`

	// Player session status to filter results on.
	//
	// Possible player session statuses include the following:
	//
	//    * RESERVED – The player session request has been received, but the player
	//    has not yet connected to the server process and/or been validated.
	//
	//    * ACTIVE – The player has been validated by the server process and is
	//    currently connected.
	//
	//    * COMPLETED – The player connection has been dropped.
	//
	//    * TIMEDOUT – A player session request was received, but the player did
	//    not connect and/or was not validated within the time-out limit (60 seconds).
	PlayerSessionStatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribePlayerSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlayerSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePlayerSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePlayerSessionsInput"}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}
	if s.PlayerSessionStatusFilter != nil && len(*s.PlayerSessionStatusFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerSessionStatusFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *DescribePlayerSessionsInput) SetGameSessionId(v string) *DescribePlayerSessionsInput {
	s.GameSessionId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribePlayerSessionsInput) SetLimit(v int64) *DescribePlayerSessionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePlayerSessionsInput) SetNextToken(v string) *DescribePlayerSessionsInput {
	s.NextToken = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *DescribePlayerSessionsInput) SetPlayerId(v string) *DescribePlayerSessionsInput {
	s.PlayerId = &v
	return s
}

// SetPlayerSessionId sets the PlayerSessionId field's value.
func (s *DescribePlayerSessionsInput) SetPlayerSessionId(v string) *DescribePlayerSessionsInput {
	s.PlayerSessionId = &v
	return s
}

// SetPlayerSessionStatusFilter sets the PlayerSessionStatusFilter field's value.
func (s *DescribePlayerSessionsInput) SetPlayerSessionStatusFilter(v string) *DescribePlayerSessionsInput {
	s.PlayerSessionStatusFilter = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessionsOutput
type DescribePlayerSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`

	// Collection of objects containing properties for each player session that
	// matches the request.
	PlayerSessions []*PlayerSession `type:"list"`
}

// String returns the string representation
func (s DescribePlayerSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlayerSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePlayerSessionsOutput) SetNextToken(v string) *DescribePlayerSessionsOutput {
	s.NextToken = &v
	return s
}

// SetPlayerSessions sets the PlayerSessions field's value.
func (s *DescribePlayerSessionsOutput) SetPlayerSessions(v []*PlayerSession) *DescribePlayerSessionsOutput {
	s.PlayerSessions = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfigurationInput
type DescribeRuntimeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to get the run-time configuration for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRuntimeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuntimeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuntimeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRuntimeConfigurationInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeRuntimeConfigurationInput) SetFleetId(v string) *DescribeRuntimeConfigurationInput {
	s.FleetId = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfigurationOutput
type DescribeRuntimeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Instructions describing how server processes should be launched and maintained
	// on each instance in the fleet.
	RuntimeConfiguration *RuntimeConfiguration `type:"structure"`
}

// String returns the string representation
func (s DescribeRuntimeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuntimeConfigurationOutput) GoString() string {
	return s.String()
}

// SetRuntimeConfiguration sets the RuntimeConfiguration field's value.
func (s *DescribeRuntimeConfigurationOutput) SetRuntimeConfiguration(v *RuntimeConfiguration) *DescribeRuntimeConfigurationOutput {
	s.RuntimeConfiguration = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPoliciesInput
type DescribeScalingPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to retrieve scaling policies for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Scaling policy status to filter results on. A scaling policy is only in force
	// when in an ACTIVE status.
	//
	//    * ACTIVE – The scaling policy is currently in force.
	//
	//    * UPDATEREQUESTED – A request to update the scaling policy has been received.
	//
	//    * UPDATING – A change is being made to the scaling policy.
	//
	//    * DELETEREQUESTED – A request to delete the scaling policy has been received.
	//
	//    * DELETING – The scaling policy is being deleted.
	//
	//    * DELETED – The scaling policy has been deleted.
	//
	//    * ERROR – An error occurred in creating the policy. It should be removed
	//    and recreated.
	StatusFilter *string `type:"string" enum:"ScalingStatusType"`
}

// String returns the string representation
func (s DescribeScalingPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingPoliciesInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeScalingPoliciesInput) SetFleetId(v string) *DescribeScalingPoliciesInput {
	s.FleetId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeScalingPoliciesInput) SetLimit(v int64) *DescribeScalingPoliciesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPoliciesInput) SetNextToken(v string) *DescribeScalingPoliciesInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *DescribeScalingPoliciesInput) SetStatusFilter(v string) *DescribeScalingPoliciesInput {
	s.StatusFilter = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPoliciesOutput
type DescribeScalingPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`

	// Collection of objects containing the scaling policies matching the request.
	ScalingPolicies []*ScalingPolicy `type:"list"`
}

// String returns the string representation
func (s DescribeScalingPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPoliciesOutput) SetNextToken(v string) *DescribeScalingPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetScalingPolicies sets the ScalingPolicies field's value.
func (s *DescribeScalingPoliciesOutput) SetScalingPolicies(v []*ScalingPolicy) *DescribeScalingPoliciesOutput {
	s.ScalingPolicies = v
	return s
}

// Player information for use when creating player sessions using a game session
// placement request with StartGameSessionPlacement.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DesiredPlayerSession
type DesiredPlayerSession struct {
	_ struct{} `type:"structure"`

	// Developer-defined information related to a player. Amazon GameLift does not
	// use this data, so it can be formatted as needed for use in the game.
	PlayerData *string `min:"1" type:"string"`

	// Unique identifier for a player to associate with the player session.
	PlayerId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DesiredPlayerSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DesiredPlayerSession) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DesiredPlayerSession) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DesiredPlayerSession"}
	if s.PlayerData != nil && len(*s.PlayerData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerData", 1))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlayerData sets the PlayerData field's value.
func (s *DesiredPlayerSession) SetPlayerData(v string) *DesiredPlayerSession {
	s.PlayerData = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *DesiredPlayerSession) SetPlayerId(v string) *DesiredPlayerSession {
	s.PlayerId = &v
	return s
}

// Current status of fleet capacity. The number of active instances should match
// or be in the process of matching the number of desired instances. Pending
// and terminating counts are non-zero only if fleet capacity is adjusting to
// an UpdateFleetCapacity request, or if access to resources is temporarily
// affected.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/EC2InstanceCounts
type EC2InstanceCounts struct {
	_ struct{} `type:"structure"`

	// Actual number of active instances in the fleet.
	ACTIVE *int64 `type:"integer"`

	// Ideal number of active instances in the fleet.
	DESIRED *int64 `type:"integer"`

	// Number of active instances in the fleet that are not currently hosting a
	// game session.
	IDLE *int64 `type:"integer"`

	// Maximum value allowed for the fleet's instance count.
	MAXIMUM *int64 `type:"integer"`

	// Minimum value allowed for the fleet's instance count.
	MINIMUM *int64 `type:"integer"`

	// Number of instances in the fleet that are starting but not yet active.
	PENDING *int64 `type:"integer"`

	// Number of instances in the fleet that are no longer active but haven't yet
	// been terminated.
	TERMINATING *int64 `type:"integer"`
}

// String returns the string representation
func (s EC2InstanceCounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2InstanceCounts) GoString() string {
	return s.String()
}

// SetACTIVE sets the ACTIVE field's value.
func (s *EC2InstanceCounts) SetACTIVE(v int64) *EC2InstanceCounts {
	s.ACTIVE = &v
	return s
}

// SetDESIRED sets the DESIRED field's value.
func (s *EC2InstanceCounts) SetDESIRED(v int64) *EC2InstanceCounts {
	s.DESIRED = &v
	return s
}

// SetIDLE sets the IDLE field's value.
func (s *EC2InstanceCounts) SetIDLE(v int64) *EC2InstanceCounts {
	s.IDLE = &v
	return s
}

// SetMAXIMUM sets the MAXIMUM field's value.
func (s *EC2InstanceCounts) SetMAXIMUM(v int64) *EC2InstanceCounts {
	s.MAXIMUM = &v
	return s
}

// SetMINIMUM sets the MINIMUM field's value.
func (s *EC2InstanceCounts) SetMINIMUM(v int64) *EC2InstanceCounts {
	s.MINIMUM = &v
	return s
}

// SetPENDING sets the PENDING field's value.
func (s *EC2InstanceCounts) SetPENDING(v int64) *EC2InstanceCounts {
	s.PENDING = &v
	return s
}

// SetTERMINATING sets the TERMINATING field's value.
func (s *EC2InstanceCounts) SetTERMINATING(v int64) *EC2InstanceCounts {
	s.TERMINATING = &v
	return s
}

// Maximum number of instances allowed based on the Amazon Elastic Compute Cloud
// (Amazon EC2) instance type. Instance limits can be retrieved by calling DescribeEC2InstanceLimits.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/EC2InstanceLimit
type EC2InstanceLimit struct {
	_ struct{} `type:"structure"`

	// Number of instances of the specified type that are currently in use by this
	// AWS account.
	CurrentInstances *int64 `type:"integer"`

	// Name of an EC2 instance type that is supported in Amazon GameLift. A fleet
	// instance type determines the computing resources of each instance in the
	// fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
	// supports the following EC2 instance types. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	EC2InstanceType *string `type:"string" enum:"EC2InstanceType"`

	// Number of instances allowed.
	InstanceLimit *int64 `type:"integer"`
}

// String returns the string representation
func (s EC2InstanceLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2InstanceLimit) GoString() string {
	return s.String()
}

// SetCurrentInstances sets the CurrentInstances field's value.
func (s *EC2InstanceLimit) SetCurrentInstances(v int64) *EC2InstanceLimit {
	s.CurrentInstances = &v
	return s
}

// SetEC2InstanceType sets the EC2InstanceType field's value.
func (s *EC2InstanceLimit) SetEC2InstanceType(v string) *EC2InstanceLimit {
	s.EC2InstanceType = &v
	return s
}

// SetInstanceLimit sets the InstanceLimit field's value.
func (s *EC2InstanceLimit) SetInstanceLimit(v int64) *EC2InstanceLimit {
	s.InstanceLimit = &v
	return s
}

// Log entry describing an event that involves Amazon GameLift resources (such
// as a fleet). In addition to tracking activity, event codes and messages can
// provide additional information for troubleshooting and debugging problems.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/Event
type Event struct {
	_ struct{} `type:"structure"`

	// Type of event being logged. The following events are currently in use:
	//
	//    * General events:
	//
	// GENERIC_EVENT – An unspecified event has occurred.
	//
	//    * Fleet creation events:
	//
	// FLEET_CREATED – A fleet record was successfully created with a status of
	//    NEW. Event messaging includes the fleet ID.
	//
	// FLEET_STATE_DOWNLOADING – Fleet status changed from NEW to DOWNLOADING. The
	//    compressed build has started downloading to a fleet instance for installation.
	//
	// FLEET_BINARY_DOWNLOAD_FAILED – The build failed to download to the fleet
	//    instance.
	//
	// FLEET_CREATION_EXTRACTING_BUILD – The game server build was successfully
	//    downloaded to an instance, and the build files are now being extracted
	//    from the uploaded build and saved to an instance. Failure at this stage
	//    prevents a fleet from moving to ACTIVE status. Logs for this stage display
	//    a list of the files that are extracted and saved on the instance. Access
	//    the logs by using the URL in PreSignedLogUrl).
	//
	// FLEET_CREATION_RUNNING_INSTALLER – The game server build files were successfully
	//    extracted, and the Amazon GameLift is now running the build's install
	//    script (if one is included). Failure in this stage prevents a fleet from
	//    moving to ACTIVE status. Logs for this stage list the installation steps
	//    and whether or not the install completed sucessfully. Access the logs
	//    by using the URL in PreSignedLogUrl).
	//
	// FLEET_CREATION_VALIDATING_RUNTIME_CONFIG – The build process was successful,
	//    and the Amazon GameLift is now verifying that the game server launch path(s),
	//    which are specified in the fleet's run-time configuration, exist. If any
	//    listed launch path exists, Amazon GameLift tries to launch a game server
	//    process and waits for the process to report ready. Failures in this stage
	//    prevent a fleet from moving to ACTIVE status. Logs for this stage list
	//    the launch paths in the run-time configuration and indicate whether each
	//    is found. Access the logs by using the URL in PreSignedLogUrl). Once the
	//    game server is launched, failures and crashes are logged; these logs can
	//    be downloaded from the Amazon GameLift console.
	//
	// FLEET_STATE_VALIDATING – Fleet status changed from DOWNLOADING to VALIDATING.
	//
	// FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND – Validation of the run-time validation
	//    failed because the executable specified in a launch path does not exist
	//    on the instance.
	//
	// FLEET_STATE_BUILDING – Fleet status changed from VALIDATING to BUILDING.
	//
	// FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE – Validation of the runtime validation
	//    failed because the executable specified in a launch path failed to run
	//    on the fleet instance.
	//
	// FLEET_STATE_ACTIVATING – Fleet status changed from BUILDING to ACTIVATING.
	//
	//
	// FLEET_ACTIVATION_FAILED - The fleet failed to successfully complete one of
	//    the steps in the fleet activation process. This event code indicates that
	//    the game build was successfully downloaded to a fleet instance, built,
	//    and validated, but was not able to start a server process. A possible
	//    reason for failure is that the game server is not reporting "process ready"
	//    to the Amazon GameLift service.
	//
	// FLEET_STATE_ACTIVE – The fleet's status changed from ACTIVATING to ACTIVE.
	//    The fleet is now ready to host game sessions.
	//
	//    * Other fleet events:
	//
	// FLEET_SCALING_EVENT – A change was made to the fleet's capacity settings
	//    (desired instances, minimum/maximum scaling limits). Event messaging includes
	//    the new capacity settings.
	//
	// FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED – A change was made to the
	//    fleet's game session protection policy setting. Event messaging includes
	//    both the old and new policy setting.
	//
	// FLEET_DELETED – A request to delete a fleet was initiated.
	EventCode *string `type:"string" enum:"EventCode"`

	// Unique identifier for a fleet event.
	EventId *string `min:"1" type:"string"`

	// Time stamp indicating when this event occurred. Format is a number expressed
	// in Unix time as milliseconds (for example "1469498468.057").
	EventTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Additional information related to the event.
	Message *string `min:"1" type:"string"`

	// Location of stored logs with additional detail related to the event, useful
	// for debugging issues. The URL is valid for 15 minutes. Fleet creation logs
	// can also be accessed through the Amazon GameLift console.
	PreSignedLogUrl *string `min:"1" type:"string"`

	// Unique identifier for an event resource, such as a fleet ID.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetEventCode sets the EventCode field's value.
func (s *Event) SetEventCode(v string) *Event {
	s.EventCode = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *Event) SetEventId(v string) *Event {
	s.EventId = &v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *Event) SetEventTime(v time.Time) *Event {
	s.EventTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetPreSignedLogUrl sets the PreSignedLogUrl field's value.
func (s *Event) SetPreSignedLogUrl(v string) *Event {
	s.PreSignedLogUrl = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *Event) SetResourceId(v string) *Event {
	s.ResourceId = &v
	return s
}

// General properties describing a fleet.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/FleetAttributes
type FleetAttributes struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build.
	BuildId *string `type:"string"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Human-readable description of the fleet.
	Description *string `min:"1" type:"string"`

	// Identifier for a fleet that is unique across all regions.
	FleetArn *string `min:"1" type:"string"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Location of default log files. When a server process is shut down, Amazon
	// GameLift captures and stores any log files in this location. These logs are
	// in addition to game session logs; see more on game session logs in the Amazon
	// GameLift Developer Guide (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-api-server-code).
	// If no default log path for a fleet is specified, Amazon GameLift automatically
	// uploads logs that are stored on each instance at C:\game\logs (for Windows)
	// or /local/game/logs (for Linux). Use the Amazon GameLift console to access
	// stored logs.
	LogPaths []*string `type:"list"`

	// Names of metric groups that this fleet is included in. In Amazon CloudWatch,
	// you can view metrics for an individual fleet or aggregated metrics for fleets
	// that are in a fleet metric group. A fleet can be included in only one metric
	// group at a time.
	MetricGroups []*string `type:"list"`

	// Descriptive label that is associated with a fleet. Fleet names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Type of game session protection to set for all new instances started in the
	// fleet.
	//
	//    * NoProtection – The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection – If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	NewGameSessionProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`

	// Operating system of the fleet's computing resources. A fleet's operating
	// system depends on the OS specified for the build that is deployed on this
	// fleet.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// Fleet policy to limit the number of game sessions an individual player can
	// create over a span of time.
	ResourceCreationLimitPolicy *ResourceCreationLimitPolicy `type:"structure"`

	// Game server launch parameters specified for fleets created before 2016-08-04
	// (or AWS SDK v. 0.12.16). Server launch parameters for fleets created after
	// this date are specified in the fleet's RuntimeConfiguration.
	ServerLaunchParameters *string `min:"1" type:"string"`

	// Path to a game server executable in the fleet's build, specified for fleets
	// created before 2016-08-04 (or AWS SDK v. 0.12.16). Server launch paths for
	// fleets created after this date are specified in the fleet's RuntimeConfiguration.
	ServerLaunchPath *string `min:"1" type:"string"`

	// Current status of the fleet.
	//
	// Possible fleet statuses include the following:
	//
	//    * NEW – A new fleet has been defined and desired instances is set to 1.
	//
	//
	//    * DOWNLOADING/VALIDATING/BUILDING/ACTIVATING – Amazon GameLift is setting
	//    up the new fleet, creating new instances with the game build and starting
	//    server processes.
	//
	//    * ACTIVE – Hosts can now accept game sessions.
	//
	//    * ERROR – An error occurred when downloading, validating, building, or
	//    activating the fleet.
	//
	//    * DELETING – Hosts are responding to a delete fleet request.
	//
	//    * TERMINATED – The fleet no longer exists.
	Status *string `type:"string" enum:"FleetStatus"`

	// Time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s FleetAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetAttributes) GoString() string {
	return s.String()
}

// SetBuildId sets the BuildId field's value.
func (s *FleetAttributes) SetBuildId(v string) *FleetAttributes {
	s.BuildId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *FleetAttributes) SetCreationTime(v time.Time) *FleetAttributes {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FleetAttributes) SetDescription(v string) *FleetAttributes {
	s.Description = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *FleetAttributes) SetFleetArn(v string) *FleetAttributes {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *FleetAttributes) SetFleetId(v string) *FleetAttributes {
	s.FleetId = &v
	return s
}

// SetLogPaths sets the LogPaths field's value.
func (s *FleetAttributes) SetLogPaths(v []*string) *FleetAttributes {
	s.LogPaths = v
	return s
}

// SetMetricGroups sets the MetricGroups field's value.
func (s *FleetAttributes) SetMetricGroups(v []*string) *FleetAttributes {
	s.MetricGroups = v
	return s
}

// SetName sets the Name field's value.
func (s *FleetAttributes) SetName(v string) *FleetAttributes {
	s.Name = &v
	return s
}

// SetNewGameSessionProtectionPolicy sets the NewGameSessionProtectionPolicy field's value.
func (s *FleetAttributes) SetNewGameSessionProtectionPolicy(v string) *FleetAttributes {
	s.NewGameSessionProtectionPolicy = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *FleetAttributes) SetOperatingSystem(v string) *FleetAttributes {
	s.OperatingSystem = &v
	return s
}

// SetResourceCreationLimitPolicy sets the ResourceCreationLimitPolicy field's value.
func (s *FleetAttributes) SetResourceCreationLimitPolicy(v *ResourceCreationLimitPolicy) *FleetAttributes {
	s.ResourceCreationLimitPolicy = v
	return s
}

// SetServerLaunchParameters sets the ServerLaunchParameters field's value.
func (s *FleetAttributes) SetServerLaunchParameters(v string) *FleetAttributes {
	s.ServerLaunchParameters = &v
	return s
}

// SetServerLaunchPath sets the ServerLaunchPath field's value.
func (s *FleetAttributes) SetServerLaunchPath(v string) *FleetAttributes {
	s.ServerLaunchPath = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FleetAttributes) SetStatus(v string) *FleetAttributes {
	s.Status = &v
	return s
}

// SetTerminationTime sets the TerminationTime field's value.
func (s *FleetAttributes) SetTerminationTime(v time.Time) *FleetAttributes {
	s.TerminationTime = &v
	return s
}

// Information about the fleet's capacity. Fleet capacity is measured in EC2
// instances. By default, new fleets have a capacity of one instance, but can
// be updated as needed. The maximum number of instances for a fleet is determined
// by the fleet's instance type.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/FleetCapacity
type FleetCapacity struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Current status of fleet capacity.
	InstanceCounts *EC2InstanceCounts `type:"structure"`

	// Name of an EC2 instance type that is supported in Amazon GameLift. A fleet
	// instance type determines the computing resources of each instance in the
	// fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
	// supports the following EC2 instance types. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	InstanceType *string `type:"string" enum:"EC2InstanceType"`
}

// String returns the string representation
func (s FleetCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetCapacity) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *FleetCapacity) SetFleetId(v string) *FleetCapacity {
	s.FleetId = &v
	return s
}

// SetInstanceCounts sets the InstanceCounts field's value.
func (s *FleetCapacity) SetInstanceCounts(v *EC2InstanceCounts) *FleetCapacity {
	s.InstanceCounts = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *FleetCapacity) SetInstanceType(v string) *FleetCapacity {
	s.InstanceType = &v
	return s
}

// Current status of fleet utilization, including the number of game and player
// sessions being hosted.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/FleetUtilization
type FleetUtilization struct {
	_ struct{} `type:"structure"`

	// Number of active game sessions currently being hosted on all instances in
	// the fleet.
	ActiveGameSessionCount *int64 `type:"integer"`

	// Number of server processes in an ACTIVE status currently running across all
	// instances in the fleet
	ActiveServerProcessCount *int64 `type:"integer"`

	// Number of active player sessions currently being hosted on all instances
	// in the fleet.
	CurrentPlayerSessionCount *int64 `type:"integer"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Maximum players allowed across all game sessions currently being hosted on
	// all instances in the fleet.
	MaximumPlayerSessionCount *int64 `type:"integer"`
}

// String returns the string representation
func (s FleetUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetUtilization) GoString() string {
	return s.String()
}

// SetActiveGameSessionCount sets the ActiveGameSessionCount field's value.
func (s *FleetUtilization) SetActiveGameSessionCount(v int64) *FleetUtilization {
	s.ActiveGameSessionCount = &v
	return s
}

// SetActiveServerProcessCount sets the ActiveServerProcessCount field's value.
func (s *FleetUtilization) SetActiveServerProcessCount(v int64) *FleetUtilization {
	s.ActiveServerProcessCount = &v
	return s
}

// SetCurrentPlayerSessionCount sets the CurrentPlayerSessionCount field's value.
func (s *FleetUtilization) SetCurrentPlayerSessionCount(v int64) *FleetUtilization {
	s.CurrentPlayerSessionCount = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *FleetUtilization) SetFleetId(v string) *FleetUtilization {
	s.FleetId = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *FleetUtilization) SetMaximumPlayerSessionCount(v int64) *FleetUtilization {
	s.MaximumPlayerSessionCount = &v
	return s
}

// Set of key-value pairs containing information a server process requires to
// set up a game session. This object allows you to pass in any set of data
// needed for your game. For more information, see the Amazon GameLift Developer
// Guide (http://docs.aws.amazon.com/gamelift/latest/developerguide/).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameProperty
type GameProperty struct {
	_ struct{} `type:"structure"`

	// TBD
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// TBD
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GameProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GameProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GameProperty"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *GameProperty) SetKey(v string) *GameProperty {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *GameProperty) SetValue(v string) *GameProperty {
	s.Value = &v
	return s
}

// Properties describing a game session.
//
// Game-session-related operations include:
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameSession
type GameSession struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for a player. This ID is used to enforce a resource protection
	// policy (if one exists), that limits the number of game sessions a player
	// can create.
	CreatorId *string `min:"1" type:"string"`

	// Number of players currently in the game session.
	CurrentPlayerSessionCount *int64 `type:"integer"`

	// Unique identifier for a fleet the game session is running on.
	FleetId *string `type:"string"`

	// Set of developer-defined properties for a game session. These properties
	// are passed to the server process hosting the game session.
	GameProperties []*GameProperty `type:"list"`

	// Unique identifier for the game session. A game session ID has the following
	// format: arn:aws:gamelift:<region>::gamesession/<fleet ID>/<custom ID string
	// or idempotency token>.
	GameSessionId *string `min:"1" type:"string"`

	// IP address of the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	IpAddress *string `type:"string"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	Name *string `min:"1" type:"string"`

	// Indicates whether or not the game session is accepting new players.
	PlayerSessionCreationPolicy *string `type:"string" enum:"PlayerSessionCreationPolicy"`

	// Port number for the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	Port *int64 `min:"1" type:"integer"`

	// Current status of the game session. A game session must have an ACTIVE status
	// to have player sessions.
	Status *string `type:"string" enum:"GameSessionStatus"`

	// Time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s GameSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSession) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GameSession) SetCreationTime(v time.Time) *GameSession {
	s.CreationTime = &v
	return s
}

// SetCreatorId sets the CreatorId field's value.
func (s *GameSession) SetCreatorId(v string) *GameSession {
	s.CreatorId = &v
	return s
}

// SetCurrentPlayerSessionCount sets the CurrentPlayerSessionCount field's value.
func (s *GameSession) SetCurrentPlayerSessionCount(v int64) *GameSession {
	s.CurrentPlayerSessionCount = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GameSession) SetFleetId(v string) *GameSession {
	s.FleetId = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *GameSession) SetGameProperties(v []*GameProperty) *GameSession {
	s.GameProperties = v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *GameSession) SetGameSessionId(v string) *GameSession {
	s.GameSessionId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *GameSession) SetIpAddress(v string) *GameSession {
	s.IpAddress = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *GameSession) SetMaximumPlayerSessionCount(v int64) *GameSession {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *GameSession) SetName(v string) *GameSession {
	s.Name = &v
	return s
}

// SetPlayerSessionCreationPolicy sets the PlayerSessionCreationPolicy field's value.
func (s *GameSession) SetPlayerSessionCreationPolicy(v string) *GameSession {
	s.PlayerSessionCreationPolicy = &v
	return s
}

// SetPort sets the Port field's value.
func (s *GameSession) SetPort(v int64) *GameSession {
	s.Port = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GameSession) SetStatus(v string) *GameSession {
	s.Status = &v
	return s
}

// SetTerminationTime sets the TerminationTime field's value.
func (s *GameSession) SetTerminationTime(v time.Time) *GameSession {
	s.TerminationTime = &v
	return s
}

// A game session's properties plus the protection policy currently in force.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameSessionDetail
type GameSessionDetail struct {
	_ struct{} `type:"structure"`

	// Object that describes a game session.
	GameSession *GameSession `type:"structure"`

	// Current status of protection for the game session.
	//
	//    * NoProtection – The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection – If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	ProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`
}

// String returns the string representation
func (s GameSessionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSessionDetail) GoString() string {
	return s.String()
}

// SetGameSession sets the GameSession field's value.
func (s *GameSessionDetail) SetGameSession(v *GameSession) *GameSessionDetail {
	s.GameSession = v
	return s
}

// SetProtectionPolicy sets the ProtectionPolicy field's value.
func (s *GameSessionDetail) SetProtectionPolicy(v string) *GameSessionDetail {
	s.ProtectionPolicy = &v
	return s
}

// Object that describes a StartGameSessionPlacement request. This object includes
// the full details of the original request plus the current status and start/end
// time stamps.
//
// Game session placement-related operations include:
//
//    * StartGameSessionPlacement
//
//    * DescribeGameSessionPlacement
//
//    * StopGameSessionPlacement
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameSessionPlacement
type GameSessionPlacement struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this request was completed, canceled, or timed
	// out.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Set of developer-defined properties for a game session. These properties
	// are passed to the server process hosting the game session.
	GameProperties []*GameProperty `type:"list"`

	// Identifier for the game session created by this placement request. This value
	// is set once the new game session is placed (placement status is Fulfilled).
	// This identifier is unique across all regions. You can use this value as a
	// GameSessionId value as needed.
	GameSessionArn *string `min:"1" type:"string"`

	// Unique identifier for the game session. This value is set once the new game
	// session is placed (placement status is Fulfilled).
	GameSessionId *string `min:"1" type:"string"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	GameSessionName *string `min:"1" type:"string"`

	// Descriptive label that is associated with queue. Queue names must be unique
	// within each region.
	GameSessionQueueName *string `min:"1" type:"string"`

	// Name of the region where the game session created by this placement request
	// is running. This value is set once the new game session is placed (placement
	// status is Fulfilled).
	GameSessionRegion *string `min:"1" type:"string"`

	// IP address of the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number. This value is set once
	// the new game session is placed (placement status is Fulfilled).
	IpAddress *string `type:"string"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// Collection of information on player sessions created in response to the game
	// session placement request. These player sessions are created only once a
	// new game session is successfully placed (placement status is Fulfilled).
	// This information includes the player ID (as provided in the placement request)
	// and the corresponding player session ID. Retrieve full player sessions by
	// calling DescribePlayerSessions with the player session ID.
	PlacedPlayerSessions []*PlacedPlayerSession `type:"list"`

	// Unique identifier for a game session placement.
	PlacementId *string `min:"1" type:"string"`

	// Set of values, expressed in milliseconds, indicating the amount of latency
	// that players are experiencing when connected to AWS regions.
	PlayerLatencies []*PlayerLatency `type:"list"`

	// Port number for the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number. This value is set once
	// the new game session is placed (placement status is Fulfilled).
	Port *int64 `min:"1" type:"integer"`

	// Time stamp indicating when this request was placed in the queue. Format is
	// a number expressed in Unix time as milliseconds (for example "1469498468.057").
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Current status of the game session placement request.
	//
	//    * PENDING – The placement request is currently in the queue waiting to
	//    be processed.
	//
	//    * FULFILLED – A new game session and player sessions (if requested) have
	//    been successfully created. Values for GameSessionArn and GameSessionRegion
	//    are available.
	//
	//    * CANCELLED – The placement request was canceled with a call to StopGameSessionPlacement.
	//
	//    * TIMED_OUT – A new game session was not successfully created before the
	//    time limit expired. You can resubmit the placement request as needed.
	Status *string `type:"string" enum:"GameSessionPlacementState"`
}

// String returns the string representation
func (s GameSessionPlacement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSessionPlacement) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *GameSessionPlacement) SetEndTime(v time.Time) *GameSessionPlacement {
	s.EndTime = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *GameSessionPlacement) SetGameProperties(v []*GameProperty) *GameSessionPlacement {
	s.GameProperties = v
	return s
}

// SetGameSessionArn sets the GameSessionArn field's value.
func (s *GameSessionPlacement) SetGameSessionArn(v string) *GameSessionPlacement {
	s.GameSessionArn = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *GameSessionPlacement) SetGameSessionId(v string) *GameSessionPlacement {
	s.GameSessionId = &v
	return s
}

// SetGameSessionName sets the GameSessionName field's value.
func (s *GameSessionPlacement) SetGameSessionName(v string) *GameSessionPlacement {
	s.GameSessionName = &v
	return s
}

// SetGameSessionQueueName sets the GameSessionQueueName field's value.
func (s *GameSessionPlacement) SetGameSessionQueueName(v string) *GameSessionPlacement {
	s.GameSessionQueueName = &v
	return s
}

// SetGameSessionRegion sets the GameSessionRegion field's value.
func (s *GameSessionPlacement) SetGameSessionRegion(v string) *GameSessionPlacement {
	s.GameSessionRegion = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *GameSessionPlacement) SetIpAddress(v string) *GameSessionPlacement {
	s.IpAddress = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *GameSessionPlacement) SetMaximumPlayerSessionCount(v int64) *GameSessionPlacement {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetPlacedPlayerSessions sets the PlacedPlayerSessions field's value.
func (s *GameSessionPlacement) SetPlacedPlayerSessions(v []*PlacedPlayerSession) *GameSessionPlacement {
	s.PlacedPlayerSessions = v
	return s
}

// SetPlacementId sets the PlacementId field's value.
func (s *GameSessionPlacement) SetPlacementId(v string) *GameSessionPlacement {
	s.PlacementId = &v
	return s
}

// SetPlayerLatencies sets the PlayerLatencies field's value.
func (s *GameSessionPlacement) SetPlayerLatencies(v []*PlayerLatency) *GameSessionPlacement {
	s.PlayerLatencies = v
	return s
}

// SetPort sets the Port field's value.
func (s *GameSessionPlacement) SetPort(v int64) *GameSessionPlacement {
	s.Port = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GameSessionPlacement) SetStartTime(v time.Time) *GameSessionPlacement {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GameSessionPlacement) SetStatus(v string) *GameSessionPlacement {
	s.Status = &v
	return s
}

// Configuration of a queue that is used to process game session placement requests.
// The queue configuration identifies several game features:
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
//
//    * The destinations where a new game session can potentially be hosted.
//    Amazon GameLift tries these destinations in an order based on either the
//    queue's default order or player latency information, if provided in a
//    placement request. With latency information, Amazon GameLift can place
//    game sessions where the majority of players are reporting the lowest possible
//    latency.
//
//    * The length of time that placement requests can wait in the queue before
//    timing out.
//
//    * A set of optional latency policies that protect individual players from
//    high latencies, preventing game sessions from being placed where any individual
//    player is reporting latency higher than a policy's maximum.
//
// Queue-related operations include the following:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameSessionQueue
type GameSessionQueue struct {
	_ struct{} `type:"structure"`

	// List of fleets that can be used to fulfill game session placement requests
	// in the queue. Fleets are identified by either a fleet ARN or a fleet alias
	// ARN. Destinations are listed in default preference order.
	Destinations []*GameSessionQueueDestination `type:"list"`

	// Amazon Resource Name (ARN (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a game session queue and uniquely identifies it. Format
	// is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	GameSessionQueueArn *string `min:"1" type:"string"`

	// Descriptive label that is associated with queue. Queue names must be unique
	// within each region.
	Name *string `min:"1" type:"string"`

	// Collection of latency policies to apply when processing game sessions placement
	// requests with player latency information. Multiple policies are evaluated
	// in order of the maximum latency value, starting with the lowest latency values.
	// With just one policy, it is enforced at the start of the game session placement
	// for the duration period. With multiple policies, each policy is enforced
	// consecutively for its duration period. For example, a queue might enforce
	// a 60-second policy followed by a 120-second policy, and then no policy for
	// the remainder of the placement.
	PlayerLatencyPolicies []*PlayerLatencyPolicy `type:"list"`

	// Maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status.
	TimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s GameSessionQueue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSessionQueue) GoString() string {
	return s.String()
}

// SetDestinations sets the Destinations field's value.
func (s *GameSessionQueue) SetDestinations(v []*GameSessionQueueDestination) *GameSessionQueue {
	s.Destinations = v
	return s
}

// SetGameSessionQueueArn sets the GameSessionQueueArn field's value.
func (s *GameSessionQueue) SetGameSessionQueueArn(v string) *GameSessionQueue {
	s.GameSessionQueueArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GameSessionQueue) SetName(v string) *GameSessionQueue {
	s.Name = &v
	return s
}

// SetPlayerLatencyPolicies sets the PlayerLatencyPolicies field's value.
func (s *GameSessionQueue) SetPlayerLatencyPolicies(v []*PlayerLatencyPolicy) *GameSessionQueue {
	s.PlayerLatencyPolicies = v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *GameSessionQueue) SetTimeoutInSeconds(v int64) *GameSessionQueue {
	s.TimeoutInSeconds = &v
	return s
}

// Fleet designated in a game session queue. Requests for new game sessions
// in the queue are fulfilled by starting a new game session on any destination
// configured for a queue.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameSessionQueueDestination
type GameSessionQueueDestination struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) assigned to fleet or fleet alias. ARNs, which
	// include a fleet ID or alias ID and a region name, provide a unique identifier
	// across all regions.
	DestinationArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GameSessionQueueDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSessionQueueDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GameSessionQueueDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GameSessionQueueDestination"}
	if s.DestinationArn != nil && len(*s.DestinationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *GameSessionQueueDestination) SetDestinationArn(v string) *GameSessionQueueDestination {
	s.DestinationArn = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrlInput
type GetGameSessionLogUrlInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to get logs for.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGameSessionLogUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGameSessionLogUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGameSessionLogUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGameSessionLogUrlInput"}
	if s.GameSessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *GetGameSessionLogUrlInput) SetGameSessionId(v string) *GetGameSessionLogUrlInput {
	s.GameSessionId = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrlOutput
type GetGameSessionLogUrlOutput struct {
	_ struct{} `type:"structure"`

	// Location of the requested game session logs, available for download.
	PreSignedUrl *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetGameSessionLogUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGameSessionLogUrlOutput) GoString() string {
	return s.String()
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *GetGameSessionLogUrlOutput) SetPreSignedUrl(v string) *GetGameSessionLogUrlOutput {
	s.PreSignedUrl = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccessInput
type GetInstanceAccessInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet that contains the instance you want access
	// to. The fleet can be in any of the following statuses: ACTIVATING, ACTIVE,
	// or ERROR. Fleets with an ERROR status may be accessible for a short time
	// before they are deleted.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Unique identifier for an instance you want to get access to. You can access
	// an instance in any status.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceAccessInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *GetInstanceAccessInput) SetFleetId(v string) *GetInstanceAccessInput {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetInstanceAccessInput) SetInstanceId(v string) *GetInstanceAccessInput {
	s.InstanceId = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccessOutput
type GetInstanceAccessOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains connection information for a fleet instance, including
	// IP address and access credentials.
	InstanceAccess *InstanceAccess `type:"structure"`
}

// String returns the string representation
func (s GetInstanceAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceAccessOutput) GoString() string {
	return s.String()
}

// SetInstanceAccess sets the InstanceAccess field's value.
func (s *GetInstanceAccessOutput) SetInstanceAccess(v *InstanceAccess) *GetInstanceAccessOutput {
	s.InstanceAccess = v
	return s
}

// Properties that describe an instance of a virtual computing resource that
// hosts one or more game servers. A fleet contains zero or more instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/Instance
type Instance struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for a fleet that the instance is in.
	FleetId *string `type:"string"`

	// Unique identifier for an instance.
	InstanceId *string `type:"string"`

	// IP address assigned to the instance.
	IpAddress *string `type:"string"`

	// Operating system that is running on this instance.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// Current status of the instance. Possible statuses include the following:
	//
	//    * PENDING – The instance is in the process of being created and launching
	//    server processes as defined in the fleet's run-time configuration.
	//
	//    * ACTIVE – The instance has been successfully created and at least one
	//    server process has successfully launched and reported back to Amazon GameLift
	//    that it is ready to host a game session. The instance is now considered
	//    ready to host game sessions.
	//
	//    * TERMINATING – The instance is in the process of shutting down. This
	//    may happen to reduce capacity during a scaling down event or to recycle
	//    resources in the event of a problem.
	Status *string `type:"string" enum:"InstanceStatus"`

	// EC2 instance type that defines the computing resources of this instance.
	Type *string `type:"string" enum:"EC2InstanceType"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *Instance) SetCreationTime(v time.Time) *Instance {
	s.CreationTime = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *Instance) SetFleetId(v string) *Instance {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Instance) SetInstanceId(v string) *Instance {
	s.InstanceId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Instance) SetIpAddress(v string) *Instance {
	s.IpAddress = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *Instance) SetOperatingSystem(v string) *Instance {
	s.OperatingSystem = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Instance) SetStatus(v string) *Instance {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Instance) SetType(v string) *Instance {
	s.Type = &v
	return s
}

// Information required to remotely connect to a fleet instance. Access is requested
// by calling GetInstanceAccess.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/InstanceAccess
type InstanceAccess struct {
	_ struct{} `type:"structure"`

	// Credentials required to access the instance.
	Credentials *InstanceCredentials `type:"structure"`

	// Unique identifier for a fleet containing the instance being accessed.
	FleetId *string `type:"string"`

	// Unique identifier for an instance being accessed.
	InstanceId *string `type:"string"`

	// IP address assigned to the instance.
	IpAddress *string `type:"string"`

	// Operating system that is running on the instance.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`
}

// String returns the string representation
func (s InstanceAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceAccess) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *InstanceAccess) SetCredentials(v *InstanceCredentials) *InstanceAccess {
	s.Credentials = v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *InstanceAccess) SetFleetId(v string) *InstanceAccess {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceAccess) SetInstanceId(v string) *InstanceAccess {
	s.InstanceId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *InstanceAccess) SetIpAddress(v string) *InstanceAccess {
	s.IpAddress = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *InstanceAccess) SetOperatingSystem(v string) *InstanceAccess {
	s.OperatingSystem = &v
	return s
}

// Set of credentials required to remotely access a fleet instance. Access credentials
// are requested by calling GetInstanceAccess and returned in an InstanceAccess
// object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/InstanceCredentials
type InstanceCredentials struct {
	_ struct{} `type:"structure"`

	// Secret string. For Windows instances, the secret is a password for use with
	// Windows Remote Desktop. For Linux instances, it is a private key (which must
	// be saved as a .pem file) for use with SSH.
	Secret *string `min:"1" type:"string"`

	// User login string.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InstanceCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceCredentials) GoString() string {
	return s.String()
}

// SetSecret sets the Secret field's value.
func (s *InstanceCredentials) SetSecret(v string) *InstanceCredentials {
	s.Secret = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *InstanceCredentials) SetUserName(v string) *InstanceCredentials {
	s.UserName = &v
	return s
}

// A range of IP addresses and port settings that allow inbound traffic to connect
// to server processes on Amazon GameLift. Each game session hosted on a fleet
// is assigned a unique combination of IP address and port number, which must
// fall into the fleet's allowed ranges. This combination is included in the
// GameSession object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/IpPermission
type IpPermission struct {
	_ struct{} `type:"structure"`

	// Starting value for a range of allowed port numbers.
	//
	// FromPort is a required field
	FromPort *int64 `min:"1" type:"integer" required:"true"`

	// Range of allowed IP addresses. This value must be expressed in CIDR notation.
	// Example: "000.000.000.000/[subnet mask]" or optionally the shortened version
	// "0.0.0.0/[subnet mask]".
	//
	// IpRange is a required field
	IpRange *string `type:"string" required:"true"`

	// Network communication protocol used by the fleet.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true" enum:"IpProtocol"`

	// Ending value for a range of allowed port numbers. Port numbers are end-inclusive.
	// This value must be higher than FromPort.
	//
	// ToPort is a required field
	ToPort *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s IpPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpPermission) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IpPermission) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IpPermission"}
	if s.FromPort == nil {
		invalidParams.Add(request.NewErrParamRequired("FromPort"))
	}
	if s.FromPort != nil && *s.FromPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FromPort", 1))
	}
	if s.IpRange == nil {
		invalidParams.Add(request.NewErrParamRequired("IpRange"))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.ToPort == nil {
		invalidParams.Add(request.NewErrParamRequired("ToPort"))
	}
	if s.ToPort != nil && *s.ToPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ToPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromPort sets the FromPort field's value.
func (s *IpPermission) SetFromPort(v int64) *IpPermission {
	s.FromPort = &v
	return s
}

// SetIpRange sets the IpRange field's value.
func (s *IpPermission) SetIpRange(v string) *IpPermission {
	s.IpRange = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *IpPermission) SetProtocol(v string) *IpPermission {
	s.Protocol = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *IpPermission) SetToPort(v int64) *IpPermission {
	s.ToPort = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliasesInput
type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Descriptive label that is associated with an alias. Alias names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Type of routing to filter results on. Use this parameter to retrieve only
	// aliases of a certain type. To retrieve all aliases, leave this parameter
	// empty.
	//
	// Possible routing types include the following:
	//
	//    * SIMPLE – The alias resolves to one specific fleet. Use this type when
	//    routing to active fleets.
	//
	//    * TERMINAL – The alias does not resolve to a fleet but instead can be
	//    used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException
	//    with the RoutingStrategy message embedded.
	RoutingStrategyType *string `type:"string" enum:"RoutingStrategyType"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAliasesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListAliasesInput) SetLimit(v int64) *ListAliasesInput {
	s.Limit = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListAliasesInput) SetName(v string) *ListAliasesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesInput) SetNextToken(v string) *ListAliasesInput {
	s.NextToken = &v
	return s
}

// SetRoutingStrategyType sets the RoutingStrategyType field's value.
func (s *ListAliasesInput) SetRoutingStrategyType(v string) *ListAliasesInput {
	s.RoutingStrategyType = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliasesOutput
type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of alias records that match the list request.
	Aliases []*Alias `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *ListAliasesOutput) SetAliases(v []*Alias) *ListAliasesOutput {
	s.Aliases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesOutput) SetNextToken(v string) *ListAliasesOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuildsInput
type ListBuildsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Build status to filter results by. To retrieve all builds, leave this parameter
	// empty.
	//
	// Possible build statuses include the following:
	//
	//    * INITIALIZED – A new build has been defined, but no files have been uploaded.
	//    You cannot create fleets for builds that are in this status. When a build
	//    is successfully created, the build status is set to this value.
	//
	//    * READY – The game build has been successfully uploaded. You can now create
	//    new fleets for this build.
	//
	//    * FAILED – The game build upload failed. You cannot create new fleets
	//    for this build.
	Status *string `type:"string" enum:"BuildStatus"`
}

// String returns the string representation
func (s ListBuildsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBuildsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBuildsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListBuildsInput) SetLimit(v int64) *ListBuildsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsInput) SetNextToken(v string) *ListBuildsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListBuildsInput) SetStatus(v string) *ListBuildsInput {
	s.Status = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuildsOutput
type ListBuildsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of build records that match the request.
	Builds []*Build `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListBuildsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsOutput) GoString() string {
	return s.String()
}

// SetBuilds sets the Builds field's value.
func (s *ListBuildsOutput) SetBuilds(v []*Build) *ListBuildsOutput {
	s.Builds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsOutput) SetNextToken(v string) *ListBuildsOutput {
	s.NextToken = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleetsInput
type ListFleetsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to return fleets for. Use this parameter to
	// return only fleets using the specified build. To retrieve all fleets, leave
	// this parameter empty.
	BuildId *string `type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFleetsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *ListFleetsInput) SetBuildId(v string) *ListFleetsInput {
	s.BuildId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListFleetsInput) SetLimit(v int64) *ListFleetsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsInput) SetNextToken(v string) *ListFleetsInput {
	s.NextToken = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleetsOutput
type ListFleetsOutput struct {
	_ struct{} `type:"structure"`

	// Set of fleet IDs matching the list request. You can retrieve additional information
	// about all returned fleets by passing this result set to a call to DescribeFleetAttributes,
	// DescribeFleetCapacity, or DescribeFleetUtilization.
	FleetIds []*string `min:"1" type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFleetsOutput) GoString() string {
	return s.String()
}

// SetFleetIds sets the FleetIds field's value.
func (s *ListFleetsOutput) SetFleetIds(v []*string) *ListFleetsOutput {
	s.FleetIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsOutput) SetNextToken(v string) *ListFleetsOutput {
	s.NextToken = &v
	return s
}

// Information about a player session that was created as part of a StartGameSessionPlacement
// request. This object contains only the player ID and player session ID. To
// retrieve full details on a player session, call DescribePlayerSessions with
// the player session ID.
//
// Player-session-related operations include:
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PlacedPlayerSession
type PlacedPlayerSession struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a player that is associated with this player session.
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session.
	PlayerSessionId *string `type:"string"`
}

// String returns the string representation
func (s PlacedPlayerSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacedPlayerSession) GoString() string {
	return s.String()
}

// SetPlayerId sets the PlayerId field's value.
func (s *PlacedPlayerSession) SetPlayerId(v string) *PlacedPlayerSession {
	s.PlayerId = &v
	return s
}

// SetPlayerSessionId sets the PlayerSessionId field's value.
func (s *PlacedPlayerSession) SetPlayerSessionId(v string) *PlacedPlayerSession {
	s.PlayerSessionId = &v
	return s
}

// Regional latency information for a player, used when requesting a new game
// session with StartGameSessionPlacement. This value indicates the amount of
// time lag that exists when the player is connected to a fleet in the specified
// region. The relative difference between a player's latency values for multiple
// regions are used to determine which fleets are best suited to place a new
// game session for the player.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PlayerLatency
type PlayerLatency struct {
	_ struct{} `type:"structure"`

	// Amount of time that represents the time lag experienced by the player when
	// connected to the specified region.
	LatencyInMilliseconds *float64 `type:"float"`

	// Unique identifier for a player associated with the latency data.
	PlayerId *string `min:"1" type:"string"`

	// Name of the region that is associated with the latency value.
	RegionIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PlayerLatency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlayerLatency) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PlayerLatency) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PlayerLatency"}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}
	if s.RegionIdentifier != nil && len(*s.RegionIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegionIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLatencyInMilliseconds sets the LatencyInMilliseconds field's value.
func (s *PlayerLatency) SetLatencyInMilliseconds(v float64) *PlayerLatency {
	s.LatencyInMilliseconds = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *PlayerLatency) SetPlayerId(v string) *PlayerLatency {
	s.PlayerId = &v
	return s
}

// SetRegionIdentifier sets the RegionIdentifier field's value.
func (s *PlayerLatency) SetRegionIdentifier(v string) *PlayerLatency {
	s.RegionIdentifier = &v
	return s
}

// Queue setting that determines the highest latency allowed for individual
// players when placing a game session. When a latency policy is in force, a
// game session cannot be placed at any destination in a region where a player
// is reporting latency higher than the cap. Latency policies are only enforced
// when the placement request contains player latency information.
//
// Queue-related operations include:
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PlayerLatencyPolicy
type PlayerLatencyPolicy struct {
	_ struct{} `type:"structure"`

	// The maximum latency value that is allowed for any player, in milliseconds.
	// All policies must have a value set for this property.
	MaximumIndividualPlayerLatencyMilliseconds *int64 `type:"integer"`

	// The length of time, in seconds, that the policy is enforced while placing
	// a new game session. A null value for this property means that the policy
	// is enforced until the queue times out.
	PolicyDurationSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s PlayerLatencyPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlayerLatencyPolicy) GoString() string {
	return s.String()
}

// SetMaximumIndividualPlayerLatencyMilliseconds sets the MaximumIndividualPlayerLatencyMilliseconds field's value.
func (s *PlayerLatencyPolicy) SetMaximumIndividualPlayerLatencyMilliseconds(v int64) *PlayerLatencyPolicy {
	s.MaximumIndividualPlayerLatencyMilliseconds = &v
	return s
}

// SetPolicyDurationSeconds sets the PolicyDurationSeconds field's value.
func (s *PlayerLatencyPolicy) SetPolicyDurationSeconds(v int64) *PlayerLatencyPolicy {
	s.PolicyDurationSeconds = &v
	return s
}

// Properties describing a player session. A player session represents either
// a player reservation for a game session or actual player activity in a game
// session. A player session object (including player data) is automatically
// passed to a game session when the player connects to the game session and
// is validated.
//
// Player-session-related operations include:
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements
//
// StartGameSessionPlacement
//
// DescribeGameSessionPlacement
//
// StopGameSessionPlacement
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PlayerSession
type PlayerSession struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for a fleet that the player's game session is running on.
	FleetId *string `type:"string"`

	// Unique identifier for the game session that the player session is connected
	// to.
	GameSessionId *string `min:"1" type:"string"`

	// IP address of the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	IpAddress *string `type:"string"`

	// Developer-defined information related to a player. Amazon GameLift does not
	// use this data, so it can be formatted as needed for use in the game.
	PlayerData *string `min:"1" type:"string"`

	// Unique identifier for a player that is associated with this player session.
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session.
	PlayerSessionId *string `type:"string"`

	// Port number for the game session. To connect to a Amazon GameLift server
	// process, an app needs both the IP address and port number.
	Port *int64 `min:"1" type:"integer"`

	// Current status of the player session.
	//
	// Possible player session statuses include the following:
	//
	//    * RESERVED – The player session request has been received, but the player
	//    has not yet connected to the server process and/or been validated.
	//
	//    * ACTIVE – The player has been validated by the server process and is
	//    currently connected.
	//
	//    * COMPLETED – The player connection has been dropped.
	//
	//    * TIMEDOUT – A player session request was received, but the player did
	//    not connect and/or was not validated within the time-out limit (60 seconds).
	Status *string `type:"string" enum:"PlayerSessionStatus"`

	// Time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s PlayerSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlayerSession) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *PlayerSession) SetCreationTime(v time.Time) *PlayerSession {
	s.CreationTime = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *PlayerSession) SetFleetId(v string) *PlayerSession {
	s.FleetId = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *PlayerSession) SetGameSessionId(v string) *PlayerSession {
	s.GameSessionId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *PlayerSession) SetIpAddress(v string) *PlayerSession {
	s.IpAddress = &v
	return s
}

// SetPlayerData sets the PlayerData field's value.
func (s *PlayerSession) SetPlayerData(v string) *PlayerSession {
	s.PlayerData = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *PlayerSession) SetPlayerId(v string) *PlayerSession {
	s.PlayerId = &v
	return s
}

// SetPlayerSessionId sets the PlayerSessionId field's value.
func (s *PlayerSession) SetPlayerSessionId(v string) *PlayerSession {
	s.PlayerSessionId = &v
	return s
}

// SetPort sets the Port field's value.
func (s *PlayerSession) SetPort(v int64) *PlayerSession {
	s.Port = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PlayerSession) SetStatus(v string) *PlayerSession {
	s.Status = &v
	return s
}

// SetTerminationTime sets the TerminationTime field's value.
func (s *PlayerSession) SetTerminationTime(v time.Time) *PlayerSession {
	s.TerminationTime = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicyInput
type PutScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Comparison operator to use when measuring the metric against the threshold
	// value.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperatorType"`

	// Length of time (in minutes) the metric must be at or beyond the threshold
	// before a scaling event is triggered.
	//
	// EvaluationPeriods is a required field
	EvaluationPeriods *int64 `min:"1" type:"integer" required:"true"`

	// Unique identifier for a fleet to apply this policy to.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Name of the Amazon GameLift-defined metric that is used to trigger an adjustment.
	//
	//    * ActivatingGameSessions – number of game sessions in the process of being
	//    created (game session status = ACTIVATING).
	//
	//    * ActiveGameSessions – number of game sessions currently running (game
	//    session status = ACTIVE).
	//
	//    * CurrentPlayerSessions – number of active or reserved player sessions
	//    (player session status = ACTIVE or RESERVED).
	//
	//    * AvailablePlayerSessions – number of player session slots currently available
	//    in active game sessions across the fleet, calculated by subtracting a
	//    game session's current player session count from its maximum player session
	//    count. This number includes game sessions that are not currently accepting
	//    players (game session PlayerSessionCreationPolicy = DENY_ALL).
	//
	//    * ActiveInstances – number of instances currently running a game session.
	//
	//    * IdleInstances – number of instances not currently running a game session.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true" enum:"MetricName"`

	// Descriptive label that is associated with a scaling policy. Policy names
	// do not need to be unique. A fleet can have only one scaling policy with the
	// same name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Amount of adjustment to make, based on the scaling adjustment type.
	//
	// ScalingAdjustment is a required field
	ScalingAdjustment *int64 `type:"integer" required:"true"`

	// Type of adjustment to make to a fleet's instance count (see FleetCapacity):
	//
	//    * ChangeInCapacity – add (or subtract) the scaling adjustment value from
	//    the current instance count. Positive values scale up while negative values
	//    scale down.
	//
	//    * ExactCapacity – set the instance count to the scaling adjustment value.
	//
	//    * PercentChangeInCapacity – increase or reduce the current instance count
	//    by the scaling adjustment, read as a percentage. Positive values scale
	//    up while negative values scale down; for example, a value of "-10" scales
	//    the fleet down by 10%.
	//
	// ScalingAdjustmentType is a required field
	ScalingAdjustmentType *string `type:"string" required:"true" enum:"ScalingAdjustmentType"`

	// Metric value used to trigger a scaling event.
	//
	// Threshold is a required field
	Threshold *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s PutScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutScalingPolicyInput"}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.EvaluationPeriods == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationPeriods"))
	}
	if s.EvaluationPeriods != nil && *s.EvaluationPeriods < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EvaluationPeriods", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ScalingAdjustment == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingAdjustment"))
	}
	if s.ScalingAdjustmentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingAdjustmentType"))
	}
	if s.Threshold == nil {
		invalidParams.Add(request.NewErrParamRequired("Threshold"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *PutScalingPolicyInput) SetComparisonOperator(v string) *PutScalingPolicyInput {
	s.ComparisonOperator = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *PutScalingPolicyInput) SetEvaluationPeriods(v int64) *PutScalingPolicyInput {
	s.EvaluationPeriods = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *PutScalingPolicyInput) SetFleetId(v string) *PutScalingPolicyInput {
	s.FleetId = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *PutScalingPolicyInput) SetMetricName(v string) *PutScalingPolicyInput {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutScalingPolicyInput) SetName(v string) *PutScalingPolicyInput {
	s.Name = &v
	return s
}

// SetScalingAdjustment sets the ScalingAdjustment field's value.
func (s *PutScalingPolicyInput) SetScalingAdjustment(v int64) *PutScalingPolicyInput {
	s.ScalingAdjustment = &v
	return s
}

// SetScalingAdjustmentType sets the ScalingAdjustmentType field's value.
func (s *PutScalingPolicyInput) SetScalingAdjustmentType(v string) *PutScalingPolicyInput {
	s.ScalingAdjustmentType = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *PutScalingPolicyInput) SetThreshold(v float64) *PutScalingPolicyInput {
	s.Threshold = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicyOutput
type PutScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Descriptive label that is associated with a scaling policy. Policy names
	// do not need to be unique.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *PutScalingPolicyOutput) SetName(v string) *PutScalingPolicyOutput {
	s.Name = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentialsInput
type RequestUploadCredentialsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to get credentials for.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RequestUploadCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestUploadCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestUploadCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestUploadCredentialsInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *RequestUploadCredentialsInput) SetBuildId(v string) *RequestUploadCredentialsInput {
	s.BuildId = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentialsOutput
type RequestUploadCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// Amazon S3 path and key, identifying where the game build files are stored.
	StorageLocation *S3Location `type:"structure"`

	// AWS credentials required when uploading a game build to the storage location.
	// These credentials have a limited lifespan and are valid only for the build
	// they were issued for.
	UploadCredentials *AwsCredentials `type:"structure"`
}

// String returns the string representation
func (s RequestUploadCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestUploadCredentialsOutput) GoString() string {
	return s.String()
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *RequestUploadCredentialsOutput) SetStorageLocation(v *S3Location) *RequestUploadCredentialsOutput {
	s.StorageLocation = v
	return s
}

// SetUploadCredentials sets the UploadCredentials field's value.
func (s *RequestUploadCredentialsOutput) SetUploadCredentials(v *AwsCredentials) *RequestUploadCredentialsOutput {
	s.UploadCredentials = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAliasInput
type ResolveAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the alias you want to resolve.
	//
	// AliasId is a required field
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResolveAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolveAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResolveAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *ResolveAliasInput) SetAliasId(v string) *ResolveAliasInput {
	s.AliasId = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAliasOutput
type ResolveAliasOutput struct {
	_ struct{} `type:"structure"`

	// Fleet identifier that is associated with the requested alias.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s ResolveAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveAliasOutput) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *ResolveAliasOutput) SetFleetId(v string) *ResolveAliasOutput {
	s.FleetId = &v
	return s
}

// Policy that limits the number of game sessions a player can create on the
// same fleet. This optional policy gives game owners control over how players
// can consume available game server resources. A resource creation policy makes
// the following statement: "An individual player can create a maximum number
// of new game sessions within a specified time period".
//
// The policy is evaluated when a player tries to create a new game session.
// For example, with a policy of 10 new game sessions and a time period of 60
// minutes, on receiving a CreateGameSession request, Amazon GameLift checks
// that the player (identified by CreatorId) has created fewer than 10 game
// sessions in the past 60 minutes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResourceCreationLimitPolicy
type ResourceCreationLimitPolicy struct {
	_ struct{} `type:"structure"`

	// Maximum number of game sessions that an individual can create during the
	// policy period.
	NewGameSessionsPerCreator *int64 `type:"integer"`

	// Time span used in evaluating the resource creation limit policy.
	PolicyPeriodInMinutes *int64 `type:"integer"`
}

// String returns the string representation
func (s ResourceCreationLimitPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceCreationLimitPolicy) GoString() string {
	return s.String()
}

// SetNewGameSessionsPerCreator sets the NewGameSessionsPerCreator field's value.
func (s *ResourceCreationLimitPolicy) SetNewGameSessionsPerCreator(v int64) *ResourceCreationLimitPolicy {
	s.NewGameSessionsPerCreator = &v
	return s
}

// SetPolicyPeriodInMinutes sets the PolicyPeriodInMinutes field's value.
func (s *ResourceCreationLimitPolicy) SetPolicyPeriodInMinutes(v int64) *ResourceCreationLimitPolicy {
	s.PolicyPeriodInMinutes = &v
	return s
}

// Routing configuration for a fleet alias.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RoutingStrategy
type RoutingStrategy struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet that the alias points to.
	FleetId *string `type:"string"`

	// Message text to be used with a terminal routing strategy.
	Message *string `type:"string"`

	// Type of routing strategy.
	//
	// Possible routing types include the following:
	//
	//    * SIMPLE – The alias resolves to one specific fleet. Use this type when
	//    routing to active fleets.
	//
	//    * TERMINAL – The alias does not resolve to a fleet but instead can be
	//    used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException
	//    with the RoutingStrategy message embedded.
	Type *string `type:"string" enum:"RoutingStrategyType"`
}

// String returns the string representation
func (s RoutingStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoutingStrategy) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *RoutingStrategy) SetFleetId(v string) *RoutingStrategy {
	s.FleetId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *RoutingStrategy) SetMessage(v string) *RoutingStrategy {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *RoutingStrategy) SetType(v string) *RoutingStrategy {
	s.Type = &v
	return s
}

// A collection of server process configurations that describe what processes
// to run on each instance in a fleet. All fleets must have a runtime configuration.
// Each instance in the fleet launches the server processes specified in the
// run-time configuration and launches new ones as existing processes end. Each
// instance regularly checks for an updated run-time configuration and follows
// the new instructions.
//
// The run-time configuration enables the instances in a fleet to run multiple
// processes simultaneously. Potential scenarios are as follows: (1) Run multiple
// processes of a single game server executable to maximize usage of your hosting
// resources. (2) Run one or more processes of different build executables,
// such as your game server executable and a related program, or two or more
// different versions of a game server. (3) Run multiple processes of a single
// game server but with different launch parameters, for example to run one
// process on each instance in debug mode.
//
// A Amazon GameLift instance is limited to 50 processes running simultaneously.
// A run-time configuration must specify fewer than this limit. To calculate
// the total number of processes specified in a run-time configuration, add
// the values of the ConcurrentExecutions parameter for each ServerProcess object
// in the run-time configuration.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RuntimeConfiguration
type RuntimeConfiguration struct {
	_ struct{} `type:"structure"`

	// Maximum amount of time (in seconds) that a game session can remain in status
	// ACTIVATING. If the game session is not active before the timeout, activation
	// is terminated and the game session status is changed to TERMINATED.
	GameSessionActivationTimeoutSeconds *int64 `min:"1" type:"integer"`

	// Maximum number of game sessions with status ACTIVATING to allow on an instance
	// simultaneously. This setting limits the amount of instance resources that
	// can be used for new game activations at any one time.
	MaxConcurrentGameSessionActivations *int64 `min:"1" type:"integer"`

	// Collection of server process configurations that describe which server processes
	// to run on each instance in a fleet.
	ServerProcesses []*ServerProcess `min:"1" type:"list"`
}

// String returns the string representation
func (s RuntimeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuntimeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuntimeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuntimeConfiguration"}
	if s.GameSessionActivationTimeoutSeconds != nil && *s.GameSessionActivationTimeoutSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("GameSessionActivationTimeoutSeconds", 1))
	}
	if s.MaxConcurrentGameSessionActivations != nil && *s.MaxConcurrentGameSessionActivations < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxConcurrentGameSessionActivations", 1))
	}
	if s.ServerProcesses != nil && len(s.ServerProcesses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerProcesses", 1))
	}
	if s.ServerProcesses != nil {
		for i, v := range s.ServerProcesses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ServerProcesses", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionActivationTimeoutSeconds sets the GameSessionActivationTimeoutSeconds field's value.
func (s *RuntimeConfiguration) SetGameSessionActivationTimeoutSeconds(v int64) *RuntimeConfiguration {
	s.GameSessionActivationTimeoutSeconds = &v
	return s
}

// SetMaxConcurrentGameSessionActivations sets the MaxConcurrentGameSessionActivations field's value.
func (s *RuntimeConfiguration) SetMaxConcurrentGameSessionActivations(v int64) *RuntimeConfiguration {
	s.MaxConcurrentGameSessionActivations = &v
	return s
}

// SetServerProcesses sets the ServerProcesses field's value.
func (s *RuntimeConfiguration) SetServerProcesses(v []*ServerProcess) *RuntimeConfiguration {
	s.ServerProcesses = v
	return s
}

// Location in Amazon Simple Storage Service (Amazon S3) where build files can
// be stored for access by Amazon GameLift. This location is specified in a
// CreateBuild request. For more details, see the Create a Build with Files
// in Amazon S3 (http://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/S3Location
type S3Location struct {
	_ struct{} `type:"structure"`

	// Amazon S3 bucket identifier. This is the name of your S3 bucket.
	Bucket *string `min:"1" type:"string"`

	// Name of the zip file containing your build files.
	Key *string `min:"1" type:"string"`

	// Amazon Resource Name (ARN (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// for the access role that allows Amazon GameLift to access your S3 bucket.
	RoleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Location) SetBucket(v string) *S3Location {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Location) SetKey(v string) *S3Location {
	s.Key = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *S3Location) SetRoleArn(v string) *S3Location {
	s.RoleArn = &v
	return s
}

// Rule that controls how a fleet is scaled. Scaling policies are uniquely identified
// by the combination of name and fleet ID.
//
// Fleet-related operations include:
//
//    * CreateFleet
//
//    * ListFleets
//
//    * Describe fleets:
//
// DescribeFleetAttributes
//
// DescribeFleetPortSettings
//
// DescribeFleetUtilization
//
// DescribeRuntimeConfiguration
//
// DescribeFleetEvents
//
//    * Update fleets:
//
// UpdateFleetAttributes
//
// UpdateFleetCapacity
//
// UpdateFleetPortSettings
//
// UpdateRuntimeConfiguration
//
//    * Manage fleet capacity:
//
// DescribeFleetCapacity
//
// UpdateFleetCapacity
//
// PutScalingPolicy (automatic scaling)
//
// DescribeScalingPolicies (automatic scaling)
//
// DeleteScalingPolicy (automatic scaling)
//
// DescribeEC2InstanceLimits
//
//    * DeleteFleet
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ScalingPolicy
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// Comparison operator to use when measuring a metric against the threshold
	// value.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperatorType"`

	// Length of time (in minutes) the metric must be at or beyond the threshold
	// before a scaling event is triggered.
	EvaluationPeriods *int64 `min:"1" type:"integer"`

	// Unique identifier for a fleet that is associated with this scaling policy.
	FleetId *string `type:"string"`

	// Name of the Amazon GameLift-defined metric that is used to trigger an adjustment.
	//
	//    * ActivatingGameSessions – number of game sessions in the process of being
	//    created (game session status = ACTIVATING).
	//
	//    * ActiveGameSessions – number of game sessions currently running (game
	//    session status = ACTIVE).
	//
	//    * CurrentPlayerSessions – number of active or reserved player sessions
	//    (player session status = ACTIVE or RESERVED).
	//
	//    * AvailablePlayerSessions – number of player session slots currently available
	//    in active game sessions across the fleet, calculated by subtracting a
	//    game session's current player session count from its maximum player session
	//    count. This number does include game sessions that are not currently accepting
	//    players (game session PlayerSessionCreationPolicy = DENY_ALL).
	//
	//    * ActiveInstances – number of instances currently running a game session.
	//
	//    * IdleInstances – number of instances not currently running a game session.
	MetricName *string `type:"string" enum:"MetricName"`

	// Descriptive label that is associated with a scaling policy. Policy names
	// do not need to be unique.
	Name *string `min:"1" type:"string"`

	// Amount of adjustment to make, based on the scaling adjustment type.
	ScalingAdjustment *int64 `type:"integer"`

	// Type of adjustment to make to a fleet's instance count (see FleetCapacity):
	//
	//    * ChangeInCapacity – add (or subtract) the scaling adjustment value from
	//    the current instance count. Positive values scale up while negative values
	//    scale down.
	//
	//    * ExactCapacity – set the instance count to the scaling adjustment value.
	//
	//    * PercentChangeInCapacity – increase or reduce the current instance count
	//    by the scaling adjustment, read as a percentage. Positive values scale
	//    up while negative values scale down.
	ScalingAdjustmentType *string `type:"string" enum:"ScalingAdjustmentType"`

	// Current status of the scaling policy. The scaling policy is only in force
	// when in an ACTIVE status.
	//
	//    * ACTIVE – The scaling policy is currently in force.
	//
	//    * UPDATE_REQUESTED – A request to update the scaling policy has been received.
	//
	//    * UPDATING – A change is being made to the scaling policy.
	//
	//    * DELETE_REQUESTED – A request to delete the scaling policy has been received.
	//
	//    * DELETING – The scaling policy is being deleted.
	//
	//    * DELETED – The scaling policy has been deleted.
	//
	//    * ERROR – An error occurred in creating the policy. It should be removed
	//    and recreated.
	Status *string `type:"string" enum:"ScalingStatusType"`

	// Metric value used to trigger a scaling event.
	Threshold *float64 `type:"double"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPolicy) GoString() string {
	return s.String()
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *ScalingPolicy) SetComparisonOperator(v string) *ScalingPolicy {
	s.ComparisonOperator = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *ScalingPolicy) SetEvaluationPeriods(v int64) *ScalingPolicy {
	s.EvaluationPeriods = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *ScalingPolicy) SetFleetId(v string) *ScalingPolicy {
	s.FleetId = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *ScalingPolicy) SetMetricName(v string) *ScalingPolicy {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *ScalingPolicy) SetName(v string) *ScalingPolicy {
	s.Name = &v
	return s
}

// SetScalingAdjustment sets the ScalingAdjustment field's value.
func (s *ScalingPolicy) SetScalingAdjustment(v int64) *ScalingPolicy {
	s.ScalingAdjustment = &v
	return s
}

// SetScalingAdjustmentType sets the ScalingAdjustmentType field's value.
func (s *ScalingPolicy) SetScalingAdjustmentType(v string) *ScalingPolicy {
	s.ScalingAdjustmentType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ScalingPolicy) SetStatus(v string) *ScalingPolicy {
	s.Status = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *ScalingPolicy) SetThreshold(v float64) *ScalingPolicy {
	s.Threshold = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessionsInput
type SearchGameSessionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for an alias associated with the fleet to search for active
	// game sessions. Each request must reference either a fleet ID or alias ID,
	// but not both.
	AliasId *string `type:"string"`

	// String containing the search criteria for the session search. If no filter
	// expression is included, the request returns results for all game sessions
	// in the fleet that are in ACTIVE status.
	//
	// A filter expression can contain one or multiple conditions. Each condition
	// consists of the following:
	//
	//    * Operand -- Name of a game session attribute. Valid values are gameSessionName,
	//    gameSessionId, creationTimeMillis, playerSessionCount, maximumSessions,
	//    hasAvailablePlayerSessions.
	//
	//    * Comparator -- Valid comparators are: =, <>, <, >, <=, >=.
	//
	//    * Value -- Value to be searched for. Values can be numbers, boolean values
	//    (true/false) or strings. String values are case sensitive, enclosed in
	//    single quotes. Special characters must be escaped. Boolean and string
	//    values can only be used with the comparators = and <>. For example, the
	//    following filter expression searches on gameSessionName: "FilterExpression":
	//    "gameSessionName = 'Matt\\'s Awesome Game 1'".
	//
	// To chain multiple conditions in a single expression, use the logical keywords
	// AND, OR, and NOT and parentheses as needed. For example: x AND y AND NOT
	// z, NOT (x OR y).
	//
	// Session search evaluates conditions from left to right using the following
	// precedence rules:
	//
	// =, <>, <, >, <=, >=
	//
	// Parentheses
	//
	// NOT
	//
	// AND
	//
	// OR
	//
	// For example, this filter expression retrieves game sessions hosting at least
	// ten players that have an open player slot: "maximumSessions>=10 AND hasAvailablePlayerSessions=true".
	FilterExpression *string `min:"1" type:"string"`

	// Unique identifier for a fleet to search for active game sessions. Each request
	// must reference either a fleet ID or alias ID, but not both.
	FleetId *string `type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages. The maximum number of results returned
	// is 20, even if this value is not set or is set higher than 20.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To specify
	// the start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Instructions on how to sort the search results. If no sort expression is
	// included, the request returns results in random order. A sort expression
	// consists of the following elements:
	//
	//    * Operand -- Name of a game session attribute. Valid values are gameSessionName,
	//    gameSessionId, creationTimeMillis, playerSessionCount, maximumSessions,
	//    hasAvailablePlayerSessions.
	//
	//    * Order -- Valid sort orders are ASC (ascending) and DESC (descending).
	//
	// For example, this sort expression returns the oldest active sessions first:
	// "SortExpression": "creationTimeMillis ASC". Results with a null value for
	// the sort operand are returned at the end of the list.
	SortExpression *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SearchGameSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchGameSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchGameSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchGameSessionsInput"}
	if s.FilterExpression != nil && len(*s.FilterExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterExpression", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SortExpression != nil && len(*s.SortExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SortExpression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *SearchGameSessionsInput) SetAliasId(v string) *SearchGameSessionsInput {
	s.AliasId = &v
	return s
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *SearchGameSessionsInput) SetFilterExpression(v string) *SearchGameSessionsInput {
	s.FilterExpression = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *SearchGameSessionsInput) SetFleetId(v string) *SearchGameSessionsInput {
	s.FleetId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *SearchGameSessionsInput) SetLimit(v int64) *SearchGameSessionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchGameSessionsInput) SetNextToken(v string) *SearchGameSessionsInput {
	s.NextToken = &v
	return s
}

// SetSortExpression sets the SortExpression field's value.
func (s *SearchGameSessionsInput) SetSortExpression(v string) *SearchGameSessionsInput {
	s.SortExpression = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessionsOutput
type SearchGameSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing game session properties for each session
	// matching the request.
	GameSessions []*GameSession `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SearchGameSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchGameSessionsOutput) GoString() string {
	return s.String()
}

// SetGameSessions sets the GameSessions field's value.
func (s *SearchGameSessionsOutput) SetGameSessions(v []*GameSession) *SearchGameSessionsOutput {
	s.GameSessions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchGameSessionsOutput) SetNextToken(v string) *SearchGameSessionsOutput {
	s.NextToken = &v
	return s
}

// A set of instructions for launching server processes on each instance in
// a fleet. Each instruction set identifies the location of the server executable,
// optional launch parameters, and the number of server processes with this
// configuration to maintain concurrently on the instance. Server process configurations
// make up a fleet's RuntimeConfiguration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ServerProcess
type ServerProcess struct {
	_ struct{} `type:"structure"`

	// Number of server processes using this configuration to run concurrently on
	// an instance.
	//
	// ConcurrentExecutions is a required field
	ConcurrentExecutions *int64 `min:"1" type:"integer" required:"true"`

	// Location of the server executable in a game build. All game builds are installed
	// on instances at the root : for Windows instances C:\game, and for Linux instances
	// /local/game. A Windows game build with an executable file located at MyGame\latest\server.exe
	// must have a launch path of "C:\game\MyGame\latest\server.exe". A Linux game
	// build with an executable file located at MyGame/latest/server.exe must have
	// a launch path of "/local/game/MyGame/latest/server.exe".
	//
	// LaunchPath is a required field
	LaunchPath *string `min:"1" type:"string" required:"true"`

	// Optional list of parameters to pass to the server executable on launch.
	Parameters *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ServerProcess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerProcess) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerProcess) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerProcess"}
	if s.ConcurrentExecutions == nil {
		invalidParams.Add(request.NewErrParamRequired("ConcurrentExecutions"))
	}
	if s.ConcurrentExecutions != nil && *s.ConcurrentExecutions < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ConcurrentExecutions", 1))
	}
	if s.LaunchPath == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchPath"))
	}
	if s.LaunchPath != nil && len(*s.LaunchPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchPath", 1))
	}
	if s.Parameters != nil && len(*s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConcurrentExecutions sets the ConcurrentExecutions field's value.
func (s *ServerProcess) SetConcurrentExecutions(v int64) *ServerProcess {
	s.ConcurrentExecutions = &v
	return s
}

// SetLaunchPath sets the LaunchPath field's value.
func (s *ServerProcess) SetLaunchPath(v string) *ServerProcess {
	s.LaunchPath = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ServerProcess) SetParameters(v string) *ServerProcess {
	s.Parameters = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartGameSessionPlacementInput
type StartGameSessionPlacementInput struct {
	_ struct{} `type:"structure"`

	// Set of information on each player to create a player session for.
	DesiredPlayerSessions []*DesiredPlayerSession `type:"list"`

	// Set of developer-defined properties for a game session. These properties
	// are passed to the server process hosting the game session.
	GameProperties []*GameProperty `type:"list"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	GameSessionName *string `min:"1" type:"string"`

	// Name of the queue to use to place the new game session.
	//
	// GameSessionQueueName is a required field
	GameSessionQueueName *string `min:"1" type:"string" required:"true"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	//
	// MaximumPlayerSessionCount is a required field
	MaximumPlayerSessionCount *int64 `type:"integer" required:"true"`

	// Unique identifier to assign to the new game session placement. This value
	// is developer-defined. The value must be unique across all regions and cannot
	// be reused unless you are resubmitting a canceled or timed-out placement request.
	//
	// PlacementId is a required field
	PlacementId *string `min:"1" type:"string" required:"true"`

	// Set of values, expressed in milliseconds, indicating the amount of latency
	// that players are experiencing when connected to AWS regions. This information
	// is used to try to place the new game session where it can offer the best
	// possible gameplay experience for the players.
	PlayerLatencies []*PlayerLatency `type:"list"`
}

// String returns the string representation
func (s StartGameSessionPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGameSessionPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartGameSessionPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartGameSessionPlacementInput"}
	if s.GameSessionName != nil && len(*s.GameSessionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionName", 1))
	}
	if s.GameSessionQueueName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionQueueName"))
	}
	if s.GameSessionQueueName != nil && len(*s.GameSessionQueueName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionQueueName", 1))
	}
	if s.MaximumPlayerSessionCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumPlayerSessionCount"))
	}
	if s.PlacementId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementId"))
	}
	if s.PlacementId != nil && len(*s.PlacementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementId", 1))
	}
	if s.DesiredPlayerSessions != nil {
		for i, v := range s.DesiredPlayerSessions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DesiredPlayerSessions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.GameProperties != nil {
		for i, v := range s.GameProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GameProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PlayerLatencies != nil {
		for i, v := range s.PlayerLatencies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PlayerLatencies", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredPlayerSessions sets the DesiredPlayerSessions field's value.
func (s *StartGameSessionPlacementInput) SetDesiredPlayerSessions(v []*DesiredPlayerSession) *StartGameSessionPlacementInput {
	s.DesiredPlayerSessions = v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *StartGameSessionPlacementInput) SetGameProperties(v []*GameProperty) *StartGameSessionPlacementInput {
	s.GameProperties = v
	return s
}

// SetGameSessionName sets the GameSessionName field's value.
func (s *StartGameSessionPlacementInput) SetGameSessionName(v string) *StartGameSessionPlacementInput {
	s.GameSessionName = &v
	return s
}

// SetGameSessionQueueName sets the GameSessionQueueName field's value.
func (s *StartGameSessionPlacementInput) SetGameSessionQueueName(v string) *StartGameSessionPlacementInput {
	s.GameSessionQueueName = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *StartGameSessionPlacementInput) SetMaximumPlayerSessionCount(v int64) *StartGameSessionPlacementInput {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetPlacementId sets the PlacementId field's value.
func (s *StartGameSessionPlacementInput) SetPlacementId(v string) *StartGameSessionPlacementInput {
	s.PlacementId = &v
	return s
}

// SetPlayerLatencies sets the PlayerLatencies field's value.
func (s *StartGameSessionPlacementInput) SetPlayerLatencies(v []*PlayerLatency) *StartGameSessionPlacementInput {
	s.PlayerLatencies = v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartGameSessionPlacementOutput
type StartGameSessionPlacementOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created game session placement. This object
	// includes all the information provided in the request, as well as start/end
	// time stamps and placement status.
	GameSessionPlacement *GameSessionPlacement `type:"structure"`
}

// String returns the string representation
func (s StartGameSessionPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGameSessionPlacementOutput) GoString() string {
	return s.String()
}

// SetGameSessionPlacement sets the GameSessionPlacement field's value.
func (s *StartGameSessionPlacementOutput) SetGameSessionPlacement(v *GameSessionPlacement) *StartGameSessionPlacementOutput {
	s.GameSessionPlacement = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopGameSessionPlacementInput
type StopGameSessionPlacementInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a game session placement to cancel.
	//
	// PlacementId is a required field
	PlacementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopGameSessionPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopGameSessionPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopGameSessionPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopGameSessionPlacementInput"}
	if s.PlacementId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementId"))
	}
	if s.PlacementId != nil && len(*s.PlacementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlacementId sets the PlacementId field's value.
func (s *StopGameSessionPlacementInput) SetPlacementId(v string) *StopGameSessionPlacementInput {
	s.PlacementId = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopGameSessionPlacementOutput
type StopGameSessionPlacementOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the canceled game session placement, with Cancelled
	// status and an end time stamp.
	GameSessionPlacement *GameSessionPlacement `type:"structure"`
}

// String returns the string representation
func (s StopGameSessionPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopGameSessionPlacementOutput) GoString() string {
	return s.String()
}

// SetGameSessionPlacement sets the GameSessionPlacement field's value.
func (s *StopGameSessionPlacementOutput) SetGameSessionPlacement(v *GameSessionPlacement) *StopGameSessionPlacementOutput {
	s.GameSessionPlacement = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateAliasInput
type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Specify the alias you want to update.
	//
	// AliasId is a required field
	AliasId *string `type:"string" required:"true"`

	// Human-readable description of an alias.
	Description *string `min:"1" type:"string"`

	// Descriptive label that is associated with an alias. Alias names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Object that specifies the fleet and routing type to use for the alias.
	RoutingStrategy *RoutingStrategy `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *UpdateAliasInput) SetAliasId(v string) *UpdateAliasInput {
	s.AliasId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAliasInput) SetDescription(v string) *UpdateAliasInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAliasInput) SetName(v string) *UpdateAliasInput {
	s.Name = &v
	return s
}

// SetRoutingStrategy sets the RoutingStrategy field's value.
func (s *UpdateAliasInput) SetRoutingStrategy(v *RoutingStrategy) *UpdateAliasInput {
	s.RoutingStrategy = v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateAliasOutput
type UpdateAliasOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains the updated alias configuration.
	Alias *Alias `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *UpdateAliasOutput) SetAlias(v *Alias) *UpdateAliasOutput {
	s.Alias = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateBuildInput
type UpdateBuildInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build to update.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`

	// Descriptive label that is associated with a build. Build names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Version that is associated with this build. Version strings do not need to
	// be unique.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBuildInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *UpdateBuildInput) SetBuildId(v string) *UpdateBuildInput {
	s.BuildId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateBuildInput) SetName(v string) *UpdateBuildInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateBuildInput) SetVersion(v string) *UpdateBuildInput {
	s.Version = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateBuildOutput
type UpdateBuildOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains the updated build record.
	Build *Build `type:"structure"`
}

// String returns the string representation
func (s UpdateBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *UpdateBuildOutput) SetBuild(v *Build) *UpdateBuildOutput {
	s.Build = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetAttributesInput
type UpdateFleetAttributesInput struct {
	_ struct{} `type:"structure"`

	// Human-readable description of a fleet.
	Description *string `min:"1" type:"string"`

	// Unique identifier for a fleet to update attribute metadata for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Names of metric groups to include this fleet in. Amazon CloudWatch uses a
	// fleet metric group is to aggregate metrics from multiple fleets. Use an existing
	// metric group name to add this fleet to the group. Or use a new name to create
	// a new metric group. A fleet can only be included in one metric group at a
	// time.
	MetricGroups []*string `type:"list"`

	// Descriptive label that is associated with a fleet. Fleet names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Game session protection policy to apply to all new instances created in this
	// fleet. Instances that already exist are not affected. You can set protection
	// for individual instances using UpdateGameSession.
	//
	//    * NoProtection – The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection – If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	NewGameSessionProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`

	// Policy that limits the number of game sessions an individual player can create
	// over a span of time.
	ResourceCreationLimitPolicy *ResourceCreationLimitPolicy `type:"structure"`
}

// String returns the string representation
func (s UpdateFleetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFleetAttributesInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateFleetAttributesInput) SetDescription(v string) *UpdateFleetAttributesInput {
	s.Description = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetAttributesInput) SetFleetId(v string) *UpdateFleetAttributesInput {
	s.FleetId = &v
	return s
}

// SetMetricGroups sets the MetricGroups field's value.
func (s *UpdateFleetAttributesInput) SetMetricGroups(v []*string) *UpdateFleetAttributesInput {
	s.MetricGroups = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFleetAttributesInput) SetName(v string) *UpdateFleetAttributesInput {
	s.Name = &v
	return s
}

// SetNewGameSessionProtectionPolicy sets the NewGameSessionProtectionPolicy field's value.
func (s *UpdateFleetAttributesInput) SetNewGameSessionProtectionPolicy(v string) *UpdateFleetAttributesInput {
	s.NewGameSessionProtectionPolicy = &v
	return s
}

// SetResourceCreationLimitPolicy sets the ResourceCreationLimitPolicy field's value.
func (s *UpdateFleetAttributesInput) SetResourceCreationLimitPolicy(v *ResourceCreationLimitPolicy) *UpdateFleetAttributesInput {
	s.ResourceCreationLimitPolicy = v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetAttributesOutput
type UpdateFleetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet that was updated.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s UpdateFleetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetAttributesOutput) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetAttributesOutput) SetFleetId(v string) *UpdateFleetAttributesOutput {
	s.FleetId = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetCapacityInput
type UpdateFleetCapacityInput struct {
	_ struct{} `type:"structure"`

	// Number of EC2 instances you want this fleet to host.
	DesiredInstances *int64 `type:"integer"`

	// Unique identifier for a fleet to update capacity for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Maximum value allowed for the fleet's instance count. Default if not set
	// is 1.
	MaxSize *int64 `type:"integer"`

	// Minimum value allowed for the fleet's instance count. Default if not set
	// is 0.
	MinSize *int64 `type:"integer"`
}

// String returns the string representation
func (s UpdateFleetCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetCapacityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetCapacityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFleetCapacityInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredInstances sets the DesiredInstances field's value.
func (s *UpdateFleetCapacityInput) SetDesiredInstances(v int64) *UpdateFleetCapacityInput {
	s.DesiredInstances = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetCapacityInput) SetFleetId(v string) *UpdateFleetCapacityInput {
	s.FleetId = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *UpdateFleetCapacityInput) SetMaxSize(v int64) *UpdateFleetCapacityInput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *UpdateFleetCapacityInput) SetMinSize(v int64) *UpdateFleetCapacityInput {
	s.MinSize = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetCapacityOutput
type UpdateFleetCapacityOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet that was updated.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s UpdateFleetCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetCapacityOutput) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetCapacityOutput) SetFleetId(v string) *UpdateFleetCapacityOutput {
	s.FleetId = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetPortSettingsInput
type UpdateFleetPortSettingsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to update port settings for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Collection of port settings to be added to the fleet record.
	InboundPermissionAuthorizations []*IpPermission `type:"list"`

	// Collection of port settings to be removed from the fleet record.
	InboundPermissionRevocations []*IpPermission `type:"list"`
}

// String returns the string representation
func (s UpdateFleetPortSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetPortSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetPortSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFleetPortSettingsInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.InboundPermissionAuthorizations != nil {
		for i, v := range s.InboundPermissionAuthorizations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InboundPermissionAuthorizations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InboundPermissionRevocations != nil {
		for i, v := range s.InboundPermissionRevocations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InboundPermissionRevocations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetPortSettingsInput) SetFleetId(v string) *UpdateFleetPortSettingsInput {
	s.FleetId = &v
	return s
}

// SetInboundPermissionAuthorizations sets the InboundPermissionAuthorizations field's value.
func (s *UpdateFleetPortSettingsInput) SetInboundPermissionAuthorizations(v []*IpPermission) *UpdateFleetPortSettingsInput {
	s.InboundPermissionAuthorizations = v
	return s
}

// SetInboundPermissionRevocations sets the InboundPermissionRevocations field's value.
func (s *UpdateFleetPortSettingsInput) SetInboundPermissionRevocations(v []*IpPermission) *UpdateFleetPortSettingsInput {
	s.InboundPermissionRevocations = v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetPortSettingsOutput
type UpdateFleetPortSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet that was updated.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s UpdateFleetPortSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetPortSettingsOutput) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateFleetPortSettingsOutput) SetFleetId(v string) *UpdateFleetPortSettingsOutput {
	s.FleetId = &v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionInput
type UpdateGameSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the game session to update.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	Name *string `min:"1" type:"string"`

	// Policy determining whether or not the game session accepts new players.
	PlayerSessionCreationPolicy *string `type:"string" enum:"PlayerSessionCreationPolicy"`

	// Game session protection policy to apply to this game session only.
	//
	//    * NoProtection – The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection – If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	ProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`
}

// String returns the string representation
func (s UpdateGameSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGameSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGameSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGameSessionInput"}
	if s.GameSessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *UpdateGameSessionInput) SetGameSessionId(v string) *UpdateGameSessionInput {
	s.GameSessionId = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *UpdateGameSessionInput) SetMaximumPlayerSessionCount(v int64) *UpdateGameSessionInput {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateGameSessionInput) SetName(v string) *UpdateGameSessionInput {
	s.Name = &v
	return s
}

// SetPlayerSessionCreationPolicy sets the PlayerSessionCreationPolicy field's value.
func (s *UpdateGameSessionInput) SetPlayerSessionCreationPolicy(v string) *UpdateGameSessionInput {
	s.PlayerSessionCreationPolicy = &v
	return s
}

// SetProtectionPolicy sets the ProtectionPolicy field's value.
func (s *UpdateGameSessionInput) SetProtectionPolicy(v string) *UpdateGameSessionInput {
	s.ProtectionPolicy = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionOutput
type UpdateGameSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object that contains the updated game session metadata.
	GameSession *GameSession `type:"structure"`
}

// String returns the string representation
func (s UpdateGameSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGameSessionOutput) GoString() string {
	return s.String()
}

// SetGameSession sets the GameSession field's value.
func (s *UpdateGameSessionOutput) SetGameSession(v *GameSession) *UpdateGameSessionOutput {
	s.GameSession = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionQueueInput
type UpdateGameSessionQueueInput struct {
	_ struct{} `type:"structure"`

	// List of fleets that can be used to fulfill game session placement requests
	// in the queue. Fleets are identified by either a fleet ARN or a fleet alias
	// ARN. Destinations are listed in default preference order. When updating this
	// list, provide a complete list of destinations.
	Destinations []*GameSessionQueueDestination `type:"list"`

	// Descriptive label that is associated with queue. Queue names must be unique
	// within each region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Collection of latency policies to apply when processing game sessions placement
	// requests with player latency information. Multiple policies are evaluated
	// in order of the maximum latency value, starting with the lowest latency values.
	// With just one policy, it is enforced at the start of the game session placement
	// for the duration period. With multiple policies, each policy is enforced
	// consecutively for its duration period. For example, a queue might enforce
	// a 60-second policy followed by a 120-second policy, and then no policy for
	// the remainder of the placement. When updating policies, provide a complete
	// collection of policies.
	PlayerLatencyPolicies []*PlayerLatencyPolicy `type:"list"`

	// Maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status.
	TimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s UpdateGameSessionQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGameSessionQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGameSessionQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGameSessionQueueInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinations sets the Destinations field's value.
func (s *UpdateGameSessionQueueInput) SetDestinations(v []*GameSessionQueueDestination) *UpdateGameSessionQueueInput {
	s.Destinations = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateGameSessionQueueInput) SetName(v string) *UpdateGameSessionQueueInput {
	s.Name = &v
	return s
}

// SetPlayerLatencyPolicies sets the PlayerLatencyPolicies field's value.
func (s *UpdateGameSessionQueueInput) SetPlayerLatencyPolicies(v []*PlayerLatencyPolicy) *UpdateGameSessionQueueInput {
	s.PlayerLatencyPolicies = v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *UpdateGameSessionQueueInput) SetTimeoutInSeconds(v int64) *UpdateGameSessionQueueInput {
	s.TimeoutInSeconds = &v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionQueueOutput
type UpdateGameSessionQueueOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly updated game session queue.
	GameSessionQueue *GameSessionQueue `type:"structure"`
}

// String returns the string representation
func (s UpdateGameSessionQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGameSessionQueueOutput) GoString() string {
	return s.String()
}

// SetGameSessionQueue sets the GameSessionQueue field's value.
func (s *UpdateGameSessionQueueOutput) SetGameSessionQueue(v *GameSessionQueue) *UpdateGameSessionQueueOutput {
	s.GameSessionQueue = v
	return s
}

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateRuntimeConfigurationInput
type UpdateRuntimeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to update run-time configuration for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Instructions for launching server processes on each instance in the fleet.
	// The run-time configuration for a fleet has a collection of server process
	// configurations, one for each type of server process to run on an instance.
	// A server process configuration specifies the location of the server executable,
	// launch parameters, and the number of concurrent processes with that configuration
	// to maintain on each instance.
	//
	// RuntimeConfiguration is a required field
	RuntimeConfiguration *RuntimeConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRuntimeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuntimeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuntimeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuntimeConfigurationInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.RuntimeConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("RuntimeConfiguration"))
	}
	if s.RuntimeConfiguration != nil {
		if err := s.RuntimeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RuntimeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *UpdateRuntimeConfigurationInput) SetFleetId(v string) *UpdateRuntimeConfigurationInput {
	s.FleetId = &v
	return s
}

// SetRuntimeConfiguration sets the RuntimeConfiguration field's value.
func (s *UpdateRuntimeConfigurationInput) SetRuntimeConfiguration(v *RuntimeConfiguration) *UpdateRuntimeConfigurationInput {
	s.RuntimeConfiguration = v
	return s
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateRuntimeConfigurationOutput
type UpdateRuntimeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The run-time configuration currently in force. If the update was successful,
	// this object matches the one in the request.
	RuntimeConfiguration *RuntimeConfiguration `type:"structure"`
}

// String returns the string representation
func (s UpdateRuntimeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuntimeConfigurationOutput) GoString() string {
	return s.String()
}

// SetRuntimeConfiguration sets the RuntimeConfiguration field's value.
func (s *UpdateRuntimeConfigurationOutput) SetRuntimeConfiguration(v *RuntimeConfiguration) *UpdateRuntimeConfigurationOutput {
	s.RuntimeConfiguration = v
	return s
}

const (
	// BuildStatusInitialized is a BuildStatus enum value
	BuildStatusInitialized = "INITIALIZED"

	// BuildStatusReady is a BuildStatus enum value
	BuildStatusReady = "READY"

	// BuildStatusFailed is a BuildStatus enum value
	BuildStatusFailed = "FAILED"
)

const (
	// ComparisonOperatorTypeGreaterThanOrEqualToThreshold is a ComparisonOperatorType enum value
	ComparisonOperatorTypeGreaterThanOrEqualToThreshold = "GreaterThanOrEqualToThreshold"

	// ComparisonOperatorTypeGreaterThanThreshold is a ComparisonOperatorType enum value
	ComparisonOperatorTypeGreaterThanThreshold = "GreaterThanThreshold"

	// ComparisonOperatorTypeLessThanThreshold is a ComparisonOperatorType enum value
	ComparisonOperatorTypeLessThanThreshold = "LessThanThreshold"

	// ComparisonOperatorTypeLessThanOrEqualToThreshold is a ComparisonOperatorType enum value
	ComparisonOperatorTypeLessThanOrEqualToThreshold = "LessThanOrEqualToThreshold"
)

const (
	// EC2InstanceTypeT2Micro is a EC2InstanceType enum value
	EC2InstanceTypeT2Micro = "t2.micro"

	// EC2InstanceTypeT2Small is a EC2InstanceType enum value
	EC2InstanceTypeT2Small = "t2.small"

	// EC2InstanceTypeT2Medium is a EC2InstanceType enum value
	EC2InstanceTypeT2Medium = "t2.medium"

	// EC2InstanceTypeT2Large is a EC2InstanceType enum value
	EC2InstanceTypeT2Large = "t2.large"

	// EC2InstanceTypeC3Large is a EC2InstanceType enum value
	EC2InstanceTypeC3Large = "c3.large"

	// EC2InstanceTypeC3Xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC3Xlarge = "c3.xlarge"

	// EC2InstanceTypeC32xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC32xlarge = "c3.2xlarge"

	// EC2InstanceTypeC34xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC34xlarge = "c3.4xlarge"

	// EC2InstanceTypeC38xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC38xlarge = "c3.8xlarge"

	// EC2InstanceTypeC4Large is a EC2InstanceType enum value
	EC2InstanceTypeC4Large = "c4.large"

	// EC2InstanceTypeC4Xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC4Xlarge = "c4.xlarge"

	// EC2InstanceTypeC42xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC42xlarge = "c4.2xlarge"

	// EC2InstanceTypeC44xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC44xlarge = "c4.4xlarge"

	// EC2InstanceTypeC48xlarge is a EC2InstanceType enum value
	EC2InstanceTypeC48xlarge = "c4.8xlarge"

	// EC2InstanceTypeR3Large is a EC2InstanceType enum value
	EC2InstanceTypeR3Large = "r3.large"

	// EC2InstanceTypeR3Xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR3Xlarge = "r3.xlarge"

	// EC2InstanceTypeR32xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR32xlarge = "r3.2xlarge"

	// EC2InstanceTypeR34xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR34xlarge = "r3.4xlarge"

	// EC2InstanceTypeR38xlarge is a EC2InstanceType enum value
	EC2InstanceTypeR38xlarge = "r3.8xlarge"

	// EC2InstanceTypeM3Medium is a EC2InstanceType enum value
	EC2InstanceTypeM3Medium = "m3.medium"

	// EC2InstanceTypeM3Large is a EC2InstanceType enum value
	EC2InstanceTypeM3Large = "m3.large"

	// EC2InstanceTypeM3Xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM3Xlarge = "m3.xlarge"

	// EC2InstanceTypeM32xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM32xlarge = "m3.2xlarge"

	// EC2InstanceTypeM4Large is a EC2InstanceType enum value
	EC2InstanceTypeM4Large = "m4.large"

	// EC2InstanceTypeM4Xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM4Xlarge = "m4.xlarge"

	// EC2InstanceTypeM42xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM42xlarge = "m4.2xlarge"

	// EC2InstanceTypeM44xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM44xlarge = "m4.4xlarge"

	// EC2InstanceTypeM410xlarge is a EC2InstanceType enum value
	EC2InstanceTypeM410xlarge = "m4.10xlarge"
)

const (
	// EventCodeGenericEvent is a EventCode enum value
	EventCodeGenericEvent = "GENERIC_EVENT"

	// EventCodeFleetCreated is a EventCode enum value
	EventCodeFleetCreated = "FLEET_CREATED"

	// EventCodeFleetDeleted is a EventCode enum value
	EventCodeFleetDeleted = "FLEET_DELETED"

	// EventCodeFleetScalingEvent is a EventCode enum value
	EventCodeFleetScalingEvent = "FLEET_SCALING_EVENT"

	// EventCodeFleetStateDownloading is a EventCode enum value
	EventCodeFleetStateDownloading = "FLEET_STATE_DOWNLOADING"

	// EventCodeFleetStateValidating is a EventCode enum value
	EventCodeFleetStateValidating = "FLEET_STATE_VALIDATING"

	// EventCodeFleetStateBuilding is a EventCode enum value
	EventCodeFleetStateBuilding = "FLEET_STATE_BUILDING"

	// EventCodeFleetStateActivating is a EventCode enum value
	EventCodeFleetStateActivating = "FLEET_STATE_ACTIVATING"

	// EventCodeFleetStateActive is a EventCode enum value
	EventCodeFleetStateActive = "FLEET_STATE_ACTIVE"

	// EventCodeFleetStateError is a EventCode enum value
	EventCodeFleetStateError = "FLEET_STATE_ERROR"

	// EventCodeFleetInitializationFailed is a EventCode enum value
	EventCodeFleetInitializationFailed = "FLEET_INITIALIZATION_FAILED"

	// EventCodeFleetBinaryDownloadFailed is a EventCode enum value
	EventCodeFleetBinaryDownloadFailed = "FLEET_BINARY_DOWNLOAD_FAILED"

	// EventCodeFleetValidationLaunchPathNotFound is a EventCode enum value
	EventCodeFleetValidationLaunchPathNotFound = "FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND"

	// EventCodeFleetValidationExecutableRuntimeFailure is a EventCode enum value
	EventCodeFleetValidationExecutableRuntimeFailure = "FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE"

	// EventCodeFleetValidationTimedOut is a EventCode enum value
	EventCodeFleetValidationTimedOut = "FLEET_VALIDATION_TIMED_OUT"

	// EventCodeFleetActivationFailed is a EventCode enum value
	EventCodeFleetActivationFailed = "FLEET_ACTIVATION_FAILED"

	// EventCodeFleetActivationFailedNoInstances is a EventCode enum value
	EventCodeFleetActivationFailedNoInstances = "FLEET_ACTIVATION_FAILED_NO_INSTANCES"

	// EventCodeFleetNewGameSessionProtectionPolicyUpdated is a EventCode enum value
	EventCodeFleetNewGameSessionProtectionPolicyUpdated = "FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED"

	// EventCodeServerProcessInvalidPath is a EventCode enum value
	EventCodeServerProcessInvalidPath = "SERVER_PROCESS_INVALID_PATH"

	// EventCodeServerProcessSdkInitializationTimeout is a EventCode enum value
	EventCodeServerProcessSdkInitializationTimeout = "SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT"

	// EventCodeServerProcessProcessReadyTimeout is a EventCode enum value
	EventCodeServerProcessProcessReadyTimeout = "SERVER_PROCESS_PROCESS_READY_TIMEOUT"

	// EventCodeServerProcessCrashed is a EventCode enum value
	EventCodeServerProcessCrashed = "SERVER_PROCESS_CRASHED"

	// EventCodeServerProcessTerminatedUnhealthy is a EventCode enum value
	EventCodeServerProcessTerminatedUnhealthy = "SERVER_PROCESS_TERMINATED_UNHEALTHY"

	// EventCodeServerProcessForceTerminated is a EventCode enum value
	EventCodeServerProcessForceTerminated = "SERVER_PROCESS_FORCE_TERMINATED"

	// EventCodeServerProcessProcessExitTimeout is a EventCode enum value
	EventCodeServerProcessProcessExitTimeout = "SERVER_PROCESS_PROCESS_EXIT_TIMEOUT"

	// EventCodeGameSessionActivationTimeout is a EventCode enum value
	EventCodeGameSessionActivationTimeout = "GAME_SESSION_ACTIVATION_TIMEOUT"

	// EventCodeFleetCreationExtractingBuild is a EventCode enum value
	EventCodeFleetCreationExtractingBuild = "FLEET_CREATION_EXTRACTING_BUILD"

	// EventCodeFleetCreationRunningInstaller is a EventCode enum value
	EventCodeFleetCreationRunningInstaller = "FLEET_CREATION_RUNNING_INSTALLER"

	// EventCodeFleetCreationValidatingRuntimeConfig is a EventCode enum value
	EventCodeFleetCreationValidatingRuntimeConfig = "FLEET_CREATION_VALIDATING_RUNTIME_CONFIG"
)

const (
	// FleetStatusNew is a FleetStatus enum value
	FleetStatusNew = "NEW"

	// FleetStatusDownloading is a FleetStatus enum value
	FleetStatusDownloading = "DOWNLOADING"

	// FleetStatusValidating is a FleetStatus enum value
	FleetStatusValidating = "VALIDATING"

	// FleetStatusBuilding is a FleetStatus enum value
	FleetStatusBuilding = "BUILDING"

	// FleetStatusActivating is a FleetStatus enum value
	FleetStatusActivating = "ACTIVATING"

	// FleetStatusActive is a FleetStatus enum value
	FleetStatusActive = "ACTIVE"

	// FleetStatusDeleting is a FleetStatus enum value
	FleetStatusDeleting = "DELETING"

	// FleetStatusError is a FleetStatus enum value
	FleetStatusError = "ERROR"

	// FleetStatusTerminated is a FleetStatus enum value
	FleetStatusTerminated = "TERMINATED"
)

const (
	// GameSessionPlacementStatePending is a GameSessionPlacementState enum value
	GameSessionPlacementStatePending = "PENDING"

	// GameSessionPlacementStateFulfilled is a GameSessionPlacementState enum value
	GameSessionPlacementStateFulfilled = "FULFILLED"

	// GameSessionPlacementStateCancelled is a GameSessionPlacementState enum value
	GameSessionPlacementStateCancelled = "CANCELLED"

	// GameSessionPlacementStateTimedOut is a GameSessionPlacementState enum value
	GameSessionPlacementStateTimedOut = "TIMED_OUT"
)

const (
	// GameSessionStatusActive is a GameSessionStatus enum value
	GameSessionStatusActive = "ACTIVE"

	// GameSessionStatusActivating is a GameSessionStatus enum value
	GameSessionStatusActivating = "ACTIVATING"

	// GameSessionStatusTerminated is a GameSessionStatus enum value
	GameSessionStatusTerminated = "TERMINATED"

	// GameSessionStatusTerminating is a GameSessionStatus enum value
	GameSessionStatusTerminating = "TERMINATING"

	// GameSessionStatusError is a GameSessionStatus enum value
	GameSessionStatusError = "ERROR"
)

const (
	// InstanceStatusPending is a InstanceStatus enum value
	InstanceStatusPending = "PENDING"

	// InstanceStatusActive is a InstanceStatus enum value
	InstanceStatusActive = "ACTIVE"

	// InstanceStatusTerminating is a InstanceStatus enum value
	InstanceStatusTerminating = "TERMINATING"
)

const (
	// IpProtocolTcp is a IpProtocol enum value
	IpProtocolTcp = "TCP"

	// IpProtocolUdp is a IpProtocol enum value
	IpProtocolUdp = "UDP"
)

const (
	// MetricNameActivatingGameSessions is a MetricName enum value
	MetricNameActivatingGameSessions = "ActivatingGameSessions"

	// MetricNameActiveGameSessions is a MetricName enum value
	MetricNameActiveGameSessions = "ActiveGameSessions"

	// MetricNameActiveInstances is a MetricName enum value
	MetricNameActiveInstances = "ActiveInstances"

	// MetricNameAvailableGameSessions is a MetricName enum value
	MetricNameAvailableGameSessions = "AvailableGameSessions"

	// MetricNameAvailablePlayerSessions is a MetricName enum value
	MetricNameAvailablePlayerSessions = "AvailablePlayerSessions"

	// MetricNameCurrentPlayerSessions is a MetricName enum value
	MetricNameCurrentPlayerSessions = "CurrentPlayerSessions"

	// MetricNameIdleInstances is a MetricName enum value
	MetricNameIdleInstances = "IdleInstances"

	// MetricNamePercentAvailableGameSessions is a MetricName enum value
	MetricNamePercentAvailableGameSessions = "PercentAvailableGameSessions"

	// MetricNamePercentIdleInstances is a MetricName enum value
	MetricNamePercentIdleInstances = "PercentIdleInstances"

	// MetricNameQueueDepth is a MetricName enum value
	MetricNameQueueDepth = "QueueDepth"

	// MetricNameWaitTime is a MetricName enum value
	MetricNameWaitTime = "WaitTime"
)

const (
	// OperatingSystemWindows2012 is a OperatingSystem enum value
	OperatingSystemWindows2012 = "WINDOWS_2012"

	// OperatingSystemAmazonLinux is a OperatingSystem enum value
	OperatingSystemAmazonLinux = "AMAZON_LINUX"
)

const (
	// PlayerSessionCreationPolicyAcceptAll is a PlayerSessionCreationPolicy enum value
	PlayerSessionCreationPolicyAcceptAll = "ACCEPT_ALL"

	// PlayerSessionCreationPolicyDenyAll is a PlayerSessionCreationPolicy enum value
	PlayerSessionCreationPolicyDenyAll = "DENY_ALL"
)

const (
	// PlayerSessionStatusReserved is a PlayerSessionStatus enum value
	PlayerSessionStatusReserved = "RESERVED"

	// PlayerSessionStatusActive is a PlayerSessionStatus enum value
	PlayerSessionStatusActive = "ACTIVE"

	// PlayerSessionStatusCompleted is a PlayerSessionStatus enum value
	PlayerSessionStatusCompleted = "COMPLETED"

	// PlayerSessionStatusTimedout is a PlayerSessionStatus enum value
	PlayerSessionStatusTimedout = "TIMEDOUT"
)

const (
	// ProtectionPolicyNoProtection is a ProtectionPolicy enum value
	ProtectionPolicyNoProtection = "NoProtection"

	// ProtectionPolicyFullProtection is a ProtectionPolicy enum value
	ProtectionPolicyFullProtection = "FullProtection"
)

const (
	// RoutingStrategyTypeSimple is a RoutingStrategyType enum value
	RoutingStrategyTypeSimple = "SIMPLE"

	// RoutingStrategyTypeTerminal is a RoutingStrategyType enum value
	RoutingStrategyTypeTerminal = "TERMINAL"
)

const (
	// ScalingAdjustmentTypeChangeInCapacity is a ScalingAdjustmentType enum value
	ScalingAdjustmentTypeChangeInCapacity = "ChangeInCapacity"

	// ScalingAdjustmentTypeExactCapacity is a ScalingAdjustmentType enum value
	ScalingAdjustmentTypeExactCapacity = "ExactCapacity"

	// ScalingAdjustmentTypePercentChangeInCapacity is a ScalingAdjustmentType enum value
	ScalingAdjustmentTypePercentChangeInCapacity = "PercentChangeInCapacity"
)

const (
	// ScalingStatusTypeActive is a ScalingStatusType enum value
	ScalingStatusTypeActive = "ACTIVE"

	// ScalingStatusTypeUpdateRequested is a ScalingStatusType enum value
	ScalingStatusTypeUpdateRequested = "UPDATE_REQUESTED"

	// ScalingStatusTypeUpdating is a ScalingStatusType enum value
	ScalingStatusTypeUpdating = "UPDATING"

	// ScalingStatusTypeDeleteRequested is a ScalingStatusType enum value
	ScalingStatusTypeDeleteRequested = "DELETE_REQUESTED"

	// ScalingStatusTypeDeleting is a ScalingStatusType enum value
	ScalingStatusTypeDeleting = "DELETING"

	// ScalingStatusTypeDeleted is a ScalingStatusType enum value
	ScalingStatusTypeDeleted = "DELETED"

	// ScalingStatusTypeError is a ScalingStatusType enum value
	ScalingStatusTypeError = "ERROR"
)
