// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/common/user_lists.proto

package common // import "google.golang.org/genproto/googleapis/ads/googleads/v1/common"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// SimilarUserList is a list of users which are similar to users from another
// UserList. These lists are read-only and automatically created by Google.
type SimilarUserListInfo struct {
	// Seed UserList from which this list is derived.
	SeedUserList         *wrappers.StringValue `protobuf:"bytes,1,opt,name=seed_user_list,json=seedUserList,proto3" json:"seed_user_list,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SimilarUserListInfo) Reset()         { *m = SimilarUserListInfo{} }
func (m *SimilarUserListInfo) String() string { return proto.CompactTextString(m) }
func (*SimilarUserListInfo) ProtoMessage()    {}
func (*SimilarUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{0}
}
func (m *SimilarUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SimilarUserListInfo.Unmarshal(m, b)
}
func (m *SimilarUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SimilarUserListInfo.Marshal(b, m, deterministic)
}
func (dst *SimilarUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimilarUserListInfo.Merge(dst, src)
}
func (m *SimilarUserListInfo) XXX_Size() int {
	return xxx_messageInfo_SimilarUserListInfo.Size(m)
}
func (m *SimilarUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SimilarUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SimilarUserListInfo proto.InternalMessageInfo

func (m *SimilarUserListInfo) GetSeedUserList() *wrappers.StringValue {
	if m != nil {
		return m.SeedUserList
	}
	return nil
}

// UserList of CRM users provided by the advertiser.
type CrmBasedUserListInfo struct {
	// A string that uniquely identifies a mobile application from which the data
	// was collected to the Google Ads API.
	// For iOS, the ID string is the 9 digit string that appears at the end of an
	// App Store URL (e.g., "476943146" for "Flood-It! 2" whose App Store link is
	// http://itunes.apple.com/us/app/flood-it!-2/id476943146).
	// For Android, the ID string is the application's package name
	// (e.g., "com.labpixies.colordrips" for "Color Drips" given Google Play link
	// https://play.google.com/store/apps/details?id=com.labpixies.colordrips).
	// Required when creating CrmBasedUserList for uploading mobile advertising
	// IDs.
	AppId *wrappers.StringValue `protobuf:"bytes,1,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
	// Matching key type of the list.
	// Mixed data types are not allowed on the same list.
	// This field is required for an ADD operation.
	UploadKeyType enums.CustomerMatchUploadKeyTypeEnum_CustomerMatchUploadKeyType `protobuf:"varint,2,opt,name=upload_key_type,json=uploadKeyType,proto3,enum=google.ads.googleads.v1.enums.CustomerMatchUploadKeyTypeEnum_CustomerMatchUploadKeyType" json:"upload_key_type,omitempty"`
	// Data source of the list. Default value is FIRST_PARTY.
	// Only whitelisted customers can create third-party sourced CRM lists.
	DataSourceType       enums.UserListCrmDataSourceTypeEnum_UserListCrmDataSourceType `protobuf:"varint,3,opt,name=data_source_type,json=dataSourceType,proto3,enum=google.ads.googleads.v1.enums.UserListCrmDataSourceTypeEnum_UserListCrmDataSourceType" json:"data_source_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                      `json:"-"`
	XXX_unrecognized     []byte                                                        `json:"-"`
	XXX_sizecache        int32                                                         `json:"-"`
}

func (m *CrmBasedUserListInfo) Reset()         { *m = CrmBasedUserListInfo{} }
func (m *CrmBasedUserListInfo) String() string { return proto.CompactTextString(m) }
func (*CrmBasedUserListInfo) ProtoMessage()    {}
func (*CrmBasedUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{1}
}
func (m *CrmBasedUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CrmBasedUserListInfo.Unmarshal(m, b)
}
func (m *CrmBasedUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CrmBasedUserListInfo.Marshal(b, m, deterministic)
}
func (dst *CrmBasedUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CrmBasedUserListInfo.Merge(dst, src)
}
func (m *CrmBasedUserListInfo) XXX_Size() int {
	return xxx_messageInfo_CrmBasedUserListInfo.Size(m)
}
func (m *CrmBasedUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CrmBasedUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CrmBasedUserListInfo proto.InternalMessageInfo

func (m *CrmBasedUserListInfo) GetAppId() *wrappers.StringValue {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *CrmBasedUserListInfo) GetUploadKeyType() enums.CustomerMatchUploadKeyTypeEnum_CustomerMatchUploadKeyType {
	if m != nil {
		return m.UploadKeyType
	}
	return enums.CustomerMatchUploadKeyTypeEnum_UNSPECIFIED
}

func (m *CrmBasedUserListInfo) GetDataSourceType() enums.UserListCrmDataSourceTypeEnum_UserListCrmDataSourceType {
	if m != nil {
		return m.DataSourceType
	}
	return enums.UserListCrmDataSourceTypeEnum_UNSPECIFIED
}

// A client defined rule based on custom parameters sent by web sites or
// uploaded by the advertiser.
type UserListRuleInfo struct {
	// Rule type is used to determine how to group rule items.
	//
	// The default is OR of ANDs (disjunctive normal form).
	// That is, rule items will be ANDed together within rule item groups and the
	// groups themselves will be ORed together.
	//
	// Currently AND of ORs (conjunctive normal form) is only supported for
	// ExpressionRuleUserList.
	RuleType enums.UserListRuleTypeEnum_UserListRuleType `protobuf:"varint,1,opt,name=rule_type,json=ruleType,proto3,enum=google.ads.googleads.v1.enums.UserListRuleTypeEnum_UserListRuleType" json:"rule_type,omitempty"`
	// List of rule item groups that defines this rule.
	// Rule item groups are grouped together based on rule_type.
	RuleItemGroups       []*UserListRuleItemGroupInfo `protobuf:"bytes,2,rep,name=rule_item_groups,json=ruleItemGroups,proto3" json:"rule_item_groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *UserListRuleInfo) Reset()         { *m = UserListRuleInfo{} }
func (m *UserListRuleInfo) String() string { return proto.CompactTextString(m) }
func (*UserListRuleInfo) ProtoMessage()    {}
func (*UserListRuleInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{2}
}
func (m *UserListRuleInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListRuleInfo.Unmarshal(m, b)
}
func (m *UserListRuleInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListRuleInfo.Marshal(b, m, deterministic)
}
func (dst *UserListRuleInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListRuleInfo.Merge(dst, src)
}
func (m *UserListRuleInfo) XXX_Size() int {
	return xxx_messageInfo_UserListRuleInfo.Size(m)
}
func (m *UserListRuleInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListRuleInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListRuleInfo proto.InternalMessageInfo

func (m *UserListRuleInfo) GetRuleType() enums.UserListRuleTypeEnum_UserListRuleType {
	if m != nil {
		return m.RuleType
	}
	return enums.UserListRuleTypeEnum_UNSPECIFIED
}

func (m *UserListRuleInfo) GetRuleItemGroups() []*UserListRuleItemGroupInfo {
	if m != nil {
		return m.RuleItemGroups
	}
	return nil
}

// A group of rule items.
type UserListRuleItemGroupInfo struct {
	// Rule items that will be grouped together based on rule_type.
	RuleItems            []*UserListRuleItemInfo `protobuf:"bytes,1,rep,name=rule_items,json=ruleItems,proto3" json:"rule_items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *UserListRuleItemGroupInfo) Reset()         { *m = UserListRuleItemGroupInfo{} }
func (m *UserListRuleItemGroupInfo) String() string { return proto.CompactTextString(m) }
func (*UserListRuleItemGroupInfo) ProtoMessage()    {}
func (*UserListRuleItemGroupInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{3}
}
func (m *UserListRuleItemGroupInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListRuleItemGroupInfo.Unmarshal(m, b)
}
func (m *UserListRuleItemGroupInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListRuleItemGroupInfo.Marshal(b, m, deterministic)
}
func (dst *UserListRuleItemGroupInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListRuleItemGroupInfo.Merge(dst, src)
}
func (m *UserListRuleItemGroupInfo) XXX_Size() int {
	return xxx_messageInfo_UserListRuleItemGroupInfo.Size(m)
}
func (m *UserListRuleItemGroupInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListRuleItemGroupInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListRuleItemGroupInfo proto.InternalMessageInfo

func (m *UserListRuleItemGroupInfo) GetRuleItems() []*UserListRuleItemInfo {
	if m != nil {
		return m.RuleItems
	}
	return nil
}

// An atomic rule fragment.
type UserListRuleItemInfo struct {
	// Rule variable name. It should match the corresponding key name fired
	// by the pixel.
	// A name must begin with US-ascii letters or underscore or UTF8 code that is
	// greater than 127 and consist of US-ascii letters or digits or underscore or
	// UTF8 code that is greater than 127.
	// For websites, there are two built-in variable URL (name = 'url__') and
	// referrer URL (name = 'ref_url__').
	// This field must be populated when creating a new rule item.
	Name *wrappers.StringValue `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An atomic rule fragment.
	//
	// Types that are valid to be assigned to RuleItem:
	//	*UserListRuleItemInfo_NumberRuleItem
	//	*UserListRuleItemInfo_StringRuleItem
	//	*UserListRuleItemInfo_DateRuleItem
	RuleItem             isUserListRuleItemInfo_RuleItem `protobuf_oneof:"rule_item"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *UserListRuleItemInfo) Reset()         { *m = UserListRuleItemInfo{} }
func (m *UserListRuleItemInfo) String() string { return proto.CompactTextString(m) }
func (*UserListRuleItemInfo) ProtoMessage()    {}
func (*UserListRuleItemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{4}
}
func (m *UserListRuleItemInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListRuleItemInfo.Unmarshal(m, b)
}
func (m *UserListRuleItemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListRuleItemInfo.Marshal(b, m, deterministic)
}
func (dst *UserListRuleItemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListRuleItemInfo.Merge(dst, src)
}
func (m *UserListRuleItemInfo) XXX_Size() int {
	return xxx_messageInfo_UserListRuleItemInfo.Size(m)
}
func (m *UserListRuleItemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListRuleItemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListRuleItemInfo proto.InternalMessageInfo

func (m *UserListRuleItemInfo) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

type isUserListRuleItemInfo_RuleItem interface {
	isUserListRuleItemInfo_RuleItem()
}

type UserListRuleItemInfo_NumberRuleItem struct {
	NumberRuleItem *UserListNumberRuleItemInfo `protobuf:"bytes,2,opt,name=number_rule_item,json=numberRuleItem,proto3,oneof"`
}

type UserListRuleItemInfo_StringRuleItem struct {
	StringRuleItem *UserListStringRuleItemInfo `protobuf:"bytes,3,opt,name=string_rule_item,json=stringRuleItem,proto3,oneof"`
}

type UserListRuleItemInfo_DateRuleItem struct {
	DateRuleItem *UserListDateRuleItemInfo `protobuf:"bytes,4,opt,name=date_rule_item,json=dateRuleItem,proto3,oneof"`
}

func (*UserListRuleItemInfo_NumberRuleItem) isUserListRuleItemInfo_RuleItem() {}

func (*UserListRuleItemInfo_StringRuleItem) isUserListRuleItemInfo_RuleItem() {}

func (*UserListRuleItemInfo_DateRuleItem) isUserListRuleItemInfo_RuleItem() {}

func (m *UserListRuleItemInfo) GetRuleItem() isUserListRuleItemInfo_RuleItem {
	if m != nil {
		return m.RuleItem
	}
	return nil
}

func (m *UserListRuleItemInfo) GetNumberRuleItem() *UserListNumberRuleItemInfo {
	if x, ok := m.GetRuleItem().(*UserListRuleItemInfo_NumberRuleItem); ok {
		return x.NumberRuleItem
	}
	return nil
}

func (m *UserListRuleItemInfo) GetStringRuleItem() *UserListStringRuleItemInfo {
	if x, ok := m.GetRuleItem().(*UserListRuleItemInfo_StringRuleItem); ok {
		return x.StringRuleItem
	}
	return nil
}

func (m *UserListRuleItemInfo) GetDateRuleItem() *UserListDateRuleItemInfo {
	if x, ok := m.GetRuleItem().(*UserListRuleItemInfo_DateRuleItem); ok {
		return x.DateRuleItem
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UserListRuleItemInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UserListRuleItemInfo_OneofMarshaler, _UserListRuleItemInfo_OneofUnmarshaler, _UserListRuleItemInfo_OneofSizer, []interface{}{
		(*UserListRuleItemInfo_NumberRuleItem)(nil),
		(*UserListRuleItemInfo_StringRuleItem)(nil),
		(*UserListRuleItemInfo_DateRuleItem)(nil),
	}
}

func _UserListRuleItemInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UserListRuleItemInfo)
	// rule_item
	switch x := m.RuleItem.(type) {
	case *UserListRuleItemInfo_NumberRuleItem:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NumberRuleItem); err != nil {
			return err
		}
	case *UserListRuleItemInfo_StringRuleItem:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StringRuleItem); err != nil {
			return err
		}
	case *UserListRuleItemInfo_DateRuleItem:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DateRuleItem); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UserListRuleItemInfo.RuleItem has unexpected type %T", x)
	}
	return nil
}

func _UserListRuleItemInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UserListRuleItemInfo)
	switch tag {
	case 2: // rule_item.number_rule_item
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UserListNumberRuleItemInfo)
		err := b.DecodeMessage(msg)
		m.RuleItem = &UserListRuleItemInfo_NumberRuleItem{msg}
		return true, err
	case 3: // rule_item.string_rule_item
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UserListStringRuleItemInfo)
		err := b.DecodeMessage(msg)
		m.RuleItem = &UserListRuleItemInfo_StringRuleItem{msg}
		return true, err
	case 4: // rule_item.date_rule_item
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UserListDateRuleItemInfo)
		err := b.DecodeMessage(msg)
		m.RuleItem = &UserListRuleItemInfo_DateRuleItem{msg}
		return true, err
	default:
		return false, nil
	}
}

func _UserListRuleItemInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UserListRuleItemInfo)
	// rule_item
	switch x := m.RuleItem.(type) {
	case *UserListRuleItemInfo_NumberRuleItem:
		s := proto.Size(x.NumberRuleItem)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserListRuleItemInfo_StringRuleItem:
		s := proto.Size(x.StringRuleItem)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserListRuleItemInfo_DateRuleItem:
		s := proto.Size(x.DateRuleItem)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A rule item composed of date operation.
type UserListDateRuleItemInfo struct {
	// Date comparison operator.
	// This field is required and must be populated when creating new date
	// rule item.
	Operator enums.UserListDateRuleItemOperatorEnum_UserListDateRuleItemOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v1.enums.UserListDateRuleItemOperatorEnum_UserListDateRuleItemOperator" json:"operator,omitempty"`
	// String representing date value to be compared with the rule variable.
	// Supported date format is YYYY-MM-DD.
	// Times are reported in the customer's time zone.
	Value *wrappers.StringValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// The relative date value of the right hand side denoted by number of days
	// offset from now. The value field will override this field when both are
	// present.
	OffsetInDays         *wrappers.Int64Value `protobuf:"bytes,3,opt,name=offset_in_days,json=offsetInDays,proto3" json:"offset_in_days,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UserListDateRuleItemInfo) Reset()         { *m = UserListDateRuleItemInfo{} }
func (m *UserListDateRuleItemInfo) String() string { return proto.CompactTextString(m) }
func (*UserListDateRuleItemInfo) ProtoMessage()    {}
func (*UserListDateRuleItemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{5}
}
func (m *UserListDateRuleItemInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListDateRuleItemInfo.Unmarshal(m, b)
}
func (m *UserListDateRuleItemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListDateRuleItemInfo.Marshal(b, m, deterministic)
}
func (dst *UserListDateRuleItemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListDateRuleItemInfo.Merge(dst, src)
}
func (m *UserListDateRuleItemInfo) XXX_Size() int {
	return xxx_messageInfo_UserListDateRuleItemInfo.Size(m)
}
func (m *UserListDateRuleItemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListDateRuleItemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListDateRuleItemInfo proto.InternalMessageInfo

func (m *UserListDateRuleItemInfo) GetOperator() enums.UserListDateRuleItemOperatorEnum_UserListDateRuleItemOperator {
	if m != nil {
		return m.Operator
	}
	return enums.UserListDateRuleItemOperatorEnum_UNSPECIFIED
}

func (m *UserListDateRuleItemInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *UserListDateRuleItemInfo) GetOffsetInDays() *wrappers.Int64Value {
	if m != nil {
		return m.OffsetInDays
	}
	return nil
}

// A rule item composed of number operation.
type UserListNumberRuleItemInfo struct {
	// Number comparison operator.
	// This field is required and must be populated when creating a new number
	// rule item.
	Operator enums.UserListNumberRuleItemOperatorEnum_UserListNumberRuleItemOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v1.enums.UserListNumberRuleItemOperatorEnum_UserListNumberRuleItemOperator" json:"operator,omitempty"`
	// Number value to be compared with the variable.
	// This field is required and must be populated when creating a new number
	// rule item.
	Value                *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UserListNumberRuleItemInfo) Reset()         { *m = UserListNumberRuleItemInfo{} }
func (m *UserListNumberRuleItemInfo) String() string { return proto.CompactTextString(m) }
func (*UserListNumberRuleItemInfo) ProtoMessage()    {}
func (*UserListNumberRuleItemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{6}
}
func (m *UserListNumberRuleItemInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListNumberRuleItemInfo.Unmarshal(m, b)
}
func (m *UserListNumberRuleItemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListNumberRuleItemInfo.Marshal(b, m, deterministic)
}
func (dst *UserListNumberRuleItemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListNumberRuleItemInfo.Merge(dst, src)
}
func (m *UserListNumberRuleItemInfo) XXX_Size() int {
	return xxx_messageInfo_UserListNumberRuleItemInfo.Size(m)
}
func (m *UserListNumberRuleItemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListNumberRuleItemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListNumberRuleItemInfo proto.InternalMessageInfo

func (m *UserListNumberRuleItemInfo) GetOperator() enums.UserListNumberRuleItemOperatorEnum_UserListNumberRuleItemOperator {
	if m != nil {
		return m.Operator
	}
	return enums.UserListNumberRuleItemOperatorEnum_UNSPECIFIED
}

func (m *UserListNumberRuleItemInfo) GetValue() *wrappers.DoubleValue {
	if m != nil {
		return m.Value
	}
	return nil
}

// A rule item fragment composed of date operation.
type UserListStringRuleItemInfo struct {
	// String comparison operator.
	// This field is required and must be populated when creating a new string
	// rule item.
	Operator enums.UserListStringRuleItemOperatorEnum_UserListStringRuleItemOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v1.enums.UserListStringRuleItemOperatorEnum_UserListStringRuleItemOperator" json:"operator,omitempty"`
	// The right hand side of the string rule item. For URLs or referrer URLs,
	// the value can not contain illegal URL chars such as newlines, quotes,
	// tabs, or parentheses. This field is required and must be populated when
	// creating a new string rule item.
	Value                *wrappers.StringValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UserListStringRuleItemInfo) Reset()         { *m = UserListStringRuleItemInfo{} }
func (m *UserListStringRuleItemInfo) String() string { return proto.CompactTextString(m) }
func (*UserListStringRuleItemInfo) ProtoMessage()    {}
func (*UserListStringRuleItemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{7}
}
func (m *UserListStringRuleItemInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListStringRuleItemInfo.Unmarshal(m, b)
}
func (m *UserListStringRuleItemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListStringRuleItemInfo.Marshal(b, m, deterministic)
}
func (dst *UserListStringRuleItemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListStringRuleItemInfo.Merge(dst, src)
}
func (m *UserListStringRuleItemInfo) XXX_Size() int {
	return xxx_messageInfo_UserListStringRuleItemInfo.Size(m)
}
func (m *UserListStringRuleItemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListStringRuleItemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListStringRuleItemInfo proto.InternalMessageInfo

func (m *UserListStringRuleItemInfo) GetOperator() enums.UserListStringRuleItemOperatorEnum_UserListStringRuleItemOperator {
	if m != nil {
		return m.Operator
	}
	return enums.UserListStringRuleItemOperatorEnum_UNSPECIFIED
}

func (m *UserListStringRuleItemInfo) GetValue() *wrappers.StringValue {
	if m != nil {
		return m.Value
	}
	return nil
}

// User lists defined by combining two rules, left operand and right operand.
// There are two operators: AND where left operand and right operand have to be
// true; AND_NOT where left operand is true but right operand is false.
type CombinedRuleUserListInfo struct {
	// Left operand of the combined rule.
	// This field is required and must be populated when creating new combined
	// rule based user list.
	LeftOperand *UserListRuleInfo `protobuf:"bytes,1,opt,name=left_operand,json=leftOperand,proto3" json:"left_operand,omitempty"`
	// Right operand of the combined rule.
	// This field is required and must be populated when creating new combined
	// rule based user list.
	RightOperand *UserListRuleInfo `protobuf:"bytes,2,opt,name=right_operand,json=rightOperand,proto3" json:"right_operand,omitempty"`
	// Operator to connect the two operands.
	//
	// Required for creating a combined rule user list.
	RuleOperator         enums.UserListCombinedRuleOperatorEnum_UserListCombinedRuleOperator `protobuf:"varint,3,opt,name=rule_operator,json=ruleOperator,proto3,enum=google.ads.googleads.v1.enums.UserListCombinedRuleOperatorEnum_UserListCombinedRuleOperator" json:"rule_operator,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                            `json:"-"`
	XXX_unrecognized     []byte                                                              `json:"-"`
	XXX_sizecache        int32                                                               `json:"-"`
}

func (m *CombinedRuleUserListInfo) Reset()         { *m = CombinedRuleUserListInfo{} }
func (m *CombinedRuleUserListInfo) String() string { return proto.CompactTextString(m) }
func (*CombinedRuleUserListInfo) ProtoMessage()    {}
func (*CombinedRuleUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{8}
}
func (m *CombinedRuleUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CombinedRuleUserListInfo.Unmarshal(m, b)
}
func (m *CombinedRuleUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CombinedRuleUserListInfo.Marshal(b, m, deterministic)
}
func (dst *CombinedRuleUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CombinedRuleUserListInfo.Merge(dst, src)
}
func (m *CombinedRuleUserListInfo) XXX_Size() int {
	return xxx_messageInfo_CombinedRuleUserListInfo.Size(m)
}
func (m *CombinedRuleUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CombinedRuleUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CombinedRuleUserListInfo proto.InternalMessageInfo

func (m *CombinedRuleUserListInfo) GetLeftOperand() *UserListRuleInfo {
	if m != nil {
		return m.LeftOperand
	}
	return nil
}

func (m *CombinedRuleUserListInfo) GetRightOperand() *UserListRuleInfo {
	if m != nil {
		return m.RightOperand
	}
	return nil
}

func (m *CombinedRuleUserListInfo) GetRuleOperator() enums.UserListCombinedRuleOperatorEnum_UserListCombinedRuleOperator {
	if m != nil {
		return m.RuleOperator
	}
	return enums.UserListCombinedRuleOperatorEnum_UNSPECIFIED
}

// Visitors of a page during specific dates.
type DateSpecificRuleUserListInfo struct {
	// Boolean rule that defines visitor of a page.
	//
	// Required for creating a date specific rule user list.
	Rule *UserListRuleInfo `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
	// Start date of users visit. If set to 2000-01-01, then the list includes all
	// users before end_date. The date's format should be YYYY-MM-DD.
	//
	// Required for creating a data specific rule user list.
	StartDate *wrappers.StringValue `protobuf:"bytes,2,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// End date of users visit. If set to 2037-12-30, then the list includes all
	// users after start_date. The date's format should be YYYY-MM-DD.
	//
	// Required for creating a data specific rule user list.
	EndDate              *wrappers.StringValue `protobuf:"bytes,3,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *DateSpecificRuleUserListInfo) Reset()         { *m = DateSpecificRuleUserListInfo{} }
func (m *DateSpecificRuleUserListInfo) String() string { return proto.CompactTextString(m) }
func (*DateSpecificRuleUserListInfo) ProtoMessage()    {}
func (*DateSpecificRuleUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{9}
}
func (m *DateSpecificRuleUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DateSpecificRuleUserListInfo.Unmarshal(m, b)
}
func (m *DateSpecificRuleUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DateSpecificRuleUserListInfo.Marshal(b, m, deterministic)
}
func (dst *DateSpecificRuleUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DateSpecificRuleUserListInfo.Merge(dst, src)
}
func (m *DateSpecificRuleUserListInfo) XXX_Size() int {
	return xxx_messageInfo_DateSpecificRuleUserListInfo.Size(m)
}
func (m *DateSpecificRuleUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DateSpecificRuleUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DateSpecificRuleUserListInfo proto.InternalMessageInfo

func (m *DateSpecificRuleUserListInfo) GetRule() *UserListRuleInfo {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *DateSpecificRuleUserListInfo) GetStartDate() *wrappers.StringValue {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *DateSpecificRuleUserListInfo) GetEndDate() *wrappers.StringValue {
	if m != nil {
		return m.EndDate
	}
	return nil
}

// Visitors of a page. The page visit is defined by one boolean rule expression.
type ExpressionRuleUserListInfo struct {
	// Boolean rule that defines this user list. The rule consists of a list of
	// rule item groups and each rule item group consists of a list of rule items.
	// All the rule item groups are ORed or ANDed together for evaluation based on
	// rule.rule_type.
	//
	// Required for creating an expression rule user list.
	Rule                 *UserListRuleInfo `protobuf:"bytes,1,opt,name=rule,proto3" json:"rule,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ExpressionRuleUserListInfo) Reset()         { *m = ExpressionRuleUserListInfo{} }
func (m *ExpressionRuleUserListInfo) String() string { return proto.CompactTextString(m) }
func (*ExpressionRuleUserListInfo) ProtoMessage()    {}
func (*ExpressionRuleUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{10}
}
func (m *ExpressionRuleUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExpressionRuleUserListInfo.Unmarshal(m, b)
}
func (m *ExpressionRuleUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExpressionRuleUserListInfo.Marshal(b, m, deterministic)
}
func (dst *ExpressionRuleUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExpressionRuleUserListInfo.Merge(dst, src)
}
func (m *ExpressionRuleUserListInfo) XXX_Size() int {
	return xxx_messageInfo_ExpressionRuleUserListInfo.Size(m)
}
func (m *ExpressionRuleUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExpressionRuleUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExpressionRuleUserListInfo proto.InternalMessageInfo

func (m *ExpressionRuleUserListInfo) GetRule() *UserListRuleInfo {
	if m != nil {
		return m.Rule
	}
	return nil
}

// Representation of a userlist that is generated by a rule.
type RuleBasedUserListInfo struct {
	// The status of pre-population. The field is default to NONE if not set which
	// means the previous users will not be considered. If set to REQUESTED, past
	// site visitors or app users who match the list definition will be included
	// in the list (works on the Display Network only). This will only
	// add past users from within the last 30 days, depending on the
	// list's membership duration and the date when the remarketing tag is added.
	// The status will be updated to FINISHED once request is processed, or FAILED
	// if the request fails.
	PrepopulationStatus enums.UserListPrepopulationStatusEnum_UserListPrepopulationStatus `protobuf:"varint,1,opt,name=prepopulation_status,json=prepopulationStatus,proto3,enum=google.ads.googleads.v1.enums.UserListPrepopulationStatusEnum_UserListPrepopulationStatus" json:"prepopulation_status,omitempty"`
	// Subtypes of rule based user lists.
	//
	// Types that are valid to be assigned to RuleBasedUserList:
	//	*RuleBasedUserListInfo_CombinedRuleUserList
	//	*RuleBasedUserListInfo_DateSpecificRuleUserList
	//	*RuleBasedUserListInfo_ExpressionRuleUserList
	RuleBasedUserList    isRuleBasedUserListInfo_RuleBasedUserList `protobuf_oneof:"rule_based_user_list"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *RuleBasedUserListInfo) Reset()         { *m = RuleBasedUserListInfo{} }
func (m *RuleBasedUserListInfo) String() string { return proto.CompactTextString(m) }
func (*RuleBasedUserListInfo) ProtoMessage()    {}
func (*RuleBasedUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{11}
}
func (m *RuleBasedUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RuleBasedUserListInfo.Unmarshal(m, b)
}
func (m *RuleBasedUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RuleBasedUserListInfo.Marshal(b, m, deterministic)
}
func (dst *RuleBasedUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuleBasedUserListInfo.Merge(dst, src)
}
func (m *RuleBasedUserListInfo) XXX_Size() int {
	return xxx_messageInfo_RuleBasedUserListInfo.Size(m)
}
func (m *RuleBasedUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_RuleBasedUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_RuleBasedUserListInfo proto.InternalMessageInfo

func (m *RuleBasedUserListInfo) GetPrepopulationStatus() enums.UserListPrepopulationStatusEnum_UserListPrepopulationStatus {
	if m != nil {
		return m.PrepopulationStatus
	}
	return enums.UserListPrepopulationStatusEnum_UNSPECIFIED
}

type isRuleBasedUserListInfo_RuleBasedUserList interface {
	isRuleBasedUserListInfo_RuleBasedUserList()
}

type RuleBasedUserListInfo_CombinedRuleUserList struct {
	CombinedRuleUserList *CombinedRuleUserListInfo `protobuf:"bytes,2,opt,name=combined_rule_user_list,json=combinedRuleUserList,proto3,oneof"`
}

type RuleBasedUserListInfo_DateSpecificRuleUserList struct {
	DateSpecificRuleUserList *DateSpecificRuleUserListInfo `protobuf:"bytes,3,opt,name=date_specific_rule_user_list,json=dateSpecificRuleUserList,proto3,oneof"`
}

type RuleBasedUserListInfo_ExpressionRuleUserList struct {
	ExpressionRuleUserList *ExpressionRuleUserListInfo `protobuf:"bytes,4,opt,name=expression_rule_user_list,json=expressionRuleUserList,proto3,oneof"`
}

func (*RuleBasedUserListInfo_CombinedRuleUserList) isRuleBasedUserListInfo_RuleBasedUserList() {}

func (*RuleBasedUserListInfo_DateSpecificRuleUserList) isRuleBasedUserListInfo_RuleBasedUserList() {}

func (*RuleBasedUserListInfo_ExpressionRuleUserList) isRuleBasedUserListInfo_RuleBasedUserList() {}

func (m *RuleBasedUserListInfo) GetRuleBasedUserList() isRuleBasedUserListInfo_RuleBasedUserList {
	if m != nil {
		return m.RuleBasedUserList
	}
	return nil
}

func (m *RuleBasedUserListInfo) GetCombinedRuleUserList() *CombinedRuleUserListInfo {
	if x, ok := m.GetRuleBasedUserList().(*RuleBasedUserListInfo_CombinedRuleUserList); ok {
		return x.CombinedRuleUserList
	}
	return nil
}

func (m *RuleBasedUserListInfo) GetDateSpecificRuleUserList() *DateSpecificRuleUserListInfo {
	if x, ok := m.GetRuleBasedUserList().(*RuleBasedUserListInfo_DateSpecificRuleUserList); ok {
		return x.DateSpecificRuleUserList
	}
	return nil
}

func (m *RuleBasedUserListInfo) GetExpressionRuleUserList() *ExpressionRuleUserListInfo {
	if x, ok := m.GetRuleBasedUserList().(*RuleBasedUserListInfo_ExpressionRuleUserList); ok {
		return x.ExpressionRuleUserList
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RuleBasedUserListInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RuleBasedUserListInfo_OneofMarshaler, _RuleBasedUserListInfo_OneofUnmarshaler, _RuleBasedUserListInfo_OneofSizer, []interface{}{
		(*RuleBasedUserListInfo_CombinedRuleUserList)(nil),
		(*RuleBasedUserListInfo_DateSpecificRuleUserList)(nil),
		(*RuleBasedUserListInfo_ExpressionRuleUserList)(nil),
	}
}

func _RuleBasedUserListInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RuleBasedUserListInfo)
	// rule_based_user_list
	switch x := m.RuleBasedUserList.(type) {
	case *RuleBasedUserListInfo_CombinedRuleUserList:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CombinedRuleUserList); err != nil {
			return err
		}
	case *RuleBasedUserListInfo_DateSpecificRuleUserList:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DateSpecificRuleUserList); err != nil {
			return err
		}
	case *RuleBasedUserListInfo_ExpressionRuleUserList:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExpressionRuleUserList); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RuleBasedUserListInfo.RuleBasedUserList has unexpected type %T", x)
	}
	return nil
}

func _RuleBasedUserListInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RuleBasedUserListInfo)
	switch tag {
	case 2: // rule_based_user_list.combined_rule_user_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CombinedRuleUserListInfo)
		err := b.DecodeMessage(msg)
		m.RuleBasedUserList = &RuleBasedUserListInfo_CombinedRuleUserList{msg}
		return true, err
	case 3: // rule_based_user_list.date_specific_rule_user_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DateSpecificRuleUserListInfo)
		err := b.DecodeMessage(msg)
		m.RuleBasedUserList = &RuleBasedUserListInfo_DateSpecificRuleUserList{msg}
		return true, err
	case 4: // rule_based_user_list.expression_rule_user_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExpressionRuleUserListInfo)
		err := b.DecodeMessage(msg)
		m.RuleBasedUserList = &RuleBasedUserListInfo_ExpressionRuleUserList{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RuleBasedUserListInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RuleBasedUserListInfo)
	// rule_based_user_list
	switch x := m.RuleBasedUserList.(type) {
	case *RuleBasedUserListInfo_CombinedRuleUserList:
		s := proto.Size(x.CombinedRuleUserList)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RuleBasedUserListInfo_DateSpecificRuleUserList:
		s := proto.Size(x.DateSpecificRuleUserList)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RuleBasedUserListInfo_ExpressionRuleUserList:
		s := proto.Size(x.ExpressionRuleUserList)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Represents a user list that is a custom combination of user lists.
type LogicalUserListInfo struct {
	// Logical list rules that define this user list. The rules are defined as a
	// logical operator (ALL/ANY/NONE) and a list of user lists. All the rules are
	// ANDed when they are evaluated.
	//
	// Required for creating a logical user list.
	Rules                []*UserListLogicalRuleInfo `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *LogicalUserListInfo) Reset()         { *m = LogicalUserListInfo{} }
func (m *LogicalUserListInfo) String() string { return proto.CompactTextString(m) }
func (*LogicalUserListInfo) ProtoMessage()    {}
func (*LogicalUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{12}
}
func (m *LogicalUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogicalUserListInfo.Unmarshal(m, b)
}
func (m *LogicalUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogicalUserListInfo.Marshal(b, m, deterministic)
}
func (dst *LogicalUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogicalUserListInfo.Merge(dst, src)
}
func (m *LogicalUserListInfo) XXX_Size() int {
	return xxx_messageInfo_LogicalUserListInfo.Size(m)
}
func (m *LogicalUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LogicalUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LogicalUserListInfo proto.InternalMessageInfo

func (m *LogicalUserListInfo) GetRules() []*UserListLogicalRuleInfo {
	if m != nil {
		return m.Rules
	}
	return nil
}

// A user list logical rule. A rule has a logical operator (and/or/not) and a
// list of user lists as operands.
type UserListLogicalRuleInfo struct {
	// The logical operator of the rule.
	Operator enums.UserListLogicalRuleOperatorEnum_UserListLogicalRuleOperator `protobuf:"varint,1,opt,name=operator,proto3,enum=google.ads.googleads.v1.enums.UserListLogicalRuleOperatorEnum_UserListLogicalRuleOperator" json:"operator,omitempty"`
	// The list of operands of the rule.
	RuleOperands         []*LogicalUserListOperandInfo `protobuf:"bytes,2,rep,name=rule_operands,json=ruleOperands,proto3" json:"rule_operands,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *UserListLogicalRuleInfo) Reset()         { *m = UserListLogicalRuleInfo{} }
func (m *UserListLogicalRuleInfo) String() string { return proto.CompactTextString(m) }
func (*UserListLogicalRuleInfo) ProtoMessage()    {}
func (*UserListLogicalRuleInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{13}
}
func (m *UserListLogicalRuleInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListLogicalRuleInfo.Unmarshal(m, b)
}
func (m *UserListLogicalRuleInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListLogicalRuleInfo.Marshal(b, m, deterministic)
}
func (dst *UserListLogicalRuleInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListLogicalRuleInfo.Merge(dst, src)
}
func (m *UserListLogicalRuleInfo) XXX_Size() int {
	return xxx_messageInfo_UserListLogicalRuleInfo.Size(m)
}
func (m *UserListLogicalRuleInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListLogicalRuleInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListLogicalRuleInfo proto.InternalMessageInfo

func (m *UserListLogicalRuleInfo) GetOperator() enums.UserListLogicalRuleOperatorEnum_UserListLogicalRuleOperator {
	if m != nil {
		return m.Operator
	}
	return enums.UserListLogicalRuleOperatorEnum_UNSPECIFIED
}

func (m *UserListLogicalRuleInfo) GetRuleOperands() []*LogicalUserListOperandInfo {
	if m != nil {
		return m.RuleOperands
	}
	return nil
}

// Operand of logical user list that consists of a user list.
type LogicalUserListOperandInfo struct {
	// Resource name of a user list as an operand.
	UserList             *wrappers.StringValue `protobuf:"bytes,1,opt,name=user_list,json=userList,proto3" json:"user_list,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *LogicalUserListOperandInfo) Reset()         { *m = LogicalUserListOperandInfo{} }
func (m *LogicalUserListOperandInfo) String() string { return proto.CompactTextString(m) }
func (*LogicalUserListOperandInfo) ProtoMessage()    {}
func (*LogicalUserListOperandInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{14}
}
func (m *LogicalUserListOperandInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogicalUserListOperandInfo.Unmarshal(m, b)
}
func (m *LogicalUserListOperandInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogicalUserListOperandInfo.Marshal(b, m, deterministic)
}
func (dst *LogicalUserListOperandInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogicalUserListOperandInfo.Merge(dst, src)
}
func (m *LogicalUserListOperandInfo) XXX_Size() int {
	return xxx_messageInfo_LogicalUserListOperandInfo.Size(m)
}
func (m *LogicalUserListOperandInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LogicalUserListOperandInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LogicalUserListOperandInfo proto.InternalMessageInfo

func (m *LogicalUserListOperandInfo) GetUserList() *wrappers.StringValue {
	if m != nil {
		return m.UserList
	}
	return nil
}

// User list targeting as a collection of conversions or remarketing actions.
type BasicUserListInfo struct {
	// Actions associated with this user list.
	Actions              []*UserListActionInfo `protobuf:"bytes,1,rep,name=actions,proto3" json:"actions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BasicUserListInfo) Reset()         { *m = BasicUserListInfo{} }
func (m *BasicUserListInfo) String() string { return proto.CompactTextString(m) }
func (*BasicUserListInfo) ProtoMessage()    {}
func (*BasicUserListInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{15}
}
func (m *BasicUserListInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicUserListInfo.Unmarshal(m, b)
}
func (m *BasicUserListInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicUserListInfo.Marshal(b, m, deterministic)
}
func (dst *BasicUserListInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicUserListInfo.Merge(dst, src)
}
func (m *BasicUserListInfo) XXX_Size() int {
	return xxx_messageInfo_BasicUserListInfo.Size(m)
}
func (m *BasicUserListInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicUserListInfo.DiscardUnknown(m)
}

var xxx_messageInfo_BasicUserListInfo proto.InternalMessageInfo

func (m *BasicUserListInfo) GetActions() []*UserListActionInfo {
	if m != nil {
		return m.Actions
	}
	return nil
}

// Represents an action type used for building remarketing user lists.
type UserListActionInfo struct {
	// Subtypes of user list action.
	//
	// Types that are valid to be assigned to UserListAction:
	//	*UserListActionInfo_ConversionAction
	//	*UserListActionInfo_RemarketingAction
	UserListAction       isUserListActionInfo_UserListAction `protobuf_oneof:"user_list_action"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *UserListActionInfo) Reset()         { *m = UserListActionInfo{} }
func (m *UserListActionInfo) String() string { return proto.CompactTextString(m) }
func (*UserListActionInfo) ProtoMessage()    {}
func (*UserListActionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_user_lists_e2e607ee8d2b2ff7, []int{16}
}
func (m *UserListActionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserListActionInfo.Unmarshal(m, b)
}
func (m *UserListActionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserListActionInfo.Marshal(b, m, deterministic)
}
func (dst *UserListActionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserListActionInfo.Merge(dst, src)
}
func (m *UserListActionInfo) XXX_Size() int {
	return xxx_messageInfo_UserListActionInfo.Size(m)
}
func (m *UserListActionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UserListActionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UserListActionInfo proto.InternalMessageInfo

type isUserListActionInfo_UserListAction interface {
	isUserListActionInfo_UserListAction()
}

type UserListActionInfo_ConversionAction struct {
	ConversionAction *wrappers.StringValue `protobuf:"bytes,1,opt,name=conversion_action,json=conversionAction,proto3,oneof"`
}

type UserListActionInfo_RemarketingAction struct {
	RemarketingAction *wrappers.StringValue `protobuf:"bytes,2,opt,name=remarketing_action,json=remarketingAction,proto3,oneof"`
}

func (*UserListActionInfo_ConversionAction) isUserListActionInfo_UserListAction() {}

func (*UserListActionInfo_RemarketingAction) isUserListActionInfo_UserListAction() {}

func (m *UserListActionInfo) GetUserListAction() isUserListActionInfo_UserListAction {
	if m != nil {
		return m.UserListAction
	}
	return nil
}

func (m *UserListActionInfo) GetConversionAction() *wrappers.StringValue {
	if x, ok := m.GetUserListAction().(*UserListActionInfo_ConversionAction); ok {
		return x.ConversionAction
	}
	return nil
}

func (m *UserListActionInfo) GetRemarketingAction() *wrappers.StringValue {
	if x, ok := m.GetUserListAction().(*UserListActionInfo_RemarketingAction); ok {
		return x.RemarketingAction
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*UserListActionInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _UserListActionInfo_OneofMarshaler, _UserListActionInfo_OneofUnmarshaler, _UserListActionInfo_OneofSizer, []interface{}{
		(*UserListActionInfo_ConversionAction)(nil),
		(*UserListActionInfo_RemarketingAction)(nil),
	}
}

func _UserListActionInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*UserListActionInfo)
	// user_list_action
	switch x := m.UserListAction.(type) {
	case *UserListActionInfo_ConversionAction:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConversionAction); err != nil {
			return err
		}
	case *UserListActionInfo_RemarketingAction:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RemarketingAction); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("UserListActionInfo.UserListAction has unexpected type %T", x)
	}
	return nil
}

func _UserListActionInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*UserListActionInfo)
	switch tag {
	case 1: // user_list_action.conversion_action
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.StringValue)
		err := b.DecodeMessage(msg)
		m.UserListAction = &UserListActionInfo_ConversionAction{msg}
		return true, err
	case 2: // user_list_action.remarketing_action
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.StringValue)
		err := b.DecodeMessage(msg)
		m.UserListAction = &UserListActionInfo_RemarketingAction{msg}
		return true, err
	default:
		return false, nil
	}
}

func _UserListActionInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*UserListActionInfo)
	// user_list_action
	switch x := m.UserListAction.(type) {
	case *UserListActionInfo_ConversionAction:
		s := proto.Size(x.ConversionAction)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *UserListActionInfo_RemarketingAction:
		s := proto.Size(x.RemarketingAction)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*SimilarUserListInfo)(nil), "google.ads.googleads.v1.common.SimilarUserListInfo")
	proto.RegisterType((*CrmBasedUserListInfo)(nil), "google.ads.googleads.v1.common.CrmBasedUserListInfo")
	proto.RegisterType((*UserListRuleInfo)(nil), "google.ads.googleads.v1.common.UserListRuleInfo")
	proto.RegisterType((*UserListRuleItemGroupInfo)(nil), "google.ads.googleads.v1.common.UserListRuleItemGroupInfo")
	proto.RegisterType((*UserListRuleItemInfo)(nil), "google.ads.googleads.v1.common.UserListRuleItemInfo")
	proto.RegisterType((*UserListDateRuleItemInfo)(nil), "google.ads.googleads.v1.common.UserListDateRuleItemInfo")
	proto.RegisterType((*UserListNumberRuleItemInfo)(nil), "google.ads.googleads.v1.common.UserListNumberRuleItemInfo")
	proto.RegisterType((*UserListStringRuleItemInfo)(nil), "google.ads.googleads.v1.common.UserListStringRuleItemInfo")
	proto.RegisterType((*CombinedRuleUserListInfo)(nil), "google.ads.googleads.v1.common.CombinedRuleUserListInfo")
	proto.RegisterType((*DateSpecificRuleUserListInfo)(nil), "google.ads.googleads.v1.common.DateSpecificRuleUserListInfo")
	proto.RegisterType((*ExpressionRuleUserListInfo)(nil), "google.ads.googleads.v1.common.ExpressionRuleUserListInfo")
	proto.RegisterType((*RuleBasedUserListInfo)(nil), "google.ads.googleads.v1.common.RuleBasedUserListInfo")
	proto.RegisterType((*LogicalUserListInfo)(nil), "google.ads.googleads.v1.common.LogicalUserListInfo")
	proto.RegisterType((*UserListLogicalRuleInfo)(nil), "google.ads.googleads.v1.common.UserListLogicalRuleInfo")
	proto.RegisterType((*LogicalUserListOperandInfo)(nil), "google.ads.googleads.v1.common.LogicalUserListOperandInfo")
	proto.RegisterType((*BasicUserListInfo)(nil), "google.ads.googleads.v1.common.BasicUserListInfo")
	proto.RegisterType((*UserListActionInfo)(nil), "google.ads.googleads.v1.common.UserListActionInfo")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/common/user_lists.proto", fileDescriptor_user_lists_e2e607ee8d2b2ff7)
}

var fileDescriptor_user_lists_e2e607ee8d2b2ff7 = []byte{
	// 1306 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x41, 0x6f, 0xdb, 0xb6,
	0x17, 0x8f, 0x9c, 0xb4, 0x4d, 0x98, 0xd4, 0xff, 0x94, 0xcd, 0xbf, 0x75, 0xbd, 0xa0, 0x28, 0x74,
	0xea, 0x49, 0x6e, 0xdc, 0x62, 0x5d, 0xdd, 0x5d, 0xec, 0xb8, 0x48, 0x82, 0xb6, 0x6b, 0x21, 0x2f,
	0xd9, 0x56, 0x04, 0x50, 0x69, 0x89, 0x76, 0x85, 0x4a, 0xa4, 0x46, 0x4a, 0x69, 0x0d, 0x0c, 0xc3,
	0x76, 0xda, 0x61, 0xd8, 0x97, 0xd8, 0x71, 0xfb, 0x1a, 0x3b, 0xf5, 0x30, 0x60, 0xd7, 0x7d, 0x83,
	0xed, 0xb8, 0x4f, 0x30, 0x90, 0xa2, 0x6c, 0xc9, 0x96, 0x12, 0xa6, 0xc5, 0x4e, 0xa6, 0xc8, 0xf7,
	0x7e, 0xef, 0xc7, 0xc7, 0x1f, 0x1f, 0x49, 0x83, 0xd6, 0x98, 0xd2, 0x71, 0x80, 0x5b, 0xc8, 0xe3,
	0xaa, 0x29, 0x5a, 0x27, 0x3b, 0x2d, 0x97, 0x86, 0x21, 0x25, 0xad, 0x84, 0x63, 0xe6, 0x04, 0x3e,
	0x8f, 0xb9, 0x15, 0x31, 0x1a, 0x53, 0x78, 0x33, 0xb5, 0xb2, 0x90, 0xc7, 0xad, 0xa9, 0x83, 0x75,
	0xb2, 0x63, 0xa5, 0x0e, 0xcd, 0x5e, 0x15, 0x20, 0x26, 0x49, 0xc8, 0x5b, 0x6e, 0xc2, 0x63, 0x1a,
	0x62, 0xe6, 0x84, 0x28, 0x76, 0x5f, 0x39, 0x49, 0x14, 0x50, 0xe4, 0x39, 0xaf, 0xf1, 0xc4, 0x89,
	0x27, 0x11, 0x4e, 0x63, 0x34, 0xfb, 0xa7, 0x63, 0x4c, 0x39, 0x39, 0x2e, 0x0d, 0x87, 0x3e, 0xc1,
	0x9e, 0xc3, 0x92, 0x00, 0x3b, 0x34, 0xc2, 0x0c, 0xc5, 0x94, 0x29, 0x94, 0x9e, 0x36, 0x0a, 0x0b,
	0x1d, 0x0f, 0xc5, 0xc8, 0xe1, 0x34, 0x61, 0x2e, 0xce, 0x33, 0x79, 0xa4, 0x8b, 0xe1, 0xa1, 0x18,
	0xa7, 0x2c, 0xfc, 0x18, 0x87, 0xf3, 0x54, 0x76, 0x75, 0x61, 0x02, 0x3a, 0xf6, 0x5d, 0x14, 0x94,
	0xce, 0x67, 0x4f, 0x17, 0x84, 0x24, 0xe1, 0x10, 0xb3, 0x6a, 0x36, 0xda, 0x89, 0x89, 0x18, 0x8e,
	0x68, 0x94, 0x04, 0x28, 0xf6, 0x29, 0x71, 0x78, 0x8c, 0xe2, 0x44, 0xc9, 0xa0, 0x79, 0x5f, 0x17,
	0x43, 0xb2, 0xc8, 0x65, 0x54, 0x7b, 0x16, 0x3c, 0x66, 0x3e, 0x19, 0x57, 0xcf, 0x42, 0x09, 0xb1,
	0x25, 0xbf, 0x86, 0xc9, 0xa8, 0xf5, 0x86, 0xa1, 0x28, 0xc2, 0x2c, 0x63, 0xb8, 0x9d, 0x05, 0x8a,
	0xfc, 0x16, 0x22, 0x84, 0xc6, 0x72, 0x16, 0x6a, 0xd4, 0xfc, 0x0a, 0x5c, 0x1d, 0xf8, 0xa1, 0x1f,
	0x20, 0x76, 0xc8, 0x31, 0x7b, 0xe2, 0xf3, 0xf8, 0x80, 0x8c, 0x28, 0xec, 0x81, 0x3a, 0xc7, 0xd8,
	0x73, 0xa6, 0x34, 0x1a, 0xc6, 0x2d, 0xe3, 0xf6, 0x7a, 0x7b, 0x5b, 0x69, 0xdd, 0xca, 0xa2, 0x59,
	0x03, 0x49, 0xef, 0x08, 0x05, 0x09, 0xb6, 0x37, 0x84, 0x4f, 0x86, 0x63, 0xfe, 0x51, 0x03, 0x5b,
	0xbb, 0x2c, 0xec, 0x21, 0x3e, 0xeb, 0x94, 0xe0, 0x77, 0xc1, 0x45, 0x14, 0x45, 0x8e, 0xef, 0x69,
	0x81, 0x5e, 0x40, 0x51, 0x74, 0xe0, 0xc1, 0xef, 0x0c, 0xf0, 0xbf, 0xb9, 0x5d, 0xd2, 0xa8, 0xdd,
	0x32, 0x6e, 0xd7, 0xdb, 0x5f, 0x5a, 0x55, 0x5b, 0x51, 0xa6, 0xd2, 0xda, 0x55, 0x5b, 0xed, 0xa9,
	0xd8, 0x69, 0x87, 0x12, 0xe2, 0x31, 0x9e, 0x7c, 0x3e, 0x89, 0xf0, 0x23, 0x92, 0x84, 0xa7, 0x0c,
	0xdb, 0x97, 0x93, 0xfc, 0xa7, 0xa0, 0xb0, 0x39, 0xbf, 0x3f, 0x1a, 0xcb, 0x92, 0xc3, 0xd1, 0x19,
	0x1c, 0xb2, 0xf9, 0xef, 0xb2, 0xb0, 0x8f, 0x62, 0x34, 0x90, 0x00, 0x53, 0x0a, 0x95, 0xa3, 0x76,
	0xdd, 0x2b, 0x7c, 0x9b, 0x7f, 0x1a, 0x60, 0x33, 0xb3, 0xb6, 0x93, 0x00, 0xcb, 0x7c, 0x22, 0xb0,
	0x36, 0x55, 0x97, 0x4c, 0x69, 0xbd, 0xdd, 0xd7, 0xe4, 0x23, 0x30, 0x16, 0x68, 0x64, 0x9d, 0xf6,
	0x2a, 0x53, 0x2d, 0xe8, 0x82, 0xcd, 0x99, 0x00, 0xc7, 0x8c, 0x26, 0x11, 0x6f, 0xd4, 0x6e, 0x2d,
	0xdf, 0x5e, 0x6f, 0x3f, 0xb0, 0x4e, 0x2f, 0x84, 0x05, 0xd4, 0x83, 0x18, 0x87, 0x7b, 0xc2, 0x5b,
	0xf0, 0xb6, 0xeb, 0x2c, 0xdf, 0xc5, 0xcd, 0x08, 0xdc, 0xa8, 0x34, 0x86, 0x03, 0x00, 0xa6, 0x0c,
	0x78, 0xc3, 0x90, 0xb1, 0xef, 0x9d, 0x37, 0xb6, 0x0c, 0xbb, 0x96, 0x85, 0xe5, 0xe6, 0x0f, 0xcb,
	0x60, 0xab, 0xcc, 0x06, 0xde, 0x01, 0x2b, 0x04, 0x85, 0x58, 0x4b, 0xa0, 0xd2, 0x12, 0x8e, 0xc0,
	0xe6, 0x7c, 0xbd, 0x91, 0xfa, 0x5c, 0x6f, 0x77, 0x74, 0x59, 0x7e, 0x26, 0xfd, 0xf3, 0x3c, 0xf6,
	0x97, 0xec, 0x3a, 0x29, 0xf4, 0x8a, 0x38, 0xf3, 0x15, 0x41, 0x6a, 0xf0, 0x1c, 0x71, 0x52, 0xf2,
	0xf3, 0x71, 0x78, 0xa1, 0x17, 0xbe, 0x04, 0xf5, 0x62, 0x2d, 0x6f, 0xac, 0xc8, 0x28, 0x9f, 0xe8,
	0x46, 0xe9, 0xa3, 0x18, 0xcf, 0xc5, 0xd8, 0xf0, 0x72, 0x7d, 0xbd, 0x75, 0x25, 0x5b, 0x01, 0x6e,
	0xfe, 0x58, 0x03, 0x8d, 0x2a, 0x4f, 0xf8, 0x16, 0xac, 0x66, 0x45, 0x4f, 0xe9, 0xfb, 0x58, 0x53,
	0xdf, 0x79, 0xa8, 0x67, 0x0a, 0xa2, 0xa0, 0xf5, 0x32, 0x03, 0x7b, 0x1a, 0x0d, 0xb6, 0xc1, 0x85,
	0x13, 0xb1, 0xc8, 0x6a, 0x29, 0xcf, 0xa8, 0x54, 0xd2, 0x14, 0x76, 0x41, 0x9d, 0x8e, 0x46, 0x1c,
	0xc7, 0x8e, 0x4f, 0x1c, 0x0f, 0x4d, 0xb8, 0x5a, 0x9f, 0x8f, 0x16, 0x9c, 0x0f, 0x48, 0xfc, 0xf1,
	0x3d, 0x55, 0x3a, 0x53, 0x97, 0x03, 0xd2, 0x47, 0x13, 0x6e, 0xfe, 0x6e, 0x80, 0x66, 0xb5, 0x2a,
	0xe0, 0x37, 0x0b, 0xf9, 0x78, 0xa9, 0x99, 0x8f, 0x22, 0x58, 0x69, 0x46, 0xca, 0x4d, 0xce, 0x93,
	0x93, 0x3e, 0x4d, 0x86, 0x01, 0xce, 0xe7, 0xa4, 0x30, 0xa1, 0x45, 0xf9, 0x7d, 0xc0, 0x84, 0x8a,
	0x60, 0xa5, 0x13, 0x2a, 0x37, 0xf9, 0xb0, 0x45, 0x36, 0xdf, 0xd5, 0x40, 0x63, 0x57, 0xdd, 0xba,
	0x04, 0x74, 0xe1, 0x80, 0x1b, 0x80, 0x8d, 0x00, 0x8f, 0xe2, 0xf4, 0xa4, 0x26, 0xd9, 0x31, 0x77,
	0xe7, 0x5c, 0xd5, 0x4a, 0x54, 0xaa, 0x75, 0x81, 0xf2, 0x2c, 0x05, 0x81, 0x87, 0xe0, 0x32, 0xf3,
	0xc7, 0xaf, 0x66, 0xa8, 0xb5, 0xf7, 0x44, 0xdd, 0x90, 0x30, 0x19, 0xec, 0xf7, 0x06, 0xb8, 0x5c,
	0xb8, 0x65, 0xa9, 0x13, 0x4d, 0x77, 0x87, 0xe5, 0x93, 0x50, 0x9a, 0xfe, 0x32, 0x03, 0x7b, 0x83,
	0xe5, 0xbe, 0xc4, 0xa9, 0xb6, 0x2d, 0x36, 0xe2, 0x20, 0xc2, 0xae, 0x3f, 0xf2, 0xdd, 0x85, 0x84,
	0xf6, 0xc1, 0x8a, 0x70, 0x78, 0xef, 0x44, 0x4a, 0x6f, 0xf8, 0x10, 0x00, 0x1e, 0x23, 0x96, 0x5e,
	0x52, 0xb5, 0x16, 0x7b, 0x4d, 0xda, 0x0b, 0x6a, 0xf0, 0x3e, 0x58, 0xc5, 0xc4, 0x4b, 0x5d, 0x97,
	0x35, 0x5c, 0x2f, 0x61, 0xe2, 0x09, 0x47, 0x73, 0x08, 0x9a, 0x8f, 0xde, 0x46, 0x0c, 0x73, 0xee,
	0x53, 0xf2, 0xdf, 0xcc, 0xcc, 0xfc, 0x75, 0x05, 0xfc, 0x5f, 0x74, 0x2d, 0xde, 0xb5, 0x7e, 0x32,
	0xc0, 0x56, 0xd9, 0xf5, 0x55, 0x6d, 0xb3, 0x17, 0x9a, 0xab, 0xfc, 0x3c, 0x0f, 0x31, 0x90, 0x08,
	0x85, 0x45, 0x2e, 0x19, 0xb7, 0xaf, 0x46, 0x8b, 0x9d, 0xf0, 0x6b, 0x70, 0xbd, 0xf8, 0x58, 0x99,
	0xdd, 0x30, 0x6b, 0x7a, 0xe7, 0x4b, 0xd5, 0xae, 0xdb, 0x5f, 0xb2, 0xb7, 0xdc, 0x92, 0x31, 0xf8,
	0x2d, 0xd8, 0x96, 0x27, 0x19, 0x57, 0xea, 0x9a, 0x8f, 0x9b, 0xae, 0xe6, 0xa7, 0x67, 0xc5, 0x3d,
	0x4d, 0xa0, 0xfb, 0x4b, 0x76, 0xc3, 0xab, 0x18, 0x87, 0x6f, 0xc0, 0x0d, 0x3c, 0x15, 0xc0, 0x7c,
	0xf0, 0x15, 0xbd, 0xa3, 0xbb, 0x5a, 0x41, 0xfb, 0x4b, 0xf6, 0x35, 0x5c, 0x3a, 0xda, 0xbb, 0x06,
	0xb6, 0x64, 0xb4, 0xa1, 0x50, 0xc5, 0x2c, 0xa6, 0xe9, 0x81, 0xab, 0x4f, 0xd2, 0xf7, 0x55, 0x41,
	0x2a, 0x4f, 0xc1, 0x05, 0x61, 0x9e, 0x5d, 0xae, 0xee, 0xeb, 0x6a, 0x51, 0x61, 0x4d, 0x25, 0x99,
	0xa2, 0x98, 0xff, 0x18, 0xe0, 0x7a, 0x85, 0x09, 0x3c, 0x59, 0xa8, 0xf7, 0xba, 0x42, 0xcc, 0x21,
	0x95, 0x56, 0x9b, 0x92, 0xf1, 0x5c, 0xa5, 0x77, 0xf2, 0xb5, 0x8e, 0x78, 0xd9, 0x1d, 0xf6, 0xcc,
	0xf4, 0xcf, 0xa5, 0x4b, 0xd5, 0x4e, 0x55, 0x4d, 0xb3, 0x50, 0xc4, 0xe3, 0xe6, 0x17, 0xa0, 0x59,
	0x6d, 0x0b, 0x1f, 0x80, 0xb5, 0xf3, 0x3d, 0xa8, 0x56, 0x93, 0xec, 0x31, 0x85, 0xc0, 0x95, 0x1e,
	0xe2, 0xbe, 0x5b, 0x58, 0xb1, 0x27, 0xe0, 0x12, 0x72, 0xe5, 0x6b, 0x4e, 0xad, 0x59, 0x5b, 0x77,
	0xcd, 0xba, 0xd2, 0x4d, 0x4e, 0x20, 0x83, 0x30, 0x7f, 0x33, 0x00, 0x5c, 0x1c, 0x87, 0x8f, 0xc1,
	0x15, 0x97, 0x92, 0x13, 0xcc, 0xa4, 0x7c, 0x53, 0x63, 0x1d, 0xf2, 0xfb, 0x4b, 0xf6, 0xe6, 0xcc,
	0x31, 0x05, 0x84, 0x4f, 0x01, 0x64, 0x38, 0x44, 0xec, 0x35, 0x8e, 0xc5, 0x15, 0x56, 0xa1, 0xd5,
	0xb4, 0xd0, 0xae, 0xe4, 0x3c, 0x53, 0xb8, 0x1e, 0x04, 0x9b, 0xb3, 0x87, 0x72, 0x0a, 0xd6, 0xfb,
	0xcb, 0x00, 0xa6, 0x4b, 0xc3, 0x33, 0x32, 0xd1, 0xab, 0x67, 0x53, 0xe5, 0xcf, 0x45, 0xb8, 0xe7,
	0xc6, 0x0b, 0xf5, 0x6f, 0x8b, 0x35, 0xa6, 0x01, 0x22, 0x63, 0x8b, 0xb2, 0x71, 0x6b, 0x8c, 0x89,
	0x24, 0x93, 0xbd, 0xd0, 0x23, 0x9f, 0x57, 0xfd, 0x43, 0xf4, 0x30, 0xfd, 0xf9, 0xb9, 0xb6, 0xbc,
	0xd7, 0xed, 0xfe, 0x52, 0xbb, 0xb9, 0x97, 0x82, 0x75, 0x3d, 0x6e, 0xa5, 0x4d, 0xd1, 0x3a, 0xda,
	0x11, 0xe5, 0x2b, 0xa4, 0xe4, 0x5d, 0x66, 0x70, 0xdc, 0xf5, 0xf8, 0xf1, 0xd4, 0xe0, 0xf8, 0x68,
	0xe7, 0x38, 0x35, 0xf8, 0xbb, 0x66, 0xa6, 0xbd, 0x9d, 0x4e, 0xd7, 0xe3, 0x9d, 0xce, 0xd4, 0xa4,
	0xd3, 0x39, 0xda, 0xe9, 0x74, 0x52, 0xa3, 0xe1, 0x45, 0xc9, 0xee, 0xee, 0xbf, 0x01, 0x00, 0x00,
	0xff, 0xff, 0x6b, 0xb8, 0x50, 0x9f, 0xbe, 0x12, 0x00, 0x00,
}
