// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1/prediction_service.proto

package automl

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for
// [PredictionService.Predict][google.cloud.automl.v1.PredictionService.Predict].
type PredictRequest struct {
	// Name of the model requested to serve the prediction.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Payload to perform a prediction on. The payload must match the
	// problem type that the model was trained to solve.
	Payload *ExamplePayload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	// Additional domain-specific parameters, any string must be up to 25000
	// characters long.
	Params               map[string]string `protobuf:"bytes,3,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PredictRequest) Reset()         { *m = PredictRequest{} }
func (m *PredictRequest) String() string { return proto.CompactTextString(m) }
func (*PredictRequest) ProtoMessage()    {}
func (*PredictRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a60105ec759f54a4, []int{0}
}

func (m *PredictRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictRequest.Unmarshal(m, b)
}
func (m *PredictRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictRequest.Marshal(b, m, deterministic)
}
func (m *PredictRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictRequest.Merge(m, src)
}
func (m *PredictRequest) XXX_Size() int {
	return xxx_messageInfo_PredictRequest.Size(m)
}
func (m *PredictRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PredictRequest proto.InternalMessageInfo

func (m *PredictRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PredictRequest) GetPayload() *ExamplePayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *PredictRequest) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

// Response message for
// [PredictionService.Predict][google.cloud.automl.v1.PredictionService.Predict].
type PredictResponse struct {
	// Prediction result.
	// Translation and Text Sentiment will return precisely one payload.
	Payload []*AnnotationPayload `protobuf:"bytes,1,rep,name=payload,proto3" json:"payload,omitempty"`
	// Additional domain-specific prediction response metadata.
	Metadata             map[string]string `protobuf:"bytes,2,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PredictResponse) Reset()         { *m = PredictResponse{} }
func (m *PredictResponse) String() string { return proto.CompactTextString(m) }
func (*PredictResponse) ProtoMessage()    {}
func (*PredictResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a60105ec759f54a4, []int{1}
}

func (m *PredictResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictResponse.Unmarshal(m, b)
}
func (m *PredictResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictResponse.Marshal(b, m, deterministic)
}
func (m *PredictResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictResponse.Merge(m, src)
}
func (m *PredictResponse) XXX_Size() int {
	return xxx_messageInfo_PredictResponse.Size(m)
}
func (m *PredictResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PredictResponse proto.InternalMessageInfo

func (m *PredictResponse) GetPayload() []*AnnotationPayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *PredictResponse) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func init() {
	proto.RegisterType((*PredictRequest)(nil), "google.cloud.automl.v1.PredictRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.automl.v1.PredictRequest.ParamsEntry")
	proto.RegisterType((*PredictResponse)(nil), "google.cloud.automl.v1.PredictResponse")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.automl.v1.PredictResponse.MetadataEntry")
}

func init() {
	proto.RegisterFile("google/cloud/automl/v1/prediction_service.proto", fileDescriptor_a60105ec759f54a4)
}

var fileDescriptor_a60105ec759f54a4 = []byte{
	// 578 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x53, 0x4f, 0x8b, 0x13, 0x31,
	0x1c, 0x25, 0x53, 0xdd, 0x75, 0x53, 0xfc, 0x37, 0x68, 0xad, 0x83, 0x60, 0xa9, 0xb0, 0x5b, 0x0b,
	0x26, 0xb4, 0x22, 0xea, 0xac, 0x0b, 0x76, 0x97, 0x45, 0x14, 0x17, 0xc6, 0x0a, 0x3d, 0x48, 0xa1,
	0xc4, 0x69, 0x9c, 0x1d, 0xcd, 0x24, 0x71, 0x26, 0xd3, 0x5a, 0xc4, 0x8b, 0x5f, 0xc1, 0x93, 0x5f,
	0xc1, 0x8f, 0xe1, 0x71, 0x8f, 0xfa, 0x15, 0xc4, 0x83, 0xe0, 0x17, 0xf0, 0x24, 0x33, 0x49, 0xdb,
	0xed, 0xd6, 0x61, 0xd7, 0x5b, 0x66, 0x5e, 0xde, 0x7b, 0xbf, 0x97, 0xe4, 0x41, 0x1c, 0x08, 0x11,
	0x30, 0x8a, 0x7d, 0x26, 0xd2, 0x21, 0x26, 0xa9, 0x12, 0x11, 0xc3, 0xa3, 0x16, 0x96, 0x31, 0x1d,
	0x86, 0xbe, 0x0a, 0x05, 0x1f, 0x24, 0x34, 0x1e, 0x85, 0x3e, 0x45, 0x32, 0x16, 0x4a, 0xd8, 0x15,
	0x4d, 0x40, 0x39, 0x01, 0x69, 0x02, 0x1a, 0xb5, 0x9c, 0x6b, 0x46, 0x88, 0xc8, 0x10, 0x13, 0xce,
	0x85, 0x22, 0x19, 0x39, 0xd1, 0x2c, 0xe7, 0xca, 0x21, 0xd4, 0x67, 0x21, 0xe5, 0xca, 0x00, 0x45,
	0xfe, 0x73, 0x89, 0x81, 0x24, 0x13, 0x26, 0xc8, 0xd0, 0x10, 0x36, 0x0a, 0x08, 0x43, 0xa2, 0xc8,
	0x20, 0x54, 0x34, 0x9a, 0x5a, 0x5e, 0x2f, 0xd8, 0x18, 0x8a, 0x63, 0x94, 0x84, 0xa4, 0xf1, 0xc2,
	0xf0, 0x37, 0xcc, 0x46, 0x26, 0x78, 0x10, 0xa7, 0x9c, 0x87, 0x3c, 0x58, 0xda, 0x54, 0xff, 0x0d,
	0xe0, 0x39, 0x4f, 0x1f, 0x5a, 0x97, 0xbe, 0x4d, 0x69, 0xa2, 0x6c, 0x1b, 0x9e, 0xe2, 0x24, 0xa2,
	0x55, 0x50, 0x03, 0x8d, 0xb5, 0x6e, 0xbe, 0xb6, 0x1f, 0xc2, 0x55, 0x93, 0xa7, 0x6a, 0xd5, 0x40,
	0xa3, 0xdc, 0x5e, 0x47, 0xff, 0x3e, 0x50, 0xb4, 0xfb, 0x8e, 0x44, 0x92, 0x51, 0x4f, 0xef, 0xee,
	0x4e, 0x69, 0xf6, 0x13, 0xb8, 0x22, 0x49, 0x4c, 0xa2, 0xa4, 0x5a, 0xaa, 0x95, 0x1a, 0xe5, 0x76,
	0xbb, 0x48, 0x60, 0x71, 0x1a, 0xe4, 0xe5, 0xa4, 0x5d, 0xae, 0xe2, 0x49, 0xd7, 0x28, 0x38, 0xf7,
	0x61, 0xf9, 0xd0, 0x6f, 0xfb, 0x02, 0x2c, 0xbd, 0xa1, 0x13, 0x33, 0x6f, 0xb6, 0xb4, 0x2f, 0xc1,
	0xd3, 0x23, 0xc2, 0x52, 0x9a, 0x0f, 0xbb, 0xd6, 0xd5, 0x1f, 0xae, 0x75, 0x0f, 0xd4, 0x7f, 0x02,
	0x78, 0x7e, 0xe6, 0x90, 0x48, 0xc1, 0x13, 0x6a, 0xef, 0xcc, 0xc3, 0x81, 0x7c, 0xb6, 0x9b, 0x45,
	0xb3, 0x75, 0x66, 0xd7, 0xbb, 0x94, 0xef, 0x19, 0x3c, 0x13, 0x51, 0x45, 0xb2, 0xfb, 0xac, 0x5a,
	0xb9, 0xca, 0x9d, 0x63, 0x13, 0x6a, 0x7f, 0xb4, 0x67, 0x78, 0x3a, 0xe4, 0x4c, 0xc6, 0xd9, 0x84,
	0x67, 0x17, 0xa0, 0xff, 0x09, 0xda, 0xfe, 0x03, 0xe0, 0x45, 0x6f, 0xd6, 0x86, 0xe7, 0xba, 0x0c,
	0xf6, 0x67, 0x00, 0x57, 0xcd, 0x5f, 0x7b, 0xfd, 0x64, 0x37, 0xe0, 0x6c, 0x9c, 0x30, 0x47, 0x7d,
	0xeb, 0xe3, 0xf7, 0x1f, 0x9f, 0xac, 0xbb, 0xf5, 0x76, 0xf6, 0x1c, 0xdf, 0x67, 0xef, 0x66, 0x4b,
	0xc6, 0xe2, 0x35, 0xf5, 0x55, 0x82, 0x9b, 0x98, 0x09, 0x5f, 0xbf, 0x3c, 0xdc, 0xc4, 0x91, 0x18,
	0x52, 0x96, 0xe0, 0xe6, 0x07, 0xd7, 0x14, 0xd6, 0x05, 0x4d, 0xe7, 0xf1, 0x41, 0xe7, 0xb2, 0x11,
	0xd7, 0x86, 0x44, 0x86, 0x09, 0xf2, 0x45, 0xf4, 0xad, 0x83, 0xf6, 0x95, 0x92, 0x89, 0x8b, 0xf1,
	0x78, 0x3c, 0x3e, 0x02, 0x66, 0x0d, 0xd8, 0xd7, 0x65, 0xb8, 0x25, 0x19, 0x51, 0xaf, 0x44, 0x1c,
	0x6d, 0x7f, 0x05, 0xd0, 0xf1, 0x45, 0x54, 0x30, 0xf8, 0x76, 0x65, 0xe9, 0x60, 0xbc, 0xac, 0x0c,
	0x1e, 0x78, 0xf1, 0xc0, 0x30, 0x02, 0xc1, 0x08, 0x0f, 0x90, 0x88, 0x03, 0x1c, 0x50, 0x9e, 0x57,
	0x05, 0xcf, 0x7d, 0x8f, 0x76, 0x6f, 0x53, 0xaf, 0xbe, 0x58, 0x95, 0x47, 0x9a, 0xbe, 0x93, 0x1b,
	0x76, 0x52, 0x25, 0xf6, 0x9e, 0xa2, 0x5e, 0xeb, 0x60, 0x0a, 0xf4, 0x73, 0xa0, 0xaf, 0x81, 0x7e,
	0xaf, 0xf5, 0xcb, 0xba, 0xaa, 0x01, 0xd7, 0xcd, 0x11, 0xd7, 0xd5, 0x90, 0xeb, 0xf6, 0x5a, 0x2f,
	0x57, 0x72, 0xdb, 0xdb, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x32, 0xc9, 0x22, 0xb3, 0xec, 0x04,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// PredictionServiceClient is the client API for PredictionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PredictionServiceClient interface {
	// Perform an online prediction. The prediction result will be directly
	// returned in the response.
	// Available for following ML problems, and their expected request payloads:
	// * Translation - TextSnippet, content up to 25,000 characters, UTF-8
	//                 encoded.
	Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error)
}

type predictionServiceClient struct {
	cc *grpc.ClientConn
}

func NewPredictionServiceClient(cc *grpc.ClientConn) PredictionServiceClient {
	return &predictionServiceClient{cc}
}

func (c *predictionServiceClient) Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error) {
	out := new(PredictResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.PredictionService/Predict", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PredictionServiceServer is the server API for PredictionService service.
type PredictionServiceServer interface {
	// Perform an online prediction. The prediction result will be directly
	// returned in the response.
	// Available for following ML problems, and their expected request payloads:
	// * Translation - TextSnippet, content up to 25,000 characters, UTF-8
	//                 encoded.
	Predict(context.Context, *PredictRequest) (*PredictResponse, error)
}

// UnimplementedPredictionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPredictionServiceServer struct {
}

func (*UnimplementedPredictionServiceServer) Predict(ctx context.Context, req *PredictRequest) (*PredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Predict not implemented")
}

func RegisterPredictionServiceServer(s *grpc.Server, srv PredictionServiceServer) {
	s.RegisterService(&_PredictionService_serviceDesc, srv)
}

func _PredictionService_Predict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).Predict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.PredictionService/Predict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).Predict(ctx, req.(*PredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PredictionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.automl.v1.PredictionService",
	HandlerType: (*PredictionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Predict",
			Handler:    _PredictionService_Predict_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/automl/v1/prediction_service.proto",
}
