// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/oslogin/v1/oslogin.proto

package oslogin

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	common "google.golang.org/genproto/googleapis/cloud/oslogin/common"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The user profile information used for logging in to a virtual machine on
// Google Compute Engine.
type LoginProfile struct {
	// Required. A unique user ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The list of POSIX accounts associated with the user.
	PosixAccounts []*common.PosixAccount `protobuf:"bytes,2,rep,name=posix_accounts,json=posixAccounts,proto3" json:"posix_accounts,omitempty"`
	// A map from SSH public key fingerprint to the associated key object.
	SshPublicKeys map[string]*common.SshPublicKey `protobuf:"bytes,3,rep,name=ssh_public_keys,json=sshPublicKeys,proto3" json:"ssh_public_keys,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Indicates if the user is suspended. A suspended user cannot log in but
	// their profile information is retained.
	Suspended            bool     `protobuf:"varint,4,opt,name=suspended,proto3" json:"suspended,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LoginProfile) Reset()         { *m = LoginProfile{} }
func (m *LoginProfile) String() string { return proto.CompactTextString(m) }
func (*LoginProfile) ProtoMessage()    {}
func (*LoginProfile) Descriptor() ([]byte, []int) {
	return fileDescriptor_4485a75683c132f1, []int{0}
}

func (m *LoginProfile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoginProfile.Unmarshal(m, b)
}
func (m *LoginProfile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoginProfile.Marshal(b, m, deterministic)
}
func (m *LoginProfile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoginProfile.Merge(m, src)
}
func (m *LoginProfile) XXX_Size() int {
	return xxx_messageInfo_LoginProfile.Size(m)
}
func (m *LoginProfile) XXX_DiscardUnknown() {
	xxx_messageInfo_LoginProfile.DiscardUnknown(m)
}

var xxx_messageInfo_LoginProfile proto.InternalMessageInfo

func (m *LoginProfile) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *LoginProfile) GetPosixAccounts() []*common.PosixAccount {
	if m != nil {
		return m.PosixAccounts
	}
	return nil
}

func (m *LoginProfile) GetSshPublicKeys() map[string]*common.SshPublicKey {
	if m != nil {
		return m.SshPublicKeys
	}
	return nil
}

func (m *LoginProfile) GetSuspended() bool {
	if m != nil {
		return m.Suspended
	}
	return false
}

// A request message for deleting a POSIX account entry.
type DeletePosixAccountRequest struct {
	// Required. A reference to the POSIX account to update. POSIX accounts are identified
	// by the project ID they are associated with. A reference to the POSIX
	// account is in format `users/{user}/projects/{project}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeletePosixAccountRequest) Reset()         { *m = DeletePosixAccountRequest{} }
func (m *DeletePosixAccountRequest) String() string { return proto.CompactTextString(m) }
func (*DeletePosixAccountRequest) ProtoMessage()    {}
func (*DeletePosixAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4485a75683c132f1, []int{1}
}

func (m *DeletePosixAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeletePosixAccountRequest.Unmarshal(m, b)
}
func (m *DeletePosixAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeletePosixAccountRequest.Marshal(b, m, deterministic)
}
func (m *DeletePosixAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeletePosixAccountRequest.Merge(m, src)
}
func (m *DeletePosixAccountRequest) XXX_Size() int {
	return xxx_messageInfo_DeletePosixAccountRequest.Size(m)
}
func (m *DeletePosixAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeletePosixAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeletePosixAccountRequest proto.InternalMessageInfo

func (m *DeletePosixAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for deleting an SSH public key.
type DeleteSshPublicKeyRequest struct {
	// Required. The fingerprint of the public key to update. Public keys are identified by
	// their SHA-256 fingerprint. The fingerprint of the public key is in format
	// `users/{user}/sshPublicKeys/{fingerprint}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSshPublicKeyRequest) Reset()         { *m = DeleteSshPublicKeyRequest{} }
func (m *DeleteSshPublicKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSshPublicKeyRequest) ProtoMessage()    {}
func (*DeleteSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4485a75683c132f1, []int{2}
}

func (m *DeleteSshPublicKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSshPublicKeyRequest.Unmarshal(m, b)
}
func (m *DeleteSshPublicKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSshPublicKeyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteSshPublicKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSshPublicKeyRequest.Merge(m, src)
}
func (m *DeleteSshPublicKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSshPublicKeyRequest.Size(m)
}
func (m *DeleteSshPublicKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSshPublicKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSshPublicKeyRequest proto.InternalMessageInfo

func (m *DeleteSshPublicKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for retrieving the login profile information for a user.
type GetLoginProfileRequest struct {
	// Required. The unique ID for the user in format `users/{user}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The project ID of the Google Cloud Platform project.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A system ID for filtering the results of the request.
	SystemId             string   `protobuf:"bytes,3,opt,name=system_id,json=systemId,proto3" json:"system_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetLoginProfileRequest) Reset()         { *m = GetLoginProfileRequest{} }
func (m *GetLoginProfileRequest) String() string { return proto.CompactTextString(m) }
func (*GetLoginProfileRequest) ProtoMessage()    {}
func (*GetLoginProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4485a75683c132f1, []int{3}
}

func (m *GetLoginProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetLoginProfileRequest.Unmarshal(m, b)
}
func (m *GetLoginProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetLoginProfileRequest.Marshal(b, m, deterministic)
}
func (m *GetLoginProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLoginProfileRequest.Merge(m, src)
}
func (m *GetLoginProfileRequest) XXX_Size() int {
	return xxx_messageInfo_GetLoginProfileRequest.Size(m)
}
func (m *GetLoginProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLoginProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetLoginProfileRequest proto.InternalMessageInfo

func (m *GetLoginProfileRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetLoginProfileRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetLoginProfileRequest) GetSystemId() string {
	if m != nil {
		return m.SystemId
	}
	return ""
}

// A request message for retrieving an SSH public key.
type GetSshPublicKeyRequest struct {
	// The fingerprint of the public key to retrieve. Public keys are identified
	// by their SHA-256 fingerprint. The fingerprint of the public key is in
	// format `users/{user}/sshPublicKeys/{fingerprint}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSshPublicKeyRequest) Reset()         { *m = GetSshPublicKeyRequest{} }
func (m *GetSshPublicKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetSshPublicKeyRequest) ProtoMessage()    {}
func (*GetSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4485a75683c132f1, []int{4}
}

func (m *GetSshPublicKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSshPublicKeyRequest.Unmarshal(m, b)
}
func (m *GetSshPublicKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSshPublicKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetSshPublicKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSshPublicKeyRequest.Merge(m, src)
}
func (m *GetSshPublicKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetSshPublicKeyRequest.Size(m)
}
func (m *GetSshPublicKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSshPublicKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSshPublicKeyRequest proto.InternalMessageInfo

func (m *GetSshPublicKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for importing an SSH public key.
type ImportSshPublicKeyRequest struct {
	// Required. The unique ID for the user in format `users/{user}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The SSH public key and expiration time.
	SshPublicKey *common.SshPublicKey `protobuf:"bytes,2,opt,name=ssh_public_key,json=sshPublicKey,proto3" json:"ssh_public_key,omitempty"`
	// The project ID of the Google Cloud Platform project.
	ProjectId            string   `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportSshPublicKeyRequest) Reset()         { *m = ImportSshPublicKeyRequest{} }
func (m *ImportSshPublicKeyRequest) String() string { return proto.CompactTextString(m) }
func (*ImportSshPublicKeyRequest) ProtoMessage()    {}
func (*ImportSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4485a75683c132f1, []int{5}
}

func (m *ImportSshPublicKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportSshPublicKeyRequest.Unmarshal(m, b)
}
func (m *ImportSshPublicKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportSshPublicKeyRequest.Marshal(b, m, deterministic)
}
func (m *ImportSshPublicKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportSshPublicKeyRequest.Merge(m, src)
}
func (m *ImportSshPublicKeyRequest) XXX_Size() int {
	return xxx_messageInfo_ImportSshPublicKeyRequest.Size(m)
}
func (m *ImportSshPublicKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportSshPublicKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportSshPublicKeyRequest proto.InternalMessageInfo

func (m *ImportSshPublicKeyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ImportSshPublicKeyRequest) GetSshPublicKey() *common.SshPublicKey {
	if m != nil {
		return m.SshPublicKey
	}
	return nil
}

func (m *ImportSshPublicKeyRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// A response message for importing an SSH public key.
type ImportSshPublicKeyResponse struct {
	// The login profile information for the user.
	LoginProfile         *LoginProfile `protobuf:"bytes,1,opt,name=login_profile,json=loginProfile,proto3" json:"login_profile,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ImportSshPublicKeyResponse) Reset()         { *m = ImportSshPublicKeyResponse{} }
func (m *ImportSshPublicKeyResponse) String() string { return proto.CompactTextString(m) }
func (*ImportSshPublicKeyResponse) ProtoMessage()    {}
func (*ImportSshPublicKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4485a75683c132f1, []int{6}
}

func (m *ImportSshPublicKeyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportSshPublicKeyResponse.Unmarshal(m, b)
}
func (m *ImportSshPublicKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportSshPublicKeyResponse.Marshal(b, m, deterministic)
}
func (m *ImportSshPublicKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportSshPublicKeyResponse.Merge(m, src)
}
func (m *ImportSshPublicKeyResponse) XXX_Size() int {
	return xxx_messageInfo_ImportSshPublicKeyResponse.Size(m)
}
func (m *ImportSshPublicKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportSshPublicKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImportSshPublicKeyResponse proto.InternalMessageInfo

func (m *ImportSshPublicKeyResponse) GetLoginProfile() *LoginProfile {
	if m != nil {
		return m.LoginProfile
	}
	return nil
}

// A request message for updating an SSH public key.
type UpdateSshPublicKeyRequest struct {
	// Required. The fingerprint of the public key to update. Public keys are identified by
	// their SHA-256 fingerprint. The fingerprint of the public key is in format
	// `users/{user}/sshPublicKeys/{fingerprint}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The SSH public key and expiration time.
	SshPublicKey *common.SshPublicKey `protobuf:"bytes,2,opt,name=ssh_public_key,json=sshPublicKey,proto3" json:"ssh_public_key,omitempty"`
	// Mask to control which fields get updated. Updates all if not present.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateSshPublicKeyRequest) Reset()         { *m = UpdateSshPublicKeyRequest{} }
func (m *UpdateSshPublicKeyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSshPublicKeyRequest) ProtoMessage()    {}
func (*UpdateSshPublicKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4485a75683c132f1, []int{7}
}

func (m *UpdateSshPublicKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSshPublicKeyRequest.Unmarshal(m, b)
}
func (m *UpdateSshPublicKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSshPublicKeyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateSshPublicKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSshPublicKeyRequest.Merge(m, src)
}
func (m *UpdateSshPublicKeyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSshPublicKeyRequest.Size(m)
}
func (m *UpdateSshPublicKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSshPublicKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSshPublicKeyRequest proto.InternalMessageInfo

func (m *UpdateSshPublicKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateSshPublicKeyRequest) GetSshPublicKey() *common.SshPublicKey {
	if m != nil {
		return m.SshPublicKey
	}
	return nil
}

func (m *UpdateSshPublicKeyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func init() {
	proto.RegisterType((*LoginProfile)(nil), "google.cloud.oslogin.v1.LoginProfile")
	proto.RegisterMapType((map[string]*common.SshPublicKey)(nil), "google.cloud.oslogin.v1.LoginProfile.SshPublicKeysEntry")
	proto.RegisterType((*DeletePosixAccountRequest)(nil), "google.cloud.oslogin.v1.DeletePosixAccountRequest")
	proto.RegisterType((*DeleteSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1.DeleteSshPublicKeyRequest")
	proto.RegisterType((*GetLoginProfileRequest)(nil), "google.cloud.oslogin.v1.GetLoginProfileRequest")
	proto.RegisterType((*GetSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1.GetSshPublicKeyRequest")
	proto.RegisterType((*ImportSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1.ImportSshPublicKeyRequest")
	proto.RegisterType((*ImportSshPublicKeyResponse)(nil), "google.cloud.oslogin.v1.ImportSshPublicKeyResponse")
	proto.RegisterType((*UpdateSshPublicKeyRequest)(nil), "google.cloud.oslogin.v1.UpdateSshPublicKeyRequest")
}

func init() {
	proto.RegisterFile("google/cloud/oslogin/v1/oslogin.proto", fileDescriptor_4485a75683c132f1)
}

var fileDescriptor_4485a75683c132f1 = []byte{
	// 968 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0xcf, 0x6f, 0xe3, 0x44,
	0x14, 0x96, 0x9d, 0x65, 0xb5, 0x99, 0xfe, 0x58, 0x34, 0x88, 0x36, 0x75, 0x77, 0xd5, 0x60, 0xa8,
	0x28, 0x25, 0xd8, 0x4a, 0x96, 0xc3, 0xd2, 0x15, 0xac, 0xdc, 0x65, 0x59, 0x95, 0x1f, 0x22, 0xf2,
	0x42, 0x0f, 0xa8, 0x52, 0x70, 0x9d, 0x69, 0x62, 0x62, 0x7b, 0x06, 0xcf, 0x38, 0x25, 0xa0, 0xbd,
	0xf0, 0x07, 0x70, 0x59, 0x71, 0xe0, 0x06, 0x57, 0xfe, 0x94, 0x3d, 0x21, 0x10, 0x97, 0x9e, 0xf6,
	0x80, 0xe0, 0xc8, 0x19, 0x4e, 0xc8, 0x33, 0x93, 0x76, 0xfc, 0x23, 0x6d, 0x8a, 0xe0, 0xd4, 0xf1,
	0xbc, 0xf7, 0xbe, 0xf9, 0xde, 0xf7, 0x66, 0xbe, 0x06, 0x6c, 0x0e, 0x30, 0x1e, 0x84, 0xc8, 0xf6,
	0x43, 0x9c, 0xf6, 0x6d, 0x4c, 0x43, 0x3c, 0x08, 0x62, 0x7b, 0xdc, 0x9e, 0x2e, 0x2d, 0x92, 0x60,
	0x86, 0xe1, 0xaa, 0x48, 0xb3, 0x78, 0x9a, 0x35, 0x8d, 0x8d, 0xdb, 0xc6, 0x0d, 0x59, 0xef, 0x91,
	0xc0, 0xf6, 0xe2, 0x18, 0x33, 0x8f, 0x05, 0x38, 0xa6, 0xa2, 0xcc, 0x58, 0x55, 0xa2, 0x7e, 0x18,
	0xa0, 0x98, 0xc9, 0xc0, 0x86, 0x12, 0x38, 0x0a, 0x50, 0xd8, 0xef, 0x1d, 0xa2, 0xa1, 0x37, 0x0e,
	0x70, 0x22, 0x13, 0xd6, 0x94, 0x84, 0x04, 0x51, 0x9c, 0x26, 0x3e, 0x92, 0xa1, 0xad, 0x4a, 0xca,
	0x3e, 0x8e, 0x22, 0x3c, 0xfd, 0x23, 0x33, 0xd7, 0x65, 0x26, 0xff, 0x3a, 0x4c, 0x8f, 0x6c, 0x14,
	0x11, 0x36, 0x91, 0xc1, 0x66, 0x31, 0x28, 0x78, 0x44, 0x1e, 0x1d, 0x89, 0x0c, 0xf3, 0x77, 0x1d,
	0x2c, 0xbe, 0x9f, 0x81, 0x77, 0x13, 0x7c, 0x14, 0x84, 0x08, 0xae, 0x82, 0x2b, 0xb1, 0x17, 0xa1,
	0x86, 0xd6, 0xd4, 0xb6, 0xea, 0xbb, 0xb5, 0xa7, 0x8e, 0xee, 0xf2, 0x0d, 0xd8, 0x05, 0xcb, 0x04,
	0xd3, 0xe0, 0x8b, 0x9e, 0xe7, 0xfb, 0x38, 0x8d, 0x19, 0x6d, 0xe8, 0xcd, 0xda, 0xd6, 0x42, 0xe7,
	0x15, 0xab, 0x52, 0x37, 0x49, 0xb2, 0x9b, 0x95, 0x38, 0xa2, 0xc2, 0x5d, 0x22, 0xca, 0x17, 0x85,
	0x9f, 0x82, 0xeb, 0x94, 0x0e, 0x7b, 0x24, 0x3d, 0x0c, 0x03, 0xbf, 0x37, 0x42, 0x13, 0xda, 0xa8,
	0x71, 0xc8, 0xdb, 0xd6, 0x8c, 0x51, 0x58, 0x2a, 0x55, 0xeb, 0x21, 0x1d, 0x76, 0x79, 0xed, 0x7b,
	0x68, 0x42, 0xef, 0xc7, 0x2c, 0x99, 0xb8, 0x4b, 0x54, 0xdd, 0x83, 0x37, 0x40, 0x9d, 0xa6, 0x94,
	0xa0, 0xb8, 0x8f, 0xfa, 0x8d, 0x2b, 0x4d, 0x6d, 0xeb, 0x9a, 0x7b, 0xb6, 0x61, 0x8c, 0x00, 0x2c,
	0x43, 0xc0, 0x67, 0x41, 0x6d, 0x84, 0x26, 0xa2, 0x7f, 0x37, 0x5b, 0xc2, 0xbb, 0xe0, 0x99, 0xb1,
	0x17, 0xa6, 0xa8, 0xa1, 0x37, 0xb5, 0x0b, 0x1b, 0x56, 0x11, 0x5d, 0x51, 0xb7, 0xa3, 0xdf, 0xd6,
	0xcc, 0x03, 0xb0, 0xf6, 0x36, 0x0a, 0x11, 0x43, 0x39, 0x45, 0xd0, 0xe7, 0x29, 0xa2, 0x0c, 0xde,
	0xcd, 0x89, 0xfe, 0xea, 0x53, 0x47, 0xff, 0xdb, 0xd9, 0x04, 0x2f, 0x4e, 0xa1, 0xc5, 0x79, 0x1e,
	0x09, 0x68, 0x76, 0x8a, 0x9d, 0x43, 0xe0, 0x85, 0x67, 0xe8, 0xb9, 0xe3, 0xff, 0x15, 0x7a, 0x0e,
	0x41, 0xa0, 0x7f, 0xab, 0x81, 0x95, 0x07, 0x88, 0xa9, 0xe2, 0x9f, 0x8b, 0x0d, 0xe7, 0x67, 0x0e,
	0x6f, 0x02, 0x40, 0x12, 0xfc, 0x19, 0xf2, 0x59, 0x2f, 0xe8, 0x73, 0x85, 0xeb, 0x6e, 0x5d, 0xee,
	0xec, 0xf5, 0xe1, 0x3a, 0xa8, 0xd3, 0x09, 0x65, 0x28, 0xca, 0xa2, 0x35, 0x1e, 0xbd, 0x26, 0x36,
	0xf6, 0xfa, 0x66, 0x8b, 0xd3, 0xaa, 0x6a, 0x19, 0xaa, 0xb4, 0x64, 0x17, 0xbf, 0x6a, 0x60, 0x6d,
	0x2f, 0x22, 0x38, 0xa9, 0xac, 0xb8, 0x07, 0xae, 0x12, 0x2f, 0x41, 0x31, 0x9b, 0xb3, 0x95, 0x1c,
	0x86, 0x2c, 0x85, 0x1f, 0x81, 0xe5, 0xfc, 0x8d, 0xbe, 0xf4, 0x95, 0xc9, 0x5e, 0x9c, 0xe6, 0x2e,
	0xaa, 0xd7, 0xb8, 0x20, 0x51, 0xad, 0x20, 0x91, 0x39, 0x04, 0x46, 0x55, 0x5b, 0x94, 0xe0, 0x98,
	0x22, 0xf8, 0x2e, 0x58, 0xe2, 0x87, 0xf5, 0x88, 0x18, 0x1c, 0x6f, 0x6f, 0xa1, 0xb3, 0x39, 0xd7,
	0x13, 0x73, 0x17, 0x43, 0xe5, 0xcb, 0xfc, 0x53, 0x03, 0x6b, 0x1f, 0x93, 0xbe, 0xf7, 0xff, 0x5c,
	0xb3, 0xff, 0x48, 0x3d, 0xbd, 0xa0, 0xde, 0x1d, 0xb0, 0x90, 0x72, 0xce, 0xdc, 0xf6, 0xb8, 0x7c,
	0x0b, 0x1d, 0x63, 0x0a, 0x39, 0x75, 0x46, 0xeb, 0x9d, 0xcc, 0x19, 0x3f, 0xf0, 0xe8, 0xc8, 0x05,
	0x22, 0x3d, 0x5b, 0x77, 0x7e, 0xaa, 0x83, 0xe5, 0x0f, 0x29, 0x97, 0xe4, 0x21, 0x4a, 0xc6, 0x81,
	0x8f, 0xe0, 0x37, 0x1a, 0x80, 0xe5, 0x97, 0x0c, 0x3b, 0x33, 0x05, 0x9d, 0xf9, 0xec, 0x8d, 0x95,
	0x12, 0x8b, 0xfb, 0x99, 0x79, 0x9b, 0xad, 0x13, 0x87, 0x2b, 0xf2, 0xf5, 0x2f, 0xbf, 0x3d, 0xd6,
	0x37, 0xb6, 0x6f, 0x66, 0xff, 0xab, 0xbe, 0xca, 0x36, 0xde, 0x4c, 0x29, 0x4a, 0xa8, 0xbd, 0x6d,
	0xcb, 0xe9, 0x53, 0x7b, 0xfb, 0x11, 0x7c, 0x7c, 0x4a, 0x48, 0x95, 0xe2, 0x42, 0x42, 0x15, 0x23,
	0x9c, 0x49, 0xa8, 0xad, 0x12, 0x7a, 0x69, 0xdb, 0x2c, 0x13, 0xca, 0xf9, 0x6e, 0xc6, 0xea, 0x3b,
	0x0d, 0x5c, 0x2f, 0x78, 0x06, 0xb4, 0x67, 0x52, 0xaa, 0x76, 0x17, 0x63, 0xbe, 0x5b, 0x6a, 0x5a,
	0x2a, 0xbd, 0x17, 0xe0, 0x46, 0x89, 0xde, 0x23, 0x5b, 0xbd, 0xc7, 0xf0, 0x7b, 0xc1, 0x2d, 0x27,
	0xd7, 0xb9, 0xdc, 0xaa, 0xb4, 0x9a, 0xff, 0x56, 0x16, 0xe4, 0x83, 0xf3, 0xc8, 0xf7, 0x97, 0x06,
	0x60, 0xf9, 0x55, 0x9f, 0x33, 0xd4, 0x99, 0xce, 0x66, 0xdc, 0xba, 0x54, 0x8d, 0xb0, 0x0d, 0xf3,
	0xcb, 0x13, 0xe7, 0x79, 0x61, 0x6a, 0xad, 0xfc, 0x9b, 0x3c, 0x71, 0x9a, 0x95, 0xfb, 0xad, 0x33,
	0x8b, 0xe2, 0x6d, 0xbe, 0x61, 0xbe, 0xcc, 0xdb, 0x14, 0xc9, 0xa7, 0x83, 0xd8, 0x09, 0x4a, 0x67,
	0xee, 0x14, 0x5e, 0x3d, 0xfc, 0x43, 0x03, 0xb0, 0x6c, 0x33, 0xe7, 0xf4, 0x3e, 0xd3, 0x93, 0x2e,
	0x33, 0xa4, 0xe4, 0xc4, 0x79, 0x2e, 0x9b, 0x49, 0xa9, 0xdf, 0x8d, 0x8a, 0xdd, 0x96, 0x62, 0x29,
	0xbc, 0xdd, 0xd7, 0x3b, 0x73, 0x4c, 0xb5, 0xd8, 0xa9, 0x91, 0x3c, 0x71, 0x56, 0xaa, 0xfd, 0xf1,
	0x67, 0x67, 0x7f, 0xc8, 0x18, 0xa1, 0x3b, 0xb6, 0x7d, 0x7c, 0x7c, 0x5c, 0x34, 0x4f, 0x2f, 0x65,
	0x43, 0xf1, 0xdb, 0xf0, 0x35, 0x12, 0x7a, 0xec, 0x08, 0x27, 0x51, 0xeb, 0xc2, 0x74, 0x1c, 0x91,
	0x94, 0xa1, 0xdd, 0x1f, 0x34, 0xb0, 0xee, 0xe3, 0x68, 0x96, 0x98, 0xbb, 0x8b, 0xd2, 0xef, 0xba,
	0x99, 0x05, 0x74, 0xb5, 0x4f, 0xde, 0x92, 0x89, 0x03, 0x1c, 0x7a, 0xf1, 0xc0, 0xc2, 0xc9, 0xc0,
	0x1e, 0xa0, 0x98, 0x1b, 0x84, 0x7d, 0x76, 0x4e, 0xe9, 0xc7, 0xf5, 0x1d, 0xb9, 0xfc, 0x51, 0x5f,
	0x7d, 0x20, 0x00, 0xee, 0xf1, 0x93, 0x24, 0xba, 0xb5, 0xdf, 0x7e, 0x32, 0x8d, 0x1c, 0xf0, 0xc8,
	0x81, 0x8c, 0x1c, 0xec, 0xb7, 0x0f, 0xaf, 0x72, 0xf8, 0x5b, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff,
	0x42, 0x0f, 0x03, 0xee, 0xba, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// OsLoginServiceClient is the client API for OsLoginService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type OsLoginServiceClient interface {
	// Deletes a POSIX account.
	DeletePosixAccount(ctx context.Context, in *DeletePosixAccountRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Deletes an SSH public key.
	DeleteSshPublicKey(ctx context.Context, in *DeleteSshPublicKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Retrieves the profile information used for logging in to a virtual machine
	// on Google Compute Engine.
	GetLoginProfile(ctx context.Context, in *GetLoginProfileRequest, opts ...grpc.CallOption) (*LoginProfile, error)
	// Retrieves an SSH public key.
	GetSshPublicKey(ctx context.Context, in *GetSshPublicKeyRequest, opts ...grpc.CallOption) (*common.SshPublicKey, error)
	// Adds an SSH public key and returns the profile information. Default POSIX
	// account information is set when no username and UID exist as part of the
	// login profile.
	ImportSshPublicKey(ctx context.Context, in *ImportSshPublicKeyRequest, opts ...grpc.CallOption) (*ImportSshPublicKeyResponse, error)
	// Updates an SSH public key and returns the profile information. This method
	// supports patch semantics.
	UpdateSshPublicKey(ctx context.Context, in *UpdateSshPublicKeyRequest, opts ...grpc.CallOption) (*common.SshPublicKey, error)
}

type osLoginServiceClient struct {
	cc *grpc.ClientConn
}

func NewOsLoginServiceClient(cc *grpc.ClientConn) OsLoginServiceClient {
	return &osLoginServiceClient{cc}
}

func (c *osLoginServiceClient) DeletePosixAccount(ctx context.Context, in *DeletePosixAccountRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1.OsLoginService/DeletePosixAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) DeleteSshPublicKey(ctx context.Context, in *DeleteSshPublicKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1.OsLoginService/DeleteSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) GetLoginProfile(ctx context.Context, in *GetLoginProfileRequest, opts ...grpc.CallOption) (*LoginProfile, error) {
	out := new(LoginProfile)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1.OsLoginService/GetLoginProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) GetSshPublicKey(ctx context.Context, in *GetSshPublicKeyRequest, opts ...grpc.CallOption) (*common.SshPublicKey, error) {
	out := new(common.SshPublicKey)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1.OsLoginService/GetSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) ImportSshPublicKey(ctx context.Context, in *ImportSshPublicKeyRequest, opts ...grpc.CallOption) (*ImportSshPublicKeyResponse, error) {
	out := new(ImportSshPublicKeyResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1.OsLoginService/ImportSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osLoginServiceClient) UpdateSshPublicKey(ctx context.Context, in *UpdateSshPublicKeyRequest, opts ...grpc.CallOption) (*common.SshPublicKey, error) {
	out := new(common.SshPublicKey)
	err := c.cc.Invoke(ctx, "/google.cloud.oslogin.v1.OsLoginService/UpdateSshPublicKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OsLoginServiceServer is the server API for OsLoginService service.
type OsLoginServiceServer interface {
	// Deletes a POSIX account.
	DeletePosixAccount(context.Context, *DeletePosixAccountRequest) (*empty.Empty, error)
	// Deletes an SSH public key.
	DeleteSshPublicKey(context.Context, *DeleteSshPublicKeyRequest) (*empty.Empty, error)
	// Retrieves the profile information used for logging in to a virtual machine
	// on Google Compute Engine.
	GetLoginProfile(context.Context, *GetLoginProfileRequest) (*LoginProfile, error)
	// Retrieves an SSH public key.
	GetSshPublicKey(context.Context, *GetSshPublicKeyRequest) (*common.SshPublicKey, error)
	// Adds an SSH public key and returns the profile information. Default POSIX
	// account information is set when no username and UID exist as part of the
	// login profile.
	ImportSshPublicKey(context.Context, *ImportSshPublicKeyRequest) (*ImportSshPublicKeyResponse, error)
	// Updates an SSH public key and returns the profile information. This method
	// supports patch semantics.
	UpdateSshPublicKey(context.Context, *UpdateSshPublicKeyRequest) (*common.SshPublicKey, error)
}

// UnimplementedOsLoginServiceServer can be embedded to have forward compatible implementations.
type UnimplementedOsLoginServiceServer struct {
}

func (*UnimplementedOsLoginServiceServer) DeletePosixAccount(ctx context.Context, req *DeletePosixAccountRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePosixAccount not implemented")
}
func (*UnimplementedOsLoginServiceServer) DeleteSshPublicKey(ctx context.Context, req *DeleteSshPublicKeyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSshPublicKey not implemented")
}
func (*UnimplementedOsLoginServiceServer) GetLoginProfile(ctx context.Context, req *GetLoginProfileRequest) (*LoginProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLoginProfile not implemented")
}
func (*UnimplementedOsLoginServiceServer) GetSshPublicKey(ctx context.Context, req *GetSshPublicKeyRequest) (*common.SshPublicKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSshPublicKey not implemented")
}
func (*UnimplementedOsLoginServiceServer) ImportSshPublicKey(ctx context.Context, req *ImportSshPublicKeyRequest) (*ImportSshPublicKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportSshPublicKey not implemented")
}
func (*UnimplementedOsLoginServiceServer) UpdateSshPublicKey(ctx context.Context, req *UpdateSshPublicKeyRequest) (*common.SshPublicKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSshPublicKey not implemented")
}

func RegisterOsLoginServiceServer(s *grpc.Server, srv OsLoginServiceServer) {
	s.RegisterService(&_OsLoginService_serviceDesc, srv)
}

func _OsLoginService_DeletePosixAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePosixAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).DeletePosixAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1.OsLoginService/DeletePosixAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).DeletePosixAccount(ctx, req.(*DeletePosixAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_DeleteSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).DeleteSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1.OsLoginService/DeleteSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).DeleteSshPublicKey(ctx, req.(*DeleteSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_GetLoginProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLoginProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).GetLoginProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1.OsLoginService/GetLoginProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).GetLoginProfile(ctx, req.(*GetLoginProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_GetSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).GetSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1.OsLoginService/GetSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).GetSshPublicKey(ctx, req.(*GetSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_ImportSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).ImportSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1.OsLoginService/ImportSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).ImportSshPublicKey(ctx, req.(*ImportSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsLoginService_UpdateSshPublicKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSshPublicKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsLoginServiceServer).UpdateSshPublicKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oslogin.v1.OsLoginService/UpdateSshPublicKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsLoginServiceServer).UpdateSshPublicKey(ctx, req.(*UpdateSshPublicKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OsLoginService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.oslogin.v1.OsLoginService",
	HandlerType: (*OsLoginServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DeletePosixAccount",
			Handler:    _OsLoginService_DeletePosixAccount_Handler,
		},
		{
			MethodName: "DeleteSshPublicKey",
			Handler:    _OsLoginService_DeleteSshPublicKey_Handler,
		},
		{
			MethodName: "GetLoginProfile",
			Handler:    _OsLoginService_GetLoginProfile_Handler,
		},
		{
			MethodName: "GetSshPublicKey",
			Handler:    _OsLoginService_GetSshPublicKey_Handler,
		},
		{
			MethodName: "ImportSshPublicKey",
			Handler:    _OsLoginService_ImportSshPublicKey_Handler,
		},
		{
			MethodName: "UpdateSshPublicKey",
			Handler:    _OsLoginService_UpdateSshPublicKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/oslogin/v1/oslogin.proto",
}
