// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateFlowDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The name of your flow definition.
	//
	// FlowDefinitionName is a required field
	FlowDefinitionName *string `min:"1" type:"string" required:"true"`

	// An object containing information about the events that trigger a human workflow.
	HumanLoopActivationConfig *HumanLoopActivationConfig `type:"structure"`

	// An object containing information about the tasks the human reviewers will
	// perform.
	//
	// HumanLoopConfig is a required field
	HumanLoopConfig *HumanLoopConfig `type:"structure" required:"true"`

	// An object containing information about where the human review results will
	// be uploaded.
	//
	// OutputConfig is a required field
	OutputConfig *FlowDefinitionOutputConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the role needed to call other services
	// on your behalf. For example, arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// An array of key-value pairs that contain metadata to help you categorize
	// and organize a flow definition. Each tag consists of a key and a value, both
	// of which you define.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateFlowDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlowDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFlowDefinitionInput"}

	if s.FlowDefinitionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FlowDefinitionName"))
	}
	if s.FlowDefinitionName != nil && len(*s.FlowDefinitionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FlowDefinitionName", 1))
	}

	if s.HumanLoopConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("HumanLoopConfig"))
	}

	if s.OutputConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputConfig"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}
	if s.HumanLoopActivationConfig != nil {
		if err := s.HumanLoopActivationConfig.Validate(); err != nil {
			invalidParams.AddNested("HumanLoopActivationConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.HumanLoopConfig != nil {
		if err := s.HumanLoopConfig.Validate(); err != nil {
			invalidParams.AddNested("HumanLoopConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateFlowDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow definition you create.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateFlowDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateFlowDefinition = "CreateFlowDefinition"

// CreateFlowDefinitionRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Creates a flow definition.
//
//    // Example sending a request using CreateFlowDefinitionRequest.
//    req := client.CreateFlowDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition
func (c *Client) CreateFlowDefinitionRequest(input *CreateFlowDefinitionInput) CreateFlowDefinitionRequest {
	op := &aws.Operation{
		Name:       opCreateFlowDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFlowDefinitionInput{}
	}

	req := c.newRequest(op, input, &CreateFlowDefinitionOutput{})
	return CreateFlowDefinitionRequest{Request: req, Input: input, Copy: c.CreateFlowDefinitionRequest}
}

// CreateFlowDefinitionRequest is the request type for the
// CreateFlowDefinition API operation.
type CreateFlowDefinitionRequest struct {
	*aws.Request
	Input *CreateFlowDefinitionInput
	Copy  func(*CreateFlowDefinitionInput) CreateFlowDefinitionRequest
}

// Send marshals and sends the CreateFlowDefinition API request.
func (r CreateFlowDefinitionRequest) Send(ctx context.Context) (*CreateFlowDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateFlowDefinitionResponse{
		CreateFlowDefinitionOutput: r.Request.Data.(*CreateFlowDefinitionOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateFlowDefinitionResponse is the response type for the
// CreateFlowDefinition API operation.
type CreateFlowDefinitionResponse struct {
	*CreateFlowDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateFlowDefinition request.
func (r *CreateFlowDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
