package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDashboardParameters invokes the airec.ListDashboardParameters API synchronously
// api document: https://help.aliyun.com/api/airec/listdashboardparameters.html
func (client *Client) ListDashboardParameters(request *ListDashboardParametersRequest) (response *ListDashboardParametersResponse, err error) {
	response = CreateListDashboardParametersResponse()
	err = client.DoAction(request, response)
	return
}

// ListDashboardParametersWithChan invokes the airec.ListDashboardParameters API asynchronously
// api document: https://help.aliyun.com/api/airec/listdashboardparameters.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDashboardParametersWithChan(request *ListDashboardParametersRequest) (<-chan *ListDashboardParametersResponse, <-chan error) {
	responseChan := make(chan *ListDashboardParametersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDashboardParameters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDashboardParametersWithCallback invokes the airec.ListDashboardParameters API asynchronously
// api document: https://help.aliyun.com/api/airec/listdashboardparameters.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDashboardParametersWithCallback(request *ListDashboardParametersRequest, callback func(response *ListDashboardParametersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDashboardParametersResponse
		var err error
		defer close(result)
		response, err = client.ListDashboardParameters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDashboardParametersRequest is the request struct for api ListDashboardParameters
type ListDashboardParametersRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ListDashboardParametersResponse is the response struct for api ListDashboardParameters
type ListDashboardParametersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateListDashboardParametersRequest creates a request to invoke ListDashboardParameters API
func CreateListDashboardParametersRequest() (request *ListDashboardParametersRequest) {
	request = &ListDashboardParametersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "ListDashboardParameters", "/openapi/instances/[InstanceId]/dashboard/parameters", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDashboardParametersResponse creates a response to parse from ListDashboardParameters response
func CreateListDashboardParametersResponse() (response *ListDashboardParametersResponse) {
	response = &ListDashboardParametersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
