// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/helper/schema"
	"github.com/hashicorp/terraform-plugin-sdk/helper/validation"
)

func resourceCloudAssetProjectFeed() *schema.Resource {
	return &schema.Resource{
		Create: resourceCloudAssetProjectFeedCreate,
		Read:   resourceCloudAssetProjectFeedRead,
		Update: resourceCloudAssetProjectFeedUpdate,
		Delete: resourceCloudAssetProjectFeedDelete,

		Importer: &schema.ResourceImporter{
			State: resourceCloudAssetProjectFeedImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(4 * time.Minute),
			Update: schema.DefaultTimeout(4 * time.Minute),
			Delete: schema.DefaultTimeout(4 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"feed_id": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.`,
			},
			"feed_output_config": {
				Type:        schema.TypeList,
				Required:    true,
				Description: `Output configuration for asset feed destination.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"pubsub_destination": {
							Type:        schema.TypeList,
							Required:    true,
							Description: `Destination on Cloud Pubsub.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"topic": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Destination on Cloud Pubsub topic.`,
									},
								},
							},
						},
					},
				},
			},
			"asset_names": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `A list of the full names of the assets to receive updates. You must specify either or both of 
assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"asset_types": {
				Type:     schema.TypeList,
				Optional: true,
				Description: `A list of types of the assets to receive updates. You must specify either or both of assetNames
and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
the feed. For example: "compute.googleapis.com/Disk"
See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
supported asset types.`,
				Elem: &schema.Schema{
					Type: schema.TypeString,
				},
			},
			"billing_project": {
				Type:     schema.TypeString,
				Optional: true,
				ForceNew: true,
				Description: `The project whose identity will be used when sending messages to the
destination pubsub topic. It also specifies the project for API 
enablement check, quota, and billing. If not specified, the resource's
project will be used.`,
			},
			"content_type": {
				Type:         schema.TypeString,
				Optional:     true,
				ValidateFunc: validation.StringInSlice([]string{"CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY", ""}, false),
				Description:  `Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]`,
			},
			"name": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The format will be projects/{projectNumber}/feeds/{client-assigned_feed_identifier}.`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
	}
}

func resourceCloudAssetProjectFeedCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	obj := make(map[string]interface{})
	assetNamesProp, err := expandCloudAssetProjectFeedAssetNames(d.Get("asset_names"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("asset_names"); !isEmptyValue(reflect.ValueOf(assetNamesProp)) && (ok || !reflect.DeepEqual(v, assetNamesProp)) {
		obj["assetNames"] = assetNamesProp
	}
	assetTypesProp, err := expandCloudAssetProjectFeedAssetTypes(d.Get("asset_types"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("asset_types"); !isEmptyValue(reflect.ValueOf(assetTypesProp)) && (ok || !reflect.DeepEqual(v, assetTypesProp)) {
		obj["assetTypes"] = assetTypesProp
	}
	contentTypeProp, err := expandCloudAssetProjectFeedContentType(d.Get("content_type"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("content_type"); !isEmptyValue(reflect.ValueOf(contentTypeProp)) && (ok || !reflect.DeepEqual(v, contentTypeProp)) {
		obj["contentType"] = contentTypeProp
	}
	feedOutputConfigProp, err := expandCloudAssetProjectFeedFeedOutputConfig(d.Get("feed_output_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("feed_output_config"); !isEmptyValue(reflect.ValueOf(feedOutputConfigProp)) && (ok || !reflect.DeepEqual(v, feedOutputConfigProp)) {
		obj["feedOutputConfig"] = feedOutputConfigProp
	}

	obj, err = resourceCloudAssetProjectFeedEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{CloudAssetBasePath}}projects/{{project}}/feeds?feedId={{feed_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new ProjectFeed: %#v", obj)
	project, err := getProject(d, config)
	if err != nil {
		return err
	}
	// This should never happen, but the linter complains otherwise with ineffectual assignment to `project`
	if project == "dummy lint" {
		log.Printf("[DEBUG] Found project in url: %s", project)
	}
	// Send the project ID in the X-Goog-User-Project header.
	origUserProjectOverride := config.UserProjectOverride
	config.UserProjectOverride = true
	// If we have a billing project, use that one in the header.
	bp, bpok := d.GetOk("billing_project")
	if bpok && bp != "" {
		project = bp.(string)
	} else {
		// otherwise, use the resource's project
		rp, _ := d.GetOk("project")
		project = rp.(string)
	}
	res, err := sendRequestWithTimeout(config, "POST", project, url, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating ProjectFeed: %s", err)
	}
	if err := d.Set("name", flattenCloudAssetProjectFeedName(res["name"], d, config)); err != nil {
		return fmt.Errorf(`Error setting computed identity field "name": %s`, err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating ProjectFeed %q: %#v", d.Id(), res)

	// Restore the original value of user_project_override.
	config.UserProjectOverride = origUserProjectOverride

	return resourceCloudAssetProjectFeedRead(d, meta)
}

func resourceCloudAssetProjectFeedRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	url, err := replaceVars(d, config, "{{CloudAssetBasePath}}{{name}}")
	if err != nil {
		return err
	}

	project, err := getProject(d, config)
	if err != nil {
		return err
	}
	res, err := sendRequest(config, "GET", project, url, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("CloudAssetProjectFeed %q", d.Id()))
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading ProjectFeed: %s", err)
	}

	if err := d.Set("name", flattenCloudAssetProjectFeedName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading ProjectFeed: %s", err)
	}
	if err := d.Set("asset_names", flattenCloudAssetProjectFeedAssetNames(res["assetNames"], d, config)); err != nil {
		return fmt.Errorf("Error reading ProjectFeed: %s", err)
	}
	if err := d.Set("asset_types", flattenCloudAssetProjectFeedAssetTypes(res["assetTypes"], d, config)); err != nil {
		return fmt.Errorf("Error reading ProjectFeed: %s", err)
	}
	if err := d.Set("content_type", flattenCloudAssetProjectFeedContentType(res["contentType"], d, config)); err != nil {
		return fmt.Errorf("Error reading ProjectFeed: %s", err)
	}
	if err := d.Set("feed_output_config", flattenCloudAssetProjectFeedFeedOutputConfig(res["feedOutputConfig"], d, config)); err != nil {
		return fmt.Errorf("Error reading ProjectFeed: %s", err)
	}

	return nil
}

func resourceCloudAssetProjectFeedUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	project, err := getProject(d, config)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	assetNamesProp, err := expandCloudAssetProjectFeedAssetNames(d.Get("asset_names"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("asset_names"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, assetNamesProp)) {
		obj["assetNames"] = assetNamesProp
	}
	assetTypesProp, err := expandCloudAssetProjectFeedAssetTypes(d.Get("asset_types"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("asset_types"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, assetTypesProp)) {
		obj["assetTypes"] = assetTypesProp
	}
	contentTypeProp, err := expandCloudAssetProjectFeedContentType(d.Get("content_type"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("content_type"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, contentTypeProp)) {
		obj["contentType"] = contentTypeProp
	}
	feedOutputConfigProp, err := expandCloudAssetProjectFeedFeedOutputConfig(d.Get("feed_output_config"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("feed_output_config"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, feedOutputConfigProp)) {
		obj["feedOutputConfig"] = feedOutputConfigProp
	}

	obj, err = resourceCloudAssetProjectFeedEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{CloudAssetBasePath}}{{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating ProjectFeed %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("asset_names") {
		updateMask = append(updateMask, "assetNames")
	}

	if d.HasChange("asset_types") {
		updateMask = append(updateMask, "assetTypes")
	}

	if d.HasChange("content_type") {
		updateMask = append(updateMask, "contentType")
	}

	if d.HasChange("feed_output_config") {
		updateMask = append(updateMask, "feedOutputConfig")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}
	res, err := sendRequestWithTimeout(config, "PATCH", project, url, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating ProjectFeed %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating ProjectFeed %q: %#v", d.Id(), res)
	}

	return resourceCloudAssetProjectFeedRead(d, meta)
}

func resourceCloudAssetProjectFeedDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	project, err := getProject(d, config)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{CloudAssetBasePath}}{{name}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting ProjectFeed %q", d.Id())

	res, err := sendRequestWithTimeout(config, "DELETE", project, url, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "ProjectFeed")
	}

	log.Printf("[DEBUG] Finished deleting ProjectFeed %q: %#v", d.Id(), res)
	return nil
}

func resourceCloudAssetProjectFeedImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	if err := d.Set("name", d.Id()); err != nil {
		return nil, err
	}
	return []*schema.ResourceData{d}, nil
}

func flattenCloudAssetProjectFeedName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudAssetProjectFeedAssetNames(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudAssetProjectFeedAssetTypes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudAssetProjectFeedContentType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenCloudAssetProjectFeedFeedOutputConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["pubsub_destination"] =
		flattenCloudAssetProjectFeedFeedOutputConfigPubsubDestination(original["pubsubDestination"], d, config)
	return []interface{}{transformed}
}
func flattenCloudAssetProjectFeedFeedOutputConfigPubsubDestination(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["topic"] =
		flattenCloudAssetProjectFeedFeedOutputConfigPubsubDestinationTopic(original["topic"], d, config)
	return []interface{}{transformed}
}
func flattenCloudAssetProjectFeedFeedOutputConfigPubsubDestinationTopic(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandCloudAssetProjectFeedAssetNames(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudAssetProjectFeedAssetTypes(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudAssetProjectFeedContentType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandCloudAssetProjectFeedFeedOutputConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedPubsubDestination, err := expandCloudAssetProjectFeedFeedOutputConfigPubsubDestination(original["pubsub_destination"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPubsubDestination); val.IsValid() && !isEmptyValue(val) {
		transformed["pubsubDestination"] = transformedPubsubDestination
	}

	return transformed, nil
}

func expandCloudAssetProjectFeedFeedOutputConfigPubsubDestination(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedTopic, err := expandCloudAssetProjectFeedFeedOutputConfigPubsubDestinationTopic(original["topic"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedTopic); val.IsValid() && !isEmptyValue(val) {
		transformed["topic"] = transformedTopic
	}

	return transformed, nil
}

func expandCloudAssetProjectFeedFeedOutputConfigPubsubDestinationTopic(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func resourceCloudAssetProjectFeedEncoder(d *schema.ResourceData, meta interface{}, obj map[string]interface{}) (map[string]interface{}, error) {
	// Remove the "folders/" prefix from the folder ID
	if folder, ok := d.GetOkExists("folder"); ok {
		d.Set("folder_id", strings.TrimPrefix(folder.(string), "folders/"))
	}
	// The feed object must be under the "feed" attribute on the request.
	newObj := make(map[string]interface{})
	newObj["feed"] = obj
	return newObj, nil
}
