package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSupportedOpsCommand invokes the emr.GetSupportedOpsCommand API synchronously
// api document: https://help.aliyun.com/api/emr/getsupportedopscommand.html
func (client *Client) GetSupportedOpsCommand(request *GetSupportedOpsCommandRequest) (response *GetSupportedOpsCommandResponse, err error) {
	response = CreateGetSupportedOpsCommandResponse()
	err = client.DoAction(request, response)
	return
}

// GetSupportedOpsCommandWithChan invokes the emr.GetSupportedOpsCommand API asynchronously
// api document: https://help.aliyun.com/api/emr/getsupportedopscommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSupportedOpsCommandWithChan(request *GetSupportedOpsCommandRequest) (<-chan *GetSupportedOpsCommandResponse, <-chan error) {
	responseChan := make(chan *GetSupportedOpsCommandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSupportedOpsCommand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSupportedOpsCommandWithCallback invokes the emr.GetSupportedOpsCommand API asynchronously
// api document: https://help.aliyun.com/api/emr/getsupportedopscommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSupportedOpsCommandWithCallback(request *GetSupportedOpsCommandRequest, callback func(response *GetSupportedOpsCommandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSupportedOpsCommandResponse
		var err error
		defer close(result)
		response, err = client.GetSupportedOpsCommand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSupportedOpsCommandRequest is the request struct for api GetSupportedOpsCommand
type GetSupportedOpsCommandRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// GetSupportedOpsCommandResponse is the response struct for api GetSupportedOpsCommand
type GetSupportedOpsCommandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	List      List   `json:"List" xml:"List"`
}

// CreateGetSupportedOpsCommandRequest creates a request to invoke GetSupportedOpsCommand API
func CreateGetSupportedOpsCommandRequest() (request *GetSupportedOpsCommandRequest) {
	request = &GetSupportedOpsCommandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetSupportedOpsCommand", "emr", "openAPI")
	return
}

// CreateGetSupportedOpsCommandResponse creates a response to parse from GetSupportedOpsCommand response
func CreateGetSupportedOpsCommandResponse() (response *GetSupportedOpsCommandResponse) {
	response = &GetSupportedOpsCommandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
