package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EvaluateSupportByokShow invokes the rds.EvaluateSupportByokShow API synchronously
// api document: https://help.aliyun.com/api/rds/evaluatesupportbyokshow.html
func (client *Client) EvaluateSupportByokShow(request *EvaluateSupportByokShowRequest) (response *EvaluateSupportByokShowResponse, err error) {
	response = CreateEvaluateSupportByokShowResponse()
	err = client.DoAction(request, response)
	return
}

// EvaluateSupportByokShowWithChan invokes the rds.EvaluateSupportByokShow API asynchronously
// api document: https://help.aliyun.com/api/rds/evaluatesupportbyokshow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EvaluateSupportByokShowWithChan(request *EvaluateSupportByokShowRequest) (<-chan *EvaluateSupportByokShowResponse, <-chan error) {
	responseChan := make(chan *EvaluateSupportByokShowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EvaluateSupportByokShow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EvaluateSupportByokShowWithCallback invokes the rds.EvaluateSupportByokShow API asynchronously
// api document: https://help.aliyun.com/api/rds/evaluatesupportbyokshow.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) EvaluateSupportByokShowWithCallback(request *EvaluateSupportByokShowRequest, callback func(response *EvaluateSupportByokShowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EvaluateSupportByokShowResponse
		var err error
		defer close(result)
		response, err = client.EvaluateSupportByokShow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EvaluateSupportByokShowRequest is the request struct for api EvaluateSupportByokShow
type EvaluateSupportByokShowRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NodeType              string           `position:"Query" name:"NodeType"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	EngineVersion         string           `position:"Query" name:"EngineVersion"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken         string           `position:"Query" name:"SecurityToken"`
	Engine                string           `position:"Query" name:"Engine"`
	TargetRegionId        string           `position:"Query" name:"TargetRegionId"`
	DbInstanceStorageType string           `position:"Query" name:"DbInstanceStorageType"`
}

// EvaluateSupportByokShowResponse is the response struct for api EvaluateSupportByokShow
type EvaluateSupportByokShowResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	SupportByokShow int    `json:"SupportByokShow" xml:"SupportByokShow"`
	SupportByokZone string `json:"SupportByokZone" xml:"SupportByokZone"`
}

// CreateEvaluateSupportByokShowRequest creates a request to invoke EvaluateSupportByokShow API
func CreateEvaluateSupportByokShowRequest() (request *EvaluateSupportByokShowRequest) {
	request = &EvaluateSupportByokShowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "EvaluateSupportByokShow", "rds", "openAPI")
	return
}

// CreateEvaluateSupportByokShowResponse creates a response to parse from EvaluateSupportByokShow response
func CreateEvaluateSupportByokShowResponse() (response *EvaluateSupportByokShowResponse) {
	response = &EvaluateSupportByokShowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
