# ANSI转义序列

> 内容来自于 [wikipedia](https://zh.wikipedia.org/wiki/ANSI转义序列) 并且只是摘取了部分，更多请查看原页面

## 选择图形再现（SGR）参数

```text
代码	作用	备注
0	重置/正常	关闭所有属性。
1	粗体或增加强度	
2	弱化（降低强度）	未广泛支持。
3	斜体	未广泛支持。有时视为反相显示。
4	下划线	
5	缓慢闪烁	低于每分钟150次。
6	快速闪烁	MS-DOS ANSI.SYS；每分钟150以上；未广泛支持。
7	反显	前景色与背景色交换。
8	隐藏	未广泛支持。
9	划除	字符清晰，但标记为删除。未广泛支持。
10	主要（默认）字体	
11–19	替代字体	选择替代字体 {\displaystyle n-10} {\displaystyle n-10}。
20	尖角体	几乎无支持。
21	关闭粗体或双下划线	关闭粗体未广泛支持；双下划线几乎无支持。
22	正常颜色或强度	不强不弱。
23	非斜体、非尖角体	
24	关闭下划线	去掉单双下划线。
25	关闭闪烁	
27	关闭反显	
28	关闭隐藏	
29	关闭划除	
30–37	设置前景色	参见下面的颜色表。
38	设置前景色	下一个参数是5;n或2;r;g;b，见下。
39	默认前景色	由具体实现定义（按照标准）。
40–47	设置背景色	参见下面的颜色表。
48	设置背景色	下一个参数是5;n或2;r;g;b，见下。
49	默认背景色	由具体实现定义（按照标准）。
51	Framed	
52	Encircled	
53	上划线	
54	Not framed or encircled	
55	关闭上划线	
60	表意文字下划线或右边线	几乎无支持。
61	表意文字双下划线或双右边线
62	表意文字上划线或左边线
63	表意文字双上划线或双左边线
64	表意文字着重标志
65	表意文字属性关闭	重置60–64的所有效果。
90–97	设置明亮的前景色	aixterm（非标准）。
100–107	设置明亮的背景色	aixterm（非标准）。
```

## 颜色

> `ESC` 即是程序代码中的 "\033"(Octal 8进制), "\x1b"(Hexadecimal 16进制), 27 (10进制)

### 3/4位

初始的规格只有8种颜色，只给了它们的名字。SGR参数30-37选择前景色，40-47选择背景色。
相当多的终端将“粗体”（SGR代码1）实现为更明亮的颜色而不是不同的字体，从而提供了8种额外的前景色，但通常情况下并不能用于背景色，虽然有时候反显（SGR代码7）可以允许这样。
例如：在白色背景上显示黑色文字使用`ESC[30;47m`，显示红色文字用`ESC[31m`，显示明亮的红色文字用 `ESC[1;31m` 。重置为默认颜色用 `ESC[39;49m`（某些终端不支持），重置所有属性用ESC[0m。
后来的终端新增了功能，可以直接用90-97和100-107指定“明亮”的颜色。

当硬件开始使用8位DAC时，多个软件为这些颜色名称分配了24位的代码。下面的图表显示了发送到DAC的一些常用硬件和软件的值。

![cmd-term-colors](4bit-colors.jpg)

### 8位

随着256(`2^8`)色查找表在显卡上越来越常见，相应的转义序列也增加了，以从预定义的256种颜色中选择：

```text
   ESC[ … 38;5;<n> … m // 选择前景色
   ESC[ … 48;5;<n> … m // 选择背景色
   
     0-  7：标准颜色（同ESC [ 30–37 m）
     8- 15：高强度颜色（同ESC [ 90–97 m）
    16-231：6 × 6 × 6 立方（216色）: 16 + 36 × r + 6 × g + b (0 ≤ r, g, b ≤ 5)
   232-255：从黑到白的24阶灰度色
```

![8-byte-colors](8bit-colors.jpg)

### 24位

随着16位到24位颜色的“真彩色”显卡的普及，Xterm、KDE的Konsole[17]，以及所有基于libvte的终端[18]（包括GNOME终端）支持了ISO-8613-3的24位前景色和背景色设置。[19]

```text
   ESC[ … 38;2;<r>;<g>;<b> … m // 选择RGB前景色
   ESC[ … 48;2;<r>;<g>;<b> … m // 选择RGB背景色
```

作为ISO / IEC国际标准8613-6采用的ITU的T.416信息技术-开放文档体系结构（ODA）和交换格式：字符内容体系结构[20]给出了一个似乎不太受支持的替代版本：

```text
   ESC[ … 38:2:<Color-Space-ID>:<r>:<g>:<b>:<unused>:<CS tolerance>:<Color-Space: 0="CIELUV"; 1="CIELAB">m选择RGB前景色
   ESC[ … 48:2:<Color-Space-ID>:<r>:<g>:<b>:<unused>:<CS tolerance>:<Color-Space: 0="CIELUV"; 1="CIELAB">m选择RGB背景色
```

> 请注意，这里使用了保留的“:”字符来分隔子选项，这可能是在实际实现中造成混淆的始作俑者。
它还使用“3”作为第二个参数来指定使用青-品红-黄方案的方案，“4”用于青-品红-黄-黑的方案，后者使用上面标记为“unused”（“未使用”）的位置作为黑色组件。
还要注意，许多识别“:”作为分隔符的实现错误地忽视了色彩空间标识符参数，并因此改变了其余部分的位置。
