package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeListAccessKeyIdAuth invokes the aegis.DescribeListAccessKeyIdAuth API synchronously
// api document: https://help.aliyun.com/api/aegis/describelistaccesskeyidauth.html
func (client *Client) DescribeListAccessKeyIdAuth(request *DescribeListAccessKeyIdAuthRequest) (response *DescribeListAccessKeyIdAuthResponse, err error) {
	response = CreateDescribeListAccessKeyIdAuthResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeListAccessKeyIdAuthWithChan invokes the aegis.DescribeListAccessKeyIdAuth API asynchronously
// api document: https://help.aliyun.com/api/aegis/describelistaccesskeyidauth.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeListAccessKeyIdAuthWithChan(request *DescribeListAccessKeyIdAuthRequest) (<-chan *DescribeListAccessKeyIdAuthResponse, <-chan error) {
	responseChan := make(chan *DescribeListAccessKeyIdAuthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeListAccessKeyIdAuth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeListAccessKeyIdAuthWithCallback invokes the aegis.DescribeListAccessKeyIdAuth API asynchronously
// api document: https://help.aliyun.com/api/aegis/describelistaccesskeyidauth.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeListAccessKeyIdAuthWithCallback(request *DescribeListAccessKeyIdAuthRequest, callback func(response *DescribeListAccessKeyIdAuthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeListAccessKeyIdAuthResponse
		var err error
		defer close(result)
		response, err = client.DescribeListAccessKeyIdAuth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeListAccessKeyIdAuthRequest is the request struct for api DescribeListAccessKeyIdAuth
type DescribeListAccessKeyIdAuthRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeListAccessKeyIdAuthResponse is the response struct for api DescribeListAccessKeyIdAuth
type DescribeListAccessKeyIdAuthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Auth      bool   `json:"Auth" xml:"Auth"`
}

// CreateDescribeListAccessKeyIdAuthRequest creates a request to invoke DescribeListAccessKeyIdAuth API
func CreateDescribeListAccessKeyIdAuthRequest() (request *DescribeListAccessKeyIdAuthRequest) {
	request = &DescribeListAccessKeyIdAuthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeListAccessKeyIdAuth", "vipaegis", "openAPI")
	return
}

// CreateDescribeListAccessKeyIdAuthResponse creates a response to parse from DescribeListAccessKeyIdAuth response
func CreateDescribeListAccessKeyIdAuthResponse() (response *DescribeListAccessKeyIdAuthResponse) {
	response = &DescribeListAccessKeyIdAuthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
