package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachClusterForNote invokes the emr.DetachClusterForNote API synchronously
// api document: https://help.aliyun.com/api/emr/detachclusterfornote.html
func (client *Client) DetachClusterForNote(request *DetachClusterForNoteRequest) (response *DetachClusterForNoteResponse, err error) {
	response = CreateDetachClusterForNoteResponse()
	err = client.DoAction(request, response)
	return
}

// DetachClusterForNoteWithChan invokes the emr.DetachClusterForNote API asynchronously
// api document: https://help.aliyun.com/api/emr/detachclusterfornote.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetachClusterForNoteWithChan(request *DetachClusterForNoteRequest) (<-chan *DetachClusterForNoteResponse, <-chan error) {
	responseChan := make(chan *DetachClusterForNoteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachClusterForNote(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachClusterForNoteWithCallback invokes the emr.DetachClusterForNote API asynchronously
// api document: https://help.aliyun.com/api/emr/detachclusterfornote.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetachClusterForNoteWithCallback(request *DetachClusterForNoteRequest, callback func(response *DetachClusterForNoteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachClusterForNoteResponse
		var err error
		defer close(result)
		response, err = client.DetachClusterForNote(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachClusterForNoteRequest is the request struct for api DetachClusterForNote
type DetachClusterForNoteRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
}

// DetachClusterForNoteResponse is the response struct for api DetachClusterForNote
type DetachClusterForNoteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachClusterForNoteRequest creates a request to invoke DetachClusterForNote API
func CreateDetachClusterForNoteRequest() (request *DetachClusterForNoteRequest) {
	request = &DetachClusterForNoteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DetachClusterForNote", "emr", "openAPI")
	return
}

// CreateDetachClusterForNoteResponse creates a response to parse from DetachClusterForNote response
func CreateDetachClusterForNoteResponse() (response *DetachClusterForNoteResponse) {
	response = &DetachClusterForNoteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
