package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCrossRegionBackupDBInstance invokes the rds.DescribeCrossRegionBackupDBInstance API synchronously
// api document: https://help.aliyun.com/api/rds/describecrossregionbackupdbinstance.html
func (client *Client) DescribeCrossRegionBackupDBInstance(request *DescribeCrossRegionBackupDBInstanceRequest) (response *DescribeCrossRegionBackupDBInstanceResponse, err error) {
	response = CreateDescribeCrossRegionBackupDBInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCrossRegionBackupDBInstanceWithChan invokes the rds.DescribeCrossRegionBackupDBInstance API asynchronously
// api document: https://help.aliyun.com/api/rds/describecrossregionbackupdbinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCrossRegionBackupDBInstanceWithChan(request *DescribeCrossRegionBackupDBInstanceRequest) (<-chan *DescribeCrossRegionBackupDBInstanceResponse, <-chan error) {
	responseChan := make(chan *DescribeCrossRegionBackupDBInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCrossRegionBackupDBInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCrossRegionBackupDBInstanceWithCallback invokes the rds.DescribeCrossRegionBackupDBInstance API asynchronously
// api document: https://help.aliyun.com/api/rds/describecrossregionbackupdbinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCrossRegionBackupDBInstanceWithCallback(request *DescribeCrossRegionBackupDBInstanceRequest, callback func(response *DescribeCrossRegionBackupDBInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCrossRegionBackupDBInstanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeCrossRegionBackupDBInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCrossRegionBackupDBInstanceRequest is the request struct for api DescribeCrossRegionBackupDBInstance
type DescribeCrossRegionBackupDBInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeCrossRegionBackupDBInstanceResponse is the response struct for api DescribeCrossRegionBackupDBInstance
type DescribeCrossRegionBackupDBInstanceResponse struct {
	*responses.BaseResponse
	RequestId    string                                     `json:"RequestId" xml:"RequestId"`
	RegionId     string                                     `json:"RegionId" xml:"RegionId"`
	TotalRecords int                                        `json:"TotalRecords" xml:"TotalRecords"`
	PageSize     int                                        `json:"PageSize" xml:"PageSize"`
	PageNumber   int                                        `json:"PageNumber" xml:"PageNumber"`
	ItemsNumbers int                                        `json:"ItemsNumbers" xml:"ItemsNumbers"`
	Items        ItemsInDescribeCrossRegionBackupDBInstance `json:"Items" xml:"Items"`
}

// CreateDescribeCrossRegionBackupDBInstanceRequest creates a request to invoke DescribeCrossRegionBackupDBInstance API
func CreateDescribeCrossRegionBackupDBInstanceRequest() (request *DescribeCrossRegionBackupDBInstanceRequest) {
	request = &DescribeCrossRegionBackupDBInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeCrossRegionBackupDBInstance", "rds", "openAPI")
	return
}

// CreateDescribeCrossRegionBackupDBInstanceResponse creates a response to parse from DescribeCrossRegionBackupDBInstance response
func CreateDescribeCrossRegionBackupDBInstanceResponse() (response *DescribeCrossRegionBackupDBInstanceResponse) {
	response = &DescribeCrossRegionBackupDBInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
