package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNetworkOptimizations invokes the smartag.DescribeNetworkOptimizations API synchronously
// api document: https://help.aliyun.com/api/smartag/describenetworkoptimizations.html
func (client *Client) DescribeNetworkOptimizations(request *DescribeNetworkOptimizationsRequest) (response *DescribeNetworkOptimizationsResponse, err error) {
	response = CreateDescribeNetworkOptimizationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNetworkOptimizationsWithChan invokes the smartag.DescribeNetworkOptimizations API asynchronously
// api document: https://help.aliyun.com/api/smartag/describenetworkoptimizations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNetworkOptimizationsWithChan(request *DescribeNetworkOptimizationsRequest) (<-chan *DescribeNetworkOptimizationsResponse, <-chan error) {
	responseChan := make(chan *DescribeNetworkOptimizationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNetworkOptimizations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNetworkOptimizationsWithCallback invokes the smartag.DescribeNetworkOptimizations API asynchronously
// api document: https://help.aliyun.com/api/smartag/describenetworkoptimizations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNetworkOptimizationsWithCallback(request *DescribeNetworkOptimizationsRequest, callback func(response *DescribeNetworkOptimizationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNetworkOptimizationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeNetworkOptimizations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNetworkOptimizationsRequest is the request struct for api DescribeNetworkOptimizations
type DescribeNetworkOptimizationsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	NetworkOptId         string           `position:"Query" name:"NetworkOptId"`
	PageNo               requests.Integer `position:"Query" name:"PageNo"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	CcnId                string           `position:"Query" name:"CcnId"`
	Name                 string           `position:"Query" name:"Name"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeNetworkOptimizationsResponse is the response struct for api DescribeNetworkOptimizations
type DescribeNetworkOptimizationsResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	TotalCount           int                  `json:"TotalCount" xml:"TotalCount"`
	PageNo               int                  `json:"PageNo" xml:"PageNo"`
	PageSize             int                  `json:"PageSize" xml:"PageSize"`
	NetworkOptimizations NetworkOptimizations `json:"NetworkOptimizations" xml:"NetworkOptimizations"`
}

// CreateDescribeNetworkOptimizationsRequest creates a request to invoke DescribeNetworkOptimizations API
func CreateDescribeNetworkOptimizationsRequest() (request *DescribeNetworkOptimizationsRequest) {
	request = &DescribeNetworkOptimizationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeNetworkOptimizations", "smartag", "openAPI")
	return
}

// CreateDescribeNetworkOptimizationsResponse creates a response to parse from DescribeNetworkOptimizations response
func CreateDescribeNetworkOptimizationsResponse() (response *DescribeNetworkOptimizationsResponse) {
	response = &DescribeNetworkOptimizationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
