# Frequently Asked Questions

### Who are the maintainers?

The HashiCorp Terraform Kubernetes provider team is :

* Phil Sautter, Product Manager - [@redeux](https://github.com/redeux)
* Alex Somesan, Engineer - [@alexsomesan](https://github.com/alexsomesan)
* John Houston, Engineer - [@jrhouston](https://github.com/jrhouston)
* Stef Forrester, Engineer - [@dak1n1](https://github.com/dak1n1)
* Aareet Shermon, Engineering Manager - [@aareet](https://github.com/aareet)

Our collaborators are:

* Patrick Decat - [@pdecat](https://github.com/pdecat)

### Why isn’t my PR merged yet?

Unfortunately, due to the volume of issues and new pull requests we receive, we are unable to give each one the full attention that we would like. We do our best to focus on the contributions that provide the greatest value to the most community members.

### How do you decide what gets merged for each release?

The number one factor we look at when deciding what issues to look at are your 👍 [reactions](https://blog.github.com/2016-03-10-add-reactions-to-pull-requests-issues-and-comments/) to the original issue/PR description as these can be easily discovered. Comments that further explain desired use cases or poor user experience are also heavily factored. The items with the most support are always on our radar, and we do our best to keep the community updated on their status and potential timelines.

We also are investing time to improve the contributing experience by improving documentation.


### Backward Compatibility Promise

Our policy is described on the Terraform website [here](https://www.terraform.io/docs/extend/best-practices/versioning.html). While we do our best to prevent breaking changes until major version releases of the provider, it is generally recommended to [pin the provider version in your configuration](https://www.terraform.io/docs/configuration/providers.html#provider-versions).

Due to the constant release pace of Kubernetes and the relatively infrequent major version releases of the provider, there can be cases where a minor version update may contain unexpected changes depending on your configuration or environment.

### How can I help?

Check out the [Contributing Guide](CONTRIBUTING.md) for additional information.

### How can I become a maintainer?

This is an area under active research. Stay tuned!
