# Pull Request Submission and Lifecycle

We appreciate direct contributions to the provider codebase. Here's what to
expect:

 * For pull requests that follow the guidelines, we will proceed to reviewing
  and merging, following the provider team's review schedule. There may be some
  internal or community discussion needed before we can complete this.
 * Pull requests that don't follow the guidelines will be commented with what
  they're missing. The person who submits the pull request or another community
  member will need to address those requests before they move forward.

## Pull Request Lifecycle

1. If you'd like to work on an enhancement or bug that is not yet filed in our issue tracker, please create a new issue describing the problem you're solving before starting work on coding. Similarly, if you're interested in working on an existing issue, please begin by commenting on that issue to state your intention and plan for implementation. This will give the team a chance to review your proposal and provide feedback on your implementation plan before you go too deep into the work. Consider this a thumb rule - waiting for maintainer feedback may not be necessary for small changes such as corrections to documentation. Please use your judgement of the complexity of the issue to avoid wasted effort.

1. Then, you can [fork the GitHub repository](https://help.github.com/en/articles/fork-a-repo),
   modify the code, and [create a pull request](https://help.github.com/en/articles/creating-a-pull-request-from-a-fork).
   You are welcome to submit your pull request for commentary or review before
   it is fully completed by creating a [draft pull request](https://help.github.com/en/articles/about-pull-requests#draft-pull-requests).
   Please include specific questions or items you'd like feedback on.

1. Once you believe your pull request is ready to be reviewed, ensure the
   pull request is not a draft pull request by [marking it ready for review](https://help.github.com/en/articles/changing-the-stage-of-a-pull-request) and a
   maintainer will review it. Adding [tests](https://github.com/hashicorp/terraform-provider-kubernetes/blob/master/_about/CONTRIBUTING.md#tests) will help speed up our acceptance of your PR.

1. One of Terraform's provider team members will look over your contribution and
   either approve it or provide comments letting you know if there is anything
   left to do. We do our best to keep up with the volume of PRs waiting for
   review, but it will take some time for us to reach your PR based on the tasks we have in our backlog. Please do not leave LGTM comments or approvals on PRs unless you are a maintainer on the repository.

1. Once all outstanding comments and checklist items have been addressed, your
   contribution will be merged! Merged PRs will be included in the next
   Terraform release. The provider team takes care of updating the CHANGELOG as
   they merge.

1. In some cases, we might decide that a PR should be closed without merging.
   We'll make sure to provide clear reasoning when this happens.


### Go Coding Style

The following Go language resources provide common coding preferences that may be referenced during review, if not automatically handled by the project's linting tools.

- [Effective Go](https://golang.org/doc/effective_go.html)
- [Go Code Review Comments](https://github.com/golang/go/wiki/CodeReviewComments)
