---
layout: "api"
page_title: "Identity Secret Backend: Entity - HTTP API"
sidebar_title: "Entity"
sidebar_current: "api-http-secret-identity-entity"
description: |-
  This is the API documentation for managing entities in the identity store.
---

## Create an Entity

This endpoint creates or updates an Entity.

| Method   | Path                |
| :------------------ | :----------------------|
| `POST`   | `/identity/entity`  |

### Parameters

- `name` `(string: entity-<UUID>)` – Name of the entity.

- `id` `(string: <optional>)` - ID of the entity. If set, updates the
  corresponding existing entity.

- `metadata` `(key-value-map: {})` – Metadata to be associated with the
  entity.

- `policies` `(list of strings: [])` – Policies to be tied to the entity.

- `disabled` `(bool: false)` – Whether the entity is disabled. Disabled
  entities' associated tokens cannot be used, but are not revoked.

### Sample Payload

```json
{
  "metadata": {
    "organization": "hashicorp",
    "team": "vault"
  },
  "policies": ["eng-dev", "infra-dev"]
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    http://127.0.0.1:8200/v1/identity/entity
```

### Sample Response

```json
{
  "data": {
    "id": "8d6a45e5-572f-8f13-d226-cd0d1ec57297",
    "aliases": null
  }
}
```

## Read Entity by ID

This endpoint queries the entity by its identifier.

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `GET`    | `/identity/entity/id/:id`    |

### Parameters

- `id` `(string: <required>)` – Identifier of the entity.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    http://127.0.0.1:8200/v1/identity/entity/id/8d6a45e5-572f-8f13-d226-cd0d1ec57297
```

### Sample Response

```json
{
  "data": {
    "bucket_key_hash": "177553e4c58987f4cc5d7e530136c642",
    "creation_time": "2017-07-25T20:29:22.614756844Z",
    "disabled": false,
    "id": "8d6a45e5-572f-8f13-d226-cd0d1ec57297",
    "last_update_time": "2017-07-25T20:29:22.614756844Z",
    "metadata": {
      "organization": "hashicorp",
      "team": "vault"
    },
    "name": "entity-c323de27-2ad2-5ded-dbf3-0c7ef98bc613",
    "aliases": [],
    "policies": [
      "eng-dev",
      "infra-dev"
    ]
  }
}
```

## Update Entity by ID

This endpoint is used to update an existing entity.

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `POST`   | `/identity/entity/id/:id`    |

### Parameters

- `id` `(string: <required>)` – Identifier of the entity.

- `name` `(string: entity-<UUID>)` – Name of the entity.

- `metadata` `(key-value-map: {})` – Metadata to be associated with the entity.

- `policies` `(list of strings: [])` – Policies to be tied to the entity.

- `disabled` `(bool: false)` – Whether the entity is disabled. Disabled
  entities' associated tokens cannot be used, but are not revoked.

### Sample Payload

```json
{
  "name":"updatedEntityName",
  "metadata": {
    "organization": "hashicorp",
    "team": "nomad"
  },
  "policies": ["eng-developers", "infra-developers"]
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    http://127.0.0.1:8200/v1/identity/entity/id/8d6a45e5-572f-8f13-d226-cd0d1ec57297
```

### Sample Response

```json
{
  "data": {
    "id": "8d6a45e5-572f-8f13-d226-cd0d1ec57297",
    "aliases": null
  }
}
```

## Delete Entity by ID

This endpoint deletes an entity and all its associated aliases.

| Method     | Path                        |
| :-------------------------- | :----------------------|
| `DELETE`   | `/identity/entity/id/:id`   |

### Parameters

- `id` `(string: <required>)` – Identifier of the entity.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request DELETE \
    http://127.0.0.1:8200/v1/identity/entity/id/8d6a45e5-572f-8f13-d226-cd0d1ec57297
```

## List Entities by ID

This endpoint returns a list of available entities by their identifiers.

| Method   | Path                            |
| :------------------------------ | :--------------------- |
| `LIST`   | `/identity/entity/id`           |
| `GET`    | `/identity/entity/id?list=true` |

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request LIST \
    http://127.0.0.1:8200/v1/identity/entity/id
```

### Sample Response

```json
{
  "data": {
    "keys": [
      "02fe5a88-912b-6794-62ed-db873ef86a95",
      "3bf81bc9-44df-8138-57f9-724a9ae36d04",
      "627fba68-98c9-c012-71ba-bfb349585ce1",
      "6c4c805b-b384-3d0e-4d51-44d349887b96",
      "70a72feb-35d1-c775-0813-8efaa8b4b9b5",
      "f1092a67-ce34-48fd-161d-c13a367bc1cd",
      "faedd89a-0d82-c197-c8f9-93a3e6cf0cd0"
    ]
  }
}
```

## Create/Update Entity by Name

This endpoint is used to create or update an entity by a given name.

| Method   | Path                             |
| :------------------------------- | :--------------------- |
| `POST`   | `/identity/entity/name/:name`    |

### Parameters

- `name` `(string: entity-<UUID>)` – Name of the entity.

- `metadata` `(key-value-map: {})` – Metadata to be associated with the entity.

- `policies` `(list of strings: [])` – Policies to be tied to the entity.

- `disabled` `(bool: false)` – Whether the entity is disabled. Disabled
  entities' associated tokens cannot be used, but are not revoked.

### Sample Payload

```json
{
  "metadata": {
    "organization": "hashicorp",
    "team": "nomad"
  },
  "policies": ["eng-developers", "infra-developers"]
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    http://127.0.0.1:8200/v1/identity/entity/name/testentityname
```

### Sample Response

```json
{
  "data": {
    "aliases": null,
    "id": "0826be06-577c-a076-3942-2f92da0310ce"
  }
}
```

## Read Entity by Name

This endpoint queries the entity by its name.

| Method   | Path                             |
| :------------------------------- | :--------------------- |
| `GET`    | `/identity/entity/name/:name`    |

### Parameters

- `name` `(string: <required>)` – Name of the entity.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    http://127.0.0.1:8200/v1/identity/entity/name/testentityname
```

### Sample Response

```json
{
  "data": {
    "aliases": [],
    "creation_time": "2018-09-19T17:20:27.705389973Z",
    "direct_group_ids": [],
    "disabled": false,
    "group_ids": [],
    "id": "0826be06-577c-a076-3942-2f92da0310ce",
    "inherited_group_ids": [],
    "last_update_time": "2018-09-19T17:20:27.705389973Z",
    "merged_entity_ids": null,
    "metadata": {
      "organization": "hashicorp",
      "team": "nomad"
    },
    "name": "testentityname",
    "policies": [
      "eng-developers",
      "infra-developers"
    ]
  }
}
```

## Delete Entity by Name

This endpoint deletes an entity and all its associated aliases, given the
entity name.

| Method     | Path                            |
| :------------------------------ | :----------------------|
| `DELETE`   | `/identity/entity/name/:name`   |

### Parameters

- `name` `(string: <required>)` – Name of the entity.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request DELETE \
    http://127.0.0.1:8200/v1/identity/entity/name/testentityname
```

## List Entities by Name

This endpoint returns a list of available entities by their names.

| Method   | Path                              |
| :-------------------------------- | :--------------------- |
| `LIST`   | `/identity/entity/name`           |
| `GET`    | `/identity/entity/name?list=true` |


### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request LIST \
    http://127.0.0.1:8200/v1/identity/entity/name
```

### Sample Response

```json
{
  "data": {
    "keys": [
      "testentityname",
    ]
  }
}
```

## Merge Entities

This endpoint merges many entities into one entity.

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `POST`   | `/identity/entity/merge`     |

### Parameters

- `from_entity_ids` `(array: <required>)` - Entity IDs which needs to get
  merged.

- `to_entity_id` `(string: <required>)` - Entity ID into which all the other
  entities need to get merged.

- `force` `(bool: false)` - Setting this will follow the 'mine' strategy for
  merging MFA secrets. If there are secrets of the same type both in entities
  that are merged from and in entity into which all others are getting merged,
  secrets in the destination will be unaltered. If not set, this API will throw
  an error containing all the conflicts.

### Sample Payload

```json
{
  "to_entity_id": "f2cdefbe-f510-a226-77fa-989a48ba6abc",
  "from_entity_ids": ["1ade80ec-ba5c-8eed-91e2-b9dcd41d6fff", "270976d0-9bab-14a5-4b92-3861805ef73d"]
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    http://127.0.0.1:8200/v1/identity/entity/id/8d6a45e5-572f-8f13-d226-cd0d1ec57297
```


