---
layout: "docs"
page_title: "MySQL/MariaDB - Database - Secrets Engines"
sidebar_title: "MySQL/MariaDB"
sidebar_current: "docs-secrets-databases-mysql-maria"
description: |-
  MySQL is one of the supported plugins for the database secrets engine. This
  plugin generates database credentials dynamically based on configured roles
  for the MySQL database.
---

# MySQL/MariaDB Database Secrets Engine

MySQL is one of the supported plugins for the database secrets engine. This
plugin generates database credentials dynamically based on configured roles for
the MySQL database, and also supports [Static
Roles](/docs/secrets/databases/index.html#static-roles).

This plugin has a few different instances built into vault, each instance is for
a slightly different MySQL driver. The only difference between these plugins is
the length of usernames generated by the plugin as different versions of mysql
accept different lengths. The available plugins are:

 - mysql-database-plugin
 - mysql-aurora-database-plugin
 - mysql-rds-database-plugin
 - mysql-legacy-database-plugin

See the [database secrets engine](/docs/secrets/databases/index.html) docs for
more information about setting up the database secrets engine.

## Setup

1. Enable the database secrets engine if it is not already enabled:

    ```text
    $ vault secrets enable database
    Success! Enabled the database secrets engine at: database/
    ```

    By default, the secrets engine will enable at the name of the engine. To
    enable the secrets engine at a different path, use the `-path` argument.

1. Configure Vault with the proper plugin and connection information:

    ```text
    $ vault write database/config/my-mysql-database \
        plugin_name=mysql-database-plugin \
        connection_url="{{username}}:{{password}}@tcp(127.0.0.1:3306)/" \
        allowed_roles="my-role" \
        username="root" \
        password="mysql"
    ```

1. Configure a role that maps a name in Vault to an SQL statement to execute to
create the database credential:

    ```text
    $ vault write database/roles/my-role \
        db_name=my-mysql-database \
        creation_statements="CREATE USER '{{name}}'@'%' IDENTIFIED BY '{{password}}';GRANT SELECT ON *.* TO '{{name}}'@'%';" \
        default_ttl="1h" \
        max_ttl="24h"
    Success! Data written to: database/roles/my-role
    ```

## Usage

After the secrets engine is configured and a user/machine has a Vault token with
the proper permission, it can generate credentials.

1. Generate a new credential by reading from the `/creds` endpoint with the name
of the role:

    ```text
    $ vault read database/creds/my-role
    Key                Value
    ---                -----
    lease_id           database/creds/my-role/2f6a614c-4aa2-7b19-24b9-ad944a8d4de6
    lease_duration     1h
    lease_renewable    true
    password           8cab931c-d62e-a73d-60d3-5ee85139cd66
    username           v-root-e2978cd0-
    ```

## Examples

### Using wildcards in grant statements

MySQL supports using wildcards in grant statements. These are sometimes needed
by applications which expect access to a large number of databases inside MySQL.
This can be realized by using a wildcard in the grant statement. For example if
you want the user created by Vault to have access to all databases starting with
`fooapp_` you could use the following creation statement:

```text
CREATE USER '{{name}}'@'%' IDENTIFIED BY '{{password}}'; GRANT SELECT ON `fooapp\_%`.* TO '{{name}}'@'%';
```

MySQL expects the part in which the wildcards are to be placed inside backticks.
If you want to add this creation statement to Vault via the Vault CLI you cannot
simply paste the above statement on the CLI because the shell will interpret the
text between the backticks as something that must be executed. The easiest way to
get around this is to encode the creation statement as Base64 and feed this to Vault.
For example:

```text
$ vault write database/roles/my-role \
    db_name=mysql \
    creation_statements="Q1JFQVRFIFVTRVIgJ3t7bmFtZX19J0AnJScgSURFTlRJRklFRCBCWSAne3twYXNzd29yZH19JzsgR1JBTlQgU0VMRUNUIE9OIGBmb29hcHBcXyVgLiogVE8gJ3t7bmFtZX19J0AnJSc7" \
    default_ttl="1h" \
    max_ttl="24h"
```

### Rotating root credentials in MySQL 5.6

The default root rotation setup for MySQL uses the `ALTER USER` syntax present
in MySQL 5.7 and up. For MySQL 5.6, the [root rotation
statements](/api/secret/databases/index.html#root_rotation_statements)
must be configured to use the old `SET PASSWORD` syntax. For example:

```text
$ vault write database/config/my-mysql-database \
    plugin_name=mysql-database-plugin \
    connection_url="{{username}}:{{password}}@tcp(127.0.0.1:3306)/" \
    root_rotation_statements="SET PASSWORD = PASSWORD('{{password}}')" \
    allowed_roles="my-role" \
    username="root" \
    password="mysql"
```

For a guide in root credential rotation, see [Database Root Credential
Rotation](/guides/secret-mgmt/db-root-rotation.html).

## API

The full list of configurable options can be seen in the [MySQL database plugin
API](/api/secret/databases/mysql-maria.html) page.

For more information on the database secrets engine's HTTP API please see the
[Database secrets engine API](/api/secret/databases/index.html) page.
