package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetUser invokes the baas.ResetUser API synchronously
// api document: https://help.aliyun.com/api/baas/resetuser.html
func (client *Client) ResetUser(request *ResetUserRequest) (response *ResetUserResponse, err error) {
	response = CreateResetUserResponse()
	err = client.DoAction(request, response)
	return
}

// ResetUserWithChan invokes the baas.ResetUser API asynchronously
// api document: https://help.aliyun.com/api/baas/resetuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetUserWithChan(request *ResetUserRequest) (<-chan *ResetUserResponse, <-chan error) {
	responseChan := make(chan *ResetUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetUserWithCallback invokes the baas.ResetUser API asynchronously
// api document: https://help.aliyun.com/api/baas/resetuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetUserWithCallback(request *ResetUserRequest, callback func(response *ResetUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetUserResponse
		var err error
		defer close(result)
		response, err = client.ResetUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetUserRequest is the request struct for api ResetUser
type ResetUserRequest struct {
	*requests.RpcRequest
	Bizid     string           `position:"Body" name:"Bizid"`
	Bid       string           `position:"Body" name:"Bid"`
	Operation requests.Integer `position:"Body" name:"Operation"`
	UserName  string           `position:"Body" name:"UserName"`
}

// ResetUserResponse is the response struct for api ResetUser
type ResetUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateResetUserRequest creates a request to invoke ResetUser API
func CreateResetUserRequest() (request *ResetUserRequest) {
	request = &ResetUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "ResetUser", "", "")
	return
}

// CreateResetUserResponse creates a response to parse from ResetUser response
func CreateResetUserResponse() (response *ResetUserResponse) {
	response = &ResetUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
