package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyExecutionPlanScheduleInfo invokes the emr.ModifyExecutionPlanScheduleInfo API synchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanscheduleinfo.html
func (client *Client) ModifyExecutionPlanScheduleInfo(request *ModifyExecutionPlanScheduleInfoRequest) (response *ModifyExecutionPlanScheduleInfoResponse, err error) {
	response = CreateModifyExecutionPlanScheduleInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyExecutionPlanScheduleInfoWithChan invokes the emr.ModifyExecutionPlanScheduleInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanscheduleinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExecutionPlanScheduleInfoWithChan(request *ModifyExecutionPlanScheduleInfoRequest) (<-chan *ModifyExecutionPlanScheduleInfoResponse, <-chan error) {
	responseChan := make(chan *ModifyExecutionPlanScheduleInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyExecutionPlanScheduleInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyExecutionPlanScheduleInfoWithCallback invokes the emr.ModifyExecutionPlanScheduleInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyexecutionplanscheduleinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyExecutionPlanScheduleInfoWithCallback(request *ModifyExecutionPlanScheduleInfoRequest, callback func(response *ModifyExecutionPlanScheduleInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyExecutionPlanScheduleInfoResponse
		var err error
		defer close(result)
		response, err = client.ModifyExecutionPlanScheduleInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyExecutionPlanScheduleInfoRequest is the request struct for api ModifyExecutionPlanScheduleInfo
type ModifyExecutionPlanScheduleInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TimeInterval    requests.Integer `position:"Query" name:"TimeInterval"`
	DayOfWeek       string           `position:"Query" name:"DayOfWeek"`
	Id              string           `position:"Query" name:"Id"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	Strategy        string           `position:"Query" name:"Strategy"`
	TimeUnit        string           `position:"Query" name:"TimeUnit"`
	DayOfMonth      string           `position:"Query" name:"DayOfMonth"`
}

// ModifyExecutionPlanScheduleInfoResponse is the response struct for api ModifyExecutionPlanScheduleInfo
type ModifyExecutionPlanScheduleInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyExecutionPlanScheduleInfoRequest creates a request to invoke ModifyExecutionPlanScheduleInfo API
func CreateModifyExecutionPlanScheduleInfoRequest() (request *ModifyExecutionPlanScheduleInfoRequest) {
	request = &ModifyExecutionPlanScheduleInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyExecutionPlanScheduleInfo", "emr", "openAPI")
	return
}

// CreateModifyExecutionPlanScheduleInfoResponse creates a response to parse from ModifyExecutionPlanScheduleInfo response
func CreateModifyExecutionPlanScheduleInfoResponse() (response *ModifyExecutionPlanScheduleInfoResponse) {
	response = &ModifyExecutionPlanScheduleInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
