package industry_brain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOSSImageAccess invokes the industry_brain.GetOSSImageAccess API synchronously
// api document: https://help.aliyun.com/api/industry-brain/getossimageaccess.html
func (client *Client) GetOSSImageAccess(request *GetOSSImageAccessRequest) (response *GetOSSImageAccessResponse, err error) {
	response = CreateGetOSSImageAccessResponse()
	err = client.DoAction(request, response)
	return
}

// GetOSSImageAccessWithChan invokes the industry_brain.GetOSSImageAccess API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getossimageaccess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOSSImageAccessWithChan(request *GetOSSImageAccessRequest) (<-chan *GetOSSImageAccessResponse, <-chan error) {
	responseChan := make(chan *GetOSSImageAccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOSSImageAccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOSSImageAccessWithCallback invokes the industry_brain.GetOSSImageAccess API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getossimageaccess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOSSImageAccessWithCallback(request *GetOSSImageAccessRequest, callback func(response *GetOSSImageAccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOSSImageAccessResponse
		var err error
		defer close(result)
		response, err = client.GetOSSImageAccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOSSImageAccessRequest is the request struct for api GetOSSImageAccess
type GetOSSImageAccessRequest struct {
	*requests.RpcRequest
	UserCode  string `position:"Query" name:"UserCode"`
	ProjectId string `position:"Query" name:"ProjectId"`
}

// GetOSSImageAccessResponse is the response struct for api GetOSSImageAccess
type GetOSSImageAccessResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	StsInfo   StsInfo `json:"StsInfo" xml:"StsInfo"`
}

// CreateGetOSSImageAccessRequest creates a request to invoke GetOSSImageAccess API
func CreateGetOSSImageAccessRequest() (request *GetOSSImageAccessRequest) {
	request = &GetOSSImageAccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("industry-brain", "2018-07-12", "GetOSSImageAccess", "", "")
	return
}

// CreateGetOSSImageAccessResponse creates a response to parse from GetOSSImageAccess response
func CreateGetOSSImageAccessResponse() (response *GetOSSImageAccessResponse) {
	response = &GetOSSImageAccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
