// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/campaign.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v0/common"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A campaign.
type Campaign struct {
	// The resource name of the campaign.
	// Campaign resource names have the form:
	//
	// `customers/{customer_id}/campaigns/{campaign_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the campaign.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the campaign.
	//
	// This field is required and should not be empty when creating new
	// campaigns.
	//
	// It must not contain any null (code point 0x0), NL line feed
	// (code point 0xA) or carriage return (code point 0xD) characters.
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The status of the campaign.
	//
	// When a new campaign is added, the status defaults to ENABLED.
	Status enums.CampaignStatusEnum_CampaignStatus `protobuf:"varint,5,opt,name=status,proto3,enum=google.ads.googleads.v0.enums.CampaignStatusEnum_CampaignStatus" json:"status,omitempty"`
	// The ad serving status of the campaign.
	ServingStatus enums.CampaignServingStatusEnum_CampaignServingStatus `protobuf:"varint,21,opt,name=serving_status,json=servingStatus,proto3,enum=google.ads.googleads.v0.enums.CampaignServingStatusEnum_CampaignServingStatus" json:"serving_status,omitempty"`
	// The ad serving optimization status of the campaign.
	AdServingOptimizationStatus enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus `protobuf:"varint,8,opt,name=ad_serving_optimization_status,json=adServingOptimizationStatus,proto3,enum=google.ads.googleads.v0.enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus" json:"ad_serving_optimization_status,omitempty"`
	// The primary serving target for ads within the campaign.
	// The targeting options can be refined in `network_settings`.
	//
	// This field is required and should not be empty when creating new
	// campaigns.
	//
	// Can be set only when creating campaigns.
	// After the campaign is created, the field can not be changed.
	AdvertisingChannelType enums.AdvertisingChannelTypeEnum_AdvertisingChannelType `protobuf:"varint,9,opt,name=advertising_channel_type,json=advertisingChannelType,proto3,enum=google.ads.googleads.v0.enums.AdvertisingChannelTypeEnum_AdvertisingChannelType" json:"advertising_channel_type,omitempty"`
	// Optional refinement to `advertising_channel_type`.
	// Must be a valid sub-type of the parent channel type.
	//
	// Can be set only when creating campaigns.
	// After campaign is created, the field can not be changed.
	AdvertisingChannelSubType enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType `protobuf:"varint,10,opt,name=advertising_channel_sub_type,json=advertisingChannelSubType,proto3,enum=google.ads.googleads.v0.enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType" json:"advertising_channel_sub_type,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,11,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,12,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// Settings for Real-Time Bidding, a feature only available for campaigns
	// targeting the Ad Exchange network.
	RealTimeBiddingSetting *common.RealTimeBiddingSetting `protobuf:"bytes,39,opt,name=real_time_bidding_setting,json=realTimeBiddingSetting,proto3" json:"real_time_bidding_setting,omitempty"`
	// The network settings for the campaign.
	NetworkSettings *Campaign_NetworkSettings `protobuf:"bytes,14,opt,name=network_settings,json=networkSettings,proto3" json:"network_settings,omitempty"`
	// The hotel setting for the campaign.
	HotelSetting *Campaign_HotelSettingInfo `protobuf:"bytes,32,opt,name=hotel_setting,json=hotelSetting,proto3" json:"hotel_setting,omitempty"`
	// The setting for controlling Dynamic Search Ads (DSA).
	DynamicSearchAdsSetting *Campaign_DynamicSearchAdsSetting `protobuf:"bytes,33,opt,name=dynamic_search_ads_setting,json=dynamicSearchAdsSetting,proto3" json:"dynamic_search_ads_setting,omitempty"`
	// The setting for controlling Shopping campaigns.
	ShoppingSetting *Campaign_ShoppingSetting `protobuf:"bytes,36,opt,name=shopping_setting,json=shoppingSetting,proto3" json:"shopping_setting,omitempty"`
	// Setting for targeting related features.
	TargetingSetting *common.TargetingSetting `protobuf:"bytes,43,opt,name=targeting_setting,json=targetingSetting,proto3" json:"targeting_setting,omitempty"`
	// The budget of the campaign.
	CampaignBudget *wrappers.StringValue `protobuf:"bytes,6,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
	// The type of bidding strategy.
	//
	// A bidding strategy can be created by setting either the bidding scheme to
	// create a standard bidding strategy or the `bidding_strategy` field to
	// create a portfolio bidding strategy.
	//
	// This field is read-only.
	BiddingStrategyType enums.BiddingStrategyTypeEnum_BiddingStrategyType `protobuf:"varint,22,opt,name=bidding_strategy_type,json=biddingStrategyType,proto3,enum=google.ads.googleads.v0.enums.BiddingStrategyTypeEnum_BiddingStrategyType" json:"bidding_strategy_type,omitempty"`
	// The date when campaign started.
	//
	// This field must not be used in WHERE clauses.
	StartDate *wrappers.StringValue `protobuf:"bytes,19,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// The date when campaign ended.
	//
	// This field must not be used in WHERE clauses.
	EndDate *wrappers.StringValue `protobuf:"bytes,20,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Suffix used to append query parameters to landing pages that are served
	// with parallel tracking.
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,38,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// A list that limits how often each user will see this campaign's ads.
	FrequencyCaps []*common.FrequencyCapEntry `protobuf:"bytes,40,rep,name=frequency_caps,json=frequencyCaps,proto3" json:"frequency_caps,omitempty"`
	// 3-Tier Brand Safety setting for the campaign.
	VideoBrandSafetySuitability enums.BrandSafetySuitabilityEnum_BrandSafetySuitability `protobuf:"varint,42,opt,name=video_brand_safety_suitability,json=videoBrandSafetySuitability,proto3,enum=google.ads.googleads.v0.enums.BrandSafetySuitabilityEnum_BrandSafetySuitability" json:"video_brand_safety_suitability,omitempty"`
	// Describes how unbranded pharma ads will be displayed.
	VanityPharma *Campaign_VanityPharma `protobuf:"bytes,44,opt,name=vanity_pharma,json=vanityPharma,proto3" json:"vanity_pharma,omitempty"`
	// Selective optimization setting for this campaign, which includes a set of
	// conversion actions to optimize this campaign towards.
	SelectiveOptimization *Campaign_SelectiveOptimization `protobuf:"bytes,45,opt,name=selective_optimization,json=selectiveOptimization,proto3" json:"selective_optimization,omitempty"`
	// Campaign level settings for tracking information.
	TrackingSetting *Campaign_TrackingSetting `protobuf:"bytes,46,opt,name=tracking_setting,json=trackingSetting,proto3" json:"tracking_setting,omitempty"`
	// The bidding strategy for the campaign.
	//
	// Must be either portfolio (created via BiddingStrategy service) or
	// standard, that is embedded into the campaign.
	//
	// Types that are valid to be assigned to CampaignBiddingStrategy:
	//	*Campaign_BiddingStrategy
	//	*Campaign_ManualCpc
	//	*Campaign_ManualCpm
	//	*Campaign_ManualCpv
	//	*Campaign_MaximizeConversions
	//	*Campaign_MaximizeConversionValue
	//	*Campaign_TargetCpa
	//	*Campaign_TargetRoas
	//	*Campaign_TargetSpend
	//	*Campaign_PercentCpc
	//	*Campaign_TargetCpm
	CampaignBiddingStrategy isCampaign_CampaignBiddingStrategy `protobuf_oneof:"campaign_bidding_strategy"`
	XXX_NoUnkeyedLiteral    struct{}                           `json:"-"`
	XXX_unrecognized        []byte                             `json:"-"`
	XXX_sizecache           int32                              `json:"-"`
}

func (m *Campaign) Reset()         { *m = Campaign{} }
func (m *Campaign) String() string { return proto.CompactTextString(m) }
func (*Campaign) ProtoMessage()    {}
func (*Campaign) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_84f689eff017e599, []int{0}
}
func (m *Campaign) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign.Unmarshal(m, b)
}
func (m *Campaign) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign.Marshal(b, m, deterministic)
}
func (dst *Campaign) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign.Merge(dst, src)
}
func (m *Campaign) XXX_Size() int {
	return xxx_messageInfo_Campaign.Size(m)
}
func (m *Campaign) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign proto.InternalMessageInfo

func (m *Campaign) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Campaign) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Campaign) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Campaign) GetStatus() enums.CampaignStatusEnum_CampaignStatus {
	if m != nil {
		return m.Status
	}
	return enums.CampaignStatusEnum_UNSPECIFIED
}

func (m *Campaign) GetServingStatus() enums.CampaignServingStatusEnum_CampaignServingStatus {
	if m != nil {
		return m.ServingStatus
	}
	return enums.CampaignServingStatusEnum_UNSPECIFIED
}

func (m *Campaign) GetAdServingOptimizationStatus() enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus {
	if m != nil {
		return m.AdServingOptimizationStatus
	}
	return enums.AdServingOptimizationStatusEnum_UNSPECIFIED
}

func (m *Campaign) GetAdvertisingChannelType() enums.AdvertisingChannelTypeEnum_AdvertisingChannelType {
	if m != nil {
		return m.AdvertisingChannelType
	}
	return enums.AdvertisingChannelTypeEnum_UNSPECIFIED
}

func (m *Campaign) GetAdvertisingChannelSubType() enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType {
	if m != nil {
		return m.AdvertisingChannelSubType
	}
	return enums.AdvertisingChannelSubTypeEnum_UNSPECIFIED
}

func (m *Campaign) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *Campaign) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

func (m *Campaign) GetRealTimeBiddingSetting() *common.RealTimeBiddingSetting {
	if m != nil {
		return m.RealTimeBiddingSetting
	}
	return nil
}

func (m *Campaign) GetNetworkSettings() *Campaign_NetworkSettings {
	if m != nil {
		return m.NetworkSettings
	}
	return nil
}

func (m *Campaign) GetHotelSetting() *Campaign_HotelSettingInfo {
	if m != nil {
		return m.HotelSetting
	}
	return nil
}

func (m *Campaign) GetDynamicSearchAdsSetting() *Campaign_DynamicSearchAdsSetting {
	if m != nil {
		return m.DynamicSearchAdsSetting
	}
	return nil
}

func (m *Campaign) GetShoppingSetting() *Campaign_ShoppingSetting {
	if m != nil {
		return m.ShoppingSetting
	}
	return nil
}

func (m *Campaign) GetTargetingSetting() *common.TargetingSetting {
	if m != nil {
		return m.TargetingSetting
	}
	return nil
}

func (m *Campaign) GetCampaignBudget() *wrappers.StringValue {
	if m != nil {
		return m.CampaignBudget
	}
	return nil
}

func (m *Campaign) GetBiddingStrategyType() enums.BiddingStrategyTypeEnum_BiddingStrategyType {
	if m != nil {
		return m.BiddingStrategyType
	}
	return enums.BiddingStrategyTypeEnum_UNSPECIFIED
}

func (m *Campaign) GetStartDate() *wrappers.StringValue {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *Campaign) GetEndDate() *wrappers.StringValue {
	if m != nil {
		return m.EndDate
	}
	return nil
}

func (m *Campaign) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *Campaign) GetFrequencyCaps() []*common.FrequencyCapEntry {
	if m != nil {
		return m.FrequencyCaps
	}
	return nil
}

func (m *Campaign) GetVideoBrandSafetySuitability() enums.BrandSafetySuitabilityEnum_BrandSafetySuitability {
	if m != nil {
		return m.VideoBrandSafetySuitability
	}
	return enums.BrandSafetySuitabilityEnum_UNSPECIFIED
}

func (m *Campaign) GetVanityPharma() *Campaign_VanityPharma {
	if m != nil {
		return m.VanityPharma
	}
	return nil
}

func (m *Campaign) GetSelectiveOptimization() *Campaign_SelectiveOptimization {
	if m != nil {
		return m.SelectiveOptimization
	}
	return nil
}

func (m *Campaign) GetTrackingSetting() *Campaign_TrackingSetting {
	if m != nil {
		return m.TrackingSetting
	}
	return nil
}

type isCampaign_CampaignBiddingStrategy interface {
	isCampaign_CampaignBiddingStrategy()
}

type Campaign_BiddingStrategy struct {
	BiddingStrategy *wrappers.StringValue `protobuf:"bytes,23,opt,name=bidding_strategy,json=biddingStrategy,proto3,oneof"`
}

type Campaign_ManualCpc struct {
	ManualCpc *common.ManualCpc `protobuf:"bytes,24,opt,name=manual_cpc,json=manualCpc,proto3,oneof"`
}

type Campaign_ManualCpm struct {
	ManualCpm *common.ManualCpm `protobuf:"bytes,25,opt,name=manual_cpm,json=manualCpm,proto3,oneof"`
}

type Campaign_ManualCpv struct {
	ManualCpv *common.ManualCpv `protobuf:"bytes,37,opt,name=manual_cpv,json=manualCpv,proto3,oneof"`
}

type Campaign_MaximizeConversions struct {
	MaximizeConversions *common.MaximizeConversions `protobuf:"bytes,30,opt,name=maximize_conversions,json=maximizeConversions,proto3,oneof"`
}

type Campaign_MaximizeConversionValue struct {
	MaximizeConversionValue *common.MaximizeConversionValue `protobuf:"bytes,31,opt,name=maximize_conversion_value,json=maximizeConversionValue,proto3,oneof"`
}

type Campaign_TargetCpa struct {
	TargetCpa *common.TargetCpa `protobuf:"bytes,26,opt,name=target_cpa,json=targetCpa,proto3,oneof"`
}

type Campaign_TargetRoas struct {
	TargetRoas *common.TargetRoas `protobuf:"bytes,29,opt,name=target_roas,json=targetRoas,proto3,oneof"`
}

type Campaign_TargetSpend struct {
	TargetSpend *common.TargetSpend `protobuf:"bytes,27,opt,name=target_spend,json=targetSpend,proto3,oneof"`
}

type Campaign_PercentCpc struct {
	PercentCpc *common.PercentCpc `protobuf:"bytes,34,opt,name=percent_cpc,json=percentCpc,proto3,oneof"`
}

type Campaign_TargetCpm struct {
	TargetCpm *common.TargetCpm `protobuf:"bytes,41,opt,name=target_cpm,json=targetCpm,proto3,oneof"`
}

func (*Campaign_BiddingStrategy) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpc) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpm) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpv) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_MaximizeConversions) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_MaximizeConversionValue) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetCpa) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetRoas) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetSpend) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_PercentCpc) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetCpm) isCampaign_CampaignBiddingStrategy() {}

func (m *Campaign) GetCampaignBiddingStrategy() isCampaign_CampaignBiddingStrategy {
	if m != nil {
		return m.CampaignBiddingStrategy
	}
	return nil
}

func (m *Campaign) GetBiddingStrategy() *wrappers.StringValue {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_BiddingStrategy); ok {
		return x.BiddingStrategy
	}
	return nil
}

func (m *Campaign) GetManualCpc() *common.ManualCpc {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_ManualCpc); ok {
		return x.ManualCpc
	}
	return nil
}

func (m *Campaign) GetManualCpm() *common.ManualCpm {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_ManualCpm); ok {
		return x.ManualCpm
	}
	return nil
}

func (m *Campaign) GetManualCpv() *common.ManualCpv {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_ManualCpv); ok {
		return x.ManualCpv
	}
	return nil
}

func (m *Campaign) GetMaximizeConversions() *common.MaximizeConversions {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_MaximizeConversions); ok {
		return x.MaximizeConversions
	}
	return nil
}

func (m *Campaign) GetMaximizeConversionValue() *common.MaximizeConversionValue {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_MaximizeConversionValue); ok {
		return x.MaximizeConversionValue
	}
	return nil
}

func (m *Campaign) GetTargetCpa() *common.TargetCpa {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetCpa); ok {
		return x.TargetCpa
	}
	return nil
}

func (m *Campaign) GetTargetRoas() *common.TargetRoas {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetRoas); ok {
		return x.TargetRoas
	}
	return nil
}

func (m *Campaign) GetTargetSpend() *common.TargetSpend {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetSpend); ok {
		return x.TargetSpend
	}
	return nil
}

func (m *Campaign) GetPercentCpc() *common.PercentCpc {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_PercentCpc); ok {
		return x.PercentCpc
	}
	return nil
}

func (m *Campaign) GetTargetCpm() *common.TargetCpm {
	if x, ok := m.GetCampaignBiddingStrategy().(*Campaign_TargetCpm); ok {
		return x.TargetCpm
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Campaign) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Campaign_OneofMarshaler, _Campaign_OneofUnmarshaler, _Campaign_OneofSizer, []interface{}{
		(*Campaign_BiddingStrategy)(nil),
		(*Campaign_ManualCpc)(nil),
		(*Campaign_ManualCpm)(nil),
		(*Campaign_ManualCpv)(nil),
		(*Campaign_MaximizeConversions)(nil),
		(*Campaign_MaximizeConversionValue)(nil),
		(*Campaign_TargetCpa)(nil),
		(*Campaign_TargetRoas)(nil),
		(*Campaign_TargetSpend)(nil),
		(*Campaign_PercentCpc)(nil),
		(*Campaign_TargetCpm)(nil),
	}
}

func _Campaign_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Campaign)
	// campaign_bidding_strategy
	switch x := m.CampaignBiddingStrategy.(type) {
	case *Campaign_BiddingStrategy:
		b.EncodeVarint(23<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BiddingStrategy); err != nil {
			return err
		}
	case *Campaign_ManualCpc:
		b.EncodeVarint(24<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ManualCpc); err != nil {
			return err
		}
	case *Campaign_ManualCpm:
		b.EncodeVarint(25<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ManualCpm); err != nil {
			return err
		}
	case *Campaign_ManualCpv:
		b.EncodeVarint(37<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ManualCpv); err != nil {
			return err
		}
	case *Campaign_MaximizeConversions:
		b.EncodeVarint(30<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MaximizeConversions); err != nil {
			return err
		}
	case *Campaign_MaximizeConversionValue:
		b.EncodeVarint(31<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MaximizeConversionValue); err != nil {
			return err
		}
	case *Campaign_TargetCpa:
		b.EncodeVarint(26<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TargetCpa); err != nil {
			return err
		}
	case *Campaign_TargetRoas:
		b.EncodeVarint(29<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TargetRoas); err != nil {
			return err
		}
	case *Campaign_TargetSpend:
		b.EncodeVarint(27<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TargetSpend); err != nil {
			return err
		}
	case *Campaign_PercentCpc:
		b.EncodeVarint(34<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PercentCpc); err != nil {
			return err
		}
	case *Campaign_TargetCpm:
		b.EncodeVarint(41<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TargetCpm); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Campaign.CampaignBiddingStrategy has unexpected type %T", x)
	}
	return nil
}

func _Campaign_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Campaign)
	switch tag {
	case 23: // campaign_bidding_strategy.bidding_strategy
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.StringValue)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_BiddingStrategy{msg}
		return true, err
	case 24: // campaign_bidding_strategy.manual_cpc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.ManualCpc)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_ManualCpc{msg}
		return true, err
	case 25: // campaign_bidding_strategy.manual_cpm
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.ManualCpm)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_ManualCpm{msg}
		return true, err
	case 37: // campaign_bidding_strategy.manual_cpv
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.ManualCpv)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_ManualCpv{msg}
		return true, err
	case 30: // campaign_bidding_strategy.maximize_conversions
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.MaximizeConversions)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_MaximizeConversions{msg}
		return true, err
	case 31: // campaign_bidding_strategy.maximize_conversion_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.MaximizeConversionValue)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_MaximizeConversionValue{msg}
		return true, err
	case 26: // campaign_bidding_strategy.target_cpa
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.TargetCpa)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_TargetCpa{msg}
		return true, err
	case 29: // campaign_bidding_strategy.target_roas
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.TargetRoas)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_TargetRoas{msg}
		return true, err
	case 27: // campaign_bidding_strategy.target_spend
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.TargetSpend)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_TargetSpend{msg}
		return true, err
	case 34: // campaign_bidding_strategy.percent_cpc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.PercentCpc)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_PercentCpc{msg}
		return true, err
	case 41: // campaign_bidding_strategy.target_cpm
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.TargetCpm)
		err := b.DecodeMessage(msg)
		m.CampaignBiddingStrategy = &Campaign_TargetCpm{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Campaign_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Campaign)
	// campaign_bidding_strategy
	switch x := m.CampaignBiddingStrategy.(type) {
	case *Campaign_BiddingStrategy:
		s := proto.Size(x.BiddingStrategy)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_ManualCpc:
		s := proto.Size(x.ManualCpc)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_ManualCpm:
		s := proto.Size(x.ManualCpm)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_ManualCpv:
		s := proto.Size(x.ManualCpv)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_MaximizeConversions:
		s := proto.Size(x.MaximizeConversions)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_MaximizeConversionValue:
		s := proto.Size(x.MaximizeConversionValue)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_TargetCpa:
		s := proto.Size(x.TargetCpa)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_TargetRoas:
		s := proto.Size(x.TargetRoas)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_TargetSpend:
		s := proto.Size(x.TargetSpend)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_PercentCpc:
		s := proto.Size(x.PercentCpc)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Campaign_TargetCpm:
		s := proto.Size(x.TargetCpm)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The network settings for the campaign.
type Campaign_NetworkSettings struct {
	// Whether ads will be served with google.com search results.
	TargetGoogleSearch *wrappers.BoolValue `protobuf:"bytes,1,opt,name=target_google_search,json=targetGoogleSearch,proto3" json:"target_google_search,omitempty"`
	// Whether ads will be served on partner sites in the Google Search Network
	// (requires `target_google_search` to also be `true`).
	TargetSearchNetwork *wrappers.BoolValue `protobuf:"bytes,2,opt,name=target_search_network,json=targetSearchNetwork,proto3" json:"target_search_network,omitempty"`
	// Whether ads will be served on specified placements in the Google Display
	// Network. Placements are specified using the Placement criterion.
	TargetContentNetwork *wrappers.BoolValue `protobuf:"bytes,3,opt,name=target_content_network,json=targetContentNetwork,proto3" json:"target_content_network,omitempty"`
	// Whether ads will be served on the Google Partner Network.
	// This is available only to some select Google partner accounts.
	TargetPartnerSearchNetwork *wrappers.BoolValue `protobuf:"bytes,4,opt,name=target_partner_search_network,json=targetPartnerSearchNetwork,proto3" json:"target_partner_search_network,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}            `json:"-"`
	XXX_unrecognized           []byte              `json:"-"`
	XXX_sizecache              int32               `json:"-"`
}

func (m *Campaign_NetworkSettings) Reset()         { *m = Campaign_NetworkSettings{} }
func (m *Campaign_NetworkSettings) String() string { return proto.CompactTextString(m) }
func (*Campaign_NetworkSettings) ProtoMessage()    {}
func (*Campaign_NetworkSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_84f689eff017e599, []int{0, 0}
}
func (m *Campaign_NetworkSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_NetworkSettings.Unmarshal(m, b)
}
func (m *Campaign_NetworkSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_NetworkSettings.Marshal(b, m, deterministic)
}
func (dst *Campaign_NetworkSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_NetworkSettings.Merge(dst, src)
}
func (m *Campaign_NetworkSettings) XXX_Size() int {
	return xxx_messageInfo_Campaign_NetworkSettings.Size(m)
}
func (m *Campaign_NetworkSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_NetworkSettings.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_NetworkSettings proto.InternalMessageInfo

func (m *Campaign_NetworkSettings) GetTargetGoogleSearch() *wrappers.BoolValue {
	if m != nil {
		return m.TargetGoogleSearch
	}
	return nil
}

func (m *Campaign_NetworkSettings) GetTargetSearchNetwork() *wrappers.BoolValue {
	if m != nil {
		return m.TargetSearchNetwork
	}
	return nil
}

func (m *Campaign_NetworkSettings) GetTargetContentNetwork() *wrappers.BoolValue {
	if m != nil {
		return m.TargetContentNetwork
	}
	return nil
}

func (m *Campaign_NetworkSettings) GetTargetPartnerSearchNetwork() *wrappers.BoolValue {
	if m != nil {
		return m.TargetPartnerSearchNetwork
	}
	return nil
}

// Campaign-level settings for hotel ads.
type Campaign_HotelSettingInfo struct {
	// The linked Hotel Center account.
	HotelCenterId        *wrappers.Int64Value `protobuf:"bytes,1,opt,name=hotel_center_id,json=hotelCenterId,proto3" json:"hotel_center_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Campaign_HotelSettingInfo) Reset()         { *m = Campaign_HotelSettingInfo{} }
func (m *Campaign_HotelSettingInfo) String() string { return proto.CompactTextString(m) }
func (*Campaign_HotelSettingInfo) ProtoMessage()    {}
func (*Campaign_HotelSettingInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_84f689eff017e599, []int{0, 1}
}
func (m *Campaign_HotelSettingInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_HotelSettingInfo.Unmarshal(m, b)
}
func (m *Campaign_HotelSettingInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_HotelSettingInfo.Marshal(b, m, deterministic)
}
func (dst *Campaign_HotelSettingInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_HotelSettingInfo.Merge(dst, src)
}
func (m *Campaign_HotelSettingInfo) XXX_Size() int {
	return xxx_messageInfo_Campaign_HotelSettingInfo.Size(m)
}
func (m *Campaign_HotelSettingInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_HotelSettingInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_HotelSettingInfo proto.InternalMessageInfo

func (m *Campaign_HotelSettingInfo) GetHotelCenterId() *wrappers.Int64Value {
	if m != nil {
		return m.HotelCenterId
	}
	return nil
}

// The setting for controlling Dynamic Search Ads (DSA).
type Campaign_DynamicSearchAdsSetting struct {
	// The Internet domain name that this setting represents, e.g., "google.com"
	// or "www.google.com".
	DomainName *wrappers.StringValue `protobuf:"bytes,1,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// The language code specifying the language of the domain, e.g., "en".
	LanguageCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Whether the campaign uses advertiser supplied URLs exclusively.
	UseSuppliedUrlsOnly *wrappers.BoolValue `protobuf:"bytes,3,opt,name=use_supplied_urls_only,json=useSuppliedUrlsOnly,proto3" json:"use_supplied_urls_only,omitempty"`
	// The list of page feeds associated with the campaign.
	FeedIds              []*wrappers.Int64Value `protobuf:"bytes,4,rep,name=feed_ids,json=feedIds,proto3" json:"feed_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Campaign_DynamicSearchAdsSetting) Reset()         { *m = Campaign_DynamicSearchAdsSetting{} }
func (m *Campaign_DynamicSearchAdsSetting) String() string { return proto.CompactTextString(m) }
func (*Campaign_DynamicSearchAdsSetting) ProtoMessage()    {}
func (*Campaign_DynamicSearchAdsSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_84f689eff017e599, []int{0, 2}
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Unmarshal(m, b)
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Marshal(b, m, deterministic)
}
func (dst *Campaign_DynamicSearchAdsSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Merge(dst, src)
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_Size() int {
	return xxx_messageInfo_Campaign_DynamicSearchAdsSetting.Size(m)
}
func (m *Campaign_DynamicSearchAdsSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_DynamicSearchAdsSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_DynamicSearchAdsSetting proto.InternalMessageInfo

func (m *Campaign_DynamicSearchAdsSetting) GetDomainName() *wrappers.StringValue {
	if m != nil {
		return m.DomainName
	}
	return nil
}

func (m *Campaign_DynamicSearchAdsSetting) GetLanguageCode() *wrappers.StringValue {
	if m != nil {
		return m.LanguageCode
	}
	return nil
}

func (m *Campaign_DynamicSearchAdsSetting) GetUseSuppliedUrlsOnly() *wrappers.BoolValue {
	if m != nil {
		return m.UseSuppliedUrlsOnly
	}
	return nil
}

func (m *Campaign_DynamicSearchAdsSetting) GetFeedIds() []*wrappers.Int64Value {
	if m != nil {
		return m.FeedIds
	}
	return nil
}

// The setting for Shopping campaigns. Defines the universe of products that
// can be advertised by the campaign, and how this campaign interacts with
// other Shopping campaigns.
type Campaign_ShoppingSetting struct {
	// ID of the Merchant Center account.
	// This field is required for create operations. This field is immutable for
	// Shopping campaigns.
	MerchantId *wrappers.Int64Value `protobuf:"bytes,1,opt,name=merchant_id,json=merchantId,proto3" json:"merchant_id,omitempty"`
	// Sales country of products to include in the campaign.
	// This field is required for Shopping campaigns. This field is immutable.
	// This field is optional for non-Shopping campaigns, but it must be equal
	// to 'ZZ' if set.
	SalesCountry *wrappers.StringValue `protobuf:"bytes,2,opt,name=sales_country,json=salesCountry,proto3" json:"sales_country,omitempty"`
	// Priority of the campaign. Campaigns with numerically higher priorities
	// take precedence over those with lower priorities.
	// This field is required for Shopping campaigns, with values between 0 and
	// 2, inclusive.
	// This field is optional for Smart Shopping campaigns, but must be equal to
	// 3 if set.
	CampaignPriority *wrappers.Int32Value `protobuf:"bytes,3,opt,name=campaign_priority,json=campaignPriority,proto3" json:"campaign_priority,omitempty"`
	// Enable local inventory ads. This field is ignored for Smart Shopping
	// campaigns.
	EnableLocal          *wrappers.BoolValue `protobuf:"bytes,4,opt,name=enable_local,json=enableLocal,proto3" json:"enable_local,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Campaign_ShoppingSetting) Reset()         { *m = Campaign_ShoppingSetting{} }
func (m *Campaign_ShoppingSetting) String() string { return proto.CompactTextString(m) }
func (*Campaign_ShoppingSetting) ProtoMessage()    {}
func (*Campaign_ShoppingSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_84f689eff017e599, []int{0, 3}
}
func (m *Campaign_ShoppingSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_ShoppingSetting.Unmarshal(m, b)
}
func (m *Campaign_ShoppingSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_ShoppingSetting.Marshal(b, m, deterministic)
}
func (dst *Campaign_ShoppingSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_ShoppingSetting.Merge(dst, src)
}
func (m *Campaign_ShoppingSetting) XXX_Size() int {
	return xxx_messageInfo_Campaign_ShoppingSetting.Size(m)
}
func (m *Campaign_ShoppingSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_ShoppingSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_ShoppingSetting proto.InternalMessageInfo

func (m *Campaign_ShoppingSetting) GetMerchantId() *wrappers.Int64Value {
	if m != nil {
		return m.MerchantId
	}
	return nil
}

func (m *Campaign_ShoppingSetting) GetSalesCountry() *wrappers.StringValue {
	if m != nil {
		return m.SalesCountry
	}
	return nil
}

func (m *Campaign_ShoppingSetting) GetCampaignPriority() *wrappers.Int32Value {
	if m != nil {
		return m.CampaignPriority
	}
	return nil
}

func (m *Campaign_ShoppingSetting) GetEnableLocal() *wrappers.BoolValue {
	if m != nil {
		return m.EnableLocal
	}
	return nil
}

// Campaign level settings for tracking information.
type Campaign_TrackingSetting struct {
	// The url used for dynamic tracking.
	TrackingUrl          *wrappers.StringValue `protobuf:"bytes,1,opt,name=tracking_url,json=trackingUrl,proto3" json:"tracking_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Campaign_TrackingSetting) Reset()         { *m = Campaign_TrackingSetting{} }
func (m *Campaign_TrackingSetting) String() string { return proto.CompactTextString(m) }
func (*Campaign_TrackingSetting) ProtoMessage()    {}
func (*Campaign_TrackingSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_84f689eff017e599, []int{0, 4}
}
func (m *Campaign_TrackingSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_TrackingSetting.Unmarshal(m, b)
}
func (m *Campaign_TrackingSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_TrackingSetting.Marshal(b, m, deterministic)
}
func (dst *Campaign_TrackingSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_TrackingSetting.Merge(dst, src)
}
func (m *Campaign_TrackingSetting) XXX_Size() int {
	return xxx_messageInfo_Campaign_TrackingSetting.Size(m)
}
func (m *Campaign_TrackingSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_TrackingSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_TrackingSetting proto.InternalMessageInfo

func (m *Campaign_TrackingSetting) GetTrackingUrl() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrl
	}
	return nil
}

// Describes how unbranded pharma ads will be displayed.
type Campaign_VanityPharma struct {
	// The display mode for vanity pharma URLs.
	VanityPharmaDisplayUrlMode enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode `protobuf:"varint,1,opt,name=vanity_pharma_display_url_mode,json=vanityPharmaDisplayUrlMode,proto3,enum=google.ads.googleads.v0.enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode" json:"vanity_pharma_display_url_mode,omitempty"`
	// The text that will be displayed in display URL of the text ad when
	// website description is the selected display mode for vanity pharma URLs.
	VanityPharmaText     enums.VanityPharmaTextEnum_VanityPharmaText `protobuf:"varint,2,opt,name=vanity_pharma_text,json=vanityPharmaText,proto3,enum=google.ads.googleads.v0.enums.VanityPharmaTextEnum_VanityPharmaText" json:"vanity_pharma_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *Campaign_VanityPharma) Reset()         { *m = Campaign_VanityPharma{} }
func (m *Campaign_VanityPharma) String() string { return proto.CompactTextString(m) }
func (*Campaign_VanityPharma) ProtoMessage()    {}
func (*Campaign_VanityPharma) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_84f689eff017e599, []int{0, 5}
}
func (m *Campaign_VanityPharma) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_VanityPharma.Unmarshal(m, b)
}
func (m *Campaign_VanityPharma) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_VanityPharma.Marshal(b, m, deterministic)
}
func (dst *Campaign_VanityPharma) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_VanityPharma.Merge(dst, src)
}
func (m *Campaign_VanityPharma) XXX_Size() int {
	return xxx_messageInfo_Campaign_VanityPharma.Size(m)
}
func (m *Campaign_VanityPharma) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_VanityPharma.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_VanityPharma proto.InternalMessageInfo

func (m *Campaign_VanityPharma) GetVanityPharmaDisplayUrlMode() enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode {
	if m != nil {
		return m.VanityPharmaDisplayUrlMode
	}
	return enums.VanityPharmaDisplayUrlModeEnum_UNSPECIFIED
}

func (m *Campaign_VanityPharma) GetVanityPharmaText() enums.VanityPharmaTextEnum_VanityPharmaText {
	if m != nil {
		return m.VanityPharmaText
	}
	return enums.VanityPharmaTextEnum_UNSPECIFIED
}

// Selective optimization setting for this campaign, which includes a set of
// conversion actions to optimize this campaign towards.
type Campaign_SelectiveOptimization struct {
	// The selected set of conversion actions for optimizing this campaign.
	ConversionActions    []*wrappers.StringValue `protobuf:"bytes,1,rep,name=conversion_actions,json=conversionActions,proto3" json:"conversion_actions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Campaign_SelectiveOptimization) Reset()         { *m = Campaign_SelectiveOptimization{} }
func (m *Campaign_SelectiveOptimization) String() string { return proto.CompactTextString(m) }
func (*Campaign_SelectiveOptimization) ProtoMessage()    {}
func (*Campaign_SelectiveOptimization) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_84f689eff017e599, []int{0, 6}
}
func (m *Campaign_SelectiveOptimization) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Campaign_SelectiveOptimization.Unmarshal(m, b)
}
func (m *Campaign_SelectiveOptimization) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Campaign_SelectiveOptimization.Marshal(b, m, deterministic)
}
func (dst *Campaign_SelectiveOptimization) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Campaign_SelectiveOptimization.Merge(dst, src)
}
func (m *Campaign_SelectiveOptimization) XXX_Size() int {
	return xxx_messageInfo_Campaign_SelectiveOptimization.Size(m)
}
func (m *Campaign_SelectiveOptimization) XXX_DiscardUnknown() {
	xxx_messageInfo_Campaign_SelectiveOptimization.DiscardUnknown(m)
}

var xxx_messageInfo_Campaign_SelectiveOptimization proto.InternalMessageInfo

func (m *Campaign_SelectiveOptimization) GetConversionActions() []*wrappers.StringValue {
	if m != nil {
		return m.ConversionActions
	}
	return nil
}

func init() {
	proto.RegisterType((*Campaign)(nil), "google.ads.googleads.v0.resources.Campaign")
	proto.RegisterType((*Campaign_NetworkSettings)(nil), "google.ads.googleads.v0.resources.Campaign.NetworkSettings")
	proto.RegisterType((*Campaign_HotelSettingInfo)(nil), "google.ads.googleads.v0.resources.Campaign.HotelSettingInfo")
	proto.RegisterType((*Campaign_DynamicSearchAdsSetting)(nil), "google.ads.googleads.v0.resources.Campaign.DynamicSearchAdsSetting")
	proto.RegisterType((*Campaign_ShoppingSetting)(nil), "google.ads.googleads.v0.resources.Campaign.ShoppingSetting")
	proto.RegisterType((*Campaign_TrackingSetting)(nil), "google.ads.googleads.v0.resources.Campaign.TrackingSetting")
	proto.RegisterType((*Campaign_VanityPharma)(nil), "google.ads.googleads.v0.resources.Campaign.VanityPharma")
	proto.RegisterType((*Campaign_SelectiveOptimization)(nil), "google.ads.googleads.v0.resources.Campaign.SelectiveOptimization")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/campaign.proto", fileDescriptor_campaign_84f689eff017e599)
}

var fileDescriptor_campaign_84f689eff017e599 = []byte{
	// 1835 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x58, 0x4f, 0x73, 0x1b, 0x49,
	0x15, 0x8f, 0x94, 0x90, 0x4d, 0x5a, 0xf2, 0x9f, 0xb4, 0x63, 0x67, 0x2c, 0xef, 0x06, 0x67, 0x21,
	0xac, 0x77, 0xb3, 0x48, 0xc6, 0x81, 0x2c, 0x38, 0x59, 0x58, 0x59, 0xc9, 0xae, 0x1d, 0x36, 0x89,
	0x6a, 0xe4, 0x98, 0xd4, 0x96, 0x53, 0x53, 0xad, 0xe9, 0x96, 0x3c, 0xb5, 0x33, 0xdd, 0xb3, 0xdd,
	0x3d, 0x8a, 0xc5, 0x81, 0xe2, 0xcc, 0x9d, 0xe2, 0x00, 0x55, 0x14, 0x14, 0x27, 0xae, 0x7c, 0x0b,
	0x3e, 0x05, 0x67, 0x3e, 0x02, 0x27, 0xaa, 0xff, 0xcc, 0x78, 0x24, 0x4b, 0x1a, 0xe9, 0x36, 0xf3,
	0xfa, 0xfd, 0x7e, 0xef, 0xcd, 0xeb, 0xf7, 0xfa, 0xbd, 0x1e, 0xb0, 0xdb, 0x67, 0xac, 0x1f, 0x92,
	0x06, 0xc2, 0xa2, 0x61, 0x1e, 0xd5, 0xd3, 0x60, 0xb7, 0xc1, 0x89, 0x60, 0x09, 0xf7, 0x89, 0x68,
	0xf8, 0x28, 0x8a, 0x51, 0xd0, 0xa7, 0xf5, 0x98, 0x33, 0xc9, 0xe0, 0x3d, 0xa3, 0x56, 0x47, 0x58,
	0xd4, 0x33, 0x44, 0x7d, 0xb0, 0x5b, 0xcf, 0x10, 0xb5, 0x4f, 0xa7, 0x91, 0xfa, 0x2c, 0x8a, 0x18,
	0x6d, 0x74, 0x03, 0x8c, 0x03, 0xda, 0x37, 0x84, 0xb5, 0x9f, 0x15, 0x68, 0xfb, 0x89, 0x90, 0x2c,
	0xf2, 0x62, 0xc4, 0x51, 0x44, 0x24, 0xe1, 0x16, 0xb6, 0x57, 0x00, 0xeb, 0x71, 0xf2, 0x5d, 0x42,
	0xa8, 0x3f, 0xf4, 0x7c, 0x14, 0x5b, 0xcc, 0x2f, 0x0b, 0x30, 0x9c, 0xa0, 0xd0, 0x93, 0x41, 0x44,
	0x3c, 0xeb, 0xa2, 0x27, 0x88, 0x94, 0x17, 0xae, 0x3e, 0x2a, 0xc0, 0x4b, 0xc4, 0xfb, 0x44, 0x5e,
	0xc6, 0x1d, 0x4c, 0xc3, 0x11, 0x9a, 0x44, 0xa2, 0x81, 0xb0, 0x27, 0x08, 0x1f, 0x28, 0x1c, 0x8b,
	0x65, 0x10, 0x05, 0xbf, 0x45, 0x32, 0x60, 0xd4, 0x13, 0x12, 0xc9, 0x44, 0x58, 0x8e, 0x2f, 0x8a,
	0x38, 0x06, 0x84, 0xcb, 0x40, 0x28, 0x12, 0xff, 0x0c, 0x51, 0x4a, 0x42, 0x4f, 0x24, 0x5d, 0x4f,
	0x0e, 0x63, 0x62, 0x19, 0x9e, 0x2c, 0xce, 0x90, 0x43, 0xff, 0x62, 0x36, 0x3a, 0x0b, 0x98, 0xe4,
	0x48, 0x92, 0xfe, 0x70, 0x01, 0xc3, 0x5d, 0x8e, 0x28, 0xf6, 0x04, 0xea, 0x11, 0x39, 0xf4, 0x44,
	0x12, 0x48, 0xd4, 0x0d, 0xc2, 0x40, 0x0e, 0x2d, 0xfa, 0xf1, 0x6c, 0x74, 0x9a, 0x9e, 0x59, 0x08,
	0x47, 0xa2, 0xf6, 0x70, 0x5e, 0x70, 0x1e, 0x54, 0xb0, 0x5d, 0x03, 0x44, 0x03, 0x39, 0xf4, 0xe2,
	0x33, 0xc4, 0x23, 0xe4, 0xe1, 0x40, 0xc4, 0x21, 0x1a, 0x7a, 0x09, 0x0f, 0xbd, 0x88, 0x61, 0x52,
	0x94, 0x2a, 0x93, 0x38, 0x24, 0x39, 0x97, 0x16, 0x77, 0xd7, 0xe2, 0xf4, 0x5b, 0x37, 0xe9, 0x35,
	0xde, 0x71, 0x14, 0xc7, 0x84, 0x5b, 0xdf, 0x3e, 0xfc, 0xd7, 0x47, 0xe0, 0x46, 0xcb, 0x7a, 0x0d,
	0x7f, 0x00, 0x96, 0xd2, 0xaa, 0xf3, 0x28, 0x8a, 0x88, 0x53, 0xda, 0x2e, 0xed, 0xdc, 0x74, 0xab,
	0xa9, 0xf0, 0x25, 0x8a, 0x08, 0x7c, 0x00, 0xca, 0x01, 0x76, 0xae, 0x6e, 0x97, 0x76, 0x2a, 0x7b,
	0x5b, 0xb6, 0x64, 0xeb, 0x29, 0x7d, 0xfd, 0x88, 0xca, 0x47, 0x3f, 0x3d, 0x41, 0x61, 0x42, 0xdc,
	0x72, 0x80, 0xe1, 0x2e, 0xb8, 0xa6, 0x89, 0xae, 0x69, 0xf5, 0xf7, 0x2f, 0xa9, 0x77, 0x24, 0x0f,
	0x68, 0xdf, 0xe8, 0x6b, 0x4d, 0xf8, 0x06, 0x5c, 0x37, 0xc1, 0x73, 0xbe, 0xb7, 0x5d, 0xda, 0x59,
	0xde, 0xfb, 0xa2, 0x3e, 0xed, 0x80, 0xd0, 0x5f, 0x5e, 0x4f, 0x9d, 0xef, 0x68, 0xd0, 0x33, 0x9a,
	0x44, 0x63, 0x22, 0xd7, 0xf2, 0xc1, 0x04, 0x2c, 0x8f, 0xee, 0xa9, 0xb3, 0xae, 0x2d, 0xbc, 0x9c,
	0xd7, 0x82, 0x01, 0x4f, 0x32, 0x94, 0x5f, 0x71, 0x97, 0x44, 0xfe, 0x15, 0xfe, 0xb5, 0x04, 0xee,
	0xce, 0xae, 0x48, 0xe7, 0x86, 0xf6, 0xe3, 0x9b, 0x02, 0x3f, 0x9a, 0xd8, 0xda, 0x79, 0x95, 0xa3,
	0xc8, 0x79, 0x33, 0x63, 0xdd, 0xdd, 0x42, 0xd3, 0x17, 0xe1, 0x1f, 0x4a, 0xc0, 0x99, 0x56, 0xad,
	0xce, 0x4d, 0xed, 0x5b, 0xbb, 0xd0, 0xb7, 0x0c, 0xde, 0x32, 0xe8, 0xe3, 0x61, 0x4c, 0xac, 0x5b,
	0x93, 0x96, 0xdc, 0x0d, 0x34, 0x51, 0x0e, 0xff, 0x54, 0x02, 0xef, 0xcf, 0x3a, 0x7c, 0x1c, 0xa0,
	0x1d, 0x3a, 0x59, 0xd8, 0xa1, 0x4e, 0xd2, 0x9d, 0xe1, 0x93, 0x5d, 0x75, 0x37, 0xd1, 0xb4, 0x25,
	0xd8, 0x06, 0xeb, 0x92, 0x23, 0xff, 0x5b, 0xe5, 0x95, 0xaa, 0x4e, 0x49, 0xa2, 0x38, 0x44, 0x92,
	0x38, 0x95, 0x39, 0x92, 0x7b, 0x2d, 0x85, 0xbe, 0xe6, 0xe1, 0xb1, 0x05, 0x42, 0x1f, 0xac, 0x2b,
	0xa2, 0xf1, 0x8e, 0x24, 0x9c, 0xea, 0xf6, 0xd5, 0x9d, 0xca, 0x5e, 0x63, 0xea, 0x37, 0x9a, 0xfe,
	0x50, 0x6f, 0x69, 0x60, 0x3b, 0xc5, 0xb9, 0x6b, 0x09, 0x0f, 0xc7, 0x64, 0x02, 0x7e, 0x07, 0x36,
	0xa7, 0xf6, 0x21, 0xe7, 0x23, 0xed, 0xfa, 0xa3, 0x22, 0x43, 0x2e, 0x41, 0xe1, 0x71, 0x10, 0x91,
	0x03, 0x03, 0xef, 0x18, 0xb4, 0xbb, 0xc1, 0x27, 0xca, 0x61, 0x0f, 0xac, 0x52, 0x22, 0xdf, 0x31,
	0xfe, 0x6d, 0x6a, 0x48, 0x38, 0xcb, 0xda, 0xd2, 0xe3, 0x7a, 0x61, 0xbb, 0xcf, 0xaa, 0xaa, 0xfe,
	0xd2, 0x70, 0x58, 0x56, 0xe1, 0xae, 0xd0, 0x51, 0x01, 0x44, 0x60, 0xe9, 0x8c, 0x49, 0x95, 0x1c,
	0xf6, 0x73, 0xb6, 0xb5, 0x91, 0x27, 0x8b, 0x18, 0x39, 0x54, 0x04, 0x96, 0xf1, 0x88, 0xf6, 0x98,
	0x5b, 0x3d, 0xcb, 0x49, 0xe0, 0xef, 0x4b, 0xa0, 0x86, 0x87, 0x14, 0x45, 0x81, 0xef, 0x09, 0x82,
	0xb8, 0x7f, 0xe6, 0x21, 0x2c, 0x32, 0x83, 0xf7, 0xb4, 0xc1, 0xd6, 0x22, 0x06, 0x9f, 0x1a, 0xb6,
	0x8e, 0x26, 0x6b, 0x62, 0x91, 0x06, 0xf3, 0x0e, 0x9e, 0xbc, 0xa0, 0xa2, 0x29, 0xce, 0x58, 0x1c,
	0xe7, 0xf7, 0xed, 0x87, 0x8b, 0x47, 0xb3, 0x63, 0x39, 0x52, 0x7b, 0x2b, 0x62, 0x54, 0x00, 0xdf,
	0x82, 0x5b, 0x97, 0x06, 0x0e, 0xe7, 0x81, 0x36, 0xb4, 0x5b, 0x94, 0x20, 0xc7, 0x29, 0x30, 0x65,
	0x5f, 0x95, 0x63, 0x12, 0xf8, 0x0c, 0xac, 0x64, 0xed, 0xb1, 0x9b, 0xe0, 0x3e, 0x91, 0xce, 0xf5,
	0x39, 0x0a, 0x67, 0x39, 0x05, 0x1d, 0x68, 0x0c, 0xfc, 0x1d, 0x58, 0x9f, 0x38, 0x1b, 0x38, 0x1b,
	0xfa, 0x5c, 0x78, 0x5e, 0x70, 0x2e, 0xa4, 0x99, 0x6a, 0xa1, 0xd9, 0x89, 0x30, 0x41, 0xee, 0xae,
	0x75, 0x2f, 0x0b, 0xe1, 0x63, 0x00, 0x84, 0x44, 0x5c, 0x7a, 0x58, 0x95, 0xfe, 0xda, 0x1c, 0x5f,
	0x70, 0x53, 0xeb, 0x3f, 0x55, 0x05, 0xff, 0x19, 0xb8, 0x41, 0x28, 0x36, 0xd0, 0xdb, 0x73, 0x40,
	0xdf, 0x23, 0x14, 0x6b, 0xe0, 0x97, 0x60, 0xb5, 0x17, 0x50, 0x14, 0xea, 0x83, 0x47, 0x24, 0xbd,
	0x5e, 0x70, 0xee, 0xfc, 0x68, 0x9e, 0xe8, 0x69, 0xd4, 0x6b, 0x1e, 0x76, 0x34, 0x06, 0xbe, 0x01,
	0xcb, 0x23, 0x83, 0xac, 0x70, 0x76, 0xf4, 0x51, 0xf3, 0x93, 0xa2, 0x0d, 0xfe, 0x32, 0x45, 0xb5,
	0x50, 0xfc, 0x8c, 0x4a, 0x3e, 0x74, 0x97, 0x7a, 0x39, 0x91, 0x80, 0x7f, 0x2c, 0x81, 0xbb, 0x83,
	0x00, 0x13, 0xe6, 0x4d, 0x9b, 0xbf, 0x9c, 0x4f, 0xe6, 0x6a, 0x25, 0x07, 0x0a, 0xde, 0xd1, 0xe8,
	0xce, 0x05, 0xd8, 0x6c, 0xd2, 0xc4, 0x25, 0x77, 0x4b, 0xdb, 0x9d, 0xbc, 0x08, 0xdf, 0x82, 0xa5,
	0x91, 0xe1, 0xc8, 0xf9, 0x54, 0x87, 0xed, 0xe7, 0x8b, 0x94, 0xce, 0x89, 0x26, 0x68, 0x6b, 0xbc,
	0x5b, 0x1d, 0xe4, 0xde, 0xe0, 0x39, 0xd8, 0x10, 0x24, 0x24, 0xbe, 0x0c, 0x06, 0x64, 0xa4, 0xb7,
	0x3b, 0x3f, 0xd6, 0x76, 0x9a, 0x0b, 0x95, 0x68, 0xca, 0x94, 0x6f, 0xd2, 0xee, 0xba, 0x98, 0x24,
	0x56, 0xc7, 0x42, 0xd6, 0x8e, 0xd2, 0x6a, 0xad, 0x2f, 0x7e, 0x2c, 0x1c, 0x5b, 0x8e, 0xec, 0x58,
	0x90, 0xa3, 0x02, 0x78, 0x04, 0x56, 0xc7, 0x0b, 0xce, 0xb9, 0x53, 0x9c, 0x7a, 0x87, 0x57, 0xdc,
	0x95, 0xb1, 0xfa, 0x81, 0xcf, 0x01, 0x88, 0x10, 0x4d, 0x50, 0xe8, 0xf9, 0xb1, 0xef, 0x38, 0x9a,
	0xe4, 0xe3, 0xa2, 0xcc, 0x7b, 0xa1, 0x11, 0xad, 0xd8, 0x3f, 0xbc, 0xe2, 0xde, 0x8c, 0xd2, 0x97,
	0x11, 0xae, 0xc8, 0xd9, 0x5c, 0x8c, 0x2b, 0xca, 0x73, 0x45, 0x23, 0x5c, 0x03, 0xe7, 0xfe, 0x62,
	0x5c, 0x83, 0x3c, 0xd7, 0x00, 0x9e, 0x81, 0xdb, 0x11, 0x3a, 0x57, 0xdb, 0x44, 0x3c, 0x9f, 0xd1,
	0x01, 0xe1, 0x22, 0x60, 0x54, 0x38, 0x77, 0x35, 0xeb, 0xc3, 0x62, 0x56, 0x83, 0x6d, 0x5d, 0x40,
	0x0f, 0xaf, 0xb8, 0x6b, 0xd1, 0x65, 0x31, 0x4c, 0xc0, 0xe6, 0x04, 0x4b, 0xde, 0x40, 0x45, 0xdf,
	0xf9, 0xbe, 0x36, 0xf7, 0xd9, 0xe2, 0xe6, 0xd2, 0xcd, 0xbb, 0x13, 0x4d, 0x5e, 0x52, 0xc1, 0x32,
	0x67, 0xbb, 0xe7, 0xc7, 0xc8, 0xa9, 0xcd, 0x17, 0x2c, 0xd3, 0x1f, 0x5a, 0x31, 0x52, 0xc1, 0x92,
	0xe9, 0x0b, 0x7c, 0x01, 0x2a, 0x96, 0x8b, 0x33, 0x24, 0x9c, 0x0f, 0x34, 0xd9, 0x27, 0xf3, 0x91,
	0xb9, 0x0c, 0xa9, 0xd0, 0x58, 0x67, 0xd4, 0x1b, 0x6c, 0x83, 0xaa, 0xa5, 0x13, 0x31, 0xa1, 0xd8,
	0xd9, 0xd2, 0x7c, 0x0f, 0xe6, 0xe3, 0xeb, 0x28, 0xc8, 0xe1, 0x15, 0xd7, 0x7a, 0xa4, 0x5f, 0x95,
	0x83, 0x31, 0xe1, 0x3e, 0xa1, 0x52, 0xa7, 0xec, 0x87, 0xf3, 0x39, 0xd8, 0x36, 0x10, 0x93, 0xb3,
	0x20, 0xce, 0xde, 0x46, 0x62, 0x17, 0x39, 0x1f, 0x2f, 0x16, 0xbb, 0x28, 0x1f, 0xbb, 0xa8, 0xf6,
	0x9f, 0x32, 0x58, 0x19, 0x9b, 0x90, 0xe0, 0xd7, 0xe0, 0xb6, 0xe5, 0x37, 0x44, 0x76, 0x64, 0xd1,
	0xf7, 0xb8, 0xca, 0x5e, 0xed, 0x52, 0xbd, 0x1e, 0x30, 0x16, 0x9a, 0x46, 0x01, 0x0d, 0xee, 0x2b,
	0xad, 0x60, 0x46, 0x10, 0xf8, 0x12, 0xac, 0xa7, 0xe1, 0x34, 0x93, 0x8f, 0x9d, 0xbf, 0x9c, 0x72,
	0x21, 0xdd, 0x9a, 0x0d, 0xa2, 0xc6, 0x59, 0x2f, 0x61, 0x1b, 0x6c, 0xa4, 0x5f, 0xcf, 0xa8, 0x54,
	0x31, 0x4d, 0x09, 0xaf, 0x16, 0x12, 0xda, 0xef, 0x6a, 0x19, 0x60, 0xca, 0xf8, 0x16, 0x7c, 0x60,
	0x19, 0x63, 0xc4, 0x25, 0x25, 0x7c, 0xdc, 0xd3, 0x6b, 0x85, 0xc4, 0x35, 0x43, 0xd0, 0x36, 0xf8,
	0x11, 0x87, 0x6b, 0xbf, 0x01, 0xab, 0xe3, 0xe3, 0x21, 0x6c, 0x81, 0x15, 0x33, 0x73, 0xaa, 0x3d,
	0x25, 0xdc, 0x0b, 0xb0, 0x8d, 0xee, 0xcc, 0xbb, 0xb0, 0x99, 0x53, 0x5b, 0x1a, 0x72, 0x84, 0x6b,
	0xff, 0x28, 0x83, 0x3b, 0x53, 0xe6, 0x40, 0xf8, 0x39, 0xa8, 0x60, 0x16, 0xa1, 0x80, 0x5e, 0x5c,
	0xc1, 0x8b, 0xba, 0x3c, 0x30, 0x00, 0x7d, 0x3d, 0x6f, 0x82, 0xa5, 0x10, 0xd1, 0x7e, 0x82, 0xfa,
	0xea, 0x54, 0xc0, 0xc4, 0x6e, 0xd6, 0x6c, 0x82, 0x6a, 0x0a, 0x69, 0x31, 0x4c, 0xe0, 0x2b, 0xb0,
	0x91, 0x08, 0xe2, 0x89, 0x24, 0x8e, 0xc3, 0x80, 0x60, 0x35, 0x73, 0x08, 0x8f, 0xd1, 0x70, 0x38,
	0xc7, 0x3e, 0xad, 0x25, 0x82, 0x74, 0x2c, 0xf0, 0x35, 0x0f, 0xc5, 0x2b, 0x1a, 0x0e, 0xe1, 0x23,
	0x70, 0xa3, 0x47, 0x08, 0xf6, 0x02, 0x2c, 0x9c, 0x6b, 0x7a, 0xde, 0x98, 0x19, 0xac, 0xf7, 0x94,
	0xf2, 0x11, 0x16, 0xb5, 0x3f, 0x97, 0xc1, 0xca, 0xd8, 0xd8, 0x0a, 0x9f, 0x80, 0x4a, 0x44, 0xb8,
	0xba, 0x15, 0xca, 0x39, 0x63, 0x0f, 0x52, 0xfd, 0x23, 0xac, 0xa2, 0x23, 0x50, 0x48, 0x84, 0xe7,
	0xb3, 0x44, 0x4d, 0x31, 0xf3, 0x45, 0x47, 0x43, 0x5a, 0x06, 0x01, 0x0f, 0xc1, 0xad, 0x6c, 0x8e,
	0x8d, 0x79, 0xc0, 0xb8, 0x1a, 0x6d, 0x66, 0xfc, 0x0e, 0x79, 0xb8, 0x67, 0x58, 0x56, 0x53, 0x54,
	0xdb, 0x82, 0xe0, 0xe7, 0xa0, 0x4a, 0x28, 0xea, 0x86, 0xc4, 0x0b, 0x99, 0x8f, 0xc2, 0x39, 0x92,
	0xb5, 0x62, 0xf4, 0xbf, 0x56, 0xea, 0x35, 0x17, 0xac, 0x8c, 0x35, 0x6f, 0xf8, 0x2b, 0x50, 0xcd,
	0x5f, 0x51, 0xe7, 0x4a, 0x9e, 0x4a, 0xee, 0x66, 0x5a, 0xfb, 0x5b, 0x19, 0x54, 0xf3, 0xd3, 0x0e,
	0xfc, 0x8b, 0x1a, 0xeb, 0x66, 0xfe, 0xa0, 0xd2, 0x46, 0x96, 0xf7, 0xde, 0x14, 0x8c, 0x75, 0x79,
	0xd6, 0xa7, 0x86, 0xe2, 0x35, 0x0f, 0x5f, 0x30, 0x6c, 0xe6, 0xef, 0xe9, 0xcb, 0x6e, 0x6d, 0x30,
	0x75, 0x0d, 0x72, 0x00, 0x2f, 0xff, 0xfa, 0xd2, 0x9b, 0xba, 0xbc, 0xf7, 0x74, 0x01, 0x8f, 0x8e,
	0xc9, 0xb9, 0xbc, 0xe4, 0x87, 0x12, 0xba, 0xab, 0x83, 0x31, 0x49, 0x0d, 0x83, 0xf5, 0x89, 0x83,
	0x1a, 0xfc, 0x35, 0x80, 0xb9, 0x3e, 0x8c, 0x7c, 0xa9, 0x1b, 0x7f, 0x49, 0x27, 0xfc, 0xec, 0x3d,
	0xb8, 0x75, 0x81, 0x6b, 0x1a, 0xd8, 0xc1, 0x16, 0xd8, 0xbc, 0xb8, 0x2e, 0x8d, 0xcd, 0x5f, 0x07,
	0xff, 0x2b, 0x81, 0xfb, 0x3e, 0x8b, 0x8a, 0xe7, 0xbc, 0x83, 0xa5, 0x56, 0x96, 0x75, 0x4c, 0xb2,
	0x76, 0xe9, 0x9b, 0xe7, 0x16, 0xd3, 0x67, 0xaa, 0xe6, 0xeb, 0x8c, 0xf7, 0x1b, 0x7d, 0x42, 0xb5,
	0x57, 0xe9, 0x8f, 0xc5, 0x38, 0x10, 0x33, 0x7e, 0xe0, 0x3f, 0xce, 0x9e, 0xfe, 0x5e, 0xbe, 0xfa,
	0x55, 0xb3, 0xf9, 0xcf, 0xf2, 0x3d, 0xd3, 0x35, 0xea, 0x4d, 0x2c, 0xea, 0xe6, 0x51, 0x3d, 0x9d,
	0xec, 0xd6, 0xdd, 0x54, 0xf3, 0xdf, 0xa9, 0xce, 0x69, 0x13, 0x8b, 0xd3, 0x4c, 0xe7, 0xf4, 0x64,
	0xf7, 0x34, 0xd3, 0xf9, 0x6f, 0xf9, 0xbe, 0x59, 0xd8, 0xdf, 0x6f, 0x62, 0xb1, 0xbf, 0x9f, 0x69,
	0xed, 0xef, 0x9f, 0xec, 0xee, 0xef, 0x67, 0x7a, 0xdd, 0xeb, 0xda, 0xd9, 0x87, 0xff, 0x0f, 0x00,
	0x00, 0xff, 0xff, 0xd3, 0x1b, 0xc8, 0xa6, 0x6c, 0x18, 0x00, 0x00,
}
