const request = require('request');
const logger = require('../../../utils/Logger');

exports.revoke = (req, cb) => {
  const {ICP_MASTER_IP, OIDC_ENDPOINT_PORT, CLIENT_ID, CLIENT_SECRET} = process.env;
  let url = `https://${ICP_MASTER_IP}:${OIDC_ENDPOINT_PORT}/oidc/endpoint/OP/revoke`;
  let _combined = `${CLIENT_ID} ${CLIENT_SECRET}`;
  let authorization = `Basic ${Buffer.from(_combined).toString('base64')}`;
  let token = req.headers['access_token'];
  let options = {
    method: 'POST',
    headers: {'content-type': 'application/x-www-form-urlencoded', authorization},
    url,
    rejectUnauthorized: false,
    form: {token}
  };
  logger.log('info', 'revoke access token at: ' + url);

  request(options, (error, res) => {
    if (error) {
      logger.log('Error', 'failed to revoke access token', error);
      return cb(error, null, null);
    }
    return cb(null, res);
  });
};
